/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCCMPFieldMetaData
/*     */ {
/*     */   public static final byte CHECK_DIRTY_AFTER_GET_TRUE = 1;
/*     */   public static final byte CHECK_DIRTY_AFTER_GET_FALSE = 2;
/*     */   public static final byte CHECK_DIRTY_AFTER_GET_NOT_PRESENT = 4;
/*     */   private final JDBCEntityMetaData entity;
/*     */   private final String fieldName;
/*     */   private final Class fieldType;
/*     */   private final String columnName;
/*     */   private final int jdbcType;
/*     */   private final String sqlType;
/*     */   private final boolean readOnly;
/*     */   private final int readTimeOut;
/*     */   private final boolean primaryKeyMember;
/*     */   private final boolean notNull;
/*     */   private final boolean genIndex;
/*     */   private final Field primaryKeyField;
/* 100 */   private final List propertyOverrides = new ArrayList();
/*     */   private final boolean unknownPkField;
/*     */   private final boolean autoIncrement;
/*     */   private final boolean relationTableField;
/*     */   private final byte checkDirtyAfterGet;
/*     */   private final String stateFactory;
/*     */ 
/*     */   private static byte readCheckDirtyAfterGet(Element element, byte defaultValue)
/*     */     throws DeploymentException
/*     */   {
/* 120 */     String dirtyAfterGetStr = MetaData.getOptionalChildContent(element, "check-dirty-after-get");
/*     */     byte checkDirtyAfterGet;
/*     */     byte checkDirtyAfterGet;
/* 121 */     if (dirtyAfterGetStr == null)
/*     */     {
/* 123 */       checkDirtyAfterGet = defaultValue;
/*     */     }
/*     */     else
/*     */     {
/* 127 */       checkDirtyAfterGet = Boolean.valueOf(dirtyAfterGetStr).booleanValue() ? 1 : 2;
/*     */     }
/*     */ 
/* 130 */     return checkDirtyAfterGet;
/*     */   }
/*     */ 
/*     */   public static byte readCheckDirtyAfterGet(Element element) throws DeploymentException
/*     */   {
/* 135 */     return readCheckDirtyAfterGet(element, 4);
/*     */   }
/*     */ 
/*     */   public JDBCCMPFieldMetaData(JDBCEntityMetaData entity)
/*     */   {
/* 143 */     this.entity = entity;
/* 144 */     this.fieldName = (entity.getName() + "_upk");
/* 145 */     this.fieldType = entity.getPrimaryKeyClass();
/* 146 */     this.columnName = (entity.getName() + "_upk");
/* 147 */     this.jdbcType = -2147483648;
/* 148 */     this.sqlType = null;
/* 149 */     this.readOnly = entity.isReadOnly();
/* 150 */     this.readTimeOut = entity.getReadTimeOut();
/* 151 */     this.primaryKeyMember = true;
/* 152 */     this.notNull = true;
/* 153 */     this.primaryKeyField = null;
/* 154 */     this.genIndex = false;
/* 155 */     this.unknownPkField = true;
/* 156 */     this.autoIncrement = false;
/* 157 */     this.relationTableField = false;
/* 158 */     this.checkDirtyAfterGet = 4;
/* 159 */     this.stateFactory = null;
/*     */   }
/*     */ 
/*     */   public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, String fieldName)
/*     */     throws DeploymentException
/*     */   {
/* 173 */     this.entity = entity;
/* 174 */     this.fieldName = fieldName;
/*     */ 
/* 176 */     this.fieldType = loadFieldType(entity, fieldName);
/* 177 */     this.columnName = fieldName;
/* 178 */     this.jdbcType = -2147483648;
/* 179 */     this.sqlType = null;
/* 180 */     this.readOnly = entity.isReadOnly();
/* 181 */     this.readTimeOut = entity.getReadTimeOut();
/* 182 */     this.genIndex = false;
/*     */ 
/* 185 */     String pkFieldName = entity.getPrimaryKeyFieldName();
/* 186 */     if (pkFieldName != null)
/*     */     {
/* 189 */       this.primaryKeyField = null;
/*     */ 
/* 192 */       if (pkFieldName.equals(fieldName))
/*     */       {
/* 195 */         if (!entity.getPrimaryKeyClass().equals(this.fieldType))
/*     */         {
/* 197 */           throw new DeploymentException("primkey-field must be the same type as prim-key-class");
/*     */         }
/*     */ 
/* 200 */         this.primaryKeyMember = true;
/*     */       }
/*     */       else
/*     */       {
/* 204 */         this.primaryKeyMember = false;
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 210 */       Field[] fields = entity.getPrimaryKeyClass().getFields();
/*     */ 
/* 212 */       boolean pkMember = false;
/* 213 */       Field pkField = null;
/* 214 */       for (int i = 0; i < fields.length; i++)
/*     */       {
/* 216 */         Field field = fields[i];
/* 217 */         if (!field.getName().equals(fieldName))
/*     */         {
/*     */           continue;
/*     */         }
/* 221 */         if (!field.getType().equals(this.fieldType))
/*     */         {
/* 223 */           throw new DeploymentException("Field " + fieldName + " in prim-key-class must be of the same type.");
/*     */         }
/*     */ 
/* 226 */         if (pkField != null)
/*     */         {
/* 228 */           if (field.getDeclaringClass().equals(entity.getPrimaryKeyClass()))
/*     */           {
/* 230 */             pkField = field;
/*     */           }
/*     */ 
/* 233 */           Logger.getLogger(getClass().getName() + '.' + entity.getName()).warn("PK field " + fieldName + " was found more than once in class hierarchy of " + entity.getPrimaryKeyClass().getName() + ". Will use the one from " + pkField.getDeclaringClass().getName());
/*     */         }
/*     */         else
/*     */         {
/* 240 */           pkField = field;
/*     */         }
/*     */ 
/* 244 */         pkMember = true;
/*     */       }
/*     */ 
/* 247 */       this.primaryKeyMember = pkMember;
/* 248 */       this.primaryKeyField = pkField;
/*     */     }
/* 250 */     this.notNull = ((this.fieldType.isPrimitive()) || (this.primaryKeyMember));
/*     */ 
/* 252 */     this.unknownPkField = false;
/* 253 */     this.autoIncrement = false;
/* 254 */     this.relationTableField = false;
/* 255 */     this.checkDirtyAfterGet = 4;
/* 256 */     this.stateFactory = null;
/*     */   }
/*     */ 
/*     */   public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, JDBCCMPFieldMetaData defaultValues)
/*     */   {
/* 262 */     this.entity = entity;
/* 263 */     this.fieldName = defaultValues.getFieldName();
/* 264 */     this.fieldType = defaultValues.getFieldType();
/* 265 */     this.columnName = defaultValues.getColumnName();
/* 266 */     this.jdbcType = defaultValues.getJDBCType();
/* 267 */     this.sqlType = defaultValues.getSQLType();
/* 268 */     this.readOnly = entity.isReadOnly();
/* 269 */     this.readTimeOut = entity.getReadTimeOut();
/* 270 */     this.primaryKeyMember = defaultValues.isPrimaryKeyMember();
/* 271 */     this.primaryKeyField = defaultValues.getPrimaryKeyField();
/* 272 */     this.notNull = defaultValues.isNotNull();
/* 273 */     this.unknownPkField = defaultValues.isUnknownPkField();
/* 274 */     this.autoIncrement = defaultValues.isAutoIncrement();
/* 275 */     this.genIndex = false;
/* 276 */     this.relationTableField = defaultValues.isRelationTableField();
/* 277 */     this.checkDirtyAfterGet = defaultValues.getCheckDirtyAfterGet();
/* 278 */     this.stateFactory = defaultValues.getStateFactory();
/*     */   }
/*     */ 
/*     */   public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, Element element, JDBCCMPFieldMetaData defaultValues)
/*     */     throws DeploymentException
/*     */   {
/* 298 */     this.entity = entity;
/*     */ 
/* 301 */     this.unknownPkField = defaultValues.isUnknownPkField();
/*     */ 
/* 305 */     String unknownFieldName = MetaData.getOptionalChildContent(element, "field-name");
/*     */ 
/* 307 */     if ((this.unknownPkField) && (unknownFieldName != null))
/*     */     {
/* 309 */       this.fieldName = unknownFieldName;
/*     */     }
/*     */     else
/*     */     {
/* 313 */       this.fieldName = defaultValues.getFieldName();
/*     */     }
/*     */ 
/* 318 */     String unknownPkClass = MetaData.getOptionalChildContent(element, "unknown-pk-class");
/* 319 */     if (unknownPkClass == null)
/*     */     {
/* 321 */       this.fieldType = defaultValues.getFieldType();
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 327 */         this.fieldType = entity.getClassLoader().loadClass(unknownPkClass);
/*     */       }
/*     */       catch (ClassNotFoundException e)
/*     */       {
/* 331 */         throw new DeploymentException("could not load the class for  unknown primary key: " + unknownPkClass);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 337 */     String columnStr = MetaData.getOptionalChildContent(element, "column-name");
/* 338 */     if (columnStr != null)
/*     */     {
/* 340 */       this.columnName = columnStr;
/*     */     }
/*     */     else
/*     */     {
/* 344 */       this.columnName = defaultValues.getColumnName();
/*     */     }
/*     */ 
/* 348 */     String jdbcStr = MetaData.getOptionalChildContent(element, "jdbc-type");
/* 349 */     if (jdbcStr != null)
/*     */     {
/* 351 */       this.jdbcType = JDBCMappingMetaData.getJdbcTypeFromName(jdbcStr);
/*     */ 
/* 353 */       this.sqlType = MetaData.getUniqueChildContent(element, "sql-type");
/*     */     }
/*     */     else
/*     */     {
/* 357 */       this.jdbcType = defaultValues.getJDBCType();
/* 358 */       this.sqlType = defaultValues.getSQLType();
/*     */     }
/*     */ 
/* 362 */     String readOnlyStr = MetaData.getOptionalChildContent(element, "read-only");
/* 363 */     if (readOnlyStr != null)
/*     */     {
/* 365 */       this.readOnly = Boolean.valueOf(readOnlyStr).booleanValue();
/*     */     }
/*     */     else
/*     */     {
/* 369 */       this.readOnly = defaultValues.isReadOnly();
/*     */     }
/*     */ 
/* 373 */     String readTimeOutStr = MetaData.getOptionalChildContent(element, "read-time-out");
/* 374 */     if (readTimeOutStr != null)
/*     */     {
/*     */       try
/*     */       {
/* 378 */         this.readTimeOut = Integer.parseInt(readTimeOutStr);
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 382 */         throw new DeploymentException("Invalid number format in read-time-out '" + readTimeOutStr + "': " + e);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 388 */       this.readTimeOut = defaultValues.getReadTimeOut();
/*     */     }
/*     */ 
/* 392 */     this.primaryKeyMember = defaultValues.isPrimaryKeyMember();
/*     */ 
/* 395 */     this.primaryKeyField = defaultValues.getPrimaryKeyField();
/*     */ 
/* 398 */     Element notNullElement = MetaData.getOptionalChild(element, "not-null");
/* 399 */     this.notNull = ((this.fieldType.isPrimitive()) || (this.primaryKeyMember) || (notNullElement != null));
/*     */ 
/* 405 */     Iterator iterator = MetaData.getChildrenByTagName(element, "property");
/* 406 */     while (iterator.hasNext())
/*     */     {
/* 408 */       this.propertyOverrides.add(new JDBCCMPFieldPropertyMetaData(this, (Element)iterator.next()));
/*     */     }
/*     */ 
/* 412 */     this.autoIncrement = (MetaData.getOptionalChild(element, "auto-increment") != null);
/*     */ 
/* 415 */     if (MetaData.getOptionalChild(element, "dbindex") == null)
/* 416 */       this.genIndex = false;
/*     */     else {
/* 418 */       this.genIndex = true;
/*     */     }
/* 420 */     this.relationTableField = defaultValues.isRelationTableField();
/*     */ 
/* 422 */     this.checkDirtyAfterGet = readCheckDirtyAfterGet(element, defaultValues.getCheckDirtyAfterGet());
/*     */ 
/* 424 */     String stateFactoryStr = MetaData.getOptionalChildContent(element, "state-factory");
/* 425 */     if (stateFactoryStr == null)
/* 426 */       this.stateFactory = defaultValues.getStateFactory();
/*     */     else
/* 428 */       this.stateFactory = stateFactoryStr;
/*     */   }
/*     */ 
/*     */   public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, Element element, JDBCCMPFieldMetaData defaultValues, boolean primaryKeyMember, boolean notNull, boolean readOnly, int readTimeOut, boolean relationTableField)
/*     */     throws DeploymentException
/*     */   {
/* 454 */     this.entity = entity;
/* 455 */     this.fieldName = defaultValues.getFieldName();
/* 456 */     this.fieldType = defaultValues.getFieldType();
/* 457 */     String columnStr = MetaData.getOptionalChildContent(element, "column-name");
/* 458 */     if (columnStr != null)
/*     */     {
/* 460 */       this.columnName = columnStr;
/*     */     }
/*     */     else
/*     */     {
/* 464 */       this.columnName = defaultValues.getColumnName();
/*     */     }
/*     */ 
/* 468 */     String jdbcStr = MetaData.getOptionalChildContent(element, "jdbc-type");
/* 469 */     if (jdbcStr != null)
/*     */     {
/* 471 */       this.jdbcType = JDBCMappingMetaData.getJdbcTypeFromName(jdbcStr);
/* 472 */       this.sqlType = MetaData.getUniqueChildContent(element, "sql-type");
/*     */     }
/*     */     else
/*     */     {
/* 476 */       this.jdbcType = defaultValues.getJDBCType();
/* 477 */       this.sqlType = defaultValues.getSQLType();
/*     */     }
/*     */ 
/* 481 */     this.readOnly = readOnly;
/*     */ 
/* 484 */     this.readTimeOut = readTimeOut;
/*     */ 
/* 487 */     this.primaryKeyMember = primaryKeyMember;
/*     */ 
/* 490 */     this.notNull = notNull;
/*     */ 
/* 493 */     this.primaryKeyField = defaultValues.getPrimaryKeyField();
/*     */ 
/* 496 */     Iterator iterator = MetaData.getChildrenByTagName(element, "property");
/* 497 */     while (iterator.hasNext())
/*     */     {
/* 499 */       this.propertyOverrides.add(new JDBCCMPFieldPropertyMetaData(this, (Element)iterator.next()));
/*     */     }
/*     */ 
/* 502 */     this.unknownPkField = defaultValues.isUnknownPkField();
/* 503 */     this.autoIncrement = (MetaData.getOptionalChild(element, "auto-increment") != null);
/*     */ 
/* 505 */     if (MetaData.getOptionalChild(element, "dbindex") == null)
/* 506 */       this.genIndex = false;
/*     */     else {
/* 508 */       this.genIndex = true;
/*     */     }
/* 510 */     this.relationTableField = relationTableField;
/*     */ 
/* 512 */     String dirtyAfterGetStr = MetaData.getOptionalChildContent(element, "check-dirty-after-get");
/* 513 */     if (dirtyAfterGetStr == null)
/*     */     {
/* 515 */       this.checkDirtyAfterGet = defaultValues.getCheckDirtyAfterGet();
/*     */     }
/*     */     else
/*     */     {
/* 519 */       this.checkDirtyAfterGet = (Boolean.valueOf(dirtyAfterGetStr).booleanValue() ? 1 : 2);
/*     */     }
/*     */ 
/* 523 */     String stateFactoryStr = MetaData.getOptionalChildContent(element, "state-factory");
/* 524 */     if (stateFactoryStr == null)
/* 525 */       this.stateFactory = defaultValues.getStateFactory();
/*     */     else
/* 527 */       this.stateFactory = stateFactoryStr;
/*     */   }
/*     */ 
/*     */   public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, JDBCCMPFieldMetaData defaultValues, String columnName, boolean primaryKeyMember, boolean notNull, boolean readOnly, int readTimeOut, boolean relationTableField)
/*     */   {
/* 542 */     this.entity = entity;
/* 543 */     this.fieldName = defaultValues.getFieldName();
/* 544 */     this.fieldType = defaultValues.getFieldType();
/* 545 */     this.columnName = columnName;
/* 546 */     this.jdbcType = defaultValues.getJDBCType();
/* 547 */     this.sqlType = defaultValues.getSQLType();
/* 548 */     this.readOnly = readOnly;
/* 549 */     this.readTimeOut = readTimeOut;
/* 550 */     this.primaryKeyMember = primaryKeyMember;
/* 551 */     this.primaryKeyField = defaultValues.getPrimaryKeyField();
/* 552 */     this.notNull = notNull;
/*     */ 
/* 554 */     for (Iterator i = defaultValues.propertyOverrides.iterator(); i.hasNext(); )
/*     */     {
/* 556 */       this.propertyOverrides.add(new JDBCCMPFieldPropertyMetaData(this, (JDBCCMPFieldPropertyMetaData)i.next()));
/*     */     }
/*     */ 
/* 560 */     this.unknownPkField = defaultValues.isUnknownPkField();
/* 561 */     this.autoIncrement = false;
/* 562 */     this.genIndex = false;
/*     */ 
/* 564 */     this.relationTableField = relationTableField;
/* 565 */     this.checkDirtyAfterGet = defaultValues.getCheckDirtyAfterGet();
/* 566 */     this.stateFactory = defaultValues.getStateFactory();
/*     */   }
/*     */ 
/*     */   public JDBCCMPFieldMetaData(JDBCEntityMetaData entity, String fieldName, Class fieldType, String columnName, int jdbcType, String sqlType)
/*     */     throws DeploymentException
/*     */   {
/* 581 */     this.entity = entity;
/* 582 */     this.fieldName = fieldName;
/* 583 */     this.fieldType = fieldType;
/* 584 */     this.columnName = columnName;
/* 585 */     this.jdbcType = jdbcType;
/* 586 */     this.sqlType = sqlType;
/* 587 */     this.readOnly = false;
/* 588 */     this.readTimeOut = -1;
/* 589 */     this.primaryKeyMember = false;
/* 590 */     this.notNull = true;
/* 591 */     this.primaryKeyField = null;
/* 592 */     this.unknownPkField = false;
/* 593 */     this.autoIncrement = false;
/* 594 */     this.genIndex = false;
/* 595 */     this.relationTableField = false;
/* 596 */     this.checkDirtyAfterGet = 4;
/* 597 */     this.stateFactory = null;
/*     */   }
/*     */ 
/*     */   public JDBCEntityMetaData getEntity()
/*     */   {
/* 607 */     return this.entity;
/*     */   }
/*     */ 
/*     */   public String getFieldName()
/*     */   {
/* 616 */     return this.fieldName;
/*     */   }
/*     */ 
/*     */   public Class getFieldType()
/*     */   {
/* 625 */     return this.fieldType;
/*     */   }
/*     */ 
/*     */   public String getColumnName()
/*     */   {
/* 636 */     return this.columnName;
/*     */   }
/*     */ 
/*     */   public int getJDBCType()
/*     */   {
/* 646 */     return this.jdbcType;
/*     */   }
/*     */ 
/*     */   public String getSQLType()
/*     */   {
/* 656 */     return this.sqlType;
/*     */   }
/*     */ 
/*     */   public List getPropertyOverrides()
/*     */   {
/* 667 */     return Collections.unmodifiableList(this.propertyOverrides);
/*     */   }
/*     */ 
/*     */   public boolean isReadOnly()
/*     */   {
/* 677 */     return this.readOnly;
/*     */   }
/*     */ 
/*     */   public int getReadTimeOut()
/*     */   {
/* 688 */     return this.readTimeOut;
/*     */   }
/*     */ 
/*     */   public boolean isPrimaryKeyMember()
/*     */   {
/* 697 */     return this.primaryKeyMember;
/*     */   }
/*     */ 
/*     */   public boolean isNotNull()
/*     */   {
/* 706 */     return this.notNull;
/*     */   }
/*     */ 
/*     */   public boolean isIndexed()
/*     */   {
/* 718 */     return this.genIndex;
/*     */   }
/*     */ 
/*     */   public Field getPrimaryKeyField()
/*     */   {
/* 730 */     return this.primaryKeyField;
/*     */   }
/*     */ 
/*     */   public boolean isUnknownPkField()
/*     */   {
/* 739 */     return this.unknownPkField;
/*     */   }
/*     */ 
/*     */   public boolean isAutoIncrement()
/*     */   {
/* 747 */     return this.autoIncrement;
/*     */   }
/*     */ 
/*     */   public boolean isRelationTableField()
/*     */   {
/* 752 */     return this.relationTableField;
/*     */   }
/*     */ 
/*     */   public byte getCheckDirtyAfterGet()
/*     */   {
/* 757 */     return this.checkDirtyAfterGet;
/*     */   }
/*     */ 
/*     */   public String getStateFactory()
/*     */   {
/* 762 */     return this.stateFactory;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 775 */     if ((o instanceof JDBCCMPFieldMetaData))
/*     */     {
/* 777 */       JDBCCMPFieldMetaData cmpField = (JDBCCMPFieldMetaData)o;
/* 778 */       return (this.fieldName.equals(cmpField.fieldName)) && (this.entity.equals(cmpField.entity));
/*     */     }
/*     */ 
/* 781 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 792 */     int result = 17;
/* 793 */     result = 37 * result + this.entity.hashCode();
/* 794 */     result = 37 * result + this.fieldName.hashCode();
/* 795 */     return result;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 810 */     return "[JDBCCMPFieldMetaData : fieldName=" + this.fieldName + ", " + this.entity + "]";
/*     */   }
/*     */ 
/*     */   private Class loadFieldType(JDBCEntityMetaData entity, String fieldName)
/*     */     throws DeploymentException
/*     */   {
/* 824 */     if (entity.isCMP1x())
/*     */     {
/*     */       try
/*     */       {
/* 829 */         return entity.getEntityClass().getField(fieldName).getType();
/*     */       }
/*     */       catch (NoSuchFieldException e)
/*     */       {
/* 833 */         throw new DeploymentException("No field named '" + fieldName + "' found in entity class." + entity.getEntityClass().getName());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 841 */     String baseName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
/*     */ 
/* 843 */     String getName = "get" + baseName;
/* 844 */     String setName = "set" + baseName;
/*     */ 
/* 846 */     Method[] methods = entity.getEntityClass().getMethods();
/* 847 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 850 */       if ((!Modifier.isPublic(methods[i].getModifiers())) || (!Modifier.isAbstract(methods[i].getModifiers())))
/*     */       {
/*     */         continue;
/*     */       }
/*     */ 
/* 855 */       if ((getName.equals(methods[i].getName())) && (methods[i].getParameterTypes().length == 0) && (!methods[i].getReturnType().equals(Void.TYPE)))
/*     */       {
/* 859 */         return methods[i].getReturnType();
/*     */       }
/*     */ 
/* 863 */       if ((setName.equals(methods[i].getName())) && (methods[i].getParameterTypes().length == 1) && (methods[i].getReturnType().equals(Void.TYPE)))
/*     */       {
/* 868 */         return methods[i].getParameterTypes()[0];
/*     */       }
/*     */     }
/*     */ 
/* 872 */     throw new DeploymentException("No abstract accessors for field named '" + fieldName + "' found in entity class " + entity.getEntityClass().getName());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData
 * JD-Core Version:    0.6.0
 */