/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ 
/*     */ public final class JDBCRawSqlQueryMetaData
/*     */   implements JDBCQueryMetaData
/*     */ {
/*     */   private final Method method;
/*     */   private final Class compiler;
/*     */   private final boolean lazyResultSetLoading;
/*     */ 
/*     */   public JDBCRawSqlQueryMetaData(Method method, Class qlCompiler, boolean lazyResultSetLoading)
/*     */   {
/*  49 */     this.method = method;
/*  50 */     this.compiler = qlCompiler;
/*  51 */     this.lazyResultSetLoading = lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/*  56 */     return this.method;
/*     */   }
/*     */ 
/*     */   public boolean isResultTypeMappingLocal()
/*     */   {
/*  61 */     return false;
/*     */   }
/*     */ 
/*     */   public Class getQLCompilerClass()
/*     */   {
/*  66 */     return this.compiler;
/*     */   }
/*     */ 
/*     */   public JDBCReadAheadMetaData getReadAhead()
/*     */   {
/*  76 */     return JDBCReadAheadMetaData.DEFAULT;
/*     */   }
/*     */ 
/*     */   public boolean isLazyResultSetLoading()
/*     */   {
/*  81 */     return this.lazyResultSetLoading;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/*  94 */     if ((o instanceof JDBCRawSqlQueryMetaData))
/*     */     {
/*  96 */       return ((JDBCRawSqlQueryMetaData)o).method.equals(this.method);
/*     */     }
/*  98 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 109 */     return this.method.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 123 */     return "[JDBCRawSqlQueryMetaData : method=" + this.method + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRawSqlQueryMetaData
 * JD-Core Version:    0.6.0
 */