/*     */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.metadata.RelationMetaData;
/*     */ import org.jboss.metadata.RelationshipRoleMetaData;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public final class JDBCRelationshipRoleMetaData
/*     */ {
/*     */   private final JDBCRelationMetaData relationMetaData;
/*     */   private final String relationshipRoleName;
/*     */   private final boolean multiplicityOne;
/*     */   private final boolean foreignKeyConstraint;
/*     */   private final boolean cascadeDelete;
/*     */   private final boolean batchCascadeDelete;
/*     */   private final JDBCEntityMetaData entity;
/*     */   private final String cmrFieldName;
/*     */   private final boolean navigable;
/*     */   private final String cmrFieldType;
/*     */   private boolean genIndex;
/*     */   private final JDBCReadAheadMetaData readAhead;
/*     */   private JDBCRelationshipRoleMetaData relatedRole;
/*     */   private Map keyFields;
/*     */ 
/*     */   public JDBCRelationshipRoleMetaData(JDBCRelationMetaData relationMetaData, JDBCApplicationMetaData application, RelationshipRoleMetaData role)
/*     */     throws DeploymentException
/*     */   {
/*  92 */     this.relationMetaData = relationMetaData;
/*     */ 
/*  94 */     this.relationshipRoleName = role.getRelationshipRoleName();
/*  95 */     this.multiplicityOne = role.isMultiplicityOne();
/*  96 */     this.cascadeDelete = role.isCascadeDelete();
/*  97 */     this.batchCascadeDelete = false;
/*  98 */     this.foreignKeyConstraint = false;
/*  99 */     this.readAhead = null;
/*     */ 
/* 101 */     String fieldName = loadCMRFieldName(role);
/* 102 */     if (fieldName == null)
/*     */     {
/* 104 */       this.cmrFieldName = generateNonNavigableCMRName(role);
/* 105 */       this.navigable = false;
/*     */     }
/*     */     else
/*     */     {
/* 109 */       this.cmrFieldName = fieldName;
/* 110 */       this.navigable = true;
/*     */     }
/* 112 */     this.cmrFieldType = role.getCMRFieldType();
/*     */ 
/* 115 */     this.entity = application.getBeanByEjbName(role.getEntityName());
/* 116 */     if (this.entity == null)
/*     */     {
/* 118 */       throw new DeploymentException("Entity: " + role.getEntityName() + " not found for relation: " + role.getRelationMetaData().getRelationName());
/*     */     }
/*     */   }
/*     */ 
/*     */   public JDBCRelationshipRoleMetaData(JDBCRelationMetaData relationMetaData, JDBCApplicationMetaData application, Element element, JDBCRelationshipRoleMetaData defaultValues)
/*     */     throws DeploymentException
/*     */   {
/* 130 */     this.relationMetaData = relationMetaData;
/* 131 */     this.entity = application.getBeanByEjbName(defaultValues.getEntity().getName());
/*     */ 
/* 133 */     this.relationshipRoleName = defaultValues.getRelationshipRoleName();
/* 134 */     this.multiplicityOne = defaultValues.isMultiplicityOne();
/* 135 */     this.cascadeDelete = defaultValues.isCascadeDelete();
/*     */ 
/* 137 */     this.cmrFieldName = defaultValues.getCMRFieldName();
/* 138 */     this.navigable = defaultValues.isNavigable();
/* 139 */     this.cmrFieldType = defaultValues.getCMRFieldType();
/*     */ 
/* 142 */     String fkString = MetaData.getOptionalChildContent(element, "fk-constraint");
/* 143 */     if (fkString != null)
/*     */     {
/* 145 */       this.foreignKeyConstraint = Boolean.valueOf(fkString).booleanValue();
/*     */     }
/*     */     else
/*     */     {
/* 149 */       this.foreignKeyConstraint = defaultValues.hasForeignKeyConstraint();
/*     */     }
/*     */ 
/* 153 */     Element readAheadElement = MetaData.getOptionalChild(element, "read-ahead");
/* 154 */     if (readAheadElement != null)
/*     */     {
/* 156 */       this.readAhead = new JDBCReadAheadMetaData(readAheadElement, this.entity.getReadAhead());
/*     */     }
/*     */     else
/*     */     {
/* 160 */       this.readAhead = this.entity.getReadAhead();
/*     */     }
/*     */ 
/* 163 */     this.batchCascadeDelete = (MetaData.getOptionalChild(element, "batch-cascade-delete") != null);
/* 164 */     if (this.batchCascadeDelete)
/*     */     {
/* 166 */       if (!this.cascadeDelete) {
/* 167 */         throw new DeploymentException(relationMetaData.getRelationName() + '/' + this.relationshipRoleName + " has batch-cascade-delete in jbosscmp-jdbc.xml but has no cascade-delete in ejb-jar.xml");
/*     */       }
/*     */ 
/* 172 */       if (relationMetaData.isTableMappingStyle())
/*     */       {
/* 174 */         throw new DeploymentException("Relationship " + relationMetaData.getRelationName() + " with relation-table-mapping style was setup for batch cascade-delete." + " Batch cascade-delete supported only for foreign key mapping style.");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void init(JDBCRelationshipRoleMetaData relatedRole)
/*     */     throws DeploymentException
/*     */   {
/* 186 */     init(relatedRole, null);
/*     */   }
/*     */ 
/*     */   public void init(JDBCRelationshipRoleMetaData relatedRole, Element element)
/*     */     throws DeploymentException
/*     */   {
/* 192 */     this.relatedRole = relatedRole;
/* 193 */     if ((element == null) || ("defaults".equals(element.getTagName())))
/*     */     {
/* 195 */       this.keyFields = loadKeyFields();
/*     */     }
/*     */     else
/*     */     {
/* 199 */       this.keyFields = loadKeyFields(element);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static String loadCMRFieldName(RelationshipRoleMetaData role)
/*     */   {
/* 205 */     return role.getCMRFieldName();
/*     */   }
/*     */ 
/*     */   private static String generateNonNavigableCMRName(RelationshipRoleMetaData role)
/*     */   {
/* 210 */     RelationshipRoleMetaData relatedRole = role.getRelatedRoleMetaData();
/* 211 */     return relatedRole.getEntityName() + "_" + relatedRole.getCMRFieldName();
/*     */   }
/*     */ 
/*     */   public JDBCRelationMetaData getRelationMetaData()
/*     */   {
/* 219 */     return this.relationMetaData;
/*     */   }
/*     */ 
/*     */   public String getRelationshipRoleName()
/*     */   {
/* 227 */     return this.relationshipRoleName;
/*     */   }
/*     */ 
/*     */   public boolean hasForeignKeyConstraint()
/*     */   {
/* 237 */     return this.foreignKeyConstraint;
/*     */   }
/*     */ 
/*     */   public boolean isMultiplicityOne()
/*     */   {
/* 245 */     return this.multiplicityOne;
/*     */   }
/*     */ 
/*     */   public boolean isMultiplicityMany()
/*     */   {
/* 253 */     return !this.multiplicityOne;
/*     */   }
/*     */ 
/*     */   public boolean isCascadeDelete()
/*     */   {
/* 261 */     return this.cascadeDelete;
/*     */   }
/*     */ 
/*     */   public boolean isBatchCascadeDelete()
/*     */   {
/* 266 */     return this.batchCascadeDelete;
/*     */   }
/*     */ 
/*     */   public JDBCEntityMetaData getEntity()
/*     */   {
/* 274 */     return this.entity;
/*     */   }
/*     */ 
/*     */   public String getCMRFieldName()
/*     */   {
/* 282 */     return this.cmrFieldName;
/*     */   }
/*     */ 
/*     */   public boolean isNavigable()
/*     */   {
/* 287 */     return this.navigable;
/*     */   }
/*     */ 
/*     */   private String getCMRFieldType()
/*     */   {
/* 295 */     return this.cmrFieldType;
/*     */   }
/*     */ 
/*     */   public JDBCRelationshipRoleMetaData getRelatedRole()
/*     */   {
/* 303 */     return this.relationMetaData.getOtherRelationshipRole(this);
/*     */   }
/*     */ 
/*     */   public JDBCReadAheadMetaData getReadAhead()
/*     */   {
/* 311 */     return this.readAhead;
/*     */   }
/*     */ 
/*     */   public Collection getKeyFields()
/*     */   {
/* 320 */     return Collections.unmodifiableCollection(this.keyFields.values());
/*     */   }
/*     */ 
/*     */   public boolean isIndexed()
/*     */   {
/* 325 */     return this.genIndex;
/*     */   }
/*     */ 
/*     */   private Map loadKeyFields()
/*     */   {
/* 337 */     if (this.relationMetaData.isForeignKeyMappingStyle())
/*     */     {
/* 339 */       if (isMultiplicityMany()) {
/* 340 */         return Collections.EMPTY_MAP;
/*     */       }
/* 342 */       if ((getRelatedRole().isMultiplicityOne()) && (!getRelatedRole().isNavigable())) {
/* 343 */         return Collections.EMPTY_MAP;
/*     */       }
/*     */     }
/*     */ 
/* 347 */     ArrayList pkFields = new ArrayList();
/* 348 */     for (Iterator i = this.entity.getCMPFields().iterator(); i.hasNext(); )
/*     */     {
/* 350 */       JDBCCMPFieldMetaData cmpField = (JDBCCMPFieldMetaData)i.next();
/* 351 */       if (cmpField.isPrimaryKeyMember())
/*     */       {
/* 353 */         pkFields.add(cmpField);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 358 */     Map fields = new HashMap(pkFields.size());
/* 359 */     for (Iterator i = pkFields.iterator(); i.hasNext(); )
/*     */     {
/* 361 */       JDBCCMPFieldMetaData cmpField = (JDBCCMPFieldMetaData)i.next();
/*     */       String columnName;
/*     */       String columnName;
/* 364 */       if (this.relationMetaData.isTableMappingStyle())
/*     */       {
/*     */         String columnName;
/* 366 */         if (this.entity.equals(this.relatedRole.getEntity()))
/* 367 */           columnName = getCMRFieldName();
/*     */         else
/* 369 */           columnName = this.entity.getName();
/*     */       }
/*     */       else
/*     */       {
/* 373 */         columnName = this.relatedRole.getCMRFieldName();
/*     */       }
/*     */ 
/* 376 */       if (pkFields.size() > 1)
/*     */       {
/* 378 */         columnName = columnName + "_" + cmpField.getFieldName();
/*     */       }
/*     */ 
/* 381 */       cmpField = new JDBCCMPFieldMetaData(this.entity, cmpField, columnName, false, this.relationMetaData.isTableMappingStyle(), this.relationMetaData.isReadOnly(), this.relationMetaData.getReadTimeOut(), this.relationMetaData.isTableMappingStyle());
/*     */ 
/* 390 */       fields.put(cmpField.getFieldName(), cmpField);
/*     */     }
/* 392 */     return Collections.unmodifiableMap(fields);
/*     */   }
/*     */ 
/*     */   private Map loadKeyFields(Element element)
/*     */     throws DeploymentException
/*     */   {
/* 402 */     Element keysElement = MetaData.getOptionalChild(element, "key-fields");
/*     */ 
/* 405 */     if (keysElement == null)
/*     */     {
/* 407 */       return loadKeyFields();
/*     */     }
/*     */ 
/* 411 */     Iterator iter = MetaData.getChildrenByTagName(keysElement, "key-field");
/*     */ 
/* 414 */     if (!iter.hasNext())
/*     */     {
/* 416 */       return Collections.EMPTY_MAP;
/*     */     }
/*     */ 
/* 419 */     if ((this.relationMetaData.isForeignKeyMappingStyle()) && (isMultiplicityMany()))
/*     */     {
/* 421 */       throw new DeploymentException("Role: " + this.relationshipRoleName + " with multiplicity many using " + "foreign-key mapping is not allowed to have key-fields");
/*     */     }
/*     */ 
/* 426 */     Map defaultFields = getPrimaryKeyFields();
/*     */ 
/* 429 */     Map fields = new HashMap(defaultFields.size());
/* 430 */     while (iter.hasNext())
/*     */     {
/* 432 */       Element keyElement = (Element)iter.next();
/* 433 */       String fieldName = MetaData.getUniqueChildContent(keyElement, "field-name");
/*     */ 
/* 435 */       JDBCCMPFieldMetaData cmpField = (JDBCCMPFieldMetaData)defaultFields.remove(fieldName);
/* 436 */       if (cmpField == null)
/*     */       {
/* 438 */         throw new DeploymentException("Role '" + this.relationshipRoleName + "' on Entity Bean '" + this.entity.getName() + "' : CMP field for key not found: field " + "name='" + fieldName + "'");
/*     */       }
/*     */ 
/* 443 */       String isIndexedtmp = MetaData.getOptionalChildContent(keyElement, "dbindex");
/*     */       boolean isIndexed;
/*     */       boolean isIndexed;
/* 446 */       if (isIndexedtmp != null)
/* 447 */         isIndexed = true;
/*     */       else
/* 449 */         isIndexed = false;
/* 450 */       this.genIndex = isIndexed;
/*     */ 
/* 453 */       cmpField = new JDBCCMPFieldMetaData(this.entity, keyElement, cmpField, false, this.relationMetaData.isTableMappingStyle(), this.relationMetaData.isReadOnly(), this.relationMetaData.getReadTimeOut(), this.relationMetaData.isTableMappingStyle());
/*     */ 
/* 462 */       fields.put(cmpField.getFieldName(), cmpField);
/*     */     }
/*     */ 
/* 466 */     if (!defaultFields.isEmpty())
/*     */     {
/* 468 */       throw new DeploymentException("Mappings were not provided for all fields: unmaped fields=" + defaultFields.keySet() + " in role=" + this.relationshipRoleName);
/*     */     }
/*     */ 
/* 472 */     return Collections.unmodifiableMap(fields);
/*     */   }
/*     */ 
/*     */   private Map getPrimaryKeyFields()
/*     */   {
/* 480 */     Map pkFields = new HashMap();
/* 481 */     for (Iterator cmpFieldsIter = this.entity.getCMPFields().iterator(); cmpFieldsIter.hasNext(); )
/*     */     {
/* 483 */       JDBCCMPFieldMetaData cmpField = (JDBCCMPFieldMetaData)cmpFieldsIter.next();
/* 484 */       if (cmpField.isPrimaryKeyMember())
/* 485 */         pkFields.put(cmpField.getFieldName(), cmpField);
/*     */     }
/* 487 */     return pkFields;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData
 * JD-Core Version:    0.6.0
 */