/*    */ package org.jboss.ejb.plugins.cmp.jdbc.metadata;
/*    */ 
/*    */ import org.jboss.deployment.DeploymentException;
/*    */ import org.jboss.metadata.MetaData;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public class JDBCUserTypeMappingMetaData
/*    */ {
/*    */   private final String javaType;
/*    */   private final String mappedType;
/*    */   private final String mapper;
/*    */   private final byte checkDirtyAfterGet;
/*    */   private final String stateFactory;
/*    */ 
/*    */   public JDBCUserTypeMappingMetaData(Element userMappingEl)
/*    */     throws DeploymentException
/*    */   {
/* 50 */     this.javaType = MetaData.getUniqueChildContent(userMappingEl, "java-type");
/* 51 */     this.mappedType = MetaData.getUniqueChildContent(userMappingEl, "mapped-type");
/* 52 */     this.mapper = MetaData.getUniqueChildContent(userMappingEl, "mapper");
/* 53 */     this.checkDirtyAfterGet = JDBCCMPFieldMetaData.readCheckDirtyAfterGet(userMappingEl);
/* 54 */     this.stateFactory = MetaData.getOptionalChildContent(userMappingEl, "state-factory");
/*    */   }
/*    */ 
/*    */   public String getJavaType()
/*    */   {
/* 59 */     return this.javaType;
/*    */   }
/*    */ 
/*    */   public String getMappedType()
/*    */   {
/* 64 */     return this.mappedType;
/*    */   }
/*    */ 
/*    */   public String getMapper()
/*    */   {
/* 69 */     return this.mapper;
/*    */   }
/*    */ 
/*    */   public byte checkDirtyAfterGet()
/*    */   {
/* 74 */     return this.checkDirtyAfterGet;
/*    */   }
/*    */ 
/*    */   public String getStateFactory()
/*    */   {
/* 79 */     return this.stateFactory;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCUserTypeMappingMetaData
 * JD-Core Version:    0.6.0
 */