/*     */ package org.jboss.ejb.plugins.cmp.jdbc2;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.FinderException;
/*     */ import javax.ejb.ObjectNotFoundException;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory;
/*     */ import org.jboss.ejb.plugins.cmp.ejbql.SelectFunction;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.QueryParameter;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.EntityTable;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class AbstractQueryCommand
/*     */   implements QueryCommand
/*     */ {
/*  52 */   static final CollectionFactory COLLECTION_FACTORY = new CollectionFactory()
/*     */   {
/*     */     public Collection newCollection()
/*     */     {
/*  56 */       return new ArrayList();
/*     */     }
/*  52 */   };
/*     */ 
/*  60 */   static final CollectionFactory SET_FACTORY = new CollectionFactory()
/*     */   {
/*     */     public Collection newCollection()
/*     */     {
/*  64 */       return new HashSet(); }  } ;
/*     */   protected String sql;
/*     */   protected Logger log;
/*     */   protected JDBCEntityBridge2 entity;
/*     */   protected QueryParameter[] params;
/*     */   private CollectionFactory collectionFactory;
/*     */   private CollectionStrategy collectionStrategy;
/*     */   private ResultReader resultReader;
/*     */   private int offsetParam;
/*     */   private int offsetValue;
/*     */   private int limitParam;
/*     */   private int limitValue;
/*     */ 
/*  71 */   public AbstractQueryCommand() { this.params = null;
/*     */   }
/*     */ 
/*     */   protected void setResultType(Class clazz)
/*     */   {
/*  84 */     if (Set.class.isAssignableFrom(clazz))
/*     */     {
/*  86 */       this.collectionFactory = SET_FACTORY;
/*     */     }
/*  88 */     else if (Collection.class.isAssignableFrom(clazz))
/*     */     {
/*  90 */       this.collectionFactory = COLLECTION_FACTORY;
/*     */     }
/*  92 */     initCollectionStrategy();
/*     */   }
/*     */ 
/*     */   protected void setFieldReader(JDBCCMPFieldBridge2 field)
/*     */   {
/*  97 */     this.resultReader = new FieldReader(field);
/*  98 */     initCollectionStrategy();
/*     */   }
/*     */ 
/*     */   protected void setFunctionReader(SelectFunction func)
/*     */   {
/* 103 */     this.resultReader = new FunctionReader(func);
/* 104 */     initCollectionStrategy();
/*     */   }
/*     */ 
/*     */   protected void setEntityReader(JDBCEntityBridge2 entity, boolean searchableOnly)
/*     */   {
/* 109 */     this.entity = entity;
/* 110 */     this.resultReader = new EntityReader(entity, searchableOnly);
/* 111 */     initCollectionStrategy();
/*     */   }
/*     */ 
/*     */   private void initCollectionStrategy()
/*     */   {
/* 116 */     if ((this.collectionFactory != null) && (this.resultReader != null))
/*     */     {
/* 118 */       this.collectionStrategy = new EagerCollectionStrategy(this.collectionFactory, this.resultReader, this.log);
/*     */     }
/*     */   }
/*     */ 
/*     */   public JDBCStoreManager2 getStoreManager()
/*     */   {
/* 126 */     return (JDBCStoreManager2)this.entity.getManager();
/*     */   }
/*     */ 
/*     */   public Collection fetchCollection(Schema schema, GenericEntityObjectFactory factory, Object[] args)
/*     */     throws FinderException
/*     */   {
/* 132 */     int offset = toInt(args, this.offsetParam, this.offsetValue);
/* 133 */     int limit = toInt(args, this.limitParam, this.limitValue);
/* 134 */     return fetchCollection(this.entity, this.sql, this.params, offset, limit, this.collectionStrategy, schema, factory, args, this.log);
/*     */   }
/*     */ 
/*     */   public Object fetchOne(Schema schema, GenericEntityObjectFactory factory, Object[] args) throws FinderException
/*     */   {
/* 139 */     schema.flush();
/* 140 */     return executeFetchOne(args, factory);
/*     */   }
/*     */ 
/*     */   public void setOffsetValue(int offsetValue)
/*     */   {
/* 145 */     this.offsetValue = offsetValue;
/*     */   }
/*     */ 
/*     */   public void setLimitValue(int limitValue)
/*     */   {
/* 150 */     this.limitValue = limitValue;
/*     */   }
/*     */ 
/*     */   public void setOffsetParam(int offsetParam)
/*     */   {
/* 155 */     this.offsetParam = offsetParam;
/*     */   }
/*     */ 
/*     */   public void setLimitParam(int limitParam)
/*     */   {
/* 160 */     this.limitParam = limitParam;
/*     */   }
/*     */ 
/*     */   protected static int toInt(Object[] params, int paramNumber, int defaultValue)
/*     */   {
/* 167 */     if (paramNumber == 0)
/*     */     {
/* 169 */       return defaultValue;
/*     */     }
/* 171 */     Integer arg = (Integer)params[(paramNumber - 1)];
/* 172 */     return arg.intValue();
/*     */   }
/*     */ 
/*     */   protected Object executeFetchOne(Object[] args, GenericEntityObjectFactory factory) throws FinderException
/*     */   {
/* 177 */     return fetchOne(this.entity, this.sql, this.params, this.resultReader, args, factory, this.log);
/*     */   }
/*     */ 
/*     */   static Collection fetchCollection(JDBCEntityBridge2 entity, String sql, QueryParameter[] params, int offset, int limit, CollectionStrategy collectionStrategy, Schema schema, GenericEntityObjectFactory factory, Object[] args, Logger log)
/*     */     throws FinderException
/*     */   {
/* 192 */     schema.flush();
/*     */ 
/* 194 */     int count = offset;
/*     */ 
/* 197 */     Connection con = null;
/* 198 */     PreparedStatement ps = null;
/* 199 */     ResultSet rs = null;
/* 200 */     boolean throwRuntimeExceptions = entity.getMetaData().getThrowRuntimeExceptions();
/*     */ 
/* 204 */     if (throwRuntimeExceptions)
/*     */     {
/*     */       try
/*     */       {
/* 208 */         con = entity.getDataSource().getConnection();
/*     */       }
/*     */       catch (SQLException sqle)
/*     */       {
/* 212 */         EJBException ejbe = new EJBException("Could not get a connection; " + sqle);
/* 213 */         ejbe.initCause(sqle);
/* 214 */         throw ejbe;
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/* 219 */       if (log.isDebugEnabled())
/*     */       {
/* 221 */         log.debug("executing: " + sql);
/*     */       }
/*     */ 
/* 225 */       if (!throwRuntimeExceptions)
/*     */       {
/* 227 */         con = entity.getDataSource().getConnection();
/*     */       }
/* 229 */       ps = con.prepareStatement(sql);
/*     */ 
/* 231 */       if (params != null)
/*     */       {
/* 233 */         for (int i = 0; i < params.length; i++)
/*     */         {
/* 235 */           params[i].set(log, ps, i + 1, args);
/*     */         }
/*     */       }
/*     */ 
/* 239 */       rs = ps.executeQuery();
/*     */ 
/* 242 */       while ((count > 0) && (rs.next()))
/*     */       {
/* 244 */         count--;
/*     */       }
/*     */ 
/* 247 */       count = limit;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 251 */       JDBCUtil.safeClose(rs);
/* 252 */       JDBCUtil.safeClose(ps);
/* 253 */       JDBCUtil.safeClose(con);
/*     */ 
/* 255 */       log.error("Finder failed: " + e.getMessage(), e);
/* 256 */       FinderException fe = new FinderException(e.getMessage());
/* 257 */       fe.initCause(e);
/* 258 */       throw fe;
/*     */     }
/*     */ 
/* 261 */     Collection result = collectionStrategy.readResultSet(con, ps, rs, limit, count, factory);
/*     */ 
/* 263 */     return result;
/*     */   }
/*     */ 
/*     */   static Object fetchOne(JDBCEntityBridge2 entity, String sql, QueryParameter[] params, ResultReader resultReader, Object[] args, GenericEntityObjectFactory factory, Logger log)
/*     */     throws FinderException
/*     */   {
/* 276 */     Connection con = null;
/* 277 */     PreparedStatement ps = null;
/* 278 */     ResultSet rs = null;
/* 279 */     boolean throwRuntimeExceptions = entity.getMetaData().getThrowRuntimeExceptions();
/*     */ 
/* 283 */     if (throwRuntimeExceptions)
/*     */     {
/*     */       try
/*     */       {
/* 287 */         con = entity.getDataSource().getConnection();
/*     */       }
/*     */       catch (SQLException sqle)
/*     */       {
/* 291 */         EJBException ejbe = new EJBException("Could not get a connection; " + sqle);
/*     */ 
/* 293 */         throw ejbe;
/*     */       }
/*     */     }
/*     */     Object pk;
/*     */     try {
/* 298 */       if (log.isDebugEnabled())
/*     */       {
/* 300 */         log.debug("executing: " + sql);
/*     */       }
/*     */ 
/* 304 */       if (!throwRuntimeExceptions)
/*     */       {
/* 306 */         con = entity.getDataSource().getConnection();
/*     */       }
/* 308 */       ps = con.prepareStatement(sql);
/*     */ 
/* 310 */       if (params != null)
/*     */       {
/* 312 */         for (int i = 0; i < params.length; i++)
/*     */         {
/* 314 */           params[i].set(log, ps, i + 1, args);
/*     */         }
/*     */       }
/*     */ 
/* 318 */       rs = ps.executeQuery();
/* 319 */       if (rs.next())
/*     */       {
/* 321 */         Object pk = resultReader.readRow(rs, factory);
/* 322 */         if (rs.next())
/*     */         {
/* 324 */           List list = new ArrayList();
/* 325 */           list.add(pk);
/* 326 */           list.add(resultReader.readRow(rs, factory));
/* 327 */           while (rs.next())
/*     */           {
/* 329 */             list.add(resultReader.readRow(rs, factory));
/*     */           }
/* 331 */           throw new FinderException("More than one instance matches the single-object finder criteria: " + list);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 336 */         throw new ObjectNotFoundException();
/*     */       }
/*     */     }
/*     */     catch (FinderException e)
/*     */     {
/* 341 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 345 */       FinderException fe = new FinderException(e.getMessage());
/* 346 */       fe.initCause(e);
/* 347 */       throw fe;
/*     */     }
/*     */     finally
/*     */     {
/* 351 */       JDBCUtil.safeClose(rs);
/* 352 */       JDBCUtil.safeClose(ps);
/* 353 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */ 
/* 356 */     return pk;
/*     */   }
/*     */ 
/*     */   protected void setParameters(List p)
/*     */   {
/* 361 */     if (p.size() > 0)
/*     */     {
/* 363 */       this.params = new QueryParameter[p.size()];
/* 364 */       for (int i = 0; i < p.size(); i++)
/*     */       {
/* 366 */         Object pi = p.get(i);
/* 367 */         if (!(pi instanceof QueryParameter))
/*     */         {
/* 369 */           throw new IllegalArgumentException("Element " + i + " of list is not an instance of QueryParameter, but " + p.get(i).getClass().getName());
/*     */         }
/*     */ 
/* 376 */         this.params[i] = ((QueryParameter)pi);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static class EagerCollectionStrategy
/*     */     implements AbstractQueryCommand.CollectionStrategy
/*     */   {
/*     */     private final AbstractQueryCommand.CollectionFactory collectionFactory;
/*     */     private final AbstractQueryCommand.ResultReader resultReader;
/*     */     private final Logger log;
/*     */ 
/*     */     public EagerCollectionStrategy(AbstractQueryCommand.CollectionFactory collectionFactory, AbstractQueryCommand.ResultReader resultReader, Logger log)
/*     */     {
/* 457 */       this.collectionFactory = collectionFactory;
/* 458 */       this.resultReader = resultReader;
/* 459 */       this.log = log;
/*     */     }
/*     */ 
/*     */     public Collection readResultSet(Connection con, PreparedStatement ps, ResultSet rs, int limit, int count, GenericEntityObjectFactory factory)
/*     */       throws FinderException
/*     */     {
/*     */       Collection result;
/*     */       try
/*     */       {
/* 472 */         if (((limit == 0) || (count-- > 0)) && (rs.next()))
/*     */         {
/* 474 */           Collection result = this.collectionFactory.newCollection();
/* 475 */           Object instance = this.resultReader.readRow(rs, factory);
/* 476 */           result.add(instance);
/* 477 */           while (((limit == 0) || (count-- > 0)) && (rs.next()))
/*     */           {
/* 479 */             instance = this.resultReader.readRow(rs, factory);
/* 480 */             result.add(instance);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 485 */           result = Collections.EMPTY_SET;
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 490 */         this.log.error("Finder failed: " + e.getMessage(), e);
/* 491 */         throw new FinderException(e.getMessage());
/*     */       }
/*     */       finally
/*     */       {
/* 495 */         JDBCUtil.safeClose(rs);
/* 496 */         JDBCUtil.safeClose(ps);
/* 497 */         JDBCUtil.safeClose(con);
/*     */       }
/* 499 */       return result;
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface CollectionStrategy
/*     */   {
/*     */     public abstract Collection readResultSet(Connection paramConnection, PreparedStatement paramPreparedStatement, ResultSet paramResultSet, int paramInt1, int paramInt2, GenericEntityObjectFactory paramGenericEntityObjectFactory)
/*     */       throws FinderException;
/*     */   }
/*     */ 
/*     */   static class FunctionReader
/*     */     implements AbstractQueryCommand.ResultReader
/*     */   {
/*     */     private final SelectFunction function;
/*     */ 
/*     */     public FunctionReader(SelectFunction function)
/*     */     {
/* 432 */       this.function = function;
/*     */     }
/*     */ 
/*     */     public Object readRow(ResultSet rs, GenericEntityObjectFactory factory) throws SQLException
/*     */     {
/* 437 */       return this.function.readResult(rs);
/*     */     }
/*     */   }
/*     */ 
/*     */   static class FieldReader
/*     */     implements AbstractQueryCommand.ResultReader
/*     */   {
/*     */     private final JDBCCMPFieldBridge2 field;
/*     */ 
/*     */     public FieldReader(JDBCCMPFieldBridge2 field)
/*     */     {
/* 417 */       this.field = field;
/*     */     }
/*     */ 
/*     */     public Object readRow(ResultSet rs, GenericEntityObjectFactory factory) throws SQLException
/*     */     {
/* 422 */       return this.field.loadArgumentResults(rs, 1);
/*     */     }
/*     */   }
/*     */ 
/*     */   static class EntityReader
/*     */     implements AbstractQueryCommand.ResultReader
/*     */   {
/*     */     private final JDBCEntityBridge2 entity;
/*     */     private final boolean searchableOnly;
/*     */ 
/*     */     public EntityReader(JDBCEntityBridge2 entity, boolean searchableOnly)
/*     */     {
/* 400 */       this.entity = entity;
/* 401 */       this.searchableOnly = searchableOnly;
/*     */     }
/*     */ 
/*     */     public Object readRow(ResultSet rs, GenericEntityObjectFactory factory)
/*     */     {
/* 406 */       Object pk = this.entity.getTable().loadRow(rs, this.searchableOnly);
/* 407 */       return pk == null ? null : factory.getEntityEJBObject(pk);
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface ResultReader
/*     */   {
/*     */     public abstract Object readRow(ResultSet paramResultSet, GenericEntityObjectFactory paramGenericEntityObjectFactory)
/*     */       throws SQLException;
/*     */   }
/*     */ 
/*     */   static abstract interface CollectionFactory
/*     */   {
/*     */     public abstract Collection newCollection();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.AbstractQueryCommand
 * JD-Core Version:    0.6.0
 */