/*    */ package org.jboss.ejb.plugins.cmp.jdbc2;
/*    */ 
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.deployment.DeploymentException;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.EJBQLToSQL92Compiler;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.QLCompiler;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQlQueryMetaData;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
/*    */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class EJBQLQueryCommand extends AbstractQueryCommand
/*    */ {
/*    */   public EJBQLQueryCommand(JDBCEntityBridge2 entity, JDBCQlQueryMetaData metadata)
/*    */     throws DeploymentException
/*    */   {
/* 42 */     this.entity = entity;
/*    */ 
/* 44 */     JDBCStoreManager2 manager = (JDBCStoreManager2)entity.getManager();
/* 45 */     QLCompiler compiler = new EJBQLToSQL92Compiler(manager.getCatalog());
/*    */     try
/*    */     {
/* 49 */       compiler.compileEJBQL(metadata.getEjbQl(), metadata.getMethod().getReturnType(), metadata.getMethod().getParameterTypes(), metadata);
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 57 */       t.printStackTrace();
/* 58 */       throw new DeploymentException("Error compiling EJBQL statement '" + metadata.getEjbQl() + "'", t);
/*    */     }
/*    */ 
/* 61 */     this.sql = compiler.getSQL();
/*    */ 
/* 63 */     this.log = Logger.getLogger(getClass().getName() + "." + entity.getEntityName() + "#" + metadata.getMethod().getName());
/* 64 */     this.log.debug("sql: " + this.sql);
/*    */ 
/* 66 */     setParameters(compiler.getInputParameters());
/* 67 */     setResultType(metadata.getMethod().getReturnType());
/*    */ 
/* 69 */     if (!compiler.isSelectEntity())
/*    */     {
/* 71 */       if (compiler.isSelectField())
/*    */       {
/* 73 */         setFieldReader((JDBCCMPFieldBridge2)compiler.getSelectField());
/*    */       }
/*    */       else
/*    */       {
/* 77 */         setFunctionReader(compiler.getSelectFunction());
/*    */       }
/*    */     }
/*    */     else
/*    */     {
/* 82 */       setEntityReader((JDBCEntityBridge2)compiler.getSelectEntity(), compiler.isSelectDistinct());
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.EJBQLQueryCommand
 * JD-Core Version:    0.6.0
 */