/*     */ package org.jboss.ejb.plugins.cmp.jdbc2;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.ejb.CreateException;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.FinderException;
/*     */ import javax.ejb.RemoveException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EjbModule;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory;
/*     */ import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStartCommand;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCStopCommand;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeFactory;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCApplicationMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCXmlFileLoader;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.EntityTable;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.EntityTable.Row;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ApplicationMetaData;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ 
/*     */ public class JDBCStoreManager2
/*     */   implements JDBCEntityPersistenceStore
/*     */ {
/*     */   private static final String CATALOG = "CATALOG";
/*     */   private static final String SCHEMA = "SCHEMA";
/*     */   private static final String CREATED_MANAGERS = "CREATED_JDBCStoreManagers";
/*     */   private static final String CMP_JDBC = "CMP-JDBC";
/*     */   private EntityContainer container;
/*     */   private EjbModule ejbModule;
/*     */   private Logger log;
/*     */   private JDBCEntityMetaData metaData;
/*     */   private JDBCEntityBridge2 entityBridge;
/*     */   private JDBCTypeFactory typeFactory;
/*     */   private Schema schema;
/*     */   private InstanceFactory instanceFactory;
/*     */   private QueryFactory queryFactory;
/*     */   private CreateCommand createCmd;
/*     */   private JDBCStartCommand startCmd;
/*     */   private JDBCStopCommand stop;
/*  88 */   private final TransactionLocal cascadeDeleteRegistry = new TransactionLocal()
/*     */   {
/*     */     protected Object initialValue()
/*     */     {
/*  92 */       return new HashMap();
/*     */     }
/*  88 */   };
/*     */ 
/*     */   public Schema getSchema()
/*     */   {
/* 100 */     this.schema = ((Schema)getApplicationData("SCHEMA"));
/* 101 */     if (this.schema == null)
/*     */     {
/* 103 */       this.schema = new Schema();
/* 104 */       putApplicationData("SCHEMA", this.schema);
/*     */     }
/* 106 */     return this.schema;
/*     */   }
/*     */ 
/*     */   public Catalog getCatalog()
/*     */   {
/* 111 */     Catalog catalog = (Catalog)getApplicationData("CATALOG");
/* 112 */     if (catalog == null)
/*     */     {
/* 114 */       catalog = new Catalog();
/* 115 */       putApplicationData("CATALOG", catalog);
/*     */     }
/* 117 */     return catalog;
/*     */   }
/*     */ 
/*     */   public QueryFactory getQueryFactory()
/*     */   {
/* 122 */     return this.queryFactory;
/*     */   }
/*     */ 
/*     */   public boolean registerCascadeDelete(Object key, Object value)
/*     */   {
/* 127 */     Map map = (Map)this.cascadeDeleteRegistry.get();
/* 128 */     return map.put(key, value) == null;
/*     */   }
/*     */ 
/*     */   public boolean isCascadeDeleted(Object key)
/*     */   {
/* 133 */     Map map = (Map)this.cascadeDeleteRegistry.get();
/* 134 */     return map.containsKey(key);
/*     */   }
/*     */ 
/*     */   public void unregisterCascadeDelete(Object key)
/*     */   {
/* 139 */     Map map = (Map)this.cascadeDeleteRegistry.get();
/* 140 */     map.remove(key);
/*     */   }
/*     */ 
/*     */   public void setContainer(Container con)
/*     */   {
/* 147 */     this.container = ((EntityContainer)con);
/* 148 */     if (this.container != null)
/*     */     {
/* 150 */       this.ejbModule = this.container.getEjbModule();
/* 151 */       this.log = Logger.getLogger(getClass().getName() + "." + this.container.getBeanMetaData().getEjbName());
/*     */     }
/*     */     else
/*     */     {
/* 156 */       this.ejbModule = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/* 164 */     HashMap managersMap = (HashMap)getApplicationData("CREATED_JDBCStoreManagers");
/* 165 */     if (managersMap == null)
/*     */     {
/* 167 */       managersMap = new HashMap();
/* 168 */       putApplicationData("CREATED_JDBCStoreManagers", managersMap);
/*     */     }
/* 170 */     managersMap.put(this.container.getBeanMetaData().getEjbName(), this);
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 175 */     initStoreManager();
/*     */ 
/* 177 */     HashMap managersMap = (HashMap)getApplicationData("CREATED_JDBCStoreManagers");
/* 178 */     Catalog catalog = getCatalog();
/* 179 */     if ((catalog.getEntityCount() == managersMap.size()) && (catalog.getEJBNames().equals(managersMap.keySet())))
/*     */     {
/* 182 */       List managers = new ArrayList(managersMap.values());
/*     */ 
/* 185 */       for (int i = 0; i < managers.size(); i++)
/*     */       {
/* 187 */         JDBCStoreManager2 manager = (JDBCStoreManager2)managers.get(i);
/* 188 */         manager.resolveRelationships();
/*     */       }
/*     */ 
/* 192 */       for (int i = 0; i < managers.size(); i++)
/*     */       {
/* 194 */         JDBCStoreManager2 manager = (JDBCStoreManager2)managers.get(i);
/* 195 */         manager.startEntity();
/*     */       }
/*     */ 
/* 199 */       for (int i = 0; i < managers.size(); i++)
/*     */       {
/* 201 */         JDBCStoreManager2 manager = (JDBCStoreManager2)managers.get(i);
/* 202 */         manager.startStoreManager();
/*     */       }
/*     */ 
/* 206 */       for (int i = 0; i < managers.size(); i++)
/*     */       {
/* 208 */         JDBCStoreManager2 manager = (JDBCStoreManager2)managers.get(i);
/* 209 */         manager.startCmd.addForeignKeyConstraints();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 216 */     if (this.stop != null)
/*     */     {
/* 218 */       Map managersMap = (HashMap)getApplicationData("CREATED_JDBCStoreManagers");
/* 219 */       while (!managersMap.isEmpty())
/*     */       {
/* 221 */         int stoppedInIteration = 0;
/* 222 */         for (Iterator i = managersMap.values().iterator(); i.hasNext(); )
/*     */         {
/* 224 */           JDBCStoreManager2 manager = (JDBCStoreManager2)i.next();
/* 225 */           if (manager.stop.execute())
/*     */           {
/* 227 */             i.remove();
/*     */             try
/*     */             {
/* 230 */               manager.entityBridge.stop();
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 234 */               this.log.error("Failed to stop entity bridge.", e);
/*     */             }
/* 236 */             stoppedInIteration++;
/*     */           }
/*     */         }
/*     */ 
/* 240 */         if (stoppedInIteration == 0)
/*     */           break;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public JDBCAbstractEntityBridge getEntityBridge()
/*     */   {
/* 257 */     return this.entityBridge;
/*     */   }
/*     */ 
/*     */   public JDBCEntityMetaData getMetaData()
/*     */   {
/* 262 */     return this.metaData;
/*     */   }
/*     */ 
/*     */   public JDBCTypeFactory getJDBCTypeFactory()
/*     */   {
/* 267 */     return this.typeFactory;
/*     */   }
/*     */ 
/*     */   public EntityContainer getContainer()
/*     */   {
/* 272 */     return this.container;
/*     */   }
/*     */ 
/*     */   public Object getApplicationData(Object key)
/*     */   {
/* 277 */     return this.ejbModule.getModuleData(key);
/*     */   }
/*     */ 
/*     */   public void putApplicationData(Object key, Object value)
/*     */   {
/* 282 */     this.ejbModule.putModuleData(key, value);
/*     */   }
/*     */ 
/*     */   public Object createBeanClassInstance()
/*     */     throws Exception
/*     */   {
/* 289 */     return this.instanceFactory.newInstance();
/*     */   }
/*     */ 
/*     */   public void initEntity(EntityEnterpriseContext ctx)
/*     */   {
/* 294 */     this.entityBridge.initPersistenceContext(ctx);
/* 295 */     this.entityBridge.initInstance(ctx);
/*     */   }
/*     */ 
/*     */   public Object createEntity(Method m, Object[] args, EntityEnterpriseContext ctx)
/*     */     throws CreateException
/*     */   {
/* 339 */     return this.createCmd.execute(m, args, ctx);
/*     */   }
/*     */ 
/*     */   public Object postCreateEntity(Method m, Object[] args, EntityEnterpriseContext ctx) throws CreateException
/*     */   {
/* 344 */     return null;
/*     */   }
/*     */ 
/*     */   public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext instance, GenericEntityObjectFactory factory)
/*     */     throws FinderException
/*     */   {
/* 353 */     QueryCommand query = this.queryFactory.getQueryCommand(finderMethod);
/* 354 */     return query.fetchOne(this.schema, factory, args);
/*     */   }
/*     */ 
/*     */   public Collection findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext instance, GenericEntityObjectFactory factory)
/*     */     throws FinderException
/*     */   {
/* 363 */     QueryCommand query = this.queryFactory.getQueryCommand(finderMethod);
/* 364 */     return query.fetchCollection(this.schema, factory, args);
/*     */   }
/*     */ 
/*     */   public void activateEntity(EntityEnterpriseContext ctx)
/*     */   {
/* 369 */     this.entityBridge.initPersistenceContext(ctx);
/*     */   }
/*     */ 
/*     */   public void loadEntity(EntityEnterpriseContext ctx)
/*     */   {
/*     */     try
/*     */     {
/* 376 */       EntityTable.Row row = this.entityBridge.getTable().loadRow(ctx.getId());
/* 377 */       PersistentContext pctx = new PersistentContext(this.entityBridge, row);
/* 378 */       ctx.setPersistenceContext(pctx);
/*     */     }
/*     */     catch (EJBException e)
/*     */     {
/* 382 */       this.log.error("Failed to load instance of " + this.entityBridge.getEntityName() + " with pk=" + ctx.getId(), e);
/* 383 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 387 */       throw new EJBException("Failed to load instance of " + this.entityBridge.getEntityName() + " with pk=" + ctx.getId(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isStoreRequired(EntityEnterpriseContext instance)
/*     */   {
/* 395 */     return this.entityBridge.isStoreRequired(instance);
/*     */   }
/*     */ 
/*     */   public boolean isModified(EntityEnterpriseContext instance) throws Exception
/*     */   {
/* 400 */     return this.entityBridge.isModified(instance);
/*     */   }
/*     */ 
/*     */   public void storeEntity(EntityEnterpriseContext instance)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void passivateEntity(EntityEnterpriseContext ctx)
/*     */   {
/* 410 */     JDBCEntityBridge2.destroyPersistenceContext(ctx);
/*     */   }
/*     */ 
/*     */   public void removeEntity(EntityEnterpriseContext ctx) throws RemoveException
/*     */   {
/* 415 */     this.entityBridge.remove(ctx);
/* 416 */     PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
/* 417 */     pctx.remove();
/*     */   }
/*     */ 
/*     */   protected void initStoreManager()
/*     */     throws Exception
/*     */   {
/* 424 */     if (this.log.isDebugEnabled())
/*     */     {
/* 426 */       this.log.debug("Initializing CMP plugin for " + this.container.getBeanMetaData().getEjbName());
/*     */     }
/*     */ 
/* 429 */     this.metaData = loadJDBCEntityMetaData();
/*     */ 
/* 432 */     this.typeFactory = new JDBCTypeFactory(this.metaData.getTypeMapping(), this.metaData.getJDBCApplication().getValueClasses(), this.metaData.getJDBCApplication().getUserTypeMappings());
/*     */ 
/* 437 */     this.entityBridge = new JDBCEntityBridge2(this, this.metaData);
/* 438 */     this.entityBridge.init();
/*     */ 
/* 440 */     Catalog catalog = getCatalog();
/* 441 */     catalog.addEntity(this.entityBridge);
/*     */ 
/* 443 */     this.stop = new JDBCStopCommand(this);
/*     */   }
/*     */ 
/*     */   private void resolveRelationships() throws Exception
/*     */   {
/* 448 */     this.entityBridge.resolveRelationships();
/*     */   }
/*     */ 
/*     */   protected void startStoreManager() throws Exception
/*     */   {
/* 453 */     this.queryFactory = new QueryFactory(this.entityBridge);
/* 454 */     this.queryFactory.init();
/*     */ 
/* 456 */     this.instanceFactory = new InstanceFactory(this, this.entityBridge);
/*     */ 
/* 458 */     this.startCmd = new JDBCStartCommand(this);
/* 459 */     this.startCmd.execute();
/*     */ 
/* 461 */     JDBCEntityCommandMetaData entityCommand = getMetaData().getEntityCommand();
/* 462 */     if ((entityCommand == null) || ("default".equals(entityCommand.getCommandName())))
/*     */     {
/* 464 */       this.createCmd = new ApplicationPkCreateCommand();
/*     */     }
/*     */     else
/*     */     {
/* 468 */       Class cmdClass = entityCommand.getCommandClass();
/* 469 */       if (cmdClass == null)
/*     */       {
/* 471 */         throw new DeploymentException("entity-command class name is not specified for entity " + this.entityBridge.getEntityName());
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 478 */         this.createCmd = ((CreateCommand)cmdClass.newInstance());
/*     */       }
/*     */       catch (ClassCastException cce)
/*     */       {
/* 482 */         throw new DeploymentException("Entity command " + cmdClass + " does not implement " + CreateCommand.class);
/*     */       }
/*     */     }
/*     */ 
/* 486 */     this.createCmd.init(this);
/*     */   }
/*     */ 
/*     */   private void startEntity()
/*     */     throws DeploymentException
/*     */   {
/* 492 */     this.entityBridge.start();
/*     */   }
/*     */ 
/*     */   private JDBCEntityMetaData loadJDBCEntityMetaData()
/*     */     throws DeploymentException
/*     */   {
/* 498 */     ApplicationMetaData amd = this.container.getBeanMetaData().getApplicationMetaData();
/*     */ 
/* 501 */     JDBCApplicationMetaData jamd = (JDBCApplicationMetaData)amd.getPluginData("CMP-JDBC");
/*     */ 
/* 503 */     if (jamd == null)
/*     */     {
/* 507 */       JDBCXmlFileLoader jfl = new JDBCXmlFileLoader(this.container, this.log);
/*     */ 
/* 509 */       jamd = jfl.load();
/* 510 */       amd.addPluginData("CMP-JDBC", jamd);
/*     */     }
/*     */ 
/* 514 */     String ejbName = this.container.getBeanMetaData().getEjbName();
/* 515 */     JDBCEntityMetaData metadata = jamd.getBeanByEjbName(ejbName);
/* 516 */     if (metadata == null)
/*     */     {
/* 518 */       throw new DeploymentException("No metadata found for bean " + ejbName);
/*     */     }
/* 520 */     return metadata;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2
 * JD-Core Version:    0.6.0
 */