/*     */ package org.jboss.ejb.plugins.cmp.jdbc2;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import javax.ejb.FinderException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCDeclaredQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCDynamicQLQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCJBossQLQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQlQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
/*     */ 
/*     */ public class QueryFactory
/*     */ {
/*  45 */   private final Map queriesByMethod = new HashMap();
/*     */   private final JDBCEntityBridge2 entity;
/*     */ 
/*     */   public QueryFactory(JDBCEntityBridge2 entity)
/*     */   {
/*  50 */     this.entity = entity;
/*     */   }
/*     */ 
/*     */   public QueryCommand getQueryCommand(Method queryMethod) throws FinderException
/*     */   {
/*  55 */     QueryCommand queryCommand = (QueryCommand)this.queriesByMethod.get(queryMethod);
/*  56 */     if (queryCommand == null)
/*     */     {
/*  58 */       throw new FinderException("Unknown query method: " + queryMethod);
/*     */     }
/*  60 */     return queryCommand;
/*     */   }
/*     */ 
/*     */   public void init()
/*     */     throws DeploymentException
/*     */   {
/*  66 */     Class home = this.entity.getHomeClass();
/*  67 */     if (home != null) {
/*     */       Method findByPkMethod;
/*     */       try {
/*  71 */         findByPkMethod = home.getMethod("findByPrimaryKey", new Class[] { this.entity.getPrimaryKeyClass() });
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/*  75 */         throw new DeploymentException("Home interface " + home.getClass().getName() + " does not contain findByPrimaryKey(" + this.entity.getPrimaryKeyClass().getName() + ")");
/*     */       }
/*     */ 
/*  79 */       FindByPrimaryKeyCommand findByPk = new FindByPrimaryKeyCommand(this.entity);
/*  80 */       this.queriesByMethod.put(findByPkMethod, findByPk);
/*     */     }
/*     */ 
/*  83 */     Class local = this.entity.getLocalHomeClass();
/*  84 */     if (local != null) {
/*     */       Method findByPkMethod;
/*     */       try {
/*  88 */         findByPkMethod = local.getMethod("findByPrimaryKey", new Class[] { this.entity.getPrimaryKeyClass() });
/*     */       }
/*     */       catch (NoSuchMethodException e)
/*     */       {
/*  92 */         throw new DeploymentException("Local home interface " + local.getClass().getName() + " does not contain findByPrimaryKey(" + this.entity.getPrimaryKeyClass().getName() + ")");
/*     */       }
/*     */ 
/*  96 */       FindByPrimaryKeyCommand findByPk = new FindByPrimaryKeyCommand(this.entity);
/*  97 */       this.queriesByMethod.put(findByPkMethod, findByPk);
/*     */     }
/*     */ 
/* 103 */     Iterator definedFinders = this.entity.getMetaData().getQueries().iterator();
/* 104 */     while (definedFinders.hasNext())
/*     */     {
/* 106 */       JDBCQueryMetaData q = (JDBCQueryMetaData)definedFinders.next();
/*     */ 
/* 108 */       if (!this.queriesByMethod.containsKey(q.getMethod()))
/*     */       {
/* 110 */         if ((q instanceof JDBCJBossQLQueryMetaData))
/*     */         {
/* 112 */           QueryCommand queryCommand = new JBossQLQueryCommand(this.entity, (JDBCJBossQLQueryMetaData)q);
/* 113 */           this.queriesByMethod.put(q.getMethod(), queryCommand);
/*     */         }
/* 115 */         else if ((q instanceof JDBCQlQueryMetaData))
/*     */         {
/* 117 */           QueryCommand queryCommand = new EJBQLQueryCommand(this.entity, (JDBCQlQueryMetaData)q);
/* 118 */           this.queriesByMethod.put(q.getMethod(), queryCommand);
/*     */         }
/* 120 */         else if ((q instanceof JDBCDeclaredQueryMetaData))
/*     */         {
/* 122 */           QueryCommand queryCommand = new DeclaredSQLQueryCommand(this.entity, (JDBCDeclaredQueryMetaData)q);
/* 123 */           this.queriesByMethod.put(q.getMethod(), queryCommand);
/*     */         }
/* 125 */         else if ((q instanceof JDBCDynamicQLQueryMetaData))
/*     */         {
/* 127 */           QueryCommand queryCommand = new DynamicQueryCommand(this.entity, (JDBCDynamicQLQueryMetaData)q);
/* 128 */           this.queriesByMethod.put(q.getMethod(), queryCommand);
/*     */         }
/*     */         else
/*     */         {
/* 132 */           throw new DeploymentException("Unsupported query metadata: method=" + q.getMethod().getName() + ", metadata=" + q);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.QueryFactory
 * JD-Core Version:    0.6.0
 */