/*     */ package org.jboss.ejb.plugins.cmp.jdbc2.bridge;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Collection;
/*     */ import javax.ejb.FinderException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.GenericEntityObjectFactory;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.SelectorBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.QueryCommand;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.ConfigurationMetaData;
/*     */ 
/*     */ public class EJBSelectBridge
/*     */   implements SelectorBridge
/*     */ {
/*     */   private static final byte SINGLE = 0;
/*     */   private static final byte COLLECTION = 2;
/*     */   private final JDBCQueryMetaData metadata;
/*     */   private final QueryCommand command;
/*     */   private final byte returnType;
/*     */   private final Schema schema;
/*     */   private boolean syncBeforeSelect;
/*     */   private TransactionManager tm;
/*     */ 
/*     */   public EJBSelectBridge(EntityContainer container, Schema schema, JDBCQueryMetaData metadata, QueryCommand command)
/*     */   {
/*  58 */     this.schema = schema;
/*  59 */     this.metadata = metadata;
/*  60 */     this.command = command;
/*     */ 
/*  62 */     Class type = metadata.getMethod().getReturnType();
/*  63 */     if (Collection.class.isAssignableFrom(type))
/*     */     {
/*  65 */       this.returnType = 2;
/*     */     }
/*     */     else
/*     */     {
/*  69 */       this.returnType = 0;
/*     */     }
/*     */ 
/*  72 */     this.tm = container.getTransactionManager();
/*  73 */     this.syncBeforeSelect = (!container.getBeanMetaData().getContainerConfiguration().getSyncOnCommitOnly());
/*     */   }
/*     */ 
/*     */   public Object invoke(EntityEnterpriseContext instance, Method method, Object[] args)
/*     */     throws Exception
/*     */   {
/*  81 */     Transaction tx = instance != null ? instance.getTransaction() : this.tm.getTransaction();
/*     */ 
/*  83 */     if (this.syncBeforeSelect)
/*     */     {
/*  85 */       EntityContainer.synchronizeEntitiesWithinTransaction(tx);
/*     */     }
/*     */ 
/*  88 */     return execute(args);
/*     */   }
/*     */ 
/*     */   public String getSelectorName()
/*     */   {
/*  95 */     return this.metadata.getMethod().getName();
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/* 100 */     return this.metadata.getMethod();
/*     */   }
/*     */ 
/*     */   public Object execute(Object[] args) throws FinderException
/*     */   {
/* 105 */     JDBCStoreManager2 manager = this.command.getStoreManager();
/* 106 */     GenericEntityObjectFactory factory = this.metadata.isResultTypeMappingLocal() ? manager.getContainer().getLocalProxyFactory() : manager.getContainer().getProxyFactory();
/*     */     Object result;
/* 110 */     switch (this.returnType)
/*     */     {
/*     */     case 0:
/* 113 */       result = this.command.fetchOne(this.schema, factory, args);
/* 114 */       if ((result != null) || (!getMethod().getReturnType().isPrimitive()))
/*     */         break;
/* 116 */       throw new FinderException("Cannot return null as a value of primitive type " + getMethod().getReturnType().getName());
/*     */     case 2:
/* 122 */       result = this.command.fetchCollection(this.schema, factory, args);
/* 123 */       break;
/*     */     default:
/* 125 */       throw new IllegalStateException("Unexpected return type: " + this.returnType);
/*     */     }
/* 127 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.bridge.EJBSelectBridge
 * JD-Core Version:    0.6.0
 */