/*     */ package org.jboss.ejb.plugins.cmp.jdbc2.bridge;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import javax.ejb.EJBException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.ejb.EntityEnterpriseContext;
/*     */ import org.jboss.ejb.plugins.cmp.bridge.CMPFieldBridge;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCParameterSetter;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCResultSetReader;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCType;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeFactory;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.PersistentContext;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.EntityTable;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class JDBCCMPFieldBridge2
/*     */   implements CMPFieldBridge
/*     */ {
/*     */   private final JDBCEntityBridge2 entity;
/*     */   private final int rowIndex;
/*     */   private final JDBCType jdbcType;
/*     */   private final Class pkClass;
/*     */   private final Field pkField;
/*     */   private final boolean isPrimaryKeyMember;
/*     */   private final String fieldName;
/*     */   private final Class fieldType;
/*     */   private final String columnName;
/*     */   private final JDBCCMPFieldBridge2 cmpFieldIAmMappedTo;
/*     */   private final Logger log;
/*  62 */   private int versionIndex = -1;
/*     */ 
/*     */   public JDBCCMPFieldBridge2(JDBCStoreManager2 manager, JDBCEntityBridge2 entity, JDBCCMPFieldMetaData metadata, int rowIndex)
/*     */     throws DeploymentException
/*     */   {
/*  70 */     this.rowIndex = rowIndex;
/*  71 */     this.entity = entity;
/*  72 */     this.jdbcType = manager.getJDBCTypeFactory().getJDBCType(metadata);
/*  73 */     this.pkClass = metadata.getEntity().getPrimaryKeyClass();
/*  74 */     this.pkField = metadata.getPrimaryKeyField();
/*  75 */     this.isPrimaryKeyMember = metadata.isPrimaryKeyMember();
/*  76 */     this.fieldName = metadata.getFieldName();
/*  77 */     this.fieldType = metadata.getFieldType();
/*  78 */     this.cmpFieldIAmMappedTo = null;
/*  79 */     this.columnName = metadata.getColumnName();
/*     */ 
/*  81 */     this.log = Logger.getLogger(getClass().getName() + "." + entity.getEntityName() + "#" + getFieldName());
/*     */   }
/*     */ 
/*     */   public JDBCCMPFieldBridge2(JDBCCMPFieldBridge2 cmpField, JDBCCMPFieldBridge2 relatedPKField)
/*     */   {
/*  86 */     this.entity = cmpField.entity;
/*  87 */     this.rowIndex = cmpField.rowIndex;
/*  88 */     this.jdbcType = cmpField.jdbcType;
/*  89 */     this.columnName = cmpField.columnName;
/*     */ 
/*  91 */     this.fieldName = relatedPKField.fieldName;
/*  92 */     this.fieldType = relatedPKField.fieldType;
/*  93 */     this.pkClass = relatedPKField.pkClass;
/*  94 */     this.pkField = relatedPKField.pkField;
/*     */ 
/*  96 */     this.isPrimaryKeyMember = false;
/*     */ 
/*  98 */     this.cmpFieldIAmMappedTo = cmpField;
/*     */ 
/* 100 */     this.log = Logger.getLogger(getClass().getName() + "." + this.entity.getEntityName() + "#" + getFieldName());
/*     */   }
/*     */ 
/*     */   public void initVersion()
/*     */   {
/* 107 */     this.versionIndex = this.entity.getTable().addVersionField();
/*     */   }
/*     */ 
/*     */   public int getVersionIndex()
/*     */   {
/* 112 */     return this.versionIndex;
/*     */   }
/*     */ 
/*     */   public String getColumnName()
/*     */   {
/* 117 */     return this.columnName;
/*     */   }
/*     */ 
/*     */   public Object setPrimaryKeyValue(Object primaryKey, Object value)
/*     */     throws IllegalArgumentException
/*     */   {
/*     */     try
/*     */     {
/* 125 */       if (this.pkField != null)
/*     */       {
/* 128 */         if ((value == null) && (primaryKey == null))
/*     */         {
/* 130 */           return null;
/*     */         }
/*     */ 
/* 134 */         if (primaryKey == null)
/*     */         {
/* 136 */           primaryKey = this.pkClass.newInstance();
/*     */         }
/*     */ 
/* 140 */         this.pkField.set(primaryKey, value);
/* 141 */         return primaryKey;
/*     */       }
/*     */ 
/* 146 */       return value;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */ 
/* 152 */     throw new EJBException("Internal error setting instance field " + getFieldName(), e);
/*     */   }
/*     */ 
/*     */   public void setValueInternal(EntityEnterpriseContext ctx, Object value, boolean makeDirty)
/*     */   {
/* 158 */     PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
/*     */ 
/* 161 */     if ((this.cmpFieldIAmMappedTo != null) && (this.cmpFieldIAmMappedTo.isPrimaryKeyMember))
/*     */     {
/* 163 */       Object curValue = pctx.getFieldValue(this.rowIndex);
/* 164 */       if ((value != null) && (!value.equals(curValue)))
/*     */       {
/* 166 */         throw new IllegalStateException("Attempt to modify a primary key field through a foreign key field mapped to it: " + this.entity.getEntityName() + "." + this.cmpFieldIAmMappedTo.getFieldName() + " -> " + this.entity.getQualifiedTableName() + "." + this.cmpFieldIAmMappedTo.getColumnName() + ", current value=" + curValue + ", new value=" + value);
/*     */       }
/*     */ 
/* 181 */       makeDirty = false;
/*     */     }
/*     */     else
/*     */     {
/* 185 */       pctx.setFieldValue(this.rowIndex, value);
/*     */     }
/*     */ 
/* 188 */     if (makeDirty)
/*     */     {
/* 190 */       pctx.setDirty();
/*     */     }
/*     */   }
/*     */ 
/*     */   public int setArgumentParameters(PreparedStatement ps, int parameterIndex, Object arg)
/*     */   {
/*     */     try
/*     */     {
/* 198 */       int[] jdbcTypes = this.jdbcType.getJDBCTypes();
/* 199 */       for (int i = 0; i < jdbcTypes.length; i++)
/*     */       {
/* 201 */         Object columnValue = this.jdbcType.getColumnValue(i, arg);
/* 202 */         this.jdbcType.getParameterSetter()[i].set(ps, parameterIndex++, jdbcTypes[i], columnValue, this.log);
/*     */       }
/*     */ 
/* 205 */       return parameterIndex;
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/*     */     }
/* 210 */     throw new EJBException("Internal error setting parameters for field " + getFieldName(), e);
/*     */   }
/*     */ 
/*     */   public Object loadArgumentResults(ResultSet rs, int parameterIndex)
/*     */     throws IllegalArgumentException
/*     */   {
/*     */     try
/*     */     {
/* 220 */       Class[] javaTypes = this.jdbcType.getJavaTypes();
/* 221 */       if (javaTypes.length > 1)
/*     */       {
/* 223 */         throw new IllegalStateException("Complex types are not supported yet.");
/*     */       }
/*     */ 
/* 226 */       JDBCResultSetReader[] rsReaders = this.jdbcType.getResultSetReaders();
/*     */ 
/* 228 */       Object columnValue = null;
/* 229 */       for (int i = 0; i < javaTypes.length; i++)
/*     */       {
/* 231 */         columnValue = rsReaders[i].get(rs, parameterIndex++, javaTypes[i], this.log);
/* 232 */         columnValue = this.jdbcType.setColumnValue(i, null, columnValue);
/*     */       }
/*     */ 
/* 236 */       return columnValue;
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/*     */     }
/* 241 */     throw new EJBException("Internal error getting results for field member " + getFieldName(), e);
/*     */   }
/*     */ 
/*     */   public int getRowIndex()
/*     */   {
/* 247 */     return this.rowIndex;
/*     */   }
/*     */ 
/*     */   public JDBCEntityPersistenceStore getManager()
/*     */   {
/* 252 */     return this.entity.getManager();
/*     */   }
/*     */ 
/*     */   public void initInstance(EntityEnterpriseContext ctx)
/*     */   {
/* 260 */     Class fieldType = getFieldType();
/*     */     Object value;
/*     */     Object value;
/* 261 */     if (fieldType == Boolean.TYPE)
/*     */     {
/* 263 */       value = Boolean.FALSE;
/*     */     }
/*     */     else
/*     */     {
/*     */       Object value;
/* 265 */       if (fieldType == Byte.TYPE)
/*     */       {
/* 267 */         value = new Byte(0);
/*     */       }
/*     */       else
/*     */       {
/*     */         Object value;
/* 269 */         if (fieldType == Integer.TYPE)
/*     */         {
/* 271 */           value = new Integer(0);
/*     */         }
/*     */         else
/*     */         {
/*     */           Object value;
/* 273 */           if (fieldType == Long.TYPE)
/*     */           {
/* 275 */             value = new Long(0L);
/*     */           }
/*     */           else
/*     */           {
/*     */             Object value;
/* 277 */             if (fieldType == Short.TYPE)
/*     */             {
/* 279 */               value = new Short(0);
/*     */             }
/*     */             else
/*     */             {
/*     */               Object value;
/* 281 */               if (fieldType == Character.TYPE)
/*     */               {
/* 283 */                 value = new Character('\000');
/*     */               }
/*     */               else
/*     */               {
/*     */                 Object value;
/* 285 */                 if (fieldType == Double.TYPE)
/*     */                 {
/* 287 */                   value = new Double(0.0D);
/*     */                 }
/*     */                 else
/*     */                 {
/*     */                   Object value;
/* 289 */                   if (fieldType == Float.TYPE)
/*     */                   {
/* 291 */                     value = new Float(0.0F);
/*     */                   }
/*     */                   else
/*     */                   {
/* 295 */                     value = null;
/*     */                   }
/*     */                 }
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 297 */     setValueInternal(ctx, value, false);
/*     */   }
/*     */ 
/*     */   public void resetPersistenceContext(EntityEnterpriseContext ctx)
/*     */   {
/* 302 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public int setInstanceParameters(PreparedStatement ps, int parameterIndex, EntityEnterpriseContext ctx)
/*     */   {
/* 307 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public Object getInstanceValue(EntityEnterpriseContext ctx)
/*     */   {
/* 312 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void setInstanceValue(EntityEnterpriseContext ctx, Object value)
/*     */   {
/* 317 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public int loadInstanceResults(ResultSet rs, int parameterIndex, EntityEnterpriseContext ctx)
/*     */   {
/* 322 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public int loadArgumentResults(ResultSet rs, int parameterIndex, Object[] argumentRef)
/*     */   {
/* 327 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean isDirty(EntityEnterpriseContext ctx)
/*     */   {
/* 332 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void setClean(EntityEnterpriseContext ctx)
/*     */   {
/* 337 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean isCMPField()
/*     */   {
/* 342 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isPrimaryKeyMember()
/*     */   {
/* 347 */     return this.isPrimaryKeyMember;
/*     */   }
/*     */ 
/*     */   public boolean isReadOnly()
/*     */   {
/* 352 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean isReadTimedOut(EntityEnterpriseContext ctx)
/*     */   {
/* 357 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean isLoaded(EntityEnterpriseContext ctx)
/*     */   {
/* 362 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public JDBCType getJDBCType()
/*     */   {
/* 367 */     return this.jdbcType;
/*     */   }
/*     */ 
/*     */   public Object getPrimaryKeyValue(Object primaryKey)
/*     */     throws IllegalArgumentException
/*     */   {
/*     */     try
/*     */     {
/* 375 */       if (this.pkField != null)
/*     */       {
/* 377 */         if (primaryKey == null)
/*     */         {
/* 379 */           return null;
/*     */         }
/*     */ 
/* 382 */         return this.pkField.get(primaryKey);
/*     */       }
/*     */ 
/* 386 */       return primaryKey;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/* 391 */     throw new EJBException("Internal error getting primary key field member " + getFieldName(), e);
/*     */   }
/*     */ 
/*     */   public String getFieldName()
/*     */   {
/* 399 */     return this.fieldName;
/*     */   }
/*     */ 
/*     */   public Object getValue(EntityEnterpriseContext ctx)
/*     */   {
/* 404 */     PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
/* 405 */     return pctx.getFieldValue(this.rowIndex);
/*     */   }
/*     */ 
/*     */   public void setValue(EntityEnterpriseContext ctx, Object value)
/*     */   {
/* 410 */     setValueInternal(ctx, value, true);
/*     */   }
/*     */ 
/*     */   public Class getFieldType()
/*     */   {
/* 415 */     return this.fieldType;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2
 * JD-Core Version:    0.6.0
 */