/*      */ package org.jboss.ejb.plugins.cmp.jdbc2.bridge;
/*      */ 
/*      */ import java.lang.reflect.Array;
/*      */ import java.security.AccessController;
/*      */ import java.security.Principal;
/*      */ import java.security.PrivilegedAction;
/*      */ import java.sql.Connection;
/*      */ import java.sql.PreparedStatement;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.SQLException;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.ConcurrentModificationException;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import javax.ejb.EJBException;
/*      */ import javax.ejb.EJBLocalObject;
/*      */ import javax.ejb.NoSuchObjectLocalException;
/*      */ import javax.ejb.RemoveException;
/*      */ import javax.sql.DataSource;
/*      */ import javax.transaction.SystemException;
/*      */ import javax.transaction.Transaction;
/*      */ import javax.transaction.TransactionManager;
/*      */ import org.jboss.deployment.DeploymentException;
/*      */ import org.jboss.ejb.EntityCache;
/*      */ import org.jboss.ejb.EntityContainer;
/*      */ import org.jboss.ejb.EntityEnterpriseContext;
/*      */ import org.jboss.ejb.LocalProxyFactory;
/*      */ import org.jboss.ejb.plugins.cmp.bridge.EntityBridge;
/*      */ import org.jboss.ejb.plugins.cmp.bridge.FieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCType;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRInvocation;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRMessage;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc2.PersistentContext;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.Cache.CacheLoader;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.EntityTable;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.EntityTable.ForeignKeyConstraint;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.RelationTable;
/*      */ import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;
/*      */ import org.jboss.ejb.plugins.lock.Entrancy;
/*      */ import org.jboss.invocation.InvocationType;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.security.SecurityContext;
/*      */ import org.jboss.security.SecurityContextUtil;
/*      */ import org.jboss.security.plugins.SecurityContextAssociation;
/*      */ 
/*      */ public class JDBCCMRFieldBridge2 extends JDBCAbstractCMRFieldBridge
/*      */ {
/*      */   private final JDBCRelationshipRoleMetaData metadata;
/*      */   private final JDBCStoreManager2 manager;
/*      */   private final JDBCEntityBridge2 entity;
/*      */   private final int cmrIndex;
/*      */   private final Logger log;
/*      */   private JDBCEntityBridge2 relatedEntity;
/*      */   private JDBCCMRFieldBridge2 relatedCMRField;
/*      */   private EntityContainer relatedContainer;
/*      */   private JDBCCMPFieldBridge2[] tableKeyFields;
/*      */   private JDBCCMPFieldBridge2[] foreignKeyFields;
/*      */   private JDBCCMPFieldBridge2[] relatedPKFields;
/*      */   private CMRFieldLoader loader;
/*      */   private RelationTable relationTable;
/*      */   private EntityTable.ForeignKeyConstraint fkConstraint;
/*      */   private final TransactionManager tm;
/*      */ 
/*      */   public JDBCCMRFieldBridge2(JDBCEntityBridge2 entityBridge, JDBCStoreManager2 manager, JDBCRelationshipRoleMetaData metadata)
/*      */   {
/*  112 */     this.manager = manager;
/*  113 */     this.entity = entityBridge;
/*  114 */     this.metadata = metadata;
/*  115 */     this.cmrIndex = this.entity.getNextCMRIndex();
/*  116 */     this.tm = manager.getContainer().getTransactionManager();
/*      */ 
/*  118 */     this.log = Logger.getLogger(getClass().getName() + "." + this.entity.getEntityName() + "#" + getFieldName());
/*      */   }
/*      */ 
/*      */   public void resolveRelationship()
/*      */     throws DeploymentException
/*      */   {
/*  130 */     String relatedEntityName = this.metadata.getRelatedRole().getEntity().getName();
/*      */ 
/*  133 */     Catalog catalog = (Catalog)this.manager.getApplicationData("CATALOG");
/*  134 */     this.relatedEntity = ((JDBCEntityBridge2)catalog.getEntityByEJBName(relatedEntityName));
/*  135 */     if (this.relatedEntity == null)
/*      */     {
/*  137 */       throw new DeploymentException("Related entity not found: entity=" + this.entity.getEntityName() + ", " + "cmrField=" + getFieldName() + ", " + "relatedEntity=" + relatedEntityName);
/*      */     }
/*      */ 
/*  155 */     JDBCCMRFieldBridge2[] cmrFields = (JDBCCMRFieldBridge2[])(JDBCCMRFieldBridge2[])this.relatedEntity.getCMRFields();
/*  156 */     for (int i = 0; i < cmrFields.length; i++)
/*      */     {
/*  158 */       JDBCCMRFieldBridge2 cmrField = cmrFields[i];
/*  159 */       if (this.metadata.getRelatedRole() != cmrField.getMetaData())
/*      */         continue;
/*  161 */       this.relatedCMRField = cmrField;
/*  162 */       break;
/*      */     }
/*      */ 
/*  167 */     if (this.relatedCMRField == null)
/*      */     {
/*  169 */       String message = "Related CMR field not found in " + this.relatedEntity.getEntityName() + " for relationship from ";
/*      */ 
/*  172 */       message = message + this.entity.getEntityName() + ".";
/*  173 */       if (getFieldName() != null)
/*      */       {
/*  175 */         message = message + getFieldName();
/*      */       }
/*      */       else
/*      */       {
/*  179 */         message = message + "<no-field>";
/*      */       }
/*      */ 
/*  182 */       message = message + " to ";
/*  183 */       message = message + relatedEntityName + ".";
/*  184 */       if (this.metadata.getRelatedRole().getCMRFieldName() != null)
/*      */       {
/*  186 */         message = message + this.metadata.getRelatedRole().getCMRFieldName();
/*      */       }
/*      */       else
/*      */       {
/*  190 */         message = message + "<no-field>";
/*      */       }
/*      */ 
/*  193 */       throw new DeploymentException(message);
/*      */     }
/*      */ 
/*  197 */     this.relatedContainer = this.relatedEntity.getContainer();
/*      */ 
/*  202 */     if (this.metadata.getRelationMetaData().isTableMappingStyle())
/*      */     {
/*  205 */       Collection tableKeys = this.metadata.getKeyFields();
/*  206 */       List keyFieldsList = new ArrayList(tableKeys.size());
/*      */ 
/*  209 */       Map pkFieldsToFKFields = new HashMap(tableKeys.size());
/*  210 */       for (Iterator i = tableKeys.iterator(); i.hasNext(); )
/*      */       {
/*  212 */         JDBCCMPFieldMetaData cmpFieldMetaData = (JDBCCMPFieldMetaData)i.next();
/*  213 */         FieldBridge pkField = this.entity.getFieldByName(cmpFieldMetaData.getFieldName());
/*  214 */         if (pkField == null)
/*      */         {
/*  216 */           throw new DeploymentException("Primary key not found for key-field " + cmpFieldMetaData.getFieldName());
/*      */         }
/*  218 */         pkFieldsToFKFields.put(pkField, new JDBCCMPFieldBridge2(this.manager, this.entity, cmpFieldMetaData, -1));
/*      */       }
/*      */ 
/*  222 */       JDBCFieldBridge[] pkFields = this.entity.getPrimaryKeyFields();
/*  223 */       for (int i = 0; i < pkFields.length; i++)
/*      */       {
/*  225 */         Object fkField = pkFieldsToFKFields.get(pkFields[i]);
/*  226 */         if (fkField == null)
/*      */         {
/*  228 */           throw new DeploymentException("Primary key " + pkFields[i].getFieldName() + " is not mapped.");
/*      */         }
/*  230 */         keyFieldsList.add(fkField);
/*      */       }
/*  232 */       this.tableKeyFields = ((JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])keyFieldsList.toArray(new JDBCCMPFieldBridge2[keyFieldsList.size()]));
/*      */     }
/*      */     else
/*      */     {
/*  236 */       initializeForeignKeyFields();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void initLoader() throws DeploymentException
/*      */   {
/*  242 */     if (this.metadata.getRelationMetaData().isTableMappingStyle())
/*      */     {
/*  244 */       this.relationTable = this.relatedCMRField.getRelationTable();
/*  245 */       this.loader = new RelationTableLoader();
/*      */     }
/*  249 */     else if (this.foreignKeyFields != null)
/*      */     {
/*  251 */       this.loader = new ContextForeignKeyLoader(null);
/*      */     }
/*      */     else
/*      */     {
/*  255 */       this.loader = new ForeignKeyLoader();
/*      */     }
/*      */   }
/*      */ 
/*      */   public JDBCRelationshipRoleMetaData getMetaData()
/*      */   {
/*  262 */     return this.metadata;
/*      */   }
/*      */ 
/*      */   public boolean removeRelatedId(EntityEnterpriseContext ctx, Object relatedId)
/*      */   {
/*  267 */     FieldState state = getFieldState(ctx);
/*  268 */     return state.removeRelatedId(ctx, relatedId);
/*      */   }
/*      */ 
/*      */   public boolean addRelatedId(EntityEnterpriseContext ctx, Object relatedId)
/*      */   {
/*  273 */     FieldState state = getFieldState(ctx);
/*  274 */     return state.addRelatedId(ctx, relatedId);
/*      */   }
/*      */ 
/*      */   public void remove(EntityEnterpriseContext ctx) throws RemoveException
/*      */   {
/*  279 */     if (this.metadata.getRelatedRole().isCascadeDelete())
/*      */     {
/*  281 */       FieldState state = getFieldState(ctx);
/*  282 */       state.cascadeDelete(ctx);
/*      */     }
/*      */     else
/*      */     {
/*  286 */       destroyExistingRelationships(ctx);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void destroyExistingRelationships(EntityEnterpriseContext ctx)
/*      */   {
/*  292 */     FieldState state = getFieldState(ctx);
/*  293 */     state.destroyExistingRelationships(ctx);
/*      */   }
/*      */ 
/*      */   public JDBCFieldBridge[] getTableKeyFields()
/*      */   {
/*  298 */     return this.tableKeyFields;
/*      */   }
/*      */ 
/*      */   public JDBCEntityPersistenceStore getManager()
/*      */   {
/*  303 */     return this.manager;
/*      */   }
/*      */ 
/*      */   public boolean hasForeignKey()
/*      */   {
/*  308 */     return this.foreignKeyFields != null;
/*      */   }
/*      */ 
/*      */   public JDBCAbstractCMRFieldBridge getRelatedCMRField()
/*      */   {
/*  313 */     return this.relatedCMRField;
/*      */   }
/*      */ 
/*      */   public JDBCFieldBridge[] getForeignKeyFields()
/*      */   {
/*  318 */     return this.foreignKeyFields;
/*      */   }
/*      */ 
/*      */   public JDBCCMRFieldBridge2 getRelatedField()
/*      */   {
/*  323 */     return this.relatedCMRField;
/*      */   }
/*      */ 
/*      */   public JDBCAbstractEntityBridge getEntity()
/*      */   {
/*  328 */     return this.entity;
/*      */   }
/*      */ 
/*      */   public String getQualifiedTableName()
/*      */   {
/*  333 */     return this.relationTable.getTableName();
/*      */   }
/*      */ 
/*      */   public String getTableName()
/*      */   {
/*  338 */     throw new UnsupportedOperationException();
/*      */   }
/*      */ 
/*      */   public JDBCType getJDBCType()
/*      */   {
/*  345 */     throw new UnsupportedOperationException();
/*      */   }
/*      */ 
/*      */   public boolean isPrimaryKeyMember()
/*      */   {
/*  350 */     throw new UnsupportedOperationException();
/*      */   }
/*      */ 
/*      */   public boolean isReadOnly()
/*      */   {
/*  355 */     throw new UnsupportedOperationException();
/*      */   }
/*      */ 
/*      */   public boolean isReadTimedOut(EntityEnterpriseContext ctx)
/*      */   {
/*  360 */     throw new UnsupportedOperationException();
/*      */   }
/*      */ 
/*      */   public boolean isLoaded(EntityEnterpriseContext ctx)
/*      */   {
/*  365 */     throw new UnsupportedOperationException();
/*      */   }
/*      */ 
/*      */   public void initInstance(EntityEnterpriseContext ctx)
/*      */   {
/*  370 */     getFieldState(ctx).init();
/*      */   }
/*      */ 
/*      */   public void resetPersistenceContext(EntityEnterpriseContext ctx)
/*      */   {
/*  375 */     throw new UnsupportedOperationException();
/*      */   }
/*      */ 
/*      */   public int setInstanceParameters(PreparedStatement ps, int parameterIndex, EntityEnterpriseContext ctx)
/*      */   {
/*  380 */     throw new UnsupportedOperationException();
/*      */   }
/*      */ 
/*      */   public Object getInstanceValue(EntityEnterpriseContext ctx)
/*      */   {
/*  385 */     throw new UnsupportedOperationException();
/*      */   }
/*      */ 
/*      */   public void setInstanceValue(EntityEnterpriseContext ctx, Object value)
/*      */   {
/*  390 */     throw new UnsupportedOperationException();
/*      */   }
/*      */ 
/*      */   public int loadInstanceResults(ResultSet rs, int parameterIndex, EntityEnterpriseContext ctx)
/*      */   {
/*  395 */     throw new UnsupportedOperationException();
/*      */   }
/*      */ 
/*      */   public int loadArgumentResults(ResultSet rs, int parameterIndex, Object[] argumentRef)
/*      */   {
/*  400 */     throw new UnsupportedOperationException();
/*      */   }
/*      */ 
/*      */   public boolean isDirty(EntityEnterpriseContext ctx)
/*      */   {
/*  405 */     return getFieldState(ctx).isModified();
/*      */   }
/*      */ 
/*      */   public void setClean(EntityEnterpriseContext ctx)
/*      */   {
/*  410 */     throw new UnsupportedOperationException();
/*      */   }
/*      */ 
/*      */   public boolean isCMPField()
/*      */   {
/*  415 */     return false;
/*      */   }
/*      */ 
/*      */   public String getFieldName()
/*      */   {
/*  422 */     return this.metadata.getCMRFieldName();
/*      */   }
/*      */ 
/*      */   public Object getValue(EntityEnterpriseContext ctx)
/*      */   {
/*  427 */     FieldState state = getFieldState(ctx);
/*  428 */     return state.getValue(ctx);
/*      */   }
/*      */ 
/*      */   public void setValue(EntityEnterpriseContext ctx, Object value)
/*      */   {
/*  433 */     FieldState state = getFieldState(ctx);
/*  434 */     state.setValue(ctx, value);
/*  435 */     state.cacheValue(ctx);
/*      */   }
/*      */ 
/*      */   public boolean isSingleValued()
/*      */   {
/*  440 */     return this.metadata.getRelatedRole().isMultiplicityOne();
/*      */   }
/*      */ 
/*      */   public EntityBridge getRelatedEntity()
/*      */   {
/*  445 */     return this.relatedEntity;
/*      */   }
/*      */ 
/*      */   private void initializeForeignKeyFields()
/*      */     throws DeploymentException
/*      */   {
/*  452 */     Collection foreignKeys = this.metadata.getRelatedRole().getKeyFields();
/*      */ 
/*  455 */     Map fkFieldsByRelatedPKFields = new HashMap();
/*  456 */     for (Iterator i = foreignKeys.iterator(); i.hasNext(); )
/*      */     {
/*  458 */       JDBCCMPFieldMetaData fkFieldMetaData = (JDBCCMPFieldMetaData)i.next();
/*  459 */       JDBCCMPFieldBridge2 relatedPKField = (JDBCCMPFieldBridge2)this.relatedEntity.getFieldByName(fkFieldMetaData.getFieldName());
/*      */ 
/*  463 */       String fkColumnName = fkFieldMetaData.getColumnName();
/*  464 */       JDBCCMPFieldBridge2 fkField = null;
/*      */ 
/*  467 */       JDBCCMPFieldBridge2[] tableFields = (JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])this.entity.getTableFields();
/*  468 */       for (int tableInd = 0; (tableInd < tableFields.length) && (fkField == null); tableInd++)
/*      */       {
/*  470 */         JDBCCMPFieldBridge2 cmpField = tableFields[tableInd];
/*  471 */         if (!fkColumnName.equals(cmpField.getColumnName())) {
/*      */           continue;
/*      */         }
/*  474 */         fkField = new JDBCCMPFieldBridge2(cmpField, relatedPKField);
/*      */       }
/*      */ 
/*  493 */       if (fkField == null)
/*      */       {
/*  495 */         fkField = this.entity.addTableField(fkFieldMetaData);
/*      */       }
/*  497 */       fkFieldsByRelatedPKFields.put(relatedPKField, fkField);
/*      */     }
/*      */ 
/*  503 */     if (fkFieldsByRelatedPKFields.size() > 0)
/*      */     {
/*  505 */       JDBCFieldBridge[] pkFields = this.relatedEntity.getPrimaryKeyFields();
/*  506 */       List fkList = new ArrayList(pkFields.length);
/*  507 */       List relatedPKList = new ArrayList(pkFields.length);
/*  508 */       for (int i = 0; i < pkFields.length; i++)
/*      */       {
/*  510 */         JDBCFieldBridge relatedPKField = pkFields[i];
/*  511 */         JDBCFieldBridge fkField = (JDBCCMPFieldBridge2)fkFieldsByRelatedPKFields.remove(relatedPKField);
/*  512 */         fkList.add(fkField);
/*  513 */         relatedPKList.add(relatedPKField);
/*      */       }
/*  515 */       this.foreignKeyFields = ((JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])fkList.toArray(new JDBCCMPFieldBridge2[fkList.size()]));
/*  516 */       this.relatedPKFields = ((JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])relatedPKList.toArray(new JDBCCMPFieldBridge2[relatedPKList.size()]));
/*      */ 
/*  519 */       if (this.metadata.hasForeignKeyConstraint())
/*      */       {
/*  521 */         this.fkConstraint = this.entity.getTable().addFkConstraint(this.foreignKeyFields, this.relatedEntity.getTable());
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  526 */       this.foreignKeyFields = null;
/*  527 */       this.relatedPKFields = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   private FieldState getFieldState(EntityEnterpriseContext ctx)
/*      */   {
/*  533 */     PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
/*  534 */     FieldState state = pctx.getCMRState(this.cmrIndex);
/*  535 */     if (state == null)
/*      */     {
/*  537 */       if (isSingleValued())
/*      */       {
/*  539 */         state = new SingleValuedFieldState();
/*      */       }
/*      */       else
/*      */       {
/*  543 */         state = new CollectionValuedFieldState();
/*      */       }
/*  545 */       pctx.setCMRState(this.cmrIndex, state);
/*      */     }
/*  547 */     return state;
/*      */   }
/*      */ 
/*      */   private void invokeRemoveRelatedId(Object myId, Object relatedId)
/*      */   {
/*      */     try
/*      */     {
/*  554 */       Transaction tx = getTransaction();
/*  555 */       EntityCache instanceCache = (EntityCache)this.manager.getContainer().getInstanceCache();
/*      */ 
/*  568 */       SecurityActions actions = JDBCCMRFieldBridge2.SecurityActions.UTIL.getSecurityActions();
/*      */ 
/*  570 */       CMRInvocation invocation = new CMRInvocation();
/*  571 */       invocation.setCmrMessage(CMRMessage.REMOVE_RELATION);
/*  572 */       invocation.setEntrancy(Entrancy.NON_ENTRANT);
/*  573 */       invocation.setId(instanceCache.createCacheKey(myId));
/*  574 */       invocation.setArguments(new Object[] { this, relatedId });
/*  575 */       invocation.setTransaction(tx);
/*  576 */       invocation.setPrincipal(actions.getPrincipal());
/*  577 */       invocation.setCredential(actions.getCredential());
/*  578 */       invocation.setType(InvocationType.LOCAL);
/*      */ 
/*  580 */       this.manager.getContainer().invoke(invocation);
/*      */     }
/*      */     catch (EJBException e)
/*      */     {
/*  584 */       throw e;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  588 */       throw new EJBException("Error in invokeRemoveRelatedId()", e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void invokeAddRelatedId(Object myId, Object relatedId)
/*      */   {
/*      */     try
/*      */     {
/*  596 */       Transaction tx = getTransaction();
/*  597 */       EntityCache instanceCache = (EntityCache)this.manager.getContainer().getInstanceCache();
/*      */ 
/*  608 */       SecurityActions actions = JDBCCMRFieldBridge2.SecurityActions.UTIL.getSecurityActions();
/*      */ 
/*  610 */       CMRInvocation invocation = new CMRInvocation();
/*  611 */       invocation.setCmrMessage(CMRMessage.ADD_RELATION);
/*  612 */       invocation.setEntrancy(Entrancy.NON_ENTRANT);
/*  613 */       invocation.setId(instanceCache.createCacheKey(myId));
/*  614 */       invocation.setArguments(new Object[] { this, relatedId });
/*  615 */       invocation.setTransaction(tx);
/*  616 */       invocation.setPrincipal(actions.getPrincipal());
/*  617 */       invocation.setCredential(actions.getCredential());
/*  618 */       invocation.setType(InvocationType.LOCAL);
/*      */ 
/*  620 */       this.manager.getContainer().invoke(invocation);
/*      */     }
/*      */     catch (EJBException e)
/*      */     {
/*  624 */       throw e;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  628 */       throw new EJBException("Error in invokeAddRelatedId()", e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private Transaction getTransaction() throws SystemException
/*      */   {
/*  634 */     return this.tm.getTransaction();
/*      */   }
/*      */ 
/*      */   private RelationTable getRelationTable() throws DeploymentException
/*      */   {
/*  639 */     if (this.relationTable == null)
/*      */     {
/*  641 */       this.relationTable = this.manager.getSchema().createRelationTable(this, this.relatedCMRField);
/*      */     }
/*  643 */     return this.relationTable;
/*      */   }
/*      */ 
/*      */   private Object getPrimaryKey(Object o)
/*      */   {
/*  648 */     if (o == null)
/*      */     {
/*  650 */       throw new IllegalArgumentException("This implementation does not support null members.");
/*      */     }
/*      */ 
/*  653 */     if (!this.relatedEntity.getLocalInterface().isInstance(o))
/*      */     {
/*  655 */       throw new IllegalArgumentException("Argument must be of type " + this.entity.getLocalInterface().getName());
/*      */     }
/*      */ 
/*  658 */     EJBLocalObject local = (EJBLocalObject)o;
/*      */     try
/*      */     {
/*  661 */       return local.getPrimaryKey();
/*      */     }
/*      */     catch (NoSuchObjectLocalException e) {
/*      */     }
/*  665 */     throw new IllegalArgumentException(e.getMessage());
/*      */   }
/*      */ 
/*      */   static abstract interface SecurityActions
/*      */   {
/* 1740 */     public static final SecurityActions NON_PRIVILEGED = new SecurityActions()
/*      */     {
/*      */       public Principal getPrincipal()
/*      */       {
/* 1745 */         Principal p = null;
/* 1746 */         SecurityContext sc = getSecurityContext();
/* 1747 */         if (sc != null)
/*      */         {
/* 1749 */           p = sc.getUtil().getUserPrincipal();
/*      */         }
/* 1751 */         return p;
/*      */       }
/*      */ 
/*      */       public Object getCredential()
/*      */       {
/* 1757 */         Object credential = null;
/* 1758 */         SecurityContext sc = getSecurityContext();
/* 1759 */         if (sc != null)
/*      */         {
/* 1761 */           credential = sc.getUtil().getCredential();
/*      */         }
/* 1763 */         return credential;
/*      */       }
/*      */ 
/*      */       public SecurityContext getSecurityContext()
/*      */       {
/* 1768 */         return SecurityContextAssociation.getSecurityContext();
/*      */       }
/* 1740 */     };
/*      */ 
/* 1772 */     public static final SecurityActions PRIVILEGED = new SecurityActions()
/*      */     {
/* 1774 */       private final PrivilegedAction getPrincipalAction = new PrivilegedAction()
/*      */       {
/*      */         public Object run()
/*      */         {
/* 1779 */           Principal p = null;
/* 1780 */           SecurityContext sc = JDBCCMRFieldBridge2.SecurityActions.2.this.getSecurityContext();
/* 1781 */           if (sc != null)
/*      */           {
/* 1783 */             p = sc.getUtil().getUserPrincipal();
/*      */           }
/* 1785 */           return p;
/*      */         }
/* 1774 */       };
/*      */ 
/* 1789 */       private final PrivilegedAction getCredentialAction = new PrivilegedAction()
/*      */       {
/*      */         public Object run()
/*      */         {
/* 1794 */           Object credential = null;
/* 1795 */           SecurityContext sc = JDBCCMRFieldBridge2.SecurityActions.2.this.getSecurityContext();
/* 1796 */           if (sc != null)
/*      */           {
/* 1798 */             credential = sc.getUtil().getCredential();
/*      */           }
/* 1800 */           return credential;
/*      */         }
/* 1789 */       };
/*      */ 
/*      */       public Principal getPrincipal()
/*      */       {
/* 1806 */         return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
/*      */       }
/*      */ 
/*      */       public Object getCredential()
/*      */       {
/* 1811 */         return AccessController.doPrivileged(this.getCredentialAction);
/*      */       }
/*      */ 
/*      */       public SecurityContext getSecurityContext()
/*      */       {
/* 1816 */         return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction()
/*      */         {
/*      */           public Object run()
/*      */           {
/* 1820 */             return SecurityContextAssociation.getSecurityContext();
/*      */           }
/*      */         });
/*      */       }
/* 1772 */     };
/*      */ 
/*      */     public abstract Principal getPrincipal();
/*      */ 
/*      */     public abstract Object getCredential();
/*      */ 
/*      */     public abstract SecurityContext getSecurityContext();
/*      */ 
/*      */     public static class UTIL
/*      */     {
/*      */       static JDBCCMRFieldBridge2.SecurityActions getSecurityActions()
/*      */       {
/* 1736 */         return System.getSecurityManager() == null ? JDBCCMRFieldBridge2.SecurityActions.NON_PRIVILEGED : JDBCCMRFieldBridge2.SecurityActions.PRIVILEGED;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private class CMRSet
/*      */     implements Set
/*      */   {
/*      */     private final EntityEnterpriseContext ctx;
/*      */     private final JDBCCMRFieldBridge2.CollectionValuedFieldState state;
/*      */ 
/*      */     public CMRSet(EntityEnterpriseContext ctx, JDBCCMRFieldBridge2.CollectionValuedFieldState state)
/*      */     {
/* 1492 */       this.ctx = ctx;
/* 1493 */       this.state = state;
/*      */     }
/*      */ 
/*      */     public int size()
/*      */     {
/* 1498 */       return JDBCCMRFieldBridge2.CollectionValuedFieldState.access$1800(this.state, this.ctx).size();
/*      */     }
/*      */ 
/*      */     public void clear()
/*      */     {
/* 1503 */       JDBCCMRFieldBridge2.this.destroyExistingRelationships(this.ctx);
/*      */     }
/*      */ 
/*      */     public boolean isEmpty()
/*      */     {
/* 1508 */       return size() == 0;
/*      */     }
/*      */ 
/*      */     public boolean add(Object o)
/*      */     {
/* 1513 */       Object relatedId = JDBCCMRFieldBridge2.this.getPrimaryKey(o);
/* 1514 */       boolean modified = JDBCCMRFieldBridge2.this.addRelatedId(this.ctx, relatedId);
/*      */ 
/* 1516 */       if (modified)
/*      */       {
/* 1518 */         JDBCCMRFieldBridge2.this.relatedCMRField.invokeAddRelatedId(relatedId, this.ctx.getId());
/* 1519 */         JDBCCMRFieldBridge2.this.loader.addRelatedId(this.ctx, relatedId);
/*      */       }
/*      */ 
/* 1522 */       return modified;
/*      */     }
/*      */ 
/*      */     public boolean contains(Object o)
/*      */     {
/* 1527 */       Object pk = JDBCCMRFieldBridge2.this.getPrimaryKey(o);
/* 1528 */       return JDBCCMRFieldBridge2.CollectionValuedFieldState.access$1800(this.state, this.ctx).contains(pk);
/*      */     }
/*      */ 
/*      */     public boolean remove(Object o)
/*      */     {
/* 1533 */       Object relatedId = JDBCCMRFieldBridge2.this.getPrimaryKey(o);
/* 1534 */       return removeById(relatedId);
/*      */     }
/*      */ 
/*      */     public boolean addAll(Collection c)
/*      */     {
/* 1539 */       if ((c == null) || (c.isEmpty()))
/*      */       {
/* 1541 */         return false;
/*      */       }
/*      */ 
/* 1544 */       boolean modified = false;
/* 1545 */       Object[] copy = c.toArray();
/* 1546 */       for (int i = 0; i < copy.length; i++)
/*      */       {
/* 1549 */         modified = (add(copy[i])) || (modified);
/*      */       }
/*      */ 
/* 1552 */       return modified;
/*      */     }
/*      */ 
/*      */     public boolean containsAll(Collection c)
/*      */     {
/* 1557 */       if ((c == null) || (c.isEmpty()))
/*      */       {
/* 1559 */         return true;
/*      */       }
/*      */ 
/* 1562 */       Set ids = argumentToIdSet(c);
/* 1563 */       return JDBCCMRFieldBridge2.CollectionValuedFieldState.access$1800(this.state, this.ctx).containsAll(ids);
/*      */     }
/*      */ 
/*      */     public boolean removeAll(Collection c)
/*      */     {
/* 1568 */       if ((c == null) || (c.isEmpty()))
/*      */       {
/* 1570 */         return false;
/*      */       }
/*      */ 
/* 1573 */       boolean modified = false;
/* 1574 */       Object[] copy = c.toArray();
/* 1575 */       for (int i = 0; i < copy.length; i++)
/*      */       {
/* 1577 */         modified = (remove(copy[i])) || (modified);
/*      */       }
/*      */ 
/* 1580 */       return modified;
/*      */     }
/*      */ 
/*      */     public boolean retainAll(Collection c)
/*      */     {
/* 1585 */       Set value = JDBCCMRFieldBridge2.CollectionValuedFieldState.access$1800(this.state, this.ctx);
/* 1586 */       if ((c == null) || (c.isEmpty()))
/*      */       {
/* 1588 */         if (value.isEmpty())
/*      */         {
/* 1590 */           return false;
/*      */         }
/*      */ 
/* 1594 */         clear();
/*      */       }
/*      */ 
/* 1598 */       boolean modified = false;
/* 1599 */       Set idSet = argumentToIdSet(c);
/* 1600 */       Object[] valueCopy = value.toArray();
/* 1601 */       for (int i = 0; i < valueCopy.length; i++)
/*      */       {
/* 1603 */         Object id = valueCopy[i];
/* 1604 */         if (idSet.contains(id))
/*      */           continue;
/* 1606 */         removeById(id);
/* 1607 */         modified = true;
/*      */       }
/*      */ 
/* 1611 */       return modified;
/*      */     }
/*      */ 
/*      */     public Iterator iterator()
/*      */     {
/* 1616 */       return new Iterator()
/*      */       {
/* 1619 */         private final Iterator idIter = new HashSet(JDBCCMRFieldBridge2.CollectionValuedFieldState.access$1800(JDBCCMRFieldBridge2.CMRSet.this.state, JDBCCMRFieldBridge2.CMRSet.this.ctx)).iterator();
/*      */         private Object curId;
/*      */ 
/*      */         public void remove()
/*      */         {
/*      */           try {
/* 1626 */             this.idIter.remove();
/*      */           }
/*      */           catch (ConcurrentModificationException e)
/*      */           {
/* 1630 */             throw new IllegalStateException(e.getMessage());
/*      */           }
/*      */ 
/* 1633 */           JDBCCMRFieldBridge2.CMRSet.this.removeById(this.curId);
/*      */         }
/*      */ 
/*      */         public boolean hasNext()
/*      */         {
/*      */           try
/*      */           {
/* 1640 */             return this.idIter.hasNext();
/*      */           }
/*      */           catch (ConcurrentModificationException e) {
/*      */           }
/* 1644 */           throw new IllegalStateException(e.getMessage());
/*      */         }
/*      */ 
/*      */         public Object next()
/*      */         {
/*      */           try
/*      */           {
/* 1652 */             this.curId = this.idIter.next();
/*      */           }
/*      */           catch (ConcurrentModificationException e)
/*      */           {
/* 1656 */             throw new IllegalStateException(e.getMessage());
/*      */           }
/*      */ 
/* 1659 */           return JDBCCMRFieldBridge2.this.relatedContainer.getLocalProxyFactory().getEntityEJBLocalObject(this.curId);
/*      */         }
/*      */       };
/*      */     }
/*      */ 
/*      */     public Object[] toArray() {
/* 1666 */       Set value = JDBCCMRFieldBridge2.CollectionValuedFieldState.access$1800(this.state, this.ctx);
/*      */ 
/* 1668 */       Object[] result = (Object[])(Object[])Array.newInstance(JDBCCMRFieldBridge2.this.relatedEntity.getLocalInterface(), value.size());
/*      */ 
/* 1670 */       LocalProxyFactory relatedPF = JDBCCMRFieldBridge2.this.relatedContainer.getLocalProxyFactory();
/* 1671 */       int i = 0;
/* 1672 */       for (Iterator iter = value.iterator(); iter.hasNext(); )
/*      */       {
/* 1674 */         Object id = iter.next();
/* 1675 */         result[(i++)] = relatedPF.getEntityEJBLocalObject(id);
/*      */       }
/*      */ 
/* 1678 */       return result;
/*      */     }
/*      */ 
/*      */     public Object[] toArray(Object[] a)
/*      */     {
/* 1683 */       Set value = JDBCCMRFieldBridge2.CollectionValuedFieldState.access$1800(this.state, this.ctx);
/* 1684 */       if ((a == null) || (a.length < value.size()))
/*      */       {
/* 1686 */         a = (Object[])(Object[])Array.newInstance(JDBCCMRFieldBridge2.this.entity.getLocalInterface(), value.size());
/*      */       }
/*      */ 
/* 1689 */       LocalProxyFactory relatedPF = JDBCCMRFieldBridge2.this.relatedContainer.getLocalProxyFactory();
/* 1690 */       int i = 0;
/* 1691 */       for (Iterator iter = value.iterator(); iter.hasNext(); )
/*      */       {
/* 1693 */         Object id = iter.next();
/* 1694 */         a[(i++)] = relatedPF.getEntityEJBLocalObject(id);
/*      */       }
/*      */ 
/* 1697 */       return a;
/*      */     }
/*      */ 
/*      */     public String toString()
/*      */     {
/* 1702 */       return JDBCCMRFieldBridge2.CollectionValuedFieldState.access$1800(this.state, this.ctx).toString();
/*      */     }
/*      */ 
/*      */     private boolean removeById(Object relatedId)
/*      */     {
/* 1709 */       boolean modified = JDBCCMRFieldBridge2.this.removeRelatedId(this.ctx, relatedId);
/* 1710 */       if (modified)
/*      */       {
/* 1712 */         JDBCCMRFieldBridge2.this.relatedCMRField.invokeRemoveRelatedId(relatedId, this.ctx.getId());
/* 1713 */         JDBCCMRFieldBridge2.this.loader.removeRelatedId(this.ctx, relatedId);
/*      */       }
/* 1715 */       return modified;
/*      */     }
/*      */ 
/*      */     private Set argumentToIdSet(Collection c)
/*      */     {
/* 1720 */       Set ids = new HashSet();
/* 1721 */       for (Iterator iter = c.iterator(); iter.hasNext(); )
/*      */       {
/* 1723 */         Object pk = JDBCCMRFieldBridge2.this.getPrimaryKey(iter.next());
/* 1724 */         ids.add(pk);
/*      */       }
/* 1726 */       return ids;
/*      */     }
/*      */   }
/*      */ 
/*      */   private static abstract interface CMRFieldLoader
/*      */   {
/*      */     public abstract void load(EntityEnterpriseContext paramEntityEnterpriseContext, JDBCCMRFieldBridge2.FieldState paramFieldState);
/*      */ 
/*      */     public abstract void removeRelatedId(EntityEnterpriseContext paramEntityEnterpriseContext, Object paramObject);
/*      */ 
/*      */     public abstract void addRelatedId(EntityEnterpriseContext paramEntityEnterpriseContext, Object paramObject);
/*      */   }
/*      */ 
/*      */   private class ContextForeignKeyLoader
/*      */     implements JDBCCMRFieldBridge2.CMRFieldLoader
/*      */   {
/*      */     private ContextForeignKeyLoader()
/*      */     {
/*      */     }
/*      */ 
/*      */     public void load(EntityEnterpriseContext ctx, JDBCCMRFieldBridge2.FieldState state)
/*      */     {
/* 1419 */       Object relatedId = null;
/* 1420 */       for (int i = 0; i < JDBCCMRFieldBridge2.this.foreignKeyFields.length; i++)
/*      */       {
/* 1422 */         JDBCCMPFieldBridge2 fkField = JDBCCMRFieldBridge2.this.foreignKeyFields[i];
/* 1423 */         Object fkFieldValue = fkField.getValue(ctx);
/* 1424 */         if (fkFieldValue == null)
/*      */         {
/*      */           break;
/*      */         }
/*      */ 
/* 1429 */         JDBCCMPFieldBridge2 relatedPKField = JDBCCMRFieldBridge2.this.relatedPKFields[i];
/* 1430 */         relatedId = relatedPKField.setPrimaryKeyValue(relatedId, fkFieldValue);
/*      */       }
/*      */ 
/* 1433 */       state.addLoadedPk(relatedId);
/*      */     }
/*      */ 
/*      */     public void removeRelatedId(EntityEnterpriseContext ctx, Object relatedId)
/*      */     {
/* 1438 */       for (int i = 0; i < JDBCCMRFieldBridge2.this.foreignKeyFields.length; i++)
/*      */       {
/* 1440 */         JDBCCMRFieldBridge2.this.foreignKeyFields[i].setValueInternal(ctx, null, JDBCCMRFieldBridge2.this.fkConstraint == null);
/*      */       }
/*      */ 
/* 1443 */       if (JDBCCMRFieldBridge2.this.fkConstraint != null)
/*      */       {
/* 1445 */         PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
/* 1446 */         pctx.nullForeignKey(JDBCCMRFieldBridge2.this.fkConstraint);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void addRelatedId(EntityEnterpriseContext ctx, Object relatedId)
/*      */     {
/* 1452 */       boolean markDirty = (relatedId != null) || (JDBCCMRFieldBridge2.this.fkConstraint == null);
/* 1453 */       for (int i = 0; i < JDBCCMRFieldBridge2.this.foreignKeyFields.length; i++)
/*      */       {
/* 1455 */         JDBCCMPFieldBridge2 relatedPKField = JDBCCMRFieldBridge2.this.relatedPKFields[i];
/* 1456 */         Object fieldValue = relatedPKField.getPrimaryKeyValue(relatedId);
/* 1457 */         JDBCCMRFieldBridge2.this.foreignKeyFields[i].setValueInternal(ctx, fieldValue, markDirty);
/*      */       }
/*      */ 
/* 1460 */       if (JDBCCMRFieldBridge2.this.fkConstraint != null)
/*      */       {
/* 1462 */         PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
/* 1463 */         if (relatedId == null)
/*      */         {
/* 1465 */           pctx.nullForeignKey(JDBCCMRFieldBridge2.this.fkConstraint);
/*      */         }
/*      */         else
/*      */         {
/* 1469 */           pctx.nonNullForeignKey(JDBCCMRFieldBridge2.this.fkConstraint);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private class ForeignKeyLoader
/*      */     implements JDBCCMRFieldBridge2.CMRFieldLoader
/*      */   {
/*      */     private final String loadSql;
/*      */ 
/*      */     public ForeignKeyLoader()
/*      */     {
/* 1323 */       StringBuffer sql = new StringBuffer();
/* 1324 */       sql.append("select ");
/* 1325 */       JDBCCMRFieldBridge2.this.relatedEntity.getTable().appendColumnNames((JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])JDBCCMRFieldBridge2.this.relatedEntity.getTableFields(), null, sql);
/* 1326 */       sql.append(" from ").append(JDBCCMRFieldBridge2.this.relatedEntity.getQualifiedTableName()).append(" where ");
/*      */ 
/* 1328 */       JDBCCMPFieldBridge2[] relatedFkFields = JDBCCMRFieldBridge2.access$300(JDBCCMRFieldBridge2.this).foreignKeyFields;
/* 1329 */       sql.append(relatedFkFields[0].getColumnName()).append("=?");
/* 1330 */       for (int i = 1; i < relatedFkFields.length; i++)
/*      */       {
/* 1332 */         JDBCCMPFieldBridge2 relatedFkField = relatedFkFields[i];
/* 1333 */         sql.append(" and ").append(relatedFkField.getColumnName()).append("=?");
/*      */       }
/*      */ 
/* 1336 */       this.loadSql = sql.toString();
/*      */ 
/* 1338 */       if (JDBCCMRFieldBridge2.this.log.isTraceEnabled())
/*      */       {
/* 1340 */         JDBCCMRFieldBridge2.this.log.trace("load sql: " + this.loadSql);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void load(EntityEnterpriseContext ctx, JDBCCMRFieldBridge2.FieldState state)
/*      */     {
/* 1347 */       EntityTable relatedTable = JDBCCMRFieldBridge2.this.relatedEntity.getTable();
/*      */ 
/* 1349 */       Connection con = null;
/* 1350 */       PreparedStatement ps = null;
/* 1351 */       ResultSet rs = null;
/*      */       try
/*      */       {
/* 1354 */         if (JDBCCMRFieldBridge2.this.log.isDebugEnabled())
/*      */         {
/* 1356 */           JDBCCMRFieldBridge2.this.log.debug("executing: " + this.loadSql);
/*      */         }
/*      */ 
/* 1359 */         con = relatedTable.getDataSource().getConnection();
/* 1360 */         ps = con.prepareStatement(this.loadSql);
/*      */ 
/* 1362 */         JDBCCMPFieldBridge2[] relatedFkFields = JDBCCMRFieldBridge2.access$300(JDBCCMRFieldBridge2.this).foreignKeyFields;
/* 1363 */         JDBCCMPFieldBridge2[] myPkFields = JDBCCMRFieldBridge2.access$300(JDBCCMRFieldBridge2.this).relatedPKFields;
/*      */ 
/* 1365 */         Object myPk = ctx.getId();
/* 1366 */         int paramInd = 1;
/* 1367 */         for (int i = 0; i < relatedFkFields.length; i++)
/*      */         {
/* 1369 */           JDBCCMPFieldBridge2 myPkField = myPkFields[i];
/* 1370 */           Object fieldValue = myPkField.getPrimaryKeyValue(myPk);
/*      */ 
/* 1372 */           JDBCCMPFieldBridge2 relatedFkField = relatedFkFields[i];
/* 1373 */           relatedFkField.setArgumentParameters(ps, paramInd++, fieldValue);
/*      */         }
/*      */ 
/* 1376 */         rs = ps.executeQuery();
/*      */ 
/* 1378 */         while (rs.next())
/*      */         {
/* 1380 */           Object value = relatedTable.loadRow(rs, false);
/* 1381 */           state.addLoadedPk(value);
/*      */         }
/*      */       }
/*      */       catch (SQLException e)
/*      */       {
/* 1386 */         JDBCCMRFieldBridge2.this.log.error("Failed to load related role: ejb-name=" + JDBCCMRFieldBridge2.this.entity.getEntityName() + ", cmr-field=" + JDBCCMRFieldBridge2.this.getFieldName() + ": " + e.getMessage(), e);
/*      */ 
/* 1391 */         throw new EJBException("Failed to load related role: ejb-name=" + JDBCCMRFieldBridge2.this.entity.getEntityName() + ", cmr-field=" + JDBCCMRFieldBridge2.this.getFieldName() + ": " + e.getMessage(), e);
/*      */       }
/*      */       finally
/*      */       {
/* 1399 */         JDBCUtil.safeClose(rs);
/* 1400 */         JDBCUtil.safeClose(ps);
/* 1401 */         JDBCUtil.safeClose(con);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void removeRelatedId(EntityEnterpriseContext ctx, Object relatedId)
/*      */     {
/*      */     }
/*      */ 
/*      */     public void addRelatedId(EntityEnterpriseContext ctx, Object relatedId)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   private class RelationTableLoader
/*      */     implements JDBCCMRFieldBridge2.CMRFieldLoader
/*      */   {
/*      */     private final String loadSql;
/*      */ 
/*      */     public RelationTableLoader()
/*      */     {
/* 1177 */       StringBuffer sql = new StringBuffer();
/* 1178 */       sql.append("select ");
/*      */ 
/* 1180 */       String relatedTable = JDBCCMRFieldBridge2.this.relatedEntity.getQualifiedTableName();
/* 1181 */       String relationTable = JDBCCMRFieldBridge2.this.metadata.getRelationMetaData().getDefaultTableName();
/*      */ 
/* 1183 */       JDBCCMRFieldBridge2.this.relatedEntity.getTable().appendColumnNames((JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])JDBCCMRFieldBridge2.this.relatedEntity.getTableFields(), relatedTable, sql);
/*      */ 
/* 1187 */       sql.append(" from ").append(relatedTable).append(" inner join ").append(relationTable).append(" on ");
/*      */ 
/* 1193 */       JDBCCMPFieldBridge2[] pkFields = (JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])JDBCCMRFieldBridge2.this.relatedEntity.getPrimaryKeyFields();
/* 1194 */       for (int i = 0; i < pkFields.length; i++)
/*      */       {
/* 1196 */         if (i > 0)
/*      */         {
/* 1198 */           sql.append(" and ");
/*      */         }
/*      */ 
/* 1201 */         sql.append(relatedTable).append('.').append(pkFields[i].getColumnName()).append('=').append(relationTable).append('.').append(JDBCCMRFieldBridge2.access$300(JDBCCMRFieldBridge2.this).tableKeyFields[i].getColumnName());
/*      */       }
/*      */ 
/* 1226 */       sql.append(" where ");
/* 1227 */       for (int i = 0; i < JDBCCMRFieldBridge2.this.tableKeyFields.length; i++)
/*      */       {
/* 1229 */         if (i > 0)
/*      */         {
/* 1231 */           sql.append(" and ");
/*      */         }
/*      */ 
/* 1234 */         sql.append(relationTable).append('.').append(JDBCCMRFieldBridge2.this.tableKeyFields[i].getColumnName()).append("=?");
/*      */       }
/*      */ 
/* 1237 */       this.loadSql = sql.toString();
/*      */ 
/* 1239 */       if (JDBCCMRFieldBridge2.this.log.isTraceEnabled())
/*      */       {
/* 1241 */         JDBCCMRFieldBridge2.this.log.trace("load sql: " + this.loadSql);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void load(EntityEnterpriseContext ctx, JDBCCMRFieldBridge2.FieldState state)
/*      */     {
/* 1248 */       EntityTable relatedTable = JDBCCMRFieldBridge2.this.relatedEntity.getTable();
/*      */ 
/* 1250 */       Connection con = null;
/* 1251 */       PreparedStatement ps = null;
/* 1252 */       ResultSet rs = null;
/*      */       try
/*      */       {
/* 1255 */         if (JDBCCMRFieldBridge2.this.log.isDebugEnabled())
/*      */         {
/* 1257 */           JDBCCMRFieldBridge2.this.log.debug("executing: " + this.loadSql);
/*      */         }
/*      */ 
/* 1260 */         con = relatedTable.getDataSource().getConnection();
/* 1261 */         ps = con.prepareStatement(this.loadSql);
/*      */ 
/* 1263 */         JDBCCMPFieldBridge2[] pkFields = (JDBCCMPFieldBridge2[])(JDBCCMPFieldBridge2[])JDBCCMRFieldBridge2.this.entity.getPrimaryKeyFields();
/*      */ 
/* 1265 */         Object myPk = ctx.getId();
/* 1266 */         int paramInd = 1;
/* 1267 */         for (int i = 0; i < pkFields.length; i++)
/*      */         {
/* 1269 */           JDBCCMPFieldBridge2 pkField = pkFields[i];
/* 1270 */           Object fieldValue = pkField.getPrimaryKeyValue(myPk);
/*      */ 
/* 1272 */           JDBCCMPFieldBridge2 relatedFkField = JDBCCMRFieldBridge2.this.tableKeyFields[i];
/* 1273 */           relatedFkField.setArgumentParameters(ps, paramInd++, fieldValue);
/*      */         }
/*      */ 
/* 1276 */         rs = ps.executeQuery();
/*      */ 
/* 1278 */         while (rs.next())
/*      */         {
/* 1280 */           Object value = relatedTable.loadRow(rs, false);
/* 1281 */           state.addLoadedPk(value);
/*      */         }
/*      */       }
/*      */       catch (SQLException e)
/*      */       {
/* 1286 */         JDBCCMRFieldBridge2.this.log.error("Failed to load related role: ejb-name=" + JDBCCMRFieldBridge2.this.entity.getEntityName() + ", cmr-field=" + JDBCCMRFieldBridge2.this.getFieldName() + ": " + e.getMessage(), e);
/*      */ 
/* 1291 */         throw new EJBException("Failed to load related role: ejb-name=" + JDBCCMRFieldBridge2.this.entity.getEntityName() + ", cmr-field=" + JDBCCMRFieldBridge2.this.getFieldName() + ": " + e.getMessage(), e);
/*      */       }
/*      */       finally
/*      */       {
/* 1299 */         JDBCUtil.safeClose(rs);
/* 1300 */         JDBCUtil.safeClose(ps);
/* 1301 */         JDBCUtil.safeClose(con);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void removeRelatedId(EntityEnterpriseContext ctx, Object relatedId)
/*      */     {
/* 1307 */       JDBCCMRFieldBridge2.this.relationTable.removeRelation(JDBCCMRFieldBridge2.this, ctx.getId(), JDBCCMRFieldBridge2.this.relatedCMRField, relatedId);
/*      */     }
/*      */ 
/*      */     public void addRelatedId(EntityEnterpriseContext ctx, Object relatedId)
/*      */     {
/* 1312 */       JDBCCMRFieldBridge2.this.relationTable.addRelation(JDBCCMRFieldBridge2.this, ctx.getId(), JDBCCMRFieldBridge2.this.relatedCMRField, relatedId);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static abstract interface FieldState extends Cache.CacheLoader
/*      */   {
/* 1147 */     public static final Object NULL_VALUE = new Object();
/*      */ 
/*      */     public abstract void init();
/*      */ 
/*      */     public abstract Object getValue(EntityEnterpriseContext paramEntityEnterpriseContext);
/*      */ 
/*      */     public abstract void cascadeDelete(EntityEnterpriseContext paramEntityEnterpriseContext)
/*      */       throws RemoveException;
/*      */ 
/*      */     public abstract void destroyExistingRelationships(EntityEnterpriseContext paramEntityEnterpriseContext);
/*      */ 
/*      */     public abstract void setValue(EntityEnterpriseContext paramEntityEnterpriseContext, Object paramObject);
/*      */ 
/*      */     public abstract boolean removeRelatedId(EntityEnterpriseContext paramEntityEnterpriseContext, Object paramObject);
/*      */ 
/*      */     public abstract boolean addRelatedId(EntityEnterpriseContext paramEntityEnterpriseContext, Object paramObject);
/*      */ 
/*      */     public abstract void addLoadedPk(Object paramObject);
/*      */ 
/*      */     public abstract void cacheValue(EntityEnterpriseContext paramEntityEnterpriseContext);
/*      */ 
/*      */     public abstract boolean isModified();
/*      */   }
/*      */ 
/*      */   public class CollectionValuedFieldState
/*      */     implements JDBCCMRFieldBridge2.FieldState
/*      */   {
/*      */     private boolean loaded;
/*      */     private Set value;
/*      */     private JDBCCMRFieldBridge2.CMRSet cmrSet;
/*      */     private Set removedWhileNotLoaded;
/*      */     private Set addedWhileNotLoaded;
/*      */     private boolean modified;
/*      */ 
/*      */     public CollectionValuedFieldState()
/*      */     {
/*      */     }
/*      */ 
/*      */     public void init()
/*      */     {
/*  863 */       this.loaded = true;
/*  864 */       this.value = new HashSet();
/*      */     }
/*      */ 
/*      */     public Object getValue(EntityEnterpriseContext ctx)
/*      */     {
/*  869 */       if (this.cmrSet == null)
/*      */       {
/*  871 */         this.cmrSet = new JDBCCMRFieldBridge2.CMRSet(JDBCCMRFieldBridge2.this, ctx, this);
/*      */       }
/*  873 */       return this.cmrSet;
/*      */     }
/*      */ 
/*      */     public void setValue(EntityEnterpriseContext ctx, Object value)
/*      */     {
/*  878 */       if (value == null)
/*      */       {
/*  880 */         throw new IllegalArgumentException("Can't set collection-valued CMR field to null: " + JDBCCMRFieldBridge2.this.entity.getEntityName() + "." + JDBCCMRFieldBridge2.this.getFieldName());
/*      */       }
/*      */ 
/*  885 */       destroyExistingRelationships(ctx);
/*      */ 
/*  887 */       Collection newValue = (Collection)value;
/*      */       Iterator iter;
/*  888 */       if (!newValue.isEmpty())
/*      */       {
/*  890 */         Set copy = new HashSet(newValue);
/*  891 */         for (iter = copy.iterator(); iter.hasNext(); )
/*      */         {
/*  893 */           Object relatedId = JDBCCMRFieldBridge2.this.getPrimaryKey(iter.next());
/*  894 */           addRelatedId(ctx, relatedId);
/*  895 */           JDBCCMRFieldBridge2.this.relatedCMRField.invokeAddRelatedId(relatedId, ctx.getId());
/*  896 */           JDBCCMRFieldBridge2.this.loader.addRelatedId(ctx, relatedId);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*      */     public void cascadeDelete(EntityEnterpriseContext ctx) throws RemoveException
/*      */     {
/*  903 */       Collection value = (Collection)getValue(ctx);
/*  904 */       if (!value.isEmpty())
/*      */       {
/*  906 */         EJBLocalObject[] locals = (EJBLocalObject[])(EJBLocalObject[])value.toArray();
/*  907 */         for (int i = 0; i < locals.length; i++)
/*      */         {
/*  909 */           locals[i].remove();
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*      */     public void destroyExistingRelationships(EntityEnterpriseContext ctx)
/*      */     {
/*  916 */       Set value = getLoadedValue(ctx);
/*  917 */       if (!value.isEmpty())
/*      */       {
/*  919 */         Object[] copy = value.toArray();
/*  920 */         for (int i = 0; i < copy.length; i++)
/*      */         {
/*  922 */           Object relatedId = copy[i];
/*  923 */           removeRelatedId(ctx, relatedId);
/*  924 */           JDBCCMRFieldBridge2.this.relatedCMRField.invokeRemoveRelatedId(relatedId, ctx.getId());
/*  925 */           JDBCCMRFieldBridge2.this.loader.removeRelatedId(ctx, relatedId);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*      */     public boolean removeRelatedId(EntityEnterpriseContext ctx, Object relatedId)
/*      */     {
/*  932 */       boolean removed = false;
/*  933 */       if (this.loaded)
/*      */       {
/*  935 */         Set value = getLoadedValue(ctx);
/*  936 */         if (!value.isEmpty())
/*      */         {
/*  938 */           removed = value.remove(relatedId);
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  943 */         loadOnlyFromCache(ctx);
/*  944 */         if (this.loaded)
/*      */         {
/*  946 */           Set value = getLoadedValue(ctx);
/*  947 */           if (!value.isEmpty())
/*      */           {
/*  949 */             removed = value.remove(relatedId);
/*      */           }
/*      */         }
/*      */         else
/*      */         {
/*  954 */           removed = removeWhileNotLoaded(relatedId);
/*      */         }
/*      */       }
/*      */ 
/*  958 */       this.modified = true;
/*      */ 
/*  960 */       if (removed)
/*      */       {
/*  962 */         ((PersistentContext)ctx.getPersistenceContext()).setDirtyRelations();
/*      */       }
/*      */ 
/*  965 */       return removed;
/*      */     }
/*      */ 
/*      */     public boolean addRelatedId(EntityEnterpriseContext ctx, Object relatedId)
/*      */     {
/*      */       boolean added;
/*      */       boolean added;
/*  971 */       if (this.loaded)
/*      */       {
/*  973 */         Set value = getLoadedValue(ctx);
/*  974 */         added = value.add(relatedId);
/*      */       }
/*      */       else
/*      */       {
/*  978 */         loadOnlyFromCache(ctx);
/*      */         boolean added;
/*  979 */         if (this.loaded)
/*      */         {
/*  981 */           Set value = getLoadedValue(ctx);
/*  982 */           added = value.add(relatedId);
/*      */         }
/*      */         else
/*      */         {
/*  986 */           added = addWhileNotLoaded(relatedId);
/*      */         }
/*      */       }
/*      */ 
/*  990 */       this.modified = true;
/*      */ 
/*  992 */       if (added)
/*      */       {
/*  994 */         ((PersistentContext)ctx.getPersistenceContext()).setDirtyRelations();
/*      */       }
/*      */ 
/*  997 */       return added;
/*      */     }
/*      */ 
/*      */     public void addLoadedPk(Object pk)
/*      */     {
/* 1002 */       if (this.loaded)
/*      */       {
/* 1004 */         throw new IllegalStateException(JDBCCMRFieldBridge2.this.entity.getEntityName() + "." + JDBCCMRFieldBridge2.this.getFieldName() + " collection-valued CMR field is already loaded. Check the database for consistancy. " + " current value=" + this.value + ", loaded value=" + pk);
/*      */       }
/*      */ 
/* 1015 */       if (pk != null)
/*      */       {
/* 1017 */         this.value.add(pk);
/*      */       }
/*      */     }
/*      */ 
/*      */     public Object loadFromCache(Object value)
/*      */     {
/* 1023 */       if (value != null)
/*      */       {
/* 1025 */         value = this.value = new HashSet((Set)value);
/* 1026 */         this.loaded = true;
/*      */       }
/* 1028 */       return value;
/*      */     }
/*      */ 
/*      */     public Object getCachedValue()
/*      */     {
/* 1033 */       return this.value;
/*      */     }
/*      */ 
/*      */     public void cacheValue(EntityEnterpriseContext ctx)
/*      */     {
/* 1038 */       PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
/* 1039 */       pctx.cacheRelations(JDBCCMRFieldBridge2.this.cmrIndex, this);
/*      */     }
/*      */ 
/*      */     public boolean isModified()
/*      */     {
/* 1044 */       return this.modified;
/*      */     }
/*      */ 
/*      */     private Set getLoadedValue(EntityEnterpriseContext ctx)
/*      */     {
/* 1051 */       if (!this.loaded)
/*      */       {
/* 1053 */         loadOnlyFromCache(ctx);
/*      */ 
/* 1055 */         if (!this.loaded)
/*      */         {
/* 1057 */           if ((this.value == null) || (this.value == Collections.EMPTY_SET))
/*      */           {
/* 1059 */             this.value = new HashSet();
/*      */           }
/*      */ 
/* 1062 */           JDBCCMRFieldBridge2.this.loader.load(ctx, this);
/* 1063 */           cacheValue(ctx);
/*      */ 
/* 1065 */           this.loaded = true;
/*      */         }
/*      */ 
/* 1068 */         if (this.addedWhileNotLoaded != null)
/*      */         {
/* 1070 */           this.value.addAll(this.addedWhileNotLoaded);
/* 1071 */           this.addedWhileNotLoaded = null;
/*      */         }
/*      */ 
/* 1074 */         if (this.removedWhileNotLoaded != null)
/*      */         {
/* 1076 */           this.value.removeAll(this.removedWhileNotLoaded);
/* 1077 */           this.removedWhileNotLoaded = null;
/*      */         }
/*      */       }
/* 1080 */       return this.value;
/*      */     }
/*      */ 
/*      */     private void loadOnlyFromCache(EntityEnterpriseContext ctx)
/*      */     {
/* 1085 */       PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
/* 1086 */       if (pctx == null)
/*      */       {
/* 1088 */         throw new EJBException("Persistence context is not available! Make sure the CMR collection is accessed in the transaction it was obtained.");
/*      */       }
/* 1090 */       pctx.loadCachedRelations(JDBCCMRFieldBridge2.this.cmrIndex, this);
/*      */     }
/*      */ 
/*      */     private boolean removeWhileNotLoaded(Object relatedId)
/*      */     {
/* 1095 */       boolean removed = false;
/* 1096 */       if (this.addedWhileNotLoaded != null)
/*      */       {
/* 1098 */         removed = this.addedWhileNotLoaded.remove(relatedId);
/*      */       }
/*      */ 
/* 1101 */       if (!removed)
/*      */       {
/* 1103 */         if (this.removedWhileNotLoaded == null)
/*      */         {
/* 1105 */           this.removedWhileNotLoaded = new HashSet();
/*      */         }
/* 1107 */         removed = this.removedWhileNotLoaded.add(relatedId);
/*      */       }
/*      */ 
/* 1110 */       if ((JDBCCMRFieldBridge2.this.log.isTraceEnabled()) && (removed))
/*      */       {
/* 1112 */         JDBCCMRFieldBridge2.this.log.trace("removed while not loaded: relatedId=" + relatedId);
/*      */       }
/*      */ 
/* 1115 */       return removed;
/*      */     }
/*      */ 
/*      */     private boolean addWhileNotLoaded(Object relatedId)
/*      */     {
/* 1120 */       boolean added = false;
/* 1121 */       if (this.removedWhileNotLoaded != null)
/*      */       {
/* 1123 */         added = this.removedWhileNotLoaded.remove(relatedId);
/*      */       }
/*      */ 
/* 1126 */       if (!added)
/*      */       {
/* 1128 */         if (this.addedWhileNotLoaded == null)
/*      */         {
/* 1130 */           this.addedWhileNotLoaded = new HashSet();
/*      */         }
/* 1132 */         added = this.addedWhileNotLoaded.add(relatedId);
/*      */       }
/*      */ 
/* 1135 */       if ((JDBCCMRFieldBridge2.this.log.isTraceEnabled()) && (added))
/*      */       {
/* 1137 */         JDBCCMRFieldBridge2.this.log.trace("added while not loaded: relatedId=" + relatedId);
/*      */       }
/*      */ 
/* 1140 */       return added;
/*      */     }
/*      */   }
/*      */ 
/*      */   public class SingleValuedFieldState
/*      */     implements JDBCCMRFieldBridge2.FieldState
/*      */   {
/*      */     private boolean loaded;
/*      */     private Object value;
/*      */     private EJBLocalObject localObject;
/*      */     private boolean modified;
/*      */ 
/*      */     public SingleValuedFieldState()
/*      */     {
/*      */     }
/*      */ 
/*      */     public void init()
/*      */     {
/*  681 */       this.loaded = true;
/*      */     }
/*      */ 
/*      */     public Object getValue(EntityEnterpriseContext ctx)
/*      */     {
/*  686 */       Object value = getLoadedValue(ctx);
/*  687 */       if (value == null)
/*      */       {
/*  689 */         this.localObject = null;
/*      */       }
/*  691 */       else if (this.localObject == null)
/*      */       {
/*  693 */         this.localObject = JDBCCMRFieldBridge2.this.relatedContainer.getLocalProxyFactory().getEntityEJBLocalObject(value);
/*      */       }
/*  695 */       return this.localObject;
/*      */     }
/*      */ 
/*      */     public void setValue(EntityEnterpriseContext ctx, Object value)
/*      */     {
/*  700 */       if (value != null)
/*      */       {
/*  702 */         Object relatedId = JDBCCMRFieldBridge2.this.getPrimaryKey(value);
/*  703 */         addRelatedId(ctx, relatedId);
/*  704 */         JDBCCMRFieldBridge2.this.relatedCMRField.invokeAddRelatedId(relatedId, ctx.getId());
/*  705 */         this.localObject = ((EJBLocalObject)value);
/*      */       }
/*      */       else
/*      */       {
/*  709 */         destroyExistingRelationships(ctx);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void cascadeDelete(EntityEnterpriseContext ctx) throws RemoveException
/*      */     {
/*  715 */       if (JDBCCMRFieldBridge2.this.manager.registerCascadeDelete(ctx.getId(), ctx.getId()))
/*      */       {
/*  717 */         EJBLocalObject value = (EJBLocalObject)getValue(ctx);
/*  718 */         if (value != null)
/*      */         {
/*  720 */           changeValue(null);
/*      */ 
/*  722 */           Object relatedId = value.getPrimaryKey();
/*  723 */           JDBCStoreManager2 relatedManager = (JDBCStoreManager2)JDBCCMRFieldBridge2.this.relatedEntity.getManager();
/*      */ 
/*  725 */           if (!relatedManager.isCascadeDeleted(relatedId))
/*      */           {
/*  727 */             value.remove();
/*      */           }
/*      */         }
/*      */ 
/*  731 */         JDBCCMRFieldBridge2.this.manager.unregisterCascadeDelete(ctx.getId());
/*      */       }
/*      */     }
/*      */ 
/*      */     public void destroyExistingRelationships(EntityEnterpriseContext ctx)
/*      */     {
/*  737 */       Object value = getLoadedValue(ctx);
/*  738 */       if (value != null)
/*      */       {
/*  740 */         removeRelatedId(ctx, value);
/*  741 */         JDBCCMRFieldBridge2.this.relatedCMRField.invokeRemoveRelatedId(value, ctx.getId());
/*      */       }
/*      */     }
/*      */ 
/*      */     public boolean removeRelatedId(EntityEnterpriseContext ctx, Object relatedId)
/*      */     {
/*  747 */       if (JDBCCMRFieldBridge2.this.hasForeignKey())
/*      */       {
/*  749 */         getLoadedValue(ctx);
/*      */       }
/*      */ 
/*  752 */       changeValue(null);
/*  753 */       JDBCCMRFieldBridge2.this.loader.removeRelatedId(ctx, relatedId);
/*      */ 
/*  755 */       cacheValue(ctx);
/*      */ 
/*  757 */       this.modified = true;
/*      */ 
/*  759 */       return true;
/*      */     }
/*      */ 
/*      */     public boolean addRelatedId(EntityEnterpriseContext ctx, Object relatedId)
/*      */     {
/*  764 */       Object value = getLoadedValue(ctx);
/*  765 */       if (value != null)
/*      */       {
/*  767 */         JDBCCMRFieldBridge2.this.relatedCMRField.invokeRemoveRelatedId(value, ctx.getId());
/*      */       }
/*      */ 
/*  770 */       changeValue(relatedId);
/*  771 */       JDBCCMRFieldBridge2.this.loader.addRelatedId(ctx, relatedId);
/*      */ 
/*  773 */       cacheValue(ctx);
/*      */ 
/*  775 */       this.modified = true;
/*      */ 
/*  777 */       return true;
/*      */     }
/*      */ 
/*      */     public void addLoadedPk(Object pk)
/*      */     {
/*  782 */       if (this.loaded)
/*      */       {
/*  784 */         throw new IllegalStateException(JDBCCMRFieldBridge2.this.entity.getEntityName() + "." + JDBCCMRFieldBridge2.this.getFieldName() + " single-valued CMR field is already loaded. Check the database for consistancy. " + " current value=" + this.value + ", loaded value=" + pk);
/*      */       }
/*      */ 
/*  795 */       changeValue(pk);
/*      */     }
/*      */ 
/*      */     public Object loadFromCache(Object value)
/*      */     {
/*  800 */       if (value != null)
/*      */       {
/*  802 */         changeValue(NULL_VALUE == value ? null : value);
/*      */       }
/*  804 */       return value;
/*      */     }
/*      */ 
/*      */     public Object getCachedValue()
/*      */     {
/*  809 */       return this.value == null ? NULL_VALUE : this.value;
/*      */     }
/*      */ 
/*      */     public void cacheValue(EntityEnterpriseContext ctx)
/*      */     {
/*  814 */       PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
/*  815 */       pctx.cacheRelations(JDBCCMRFieldBridge2.this.cmrIndex, this);
/*      */     }
/*      */ 
/*      */     public boolean isModified()
/*      */     {
/*  820 */       return this.modified;
/*      */     }
/*      */ 
/*      */     private void changeValue(Object newValue)
/*      */     {
/*  827 */       this.value = newValue;
/*  828 */       this.localObject = null;
/*  829 */       this.loaded = true;
/*      */     }
/*      */ 
/*      */     private Object getLoadedValue(EntityEnterpriseContext ctx)
/*      */     {
/*  834 */       if (!this.loaded)
/*      */       {
/*  836 */         PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
/*  837 */         pctx.loadCachedRelations(JDBCCMRFieldBridge2.this.cmrIndex, this);
/*  838 */         if (!this.loaded)
/*      */         {
/*  840 */           JDBCCMRFieldBridge2.this.loader.load(ctx, this);
/*  841 */           this.loaded = true;
/*  842 */           cacheValue(ctx);
/*      */         }
/*      */       }
/*  845 */       return this.value;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMRFieldBridge2
 * JD-Core Version:    0.6.0
 */