/*     */ package org.jboss.ejb.plugins.cmp.jdbc2.schema;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class TableCache extends ServiceMBeanSupport
/*     */   implements Cache, TableCacheMBean
/*     */ {
/*  45 */   private Cache.Listener listener = Cache.Listener.NOOP;
/*     */   private final Map rowsById;
/*     */   private CachedRow head;
/*     */   private CachedRow tail;
/*     */   private int maxCapacity;
/*     */   private final int minCapacity;
/*     */   private boolean locked;
/*     */   private final int partitionIndex;
/*     */ 
/*     */   public TableCache(int partitionIndex, int initialCapacity, int maxCapacity)
/*     */   {
/*  58 */     this.maxCapacity = maxCapacity;
/*  59 */     this.minCapacity = initialCapacity;
/*  60 */     this.rowsById = new HashMap(initialCapacity);
/*  61 */     this.partitionIndex = partitionIndex;
/*     */   }
/*     */ 
/*     */   public TableCache(Element conf) throws DeploymentException
/*     */   {
/*  66 */     String str = MetaData.getOptionalChildContent(conf, "min-capacity");
/*  67 */     this.minCapacity = (str == null ? 1000 : Integer.parseInt(str));
/*  68 */     this.rowsById = new HashMap(this.minCapacity);
/*     */ 
/*  70 */     str = MetaData.getOptionalChildContent(conf, "max-capacity");
/*  71 */     this.maxCapacity = (str == null ? 10000 : Integer.parseInt(str));
/*     */ 
/*  73 */     this.partitionIndex = 0;
/*     */   }
/*     */ 
/*     */   public void registerListener(Cache.Listener listener)
/*     */   {
/*  81 */     if ((this.log.isTraceEnabled()) && (getServiceName() != null))
/*     */     {
/*  83 */       this.log.trace("registered listener for " + getServiceName());
/*     */     }
/*  85 */     this.listener = listener;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/*  93 */     lock();
/*     */     try
/*     */     {
/*  96 */       i = this.rowsById.size();
/*     */     }
/*     */     finally
/*     */     {
/*     */       int i;
/* 100 */       unlock();
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getMaxCapacity()
/*     */   {
/* 109 */     return this.maxCapacity;
/*     */   }
/*     */ 
/*     */   public void setMaxCapacity(int maxCapacity)
/*     */   {
/* 117 */     this.maxCapacity = maxCapacity;
/*     */   }
/*     */ 
/*     */   public int getMinCapacity()
/*     */   {
/* 125 */     return this.minCapacity;
/*     */   }
/*     */ 
/*     */   public synchronized void lock()
/*     */   {
/* 130 */     if (this.locked)
/*     */     {
/* 132 */       long start = System.currentTimeMillis();
/* 133 */       while (this.locked)
/*     */       {
/*     */         try
/*     */         {
/* 137 */           wait();
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/*     */         }
/*     */       }
/*     */ 
/* 144 */       this.listener.contention(this.partitionIndex, System.currentTimeMillis() - start);
/*     */     }
/* 146 */     this.locked = true;
/*     */   }
/*     */ 
/*     */   public void lock(Object key)
/*     */   {
/* 151 */     lock();
/*     */   }
/*     */ 
/*     */   public synchronized void unlock()
/*     */   {
/* 156 */     if (!this.locked)
/*     */     {
/* 158 */       throw new IllegalStateException("The instance is not locked!");
/*     */     }
/* 160 */     this.locked = false;
/* 161 */     notify();
/*     */   }
/*     */ 
/*     */   public void unlock(Object key)
/*     */   {
/* 166 */     unlock();
/*     */   }
/*     */ 
/*     */   public Object[] getFields(Object pk)
/*     */   {
/* 172 */     CachedRow row = (CachedRow)this.rowsById.get(pk);
/*     */     Object[] fields;
/* 173 */     if ((row != null) && (row.locker == null))
/*     */     {
/* 175 */       promoteRow(row);
/* 176 */       Object[] fields = new Object[row.fields.length];
/* 177 */       System.arraycopy(row.fields, 0, fields, 0, fields.length);
/* 178 */       this.listener.hit(this.partitionIndex);
/*     */     }
/*     */     else
/*     */     {
/* 182 */       fields = null;
/* 183 */       this.listener.miss(this.partitionIndex);
/*     */     }
/* 185 */     return fields;
/*     */   }
/*     */ 
/*     */   public Object[] getRelations(Object pk)
/*     */   {
/* 191 */     CachedRow row = (CachedRow)this.rowsById.get(pk);
/*     */     Object[] relations;
/* 192 */     if ((row != null) && (row.relations != null) && (row.locker == null))
/*     */     {
/* 194 */       promoteRow(row);
/* 195 */       Object[] relations = new Object[row.relations.length];
/* 196 */       System.arraycopy(row.relations, 0, relations, 0, relations.length);
/*     */     }
/*     */     else
/*     */     {
/* 200 */       relations = null;
/*     */     }
/* 202 */     return relations;
/*     */   }
/*     */ 
/*     */   public void put(Transaction tx, Object pk, Object[] fields, Object[] relations)
/*     */   {
/* 207 */     CachedRow row = (CachedRow)this.rowsById.get(pk);
/* 208 */     if (row == null)
/*     */     {
/* 210 */       Object[] fieldsCopy = new Object[fields.length];
/* 211 */       System.arraycopy(fields, 0, fieldsCopy, 0, fields.length);
/* 212 */       row = new CachedRow(pk, fieldsCopy);
/*     */ 
/* 214 */       if (relations != null)
/*     */       {
/* 216 */         Object[] relationsCopy = new Object[relations.length];
/* 217 */         System.arraycopy(relations, 0, relationsCopy, 0, relations.length);
/* 218 */         row.relations = relationsCopy;
/*     */       }
/*     */ 
/* 221 */       this.rowsById.put(pk, row);
/*     */ 
/* 223 */       if (this.head == null)
/*     */       {
/* 225 */         this.head = row;
/* 226 */         this.tail = row;
/*     */       }
/*     */       else
/*     */       {
/* 230 */         CachedRow.access$102(this.head, row);
/* 231 */         CachedRow.access$202(row, this.head);
/* 232 */         this.head = row;
/*     */       }
/*     */     }
/* 235 */     else if ((row.locker == null) || (row.locker.equals(tx)))
/*     */     {
/* 237 */       promoteRow(row);
/* 238 */       System.arraycopy(fields, 0, row.fields, 0, fields.length);
/*     */ 
/* 240 */       if (relations != null)
/*     */       {
/* 242 */         if (row.relations == null)
/*     */         {
/* 244 */           row.relations = new Object[relations.length];
/*     */         }
/* 246 */         System.arraycopy(relations, 0, row.relations, 0, relations.length);
/*     */       }
/*     */ 
/* 249 */       row.lastUpdated = System.currentTimeMillis();
/* 250 */       CachedRow.access$002(row, null);
/*     */     }
/*     */ 
/* 253 */     CachedRow victim = this.tail;
/* 254 */     while ((this.rowsById.size() > this.maxCapacity) && (victim != null))
/*     */     {
/* 256 */       CachedRow nextVictim = victim.prev;
/* 257 */       if (victim.locker == null)
/*     */       {
/* 259 */         dereference(victim);
/* 260 */         this.rowsById.remove(victim.pk);
/* 261 */         this.listener.eviction(this.partitionIndex, row.pk, this.rowsById.size());
/*     */       }
/* 263 */       victim = nextVictim;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void ageOut(long lastUpdated)
/*     */   {
/* 269 */     CachedRow victim = this.tail;
/* 270 */     while ((victim != null) && (victim.lastUpdated < lastUpdated))
/*     */     {
/* 272 */       CachedRow nextVictim = victim.prev;
/* 273 */       if (victim.locker == null)
/*     */       {
/* 275 */         dereference(victim);
/* 276 */         this.rowsById.remove(victim.pk);
/* 277 */         this.listener.eviction(this.partitionIndex, victim.pk, this.rowsById.size());
/*     */       }
/* 279 */       victim = nextVictim;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void remove(Transaction tx, Object pk)
/*     */   {
/* 285 */     CachedRow row = (CachedRow)this.rowsById.remove(pk);
/* 286 */     if ((row == null) || ((row.locker != null) && (!tx.equals(row.locker))))
/*     */     {
/* 288 */       String msg = "removal of " + pk + " rejected for " + tx + ": " + (row == null ? "the entry could not be found" : new StringBuilder().append("the entry is locked for update by ").append(row.locker).toString());
/*     */ 
/* 294 */       throw new Cache.RemoveException(msg);
/*     */     }
/*     */ 
/* 297 */     dereference(row);
/* 298 */     CachedRow.access$002(row, null);
/*     */   }
/*     */ 
/*     */   public boolean contains(Transaction tx, Object pk)
/*     */   {
/* 303 */     CachedRow row = (CachedRow)this.rowsById.get(pk);
/* 304 */     return (row != null) && ((row.locker == null) || (tx.equals(row.locker)));
/*     */   }
/*     */ 
/*     */   public void lockForUpdate(Transaction tx, Object pk) throws Exception
/*     */   {
/* 309 */     CachedRow row = (CachedRow)this.rowsById.get(pk);
/* 310 */     if (row != null)
/*     */     {
/* 312 */       if ((row.locker != null) && (!tx.equals(row.locker)))
/*     */       {
/* 314 */         throw new Exception("lock acquisition rejected for " + tx + ", the entry is locked for update by " + row.locker + ", id=" + pk);
/*     */       }
/*     */ 
/* 318 */       CachedRow.access$002(row, tx);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void releaseLock(Transaction tx, Object pk)
/*     */     throws Exception
/*     */   {
/* 325 */     CachedRow row = (CachedRow)this.rowsById.get(pk);
/* 326 */     if (row != null)
/*     */     {
/* 328 */       if (!tx.equals(row.locker))
/*     */       {
/* 330 */         throw new Exception("rejected to release lock for " + tx + ", the entry is locked for update by " + row.locker + ", id=" + pk);
/*     */       }
/*     */ 
/* 334 */       CachedRow.access$002(row, null);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */   {
/* 341 */     this.rowsById.clear();
/* 342 */     this.head = null;
/* 343 */     this.tail = null;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 348 */     StringBuffer buf = new StringBuffer();
/* 349 */     buf.append('[');
/*     */     try
/*     */     {
/* 353 */       lock();
/*     */ 
/* 355 */       CachedRow cursor = this.head;
/* 356 */       while (cursor != null)
/*     */       {
/* 358 */         buf.append('(').append(cursor.pk).append('|');
/*     */ 
/* 362 */         for (int i = 0; i < cursor.fields.length; i++)
/*     */         {
/* 364 */           if (i > 0)
/*     */           {
/* 366 */             buf.append(',');
/*     */           }
/*     */ 
/* 369 */           buf.append(cursor.fields[i]);
/*     */         }
/*     */ 
/* 372 */         buf.append(')');
/*     */ 
/* 374 */         cursor = cursor.next;
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 379 */       unlock();
/*     */     }
/*     */ 
/* 382 */     buf.append(']');
/* 383 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   private void dereference(CachedRow row)
/*     */   {
/* 390 */     CachedRow next = row.next;
/* 391 */     CachedRow prev = row.prev;
/*     */ 
/* 393 */     if (row == this.head)
/*     */     {
/* 395 */       this.head = next;
/*     */     }
/*     */ 
/* 398 */     if (row == this.tail)
/*     */     {
/* 400 */       this.tail = prev;
/*     */     }
/*     */ 
/* 403 */     if (next != null)
/*     */     {
/* 405 */       CachedRow.access$102(next, prev);
/*     */     }
/*     */ 
/* 408 */     if (prev != null)
/*     */     {
/* 410 */       CachedRow.access$202(prev, next);
/*     */     }
/*     */ 
/* 413 */     CachedRow.access$202(row, null);
/* 414 */     CachedRow.access$102(row, null);
/*     */   }
/*     */ 
/*     */   private void promoteRow(CachedRow row)
/*     */   {
/* 419 */     if (this.head == null)
/*     */     {
/* 421 */       this.head = row;
/* 422 */       this.tail = row;
/*     */     }
/* 424 */     else if (row != this.head)
/*     */     {
/* 427 */       if (row == this.tail)
/*     */       {
/* 429 */         this.tail = row.prev;
/* 430 */         CachedRow.access$202(this.tail, null);
/*     */ 
/* 432 */         CachedRow.access$102(row, null);
/* 433 */         CachedRow.access$202(row, this.head);
/*     */ 
/* 435 */         CachedRow.access$102(this.head, row);
/* 436 */         this.head = row;
/*     */       }
/*     */       else
/*     */       {
/* 440 */         CachedRow next = row.next;
/* 441 */         CachedRow prev = row.prev;
/*     */ 
/* 443 */         if (prev != null)
/*     */         {
/* 445 */           CachedRow.access$202(prev, next);
/*     */         }
/*     */ 
/* 448 */         if (next != null)
/*     */         {
/* 450 */           CachedRow.access$102(next, prev);
/*     */         }
/*     */ 
/* 453 */         CachedRow.access$102(this.head, row);
/* 454 */         CachedRow.access$202(row, this.head);
/* 455 */         CachedRow.access$102(row, null);
/* 456 */         this.head = row;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private class CachedRow
/*     */   {
/*     */     public final Object pk;
/*     */     public final Object[] fields;
/*     */     public Object[] relations;
/*     */     private Transaction locker;
/*     */     private CachedRow next;
/*     */     private CachedRow prev;
/* 470 */     public long lastUpdated = System.currentTimeMillis();
/*     */ 
/*     */     public CachedRow(Object pk, Object[] fields)
/*     */     {
/* 474 */       this.pk = pk;
/* 475 */       this.fields = fields;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.cmp.jdbc2.schema.TableCache
 * JD-Core Version:    0.6.0
 */