/*     */ package org.jboss.ejb.plugins.local;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.rmi.AccessException;
/*     */ import java.rmi.NoSuchObjectException;
/*     */ import java.security.AccessController;
/*     */ import java.security.Principal;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import javax.ejb.AccessLocalException;
/*     */ import javax.ejb.EJBLocalHome;
/*     */ import javax.ejb.EJBLocalObject;
/*     */ import javax.ejb.NoSuchObjectLocalException;
/*     */ import javax.ejb.TransactionRequiredLocalException;
/*     */ import javax.ejb.TransactionRolledbackLocalException;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import javax.transaction.TransactionRequiredException;
/*     */ import javax.transaction.TransactionRolledbackException;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EJBProxyFactoryContainer;
/*     */ import org.jboss.ejb.LocalProxyFactory;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.invocation.LocalEJBInvocation;
/*     */ import org.jboss.invocation.MarshalledInvocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.naming.Util;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ import org.jboss.security.plugins.SecurityContextAssociation;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ 
/*     */ public class BaseLocalProxyFactory
/*     */   implements LocalProxyFactory
/*     */ {
/*  80 */   protected static Logger log = Logger.getLogger(BaseLocalProxyFactory.class);
/*     */ 
/*  85 */   protected static Map invokerMap = Collections.synchronizedMap(new HashMap());
/*     */   protected Container container;
/*     */   protected String localJndiName;
/*     */   protected TransactionManager transactionManager;
/*     */   protected EJBLocalHome home;
/*     */   protected EJBLocalObject statelessObject;
/*     */   protected Map beanMethodInvokerMap;
/*     */   protected Map homeMethodInvokerMap;
/*     */   protected Class localHomeClass;
/*     */   protected Class localClass;
/*     */   protected Constructor proxyClassConstructor;
/*     */   private final TransactionLocal cache;
/*     */ 
/*     */   public BaseLocalProxyFactory()
/*     */   {
/* 109 */     this.cache = new TransactionLocal()
/*     */     {
/*     */       protected Object initialValue()
/*     */       {
/* 113 */         return new HashMap();
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   public void setContainer(Container con)
/*     */   {
/* 127 */     this.container = con;
/*     */   }
/*     */ 
/*     */   public void create() throws Exception
/*     */   {
/* 132 */     BeanMetaData metaData = this.container.getBeanMetaData();
/* 133 */     this.localJndiName = metaData.getLocalJndiName();
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 139 */     BeanMetaData metaData = this.container.getBeanMetaData();
/* 140 */     EJBProxyFactoryContainer invokerContainer = (EJBProxyFactoryContainer)this.container;
/*     */ 
/* 142 */     this.localHomeClass = invokerContainer.getLocalHomeClass();
/* 143 */     this.localClass = invokerContainer.getLocalClass();
/* 144 */     if ((this.localHomeClass == null) || (this.localClass == null))
/*     */     {
/* 146 */       log.debug(metaData.getEjbName() + " cannot be Bound, doesn't " + "have local and local home interfaces");
/*     */ 
/* 150 */       return;
/*     */     }
/*     */ 
/* 154 */     Class[] intfs = { this.localClass };
/* 155 */     Class proxyClass = Proxy.getProxyClass(BaseLocalProxyFactory.ClassLoaderAction.UTIL.get(this.localClass), intfs);
/* 156 */     Class[] constructorParams = { InvocationHandler.class };
/*     */ 
/* 159 */     this.proxyClassConstructor = proxyClass.getConstructor(constructorParams);
/*     */ 
/* 161 */     Context iniCtx = new InitialContext();
/* 162 */     String beanName = metaData.getEjbName();
/*     */ 
/* 166 */     this.transactionManager = ((TransactionManager)iniCtx.lookup("java:/TransactionManager"));
/*     */ 
/* 170 */     Method[] methods = this.localClass.getMethods();
/* 171 */     this.beanMethodInvokerMap = new HashMap();
/* 172 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 174 */       long hash = MarshalledInvocation.calculateHash(methods[i]);
/* 175 */       this.beanMethodInvokerMap.put(new Long(hash), methods[i]);
/*     */     }
/*     */ 
/* 178 */     methods = this.localHomeClass.getMethods();
/* 179 */     this.homeMethodInvokerMap = new HashMap();
/* 180 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/* 182 */       long hash = MarshalledInvocation.calculateHash(methods[i]);
/* 183 */       this.homeMethodInvokerMap.put(new Long(hash), methods[i]);
/*     */     }
/*     */ 
/* 187 */     Util.rebind(iniCtx, this.localJndiName, getEJBLocalHome());
/* 188 */     invokerMap.put(this.localJndiName, this);
/* 189 */     log.info("Bound EJB LocalHome '" + beanName + "' to jndi '" + this.localJndiName + "'");
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */     try
/*     */     {
/* 197 */       if (invokerMap.remove(this.localJndiName) == this)
/*     */       {
/* 199 */         log.info("Unbind EJB LocalHome '" + this.container.getBeanMetaData().getEjbName() + "' from jndi '" + this.localJndiName + "'");
/*     */ 
/* 201 */         InitialContext ctx = new InitialContext();
/* 202 */         ctx.unbind(this.localJndiName);
/*     */       }
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/* 212 */     if (this.beanMethodInvokerMap != null)
/*     */     {
/* 214 */       this.beanMethodInvokerMap.clear();
/*     */     }
/* 216 */     if (this.homeMethodInvokerMap != null)
/*     */     {
/* 218 */       this.homeMethodInvokerMap.clear();
/*     */     }
/* 220 */     MarshalledInvocation.removeHashes(this.localHomeClass);
/* 221 */     MarshalledInvocation.removeHashes(this.localClass);
/*     */ 
/* 223 */     this.container = null;
/*     */   }
/*     */ 
/*     */   public Constructor getProxyClassConstructor()
/*     */   {
/* 228 */     if (this.proxyClassConstructor == null);
/* 231 */     return this.proxyClassConstructor;
/*     */   }
/*     */ 
/*     */   public EJBLocalHome getEJBLocalHome()
/*     */   {
/* 237 */     if (this.home == null)
/*     */     {
/* 239 */       EJBProxyFactoryContainer cic = (EJBProxyFactoryContainer)this.container;
/* 240 */       InvocationHandler handler = new LocalHomeProxy(this.localJndiName, this);
/* 241 */       ClassLoader loader = BaseLocalProxyFactory.ClassLoaderAction.UTIL.get(cic.getLocalHomeClass());
/* 242 */       Class[] interfaces = { cic.getLocalHomeClass() };
/*     */ 
/* 244 */       this.home = ((EJBLocalHome)Proxy.newProxyInstance(loader, interfaces, handler));
/*     */     }
/*     */ 
/* 248 */     return this.home;
/*     */   }
/*     */ 
/*     */   public EJBLocalObject getStatelessSessionEJBLocalObject()
/*     */   {
/* 253 */     if (this.statelessObject == null)
/*     */     {
/* 255 */       EJBProxyFactoryContainer cic = (EJBProxyFactoryContainer)this.container;
/* 256 */       InvocationHandler handler = new StatelessSessionProxy(this.localJndiName, this);
/*     */ 
/* 258 */       ClassLoader loader = BaseLocalProxyFactory.ClassLoaderAction.UTIL.get(cic.getLocalClass());
/* 259 */       Class[] interfaces = { cic.getLocalClass() };
/*     */ 
/* 261 */       this.statelessObject = ((EJBLocalObject)Proxy.newProxyInstance(loader, interfaces, handler));
/*     */     }
/*     */ 
/* 265 */     return this.statelessObject;
/*     */   }
/*     */ 
/*     */   public EJBLocalObject getStatefulSessionEJBLocalObject(Object id)
/*     */   {
/* 270 */     InvocationHandler handler = new StatefulSessionProxy(this.localJndiName, id, this);
/*     */     try
/*     */     {
/* 274 */       return (EJBLocalObject)this.proxyClassConstructor.newInstance(new Object[] { handler });
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 278 */     throw new NestedRuntimeException(ex);
/*     */   }
/*     */ 
/*     */   public Object getEntityEJBObject(Object id)
/*     */   {
/* 284 */     return getEntityEJBLocalObject(id);
/*     */   }
/*     */ 
/*     */   public EJBLocalObject getEntityEJBLocalObject(Object id, boolean create)
/*     */   {
/* 289 */     EJBLocalObject result = null;
/* 290 */     if (id != null)
/*     */     {
/* 292 */       Transaction tx = this.cache.getTransaction();
/* 293 */       if (tx == null)
/*     */       {
/* 295 */         result = createEJBLocalObject(id);
/*     */       }
/*     */       else
/*     */       {
/* 299 */         Map map = (Map)this.cache.get(tx);
/* 300 */         if (create)
/*     */         {
/* 302 */           result = createEJBLocalObject(id);
/* 303 */           map.put(id, result);
/*     */         }
/*     */         else
/*     */         {
/* 307 */           result = (EJBLocalObject)map.get(id);
/* 308 */           if (result == null)
/*     */           {
/* 310 */             result = createEJBLocalObject(id);
/* 311 */             map.put(id, result);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 316 */     return result;
/*     */   }
/*     */ 
/*     */   public EJBLocalObject getEntityEJBLocalObject(Object id)
/*     */   {
/* 321 */     return getEntityEJBLocalObject(id, false);
/*     */   }
/*     */ 
/*     */   public Collection getEntityLocalCollection(Collection ids)
/*     */   {
/* 326 */     ArrayList list = new ArrayList(ids.size());
/* 327 */     Iterator iter = ids.iterator();
/* 328 */     while (iter.hasNext())
/*     */     {
/* 330 */       Object nextId = iter.next();
/* 331 */       list.add(getEntityEJBLocalObject(nextId));
/*     */     }
/* 333 */     return list;
/*     */   }
/*     */ 
/*     */   public Object invokeHome(Method m, Object[] args)
/*     */     throws Exception
/*     */   {
/* 342 */     ClassLoader oldCl = BaseLocalProxyFactory.TCLAction.UTIL.getContextClassLoader();
/* 343 */     boolean setCl = !oldCl.equals(this.container.getClassLoader());
/* 344 */     if (setCl)
/*     */     {
/* 346 */       BaseLocalProxyFactory.TCLAction.UTIL.setContextClassLoader(this.container.getClassLoader());
/*     */     }
/* 348 */     this.container.pushENC();
/*     */ 
/* 350 */     SecurityActions sa = BaseLocalProxyFactory.SecurityActions.UTIL.getSecurityActions();
/*     */     try
/*     */     {
/* 354 */       LocalEJBInvocation invocation = new LocalEJBInvocation(null, m, args, getTransaction(), sa.getPrincipal(), sa.getCredential());
/*     */ 
/* 360 */       invocation.setType(InvocationType.LOCALHOME);
/*     */ 
/* 362 */       localObject1 = this.container.invoke(invocation);
/*     */     }
/*     */     catch (AccessException ae)
/*     */     {
/*     */       Object localObject1;
/* 366 */       throw new AccessLocalException(ae.getMessage(), ae);
/*     */     }
/*     */     catch (NoSuchObjectException nsoe)
/*     */     {
/* 370 */       throw new NoSuchObjectLocalException(nsoe.getMessage(), nsoe);
/*     */     }
/*     */     catch (TransactionRequiredException tre)
/*     */     {
/* 374 */       throw new TransactionRequiredLocalException(tre.getMessage());
/*     */     }
/*     */     catch (TransactionRolledbackException trbe)
/*     */     {
/* 378 */       throw new TransactionRolledbackLocalException(trbe.getMessage(), trbe);
/*     */     }
/*     */     finally
/*     */     {
/* 382 */       this.container.popENC();
/* 383 */       if (setCl)
/*     */       {
/* 385 */         BaseLocalProxyFactory.TCLAction.UTIL.setContextClassLoader(oldCl);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/* 392 */     return this.localJndiName;
/*     */   }
/*     */ 
/*     */   Transaction getTransaction()
/*     */     throws SystemException
/*     */   {
/* 402 */     if (this.transactionManager == null)
/*     */     {
/* 404 */       return null;
/*     */     }
/* 406 */     return this.transactionManager.getTransaction();
/*     */   }
/*     */ 
/*     */   public Object invoke(Object id, Method m, Object[] args)
/*     */     throws Exception
/*     */   {
/* 416 */     ClassLoader oldCl = BaseLocalProxyFactory.TCLAction.UTIL.getContextClassLoader();
/* 417 */     boolean setCl = !oldCl.equals(this.container.getClassLoader());
/* 418 */     if (setCl)
/*     */     {
/* 420 */       BaseLocalProxyFactory.TCLAction.UTIL.setContextClassLoader(this.container.getClassLoader());
/*     */     }
/* 422 */     this.container.pushENC();
/*     */ 
/* 424 */     SecurityActions sa = BaseLocalProxyFactory.SecurityActions.UTIL.getSecurityActions();
/*     */     try
/*     */     {
/* 427 */       LocalEJBInvocation invocation = new LocalEJBInvocation(id, m, args, getTransaction(), sa.getPrincipal(), sa.getCredential());
/*     */ 
/* 433 */       invocation.setType(InvocationType.LOCAL);
/*     */ 
/* 435 */       localObject1 = this.container.invoke(invocation);
/*     */     }
/*     */     catch (AccessException ae)
/*     */     {
/*     */       Object localObject1;
/* 439 */       throw new AccessLocalException(ae.getMessage(), ae);
/*     */     }
/*     */     catch (NoSuchObjectException nsoe)
/*     */     {
/* 443 */       throw new NoSuchObjectLocalException(nsoe.getMessage(), nsoe);
/*     */     }
/*     */     catch (TransactionRequiredException tre)
/*     */     {
/* 447 */       throw new TransactionRequiredLocalException(tre.getMessage());
/*     */     }
/*     */     catch (TransactionRolledbackException trbe)
/*     */     {
/* 451 */       throw new TransactionRolledbackLocalException(trbe.getMessage(), trbe);
/*     */     }
/*     */     finally
/*     */     {
/* 455 */       this.container.popENC();
/* 456 */       if (setCl)
/*     */       {
/* 458 */         BaseLocalProxyFactory.TCLAction.UTIL.setContextClassLoader(oldCl);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private EJBLocalObject createEJBLocalObject(Object id)
/*     */   {
/* 465 */     InvocationHandler handler = new EntityProxy(this.localJndiName, id, this);
/*     */     try
/*     */     {
/* 468 */       return (EJBLocalObject)this.proxyClassConstructor.newInstance(new Object[] { handler });
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 472 */     throw new NestedRuntimeException(ex);
/*     */   }
/*     */ 
/*     */   static abstract interface TCLAction
/*     */   {
/* 640 */     public static final TCLAction NON_PRIVILEGED = new TCLAction()
/*     */     {
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 644 */         return Thread.currentThread().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 649 */         return thread.getContextClassLoader();
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 654 */         Thread.currentThread().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 659 */         thread.setContextClassLoader(cl);
/*     */       }
/* 640 */     };
/*     */ 
/* 663 */     public static final TCLAction PRIVILEGED = new TCLAction()
/*     */     {
/* 665 */       private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 669 */           return Thread.currentThread().getContextClassLoader();
/*     */         }
/* 665 */       };
/*     */ 
/*     */       public ClassLoader getContextClassLoader()
/*     */       {
/* 675 */         return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
/*     */       }
/*     */ 
/*     */       public ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 680 */         return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(thread)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 684 */             return this.val$thread.getContextClassLoader();
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(ClassLoader cl) {
/* 691 */         AccessController.doPrivileged(new PrivilegedAction(cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 696 */             Thread.currentThread().setContextClassLoader(this.val$cl);
/* 697 */             return null;
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/*     */       public void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 705 */         AccessController.doPrivileged(new PrivilegedAction(thread, cl)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 710 */             this.val$thread.setContextClassLoader(this.val$cl);
/* 711 */             return null;
/*     */           }
/*     */         });
/*     */       }
/* 663 */     };
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader();
/*     */ 
/*     */     public abstract ClassLoader getContextClassLoader(Thread paramThread);
/*     */ 
/*     */     public abstract void setContextClassLoader(ClassLoader paramClassLoader);
/*     */ 
/*     */     public abstract void setContextClassLoader(Thread paramThread, ClassLoader paramClassLoader);
/*     */ 
/*     */     public static class UTIL
/*     */     {
/*     */       static BaseLocalProxyFactory.TCLAction getTCLAction()
/*     */       {
/* 616 */         return System.getSecurityManager() == null ? BaseLocalProxyFactory.TCLAction.NON_PRIVILEGED : BaseLocalProxyFactory.TCLAction.PRIVILEGED;
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader()
/*     */       {
/* 621 */         return getTCLAction().getContextClassLoader();
/*     */       }
/*     */ 
/*     */       static ClassLoader getContextClassLoader(Thread thread)
/*     */       {
/* 626 */         return getTCLAction().getContextClassLoader(thread);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(ClassLoader cl)
/*     */       {
/* 631 */         getTCLAction().setContextClassLoader(cl);
/*     */       }
/*     */ 
/*     */       static void setContextClassLoader(Thread thread, ClassLoader cl)
/*     */       {
/* 636 */         getTCLAction().setContextClassLoader(thread, cl);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface SecurityActions
/*     */   {
/* 529 */     public static final SecurityActions NON_PRIVILEGED = new SecurityActions()
/*     */     {
/*     */       public Principal getPrincipal()
/*     */       {
/* 533 */         SecurityContext sc = getSecurityContext();
/* 534 */         if (sc == null)
/* 535 */           throw new IllegalStateException("No security context for getPrincipal");
/* 536 */         return sc.getUtil().getUserPrincipal();
/*     */       }
/*     */ 
/*     */       public Object getCredential()
/*     */       {
/* 542 */         SecurityContext sc = getSecurityContext();
/* 543 */         if (sc == null)
/* 544 */           throw new IllegalStateException("No security context for getCredential");
/* 545 */         return sc.getUtil().getCredential();
/*     */       }
/*     */ 
/*     */       public SecurityContext getSecurityContext()
/*     */       {
/* 551 */         return SecurityContextAssociation.getSecurityContext();
/*     */       }
/* 529 */     };
/*     */ 
/* 556 */     public static final SecurityActions PRIVILEGED = new SecurityActions()
/*     */     {
/* 558 */       private final PrivilegedAction getPrincipalAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 562 */           SecurityContext sc = BaseLocalProxyFactory.SecurityActions.2.this.getSecurityContext();
/* 563 */           if (sc == null)
/* 564 */             throw new IllegalStateException("No security context for getPrincipal");
/* 565 */           return sc.getUtil().getUserPrincipal();
/*     */         }
/* 558 */       };
/*     */ 
/* 570 */       private final PrivilegedAction getCredentialAction = new PrivilegedAction()
/*     */       {
/*     */         public Object run()
/*     */         {
/* 574 */           SecurityContext sc = BaseLocalProxyFactory.SecurityActions.2.this.getSecurityContext();
/* 575 */           if (sc == null)
/* 576 */             throw new IllegalStateException("No security context for getCredential");
/* 577 */           return sc.getUtil().getCredential();
/*     */         }
/* 570 */       };
/*     */ 
/*     */       public Principal getPrincipal()
/*     */       {
/* 584 */         return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
/*     */       }
/*     */ 
/*     */       public Object getCredential()
/*     */       {
/* 589 */         return AccessController.doPrivileged(this.getCredentialAction);
/*     */       }
/*     */ 
/*     */       public SecurityContext getSecurityContext()
/*     */       {
/* 594 */         return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction()
/*     */         {
/*     */           public Object run()
/*     */           {
/* 599 */             return SecurityContextAssociation.getSecurityContext();
/*     */           }
/*     */         });
/*     */       }
/* 556 */     };
/*     */ 
/*     */     public abstract Principal getPrincipal();
/*     */ 
/*     */     public abstract Object getCredential();
/*     */ 
/*     */     public abstract SecurityContext getSecurityContext();
/*     */ 
/*     */     public static class UTIL
/*     */     {
/*     */       static BaseLocalProxyFactory.SecurityActions getSecurityActions()
/*     */       {
/* 525 */         return System.getSecurityManager() == null ? BaseLocalProxyFactory.SecurityActions.NON_PRIVILEGED : BaseLocalProxyFactory.SecurityActions.PRIVILEGED;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface ClassLoaderAction
/*     */   {
/* 492 */     public static final ClassLoaderAction PRIVILEGED = new ClassLoaderAction()
/*     */     {
/*     */       public ClassLoader get(Class clazz)
/*     */       {
/* 496 */         return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(clazz)
/*     */         {
/*     */           public Object run()
/*     */           {
/* 501 */             return this.val$clazz.getClassLoader();
/*     */           }
/*     */         });
/*     */       }
/* 492 */     };
/*     */ 
/* 508 */     public static final ClassLoaderAction NON_PRIVILEGED = new ClassLoaderAction()
/*     */     {
/*     */       public ClassLoader get(Class clazz)
/*     */       {
/* 512 */         return clazz.getClassLoader();
/*     */       }
/* 508 */     };
/*     */ 
/*     */     public abstract ClassLoader get(Class paramClass);
/*     */ 
/*     */     public static class UTIL
/*     */     {
/*     */       static BaseLocalProxyFactory.ClassLoaderAction getClassLoaderAction()
/*     */       {
/* 483 */         return System.getSecurityManager() == null ? BaseLocalProxyFactory.ClassLoaderAction.NON_PRIVILEGED : BaseLocalProxyFactory.ClassLoaderAction.PRIVILEGED;
/*     */       }
/*     */ 
/*     */       static ClassLoader get(Class clazz)
/*     */       {
/* 488 */         return getClassLoaderAction().get(clazz);
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.local.BaseLocalProxyFactory
 * JD-Core Version:    0.6.0
 */