/*    */ package org.jboss.ejb.plugins.local;
/*    */ 
/*    */ import java.lang.reflect.InvocationHandler;
/*    */ import java.lang.reflect.Method;
/*    */ import java.rmi.RemoteException;
/*    */ import javax.ejb.EJBException;
/*    */ import javax.ejb.EJBLocalObject;
/*    */ import javax.ejb.EJBObject;
/*    */ 
/*    */ class StatefulSessionProxy extends LocalProxy
/*    */   implements InvocationHandler
/*    */ {
/*    */   static final long serialVersionUID = -3113762511947535929L;
/*    */   private Object id;
/*    */ 
/*    */   StatefulSessionProxy(String jndiName, Object id, BaseLocalProxyFactory factory)
/*    */   {
/* 44 */     super(jndiName, factory);
/* 45 */     this.id = id;
/*    */   }
/*    */ 
/*    */   protected Object getId()
/*    */   {
/* 50 */     return this.id;
/*    */   }
/*    */ 
/*    */   public final Object invoke(Object proxy, Method m, Object[] args)
/*    */     throws Throwable
/*    */   {
/* 57 */     if (args == null) {
/* 58 */       args = EMPTY_ARGS;
/*    */     }
/*    */ 
/* 63 */     if (m.equals(GET_PRIMARY_KEY))
/*    */     {
/* 65 */       if ((proxy instanceof EJBObject))
/*    */       {
/* 67 */         throw new RemoteException("Call to getPrimaryKey not allowed on session bean");
/*    */       }
/* 69 */       if ((proxy instanceof EJBLocalObject))
/*    */       {
/* 71 */         throw new EJBException("Call to getPrimaryKey not allowed on session bean");
/*    */       }
/*    */     }
/*    */ 
/* 75 */     Object retValue = super.invoke(proxy, m, args);
/* 76 */     if (retValue == null)
/*    */     {
/* 79 */       retValue = this.factory.invoke(this.id, m, args);
/*    */     }
/*    */ 
/* 82 */     return retValue;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.local.StatefulSessionProxy
 * JD-Core Version:    0.6.0
 */