/*     */ package org.jboss.ejb.plugins.security;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import org.jboss.security.RunAs;
/*     */ import org.jboss.security.SecurityContext;
/*     */ import org.jboss.security.SecurityContextFactory;
/*     */ import org.jboss.security.SecurityContextUtil;
/*     */ import org.jboss.security.SecurityIdentity;
/*     */ import org.jboss.security.plugins.SecurityContextAssociation;
/*     */ 
/*     */ class SecurityActions
/*     */ {
/*     */   public static SecurityContext createAndSetSecurityContext(String domain, String fqnClassName)
/*     */     throws PrivilegedActionException
/*     */   {
/*  48 */     return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(domain, fqnClassName)
/*     */     {
/*     */       public Object run() throws Exception
/*     */       {
/*  52 */         SecurityContext sc = SecurityContextFactory.createSecurityContext(this.val$domain, this.val$fqnClassName);
/*  53 */         SecurityActions.setSecurityContext(sc);
/*  54 */         return sc;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public static SecurityContext getSecurityContext() {
/*  61 */     return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/*  65 */         return SecurityContextAssociation.getSecurityContext();
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   static void pushCallerRunAsIdentity(RunAs ra) {
/*  72 */     AccessController.doPrivileged(new PrivilegedAction(ra)
/*     */     {
/*     */       public Object run() {
/*  75 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  76 */         if (sc == null)
/*  77 */           throw new IllegalStateException("Security Context is null");
/*  78 */         sc.setIncomingRunAs(this.val$ra);
/*  79 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public static void popCallerRunAsIdentity()
/*     */   {
/*  87 */     AccessController.doPrivileged(new PrivilegedAction()
/*     */     {
/*     */       public Object run() {
/*  90 */         SecurityContext sc = SecurityContextAssociation.getSecurityContext();
/*  91 */         if (sc == null)
/*  92 */           throw new IllegalStateException("Security Context is null");
/*  93 */         sc.setIncomingRunAs(null);
/*  94 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public static void setSecurityContext(SecurityContext sc) {
/* 101 */     AccessController.doPrivileged(new PrivilegedAction(sc)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 105 */         SecurityContextAssociation.setSecurityContext(this.val$sc);
/* 106 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ 
/*     */   public static void setSecurityIdentity(SecurityContext sc, SecurityIdentity si)
/*     */   {
/* 114 */     AccessController.doPrivileged(new PrivilegedAction(sc, si)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 118 */         this.val$sc.getUtil().setSecurityIdentity(this.val$si);
/* 119 */         return null;
/*     */       }
/*     */     });
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.plugins.security.SecurityActions
 * JD-Core Version:    0.6.0
 */