/*     */ package org.jboss.ejb.txtimer;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.ejb.EJBException;
/*     */ import javax.ejb.Timer;
/*     */ import javax.ejb.TimerService;
/*     */ import javax.management.ObjectName;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.ContainerMBean;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.tm.TransactionManagerFactory;
/*     */ import org.jboss.tm.TransactionManagerLocator;
/*     */ 
/*     */ public class EJBTimerServiceImpl extends ServiceMBeanSupport
/*     */   implements EJBTimerServiceImplMBean
/*     */ {
/*     */   private static Logger log;
/*     */   public static TimerService FOR_NON_TIMED_OBJECT;
/*     */   private ObjectName retryPolicyName;
/*     */   private ObjectName persistencePolicyName;
/*     */   private String timerIdGeneratorClassName;
/*     */   private String timedObjectInvokerClassName;
/*     */   private TransactionManagerFactory transactionManagerFactory;
/*     */   private TransactionManager transactionManager;
/*     */   private RetryPolicy retryPolicy;
/*     */   private PersistencePolicy persistencePolicy;
/*     */   private TimerIdGenerator timerIdGenerator;
/* 127 */   private Map timerServiceMap = Collections.synchronizedMap(new HashMap());
/*     */ 
/*     */   public ObjectName getRetryPolicy()
/*     */   {
/* 138 */     return this.retryPolicyName;
/*     */   }
/*     */ 
/*     */   public void setRetryPolicy(ObjectName retryPolicyName)
/*     */   {
/* 148 */     this.retryPolicyName = retryPolicyName;
/*     */   }
/*     */ 
/*     */   public ObjectName getPersistencePolicy()
/*     */   {
/* 158 */     return this.persistencePolicyName;
/*     */   }
/*     */ 
/*     */   public void setPersistencePolicy(ObjectName persistencePolicyName)
/*     */   {
/* 168 */     this.persistencePolicyName = persistencePolicyName;
/*     */   }
/*     */ 
/*     */   public String getTimerIdGeneratorClassName()
/*     */   {
/* 178 */     return this.timerIdGeneratorClassName;
/*     */   }
/*     */ 
/*     */   public void setTimerIdGeneratorClassName(String timerIdGeneratorClassName)
/*     */   {
/* 188 */     this.timerIdGeneratorClassName = timerIdGeneratorClassName;
/*     */   }
/*     */ 
/*     */   public String getTimedObjectInvokerClassName()
/*     */   {
/* 198 */     return this.timedObjectInvokerClassName;
/*     */   }
/*     */ 
/*     */   public void setTimedObjectInvokerClassName(String timedObjectInvokerClassName)
/*     */   {
/* 208 */     this.timedObjectInvokerClassName = timedObjectInvokerClassName;
/*     */   }
/*     */ 
/*     */   public void setTransactionManagerFactory(TransactionManagerFactory factory)
/*     */   {
/* 216 */     this.transactionManagerFactory = factory;
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 226 */     if (this.transactionManagerFactory != null)
/* 227 */       this.transactionManager = this.transactionManagerFactory.getTransactionManager();
/*     */     else {
/* 229 */       this.transactionManager = TransactionManagerLocator.getInstance().locate();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 234 */       this.retryPolicy = ((RetryPolicy)MBeanProxyExt.create(RetryPolicy.class, getRetryPolicy(), this.server));
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 238 */       log.error("Cannot obtain the implementation of a RetryPolicy", e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 244 */       this.persistencePolicy = ((PersistencePolicy)MBeanProxyExt.create(PersistencePolicy.class, this.persistencePolicyName, this.server));
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 248 */       log.warn("Cannot obtain the implementation of a PersistencePolicy, using NoopPersistencePolicy: " + e.toString());
/* 249 */       this.persistencePolicy = new NoopPersistencePolicy();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 255 */       Class timerIdGeneratorClass = getClass().getClassLoader().loadClass(this.timerIdGeneratorClassName);
/* 256 */       this.timerIdGenerator = ((TimerIdGenerator)timerIdGeneratorClass.newInstance());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 260 */       log.warn("Cannot obtain the implementation of a TimerIdGenerator, using BigIntegerTimerIdGenerator: " + e.toString());
/* 261 */       this.timerIdGenerator = new BigIntegerTimerIdGenerator();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */   {
/* 268 */     this.transactionManager = null;
/* 269 */     this.retryPolicy = null;
/* 270 */     this.persistencePolicy = null;
/* 271 */     this.timerIdGenerator = null;
/*     */   }
/*     */ 
/*     */   public TimerService createTimerService(ObjectName containerId, Object instancePk, Container container)
/*     */   {
/* 287 */     TimedObjectInvoker invoker = null;
/*     */     try
/*     */     {
/* 290 */       TimedObjectId timedObjectId = new TimedObjectId(containerId, instancePk);
/* 291 */       Class invokerClass = getClass().getClassLoader().loadClass(this.timedObjectInvokerClassName);
/* 292 */       Constructor constr = invokerClass.getConstructor(new Class[] { TimedObjectId.class, Container.class });
/* 293 */       invoker = (TimedObjectInvoker)constr.newInstance(new Object[] { timedObjectId, container });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 297 */       log.error("Cannot create TimedObjectInvoker: " + this.timedObjectInvokerClassName, e);
/* 298 */       return null;
/*     */     }
/*     */ 
/* 301 */     return createTimerService(containerId, instancePk, invoker);
/*     */   }
/*     */ 
/*     */   public TimerService createTimerService(ObjectName containerId, Object instancePk, TimedObjectInvoker invoker)
/*     */   {
/* 314 */     TimedObjectId timedObjectId = new TimedObjectId(containerId, instancePk);
/* 315 */     TimerServiceImpl timerService = (TimerServiceImpl)this.timerServiceMap.get(timedObjectId);
/* 316 */     if (timerService == null)
/*     */     {
/* 318 */       timerService = new TimerServiceImpl(timedObjectId, invoker, this.transactionManager, this.persistencePolicy, this.retryPolicy, this.timerIdGenerator);
/*     */ 
/* 320 */       log.debug("createTimerService: " + timerService);
/* 321 */       this.timerServiceMap.put(timedObjectId, timerService);
/*     */     }
/* 323 */     return timerService;
/*     */   }
/*     */ 
/*     */   public TimerService getTimerService(ObjectName containerId, Object instancePk)
/*     */   {
/* 335 */     TimedObjectId timedObjectId = new TimedObjectId(containerId, instancePk);
/* 336 */     return (TimerServiceImpl)this.timerServiceMap.get(timedObjectId);
/*     */   }
/*     */ 
/*     */   public void removeTimerService(ObjectName containerId, Object instancePk)
/*     */   {
/* 351 */     TimedObjectId timedObjectId = new TimedObjectId(containerId, instancePk);
/*     */ 
/* 353 */     if (timedObjectId.getInstancePk() != null)
/*     */     {
/* 355 */       TimerServiceImpl timerService = (TimerServiceImpl)getTimerService(containerId, instancePk);
/* 356 */       if (timerService != null)
/*     */       {
/* 358 */         log.debug("removeTimerService: " + timerService);
/*     */ 
/* 361 */         timerService.shutdown(false);
/* 362 */         this.timerServiceMap.remove(timedObjectId);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 369 */       removeTimerService(containerId, false);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeTimerService(ObjectName containerId, boolean keepState)
/*     */     throws IllegalStateException
/*     */   {
/* 386 */     Iterator it = this.timerServiceMap.entrySet().iterator();
/* 387 */     while (it.hasNext())
/*     */     {
/* 389 */       Map.Entry entry = (Map.Entry)it.next();
/* 390 */       TimedObjectId key = (TimedObjectId)entry.getKey();
/* 391 */       TimerServiceImpl timerService = (TimerServiceImpl)entry.getValue();
/* 392 */       if (containerId.equals(key.getContainerId()))
/*     */       {
/* 394 */         log.debug("removeTimerService: " + timerService);
/* 395 */         timerService.shutdown(keepState);
/* 396 */         it.remove();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeTimerService(ObjectName containerId, Object instancePk, boolean keepState)
/*     */     throws IllegalStateException
/*     */   {
/* 411 */     TimedObjectId timedObjectId = new TimedObjectId(containerId, instancePk);
/* 412 */     if (timedObjectId.getInstancePk() != null)
/*     */     {
/* 414 */       TimerServiceImpl timerService = (TimerServiceImpl)getTimerService(containerId, instancePk);
/* 415 */       if (timerService != null)
/*     */       {
/* 417 */         log.debug("removeTimerService: " + timerService);
/* 418 */         timerService.shutdown(false);
/* 419 */         this.timerServiceMap.remove(timedObjectId);
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 425 */       Iterator it = this.timerServiceMap.entrySet().iterator();
/* 426 */       while (it.hasNext())
/*     */       {
/* 428 */         Map.Entry entry = (Map.Entry)it.next();
/* 429 */         TimedObjectId key = (TimedObjectId)entry.getKey();
/* 430 */         TimerServiceImpl timerService = (TimerServiceImpl)entry.getValue();
/* 431 */         if (containerId.equals(key.getContainerId()))
/*     */         {
/* 433 */           log.debug("removeTimerService: " + timerService);
/* 434 */           timerService.shutdown(keepState);
/* 435 */           it.remove();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void restoreTimers(ObjectName containerId, ClassLoader loader)
/*     */     throws IllegalStateException
/*     */   {
/* 449 */     assert (this.persistencePolicy != null) : "persistencePolicy is not set";
/*     */ 
/* 452 */     List handles = this.persistencePolicy.listTimerHandles(containerId, loader);
/*     */     Iterator i;
/* 454 */     if (!handles.isEmpty())
/*     */     {
/* 457 */       for (Iterator i = handles.iterator(); i.hasNext(); )
/*     */       {
/* 459 */         TimerHandleImpl handle = (TimerHandleImpl)i.next();
/* 460 */         this.persistencePolicy.deleteTimer(handle.getTimerId(), handle.getTimedObjectId());
/*     */       }
/*     */ 
/* 466 */       for (i = handles.iterator(); i.hasNext(); )
/*     */       {
/* 468 */         TimerHandleImpl handle = (TimerHandleImpl)i.next();
/*     */         try
/*     */         {
/* 471 */           TimedObjectId targetId = handle.getTimedObjectId();
/* 472 */           ContainerMBean container = (ContainerMBean)MBeanProxyExt.create(ContainerMBean.class, containerId, this.server);
/* 473 */           TimerService timerService = container.getTimerService(targetId.getInstancePk());
/* 474 */           timerService.createTimer(handle.getFirstTime(), handle.getPeriode(), handle.getInfo());
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 478 */           log.warn("Unable to restore timer record: " + handle, e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String listTimers()
/*     */   {
/* 493 */     StringBuffer retBuffer = new StringBuffer();
/* 494 */     Iterator it = this.timerServiceMap.entrySet().iterator();
/*     */     Iterator iterator;
/* 495 */     while (it.hasNext())
/*     */     {
/* 497 */       Map.Entry entry = (Map.Entry)it.next();
/* 498 */       TimedObjectId timedObjectId = (TimedObjectId)entry.getKey();
/* 499 */       retBuffer.append(timedObjectId + "\n");
/*     */ 
/* 501 */       TimerServiceImpl timerService = (TimerServiceImpl)entry.getValue();
/* 502 */       Collection col = timerService.getAllTimers();
/* 503 */       for (iterator = col.iterator(); iterator.hasNext(); )
/*     */       {
/* 505 */         TimerImpl timer = (TimerImpl)iterator.next();
/* 506 */         TimerHandleImpl handle = new TimerHandleImpl(timer);
/* 507 */         retBuffer.append("   handle: " + handle + "\n");
/* 508 */         retBuffer.append("      " + timer + "\n");
/*     */       }
/*     */     }
/* 511 */     return retBuffer.toString();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  62 */     log = Logger.getLogger(EJBTimerServiceImpl.class);
/*     */ 
/*  68 */     FOR_NON_TIMED_OBJECT = new TimerService()
/*     */     {
/*     */       public Timer createTimer(long duration, Serializable info)
/*     */         throws IllegalArgumentException, IllegalStateException, EJBException
/*     */       {
/*  74 */         throw new IllegalStateException("The object does not implement javax.ejb.TimedObject interface!");
/*     */       }
/*     */ 
/*     */       public Timer createTimer(long initialDuration, long intervalDuration, Serializable info)
/*     */         throws IllegalArgumentException, IllegalStateException, EJBException
/*     */       {
/*  80 */         throw new IllegalStateException("The object does not implement javax.ejb.TimedObject interface!");
/*     */       }
/*     */ 
/*     */       public Timer createTimer(Date expiration, Serializable info)
/*     */         throws IllegalArgumentException, IllegalStateException, EJBException
/*     */       {
/*  87 */         throw new IllegalStateException("The object does not implement javax.ejb.TimedObject interface!");
/*     */       }
/*     */ 
/*     */       public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info)
/*     */         throws IllegalArgumentException, IllegalStateException, EJBException
/*     */       {
/*  93 */         throw new IllegalStateException("The object does not implement javax.ejb.TimedObject interface!");
/*     */       }
/*     */ 
/*     */       public Collection getTimers() throws IllegalStateException, EJBException
/*     */       {
/*  98 */         return Collections.EMPTY_LIST;
/*     */       }
/*     */     };
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.txtimer.EJBTimerServiceImpl
 * JD-Core Version:    0.6.0
 */