/*     */ package org.jboss.ejb.txtimer;
/*     */ 
/*     */ import javax.ejb.Timer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class FixedDelayRetryPolicy extends ServiceMBeanSupport
/*     */   implements FixedDelayRetryPolicyMBean
/*     */ {
/*  42 */   private static Logger log = Logger.getLogger(FixedDelayRetryPolicy.class);
/*     */   private long delay;
/*     */ 
/*     */   public FixedDelayRetryPolicy()
/*     */   {
/*  45 */     this.delay = 100L;
/*     */   }
/*     */ 
/*     */   public long getDelay()
/*     */   {
/*  55 */     return this.delay;
/*     */   }
/*     */ 
/*     */   public void setDelay(long delay)
/*     */   {
/*  66 */     this.delay = delay;
/*     */   }
/*     */ 
/*     */   public void retryTimeout(TimedObjectInvoker invoker, Timer timer)
/*     */   {
/*  79 */     if ((timer instanceof TimerImpl))
/*     */     {
/*  81 */       TimerImpl txTimer = (TimerImpl)timer;
/*     */ 
/*  83 */       long periode = txTimer.getPeriode();
/*  84 */       if ((0L < periode) && (periode / 2L < this.delay)) {
/*  85 */         log.warn("A delay of " + this.delay + " ms might not be appropriate for a timer periode of " + periode + " ms");
/*     */       }
/*     */     }
/*  88 */     new RetryThread(invoker, timer).start();
/*     */   }
/*     */ 
/*     */   private class RetryThread extends Thread
/*     */   {
/*     */     private TimedObjectInvoker invoker;
/*     */     private Timer timer;
/*     */ 
/*     */     public RetryThread(TimedObjectInvoker invoker, Timer timer)
/*     */     {
/* 102 */       this.invoker = invoker;
/* 103 */       this.timer = timer;
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       try
/*     */       {
/* 110 */         Thread.sleep(FixedDelayRetryPolicy.this.delay);
/* 111 */         FixedDelayRetryPolicy.log.debug("Retry ejbTimeout: " + this.timer);
/* 112 */         this.invoker.callTimeout(this.timer);
/*     */       }
/*     */       catch (Exception ignore)
/*     */       {
/* 116 */         ignore.printStackTrace();
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.txtimer.FixedDelayRetryPolicy
 * JD-Core Version:    0.6.0
 */