/*     */ package org.jboss.ejb.txtimer;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Date;
/*     */ import java.util.List;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.sql.DataSource;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCMappingMetaData;
/*     */ import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
/*     */ import org.jboss.invocation.MarshalledValueInputStream;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.ObjectNameFactory;
/*     */ 
/*     */ public class GeneralPurposeDatabasePersistencePlugin
/*     */   implements DatabasePersistencePluginExt
/*     */ {
/*  69 */   private static Logger log = Logger.getLogger(GeneralPurposeDatabasePersistencePlugin.class);
/*     */   protected MBeanServer server;
/*     */   protected ObjectName dataSourceName;
/*     */   protected String tableName;
/*     */   protected DataSource ds;
/*     */   protected ObjectName metaDataName;
/*     */   private int binarySqlType;
/*     */ 
/*     */   public void init(MBeanServer server, ObjectName dataSource, String tableName)
/*     */     throws SQLException
/*     */   {
/*  94 */     if (tableName == null)
/*  95 */       throw new IllegalArgumentException("Timers tableName is null");
/*  96 */     if (tableName.length() == 0) {
/*  97 */       throw new IllegalArgumentException("Timers tableName is empty");
/*     */     }
/*  99 */     this.tableName = tableName;
/* 100 */     init(server, dataSource);
/*     */   }
/*     */ 
/*     */   public void init(MBeanServer server, ObjectName dataSourceName)
/*     */     throws SQLException
/*     */   {
/* 106 */     this.server = server;
/* 107 */     this.dataSourceName = dataSourceName;
/*     */     try
/*     */     {
/* 112 */       String dsJndiTx = (String)server.getAttribute(dataSourceName, "BindName");
/* 113 */       this.ds = ((DataSource)new InitialContext().lookup(dsJndiTx));
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 117 */       throw new SQLException("Failed to lookup data source: " + dataSourceName);
/*     */     }
/*     */ 
/* 121 */     String dsName = dataSourceName.getKeyProperty("name");
/* 122 */     this.metaDataName = ObjectNameFactory.create("jboss.jdbc:datasource=" + dsName + ",service=metadata");
/* 123 */     if (!this.server.isRegistered(this.metaDataName))
/* 124 */       throw new IllegalStateException("Cannot find datasource meta data: " + this.metaDataName);
/*     */   }
/*     */ 
/*     */   public void createTableIfNotExists()
/*     */     throws SQLException
/*     */   {
/* 131 */     Connection con = null;
/* 132 */     Statement st = null;
/*     */     try
/*     */     {
/* 135 */       JDBCTypeMappingMetaData typeMapping = (JDBCTypeMappingMetaData)this.server.getAttribute(this.metaDataName, "TypeMappingMetaData");
/* 136 */       if (typeMapping == null) {
/* 137 */         throw new IllegalStateException("Cannot obtain type mapping from: " + this.metaDataName);
/*     */       }
/* 139 */       JDBCMappingMetaData objectMetaData = typeMapping.getTypeMappingMetaData(Object.class);
/* 140 */       this.binarySqlType = objectMetaData.getJdbcType();
/*     */ 
/* 142 */       if (!SQLUtil.tableExists(getTableName(), this.ds))
/*     */       {
/* 144 */         con = this.ds.getConnection();
/*     */ 
/* 146 */         String dateType = typeMapping.getTypeMappingMetaData(Timestamp.class).getSqlType();
/* 147 */         String longType = typeMapping.getTypeMappingMetaData(Long.class).getSqlType();
/* 148 */         String objectType = objectMetaData.getSqlType();
/*     */ 
/* 151 */         StringBuffer createTableDDL = new StringBuffer("create table " + getTableName() + " (" + " " + getColumnTimerID() + " varchar(80) not null," + " " + getColumnTargetID() + " varchar(250) not null," + " " + getColumnInitialDate() + " " + dateType + " not null," + " " + getColumnTimerInterval() + " " + longType + "," + " " + getColumnInstancePK() + " " + objectType + "," + " " + getColumnInfo() + " " + objectType + ", ");
/*     */ 
/* 160 */         JDBCFunctionMappingMetaData pkConstraint = typeMapping.getPkConstraintTemplate();
/* 161 */         String[] templateParams = { getTableName() + "_PK", getColumnTimerID() + ", " + getColumnTargetID() };
/*     */ 
/* 165 */         pkConstraint.getFunctionSql(templateParams, createTableDDL);
/*     */ 
/* 168 */         createTableDDL.append(" )");
/*     */ 
/* 170 */         log.debug("Executing DDL: " + createTableDDL);
/*     */ 
/* 172 */         st = con.createStatement();
/* 173 */         st.executeUpdate(createTableDDL.toString());
/*     */       }
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 178 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 182 */       log.error("Cannot create timer table", e);
/*     */     }
/*     */     finally
/*     */     {
/* 186 */       JDBCUtil.safeClose(st);
/* 187 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void insertTimer(String timerId, TimedObjectId timedObjectId, Date initialExpiration, long intervalDuration, Serializable info)
/*     */     throws SQLException
/*     */   {
/* 195 */     Connection con = null;
/* 196 */     PreparedStatement st = null;
/*     */     try
/*     */     {
/* 199 */       con = this.ds.getConnection();
/*     */ 
/* 201 */       String sql = "insert into " + getTableName() + " " + "(" + getColumnTimerID() + "," + getColumnTargetID() + "," + getColumnInitialDate() + "," + getColumnTimerInterval() + "," + getColumnInstancePK() + "," + getColumnInfo() + ") " + "values (?,?,?,?,?,?)";
/*     */ 
/* 204 */       st = con.prepareStatement(sql);
/*     */ 
/* 206 */       st.setString(1, timerId);
/* 207 */       st.setString(2, timedObjectId.toString());
/* 208 */       st.setTimestamp(3, new Timestamp(initialExpiration.getTime()));
/* 209 */       st.setLong(4, intervalDuration);
/*     */ 
/* 211 */       byte[] bytes = serialize(timedObjectId.getInstancePk());
/* 212 */       if (bytes == null)
/*     */       {
/* 214 */         st.setNull(5, this.binarySqlType);
/*     */       }
/*     */       else
/*     */       {
/* 218 */         st.setBytes(5, bytes);
/*     */       }
/*     */ 
/* 221 */       bytes = serialize(info);
/* 222 */       if (bytes == null)
/*     */       {
/* 224 */         st.setNull(6, this.binarySqlType);
/*     */       }
/*     */       else
/*     */       {
/* 228 */         st.setBytes(6, bytes);
/*     */       }
/*     */ 
/* 231 */       int rows = st.executeUpdate();
/* 232 */       if (rows != 1)
/* 233 */         log.error("Unable to insert timer for: " + timedObjectId);
/*     */     }
/*     */     finally
/*     */     {
/* 237 */       JDBCUtil.safeClose(st);
/* 238 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */   }
/*     */ 
/*     */   public List selectTimers(ObjectName containerId)
/*     */     throws SQLException
/*     */   {
/* 247 */     Connection con = null;
/* 248 */     Statement st = null;
/* 249 */     ResultSet rs = null;
/*     */     try
/*     */     {
/* 252 */       con = this.ds.getConnection();
/*     */ 
/* 254 */       List list = new ArrayList();
/*     */ 
/* 256 */       st = con.createStatement();
/* 257 */       rs = st.executeQuery("select * from " + getTableName());
/* 258 */       while (rs.next())
/*     */       {
/* 260 */         timerId = rs.getString(getColumnTimerID());
/* 261 */         TimedObjectId targetId = TimedObjectId.parse(rs.getString(getColumnTargetID()));
/*     */ 
/* 265 */         if ((containerId == null) || (containerId.equals(targetId.getContainerId())))
/*     */         {
/* 267 */           Date initialDate = rs.getTimestamp(getColumnInitialDate());
/* 268 */           long interval = rs.getLong(getColumnTimerInterval());
/* 269 */           Serializable pKey = (Serializable)deserialize(rs.getBytes(getColumnInstancePK()));
/* 270 */           Serializable info = null;
/*     */           try
/*     */           {
/* 273 */             info = (Serializable)deserialize(rs.getBytes(getColumnInfo()));
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 280 */             log.warn("Cannot deserialize custom info object", e);
/*     */           }
/*     */ 
/* 283 */           targetId = new TimedObjectId(targetId.getContainerId(), pKey);
/* 284 */           TimerHandleImpl handle = new TimerHandleImpl(timerId, targetId, initialDate, interval, info);
/* 285 */           list.add(handle);
/*     */         }
/*     */       }
/*     */ 
/* 289 */       timerId = list;
/*     */     }
/*     */     finally
/*     */     {
/*     */       String timerId;
/* 293 */       JDBCUtil.safeClose(rs);
/* 294 */       JDBCUtil.safeClose(st);
/* 295 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void deleteTimer(String timerId, TimedObjectId timedObjectId)
/*     */     throws SQLException
/*     */   {
/* 303 */     Connection con = null;
/* 304 */     PreparedStatement st = null;
/* 305 */     ResultSet rs = null;
/*     */     try
/*     */     {
/* 309 */       con = this.ds.getConnection();
/*     */ 
/* 311 */       String sql = "delete from " + getTableName() + " where " + getColumnTimerID() + "=? and " + getColumnTargetID() + "=?";
/* 312 */       st = con.prepareStatement(sql);
/*     */ 
/* 314 */       st.setString(1, timerId);
/* 315 */       st.setString(2, timedObjectId.toString());
/*     */ 
/* 317 */       int rows = st.executeUpdate();
/*     */ 
/* 323 */       if (rows != 1)
/*     */       {
/* 325 */         log.debug("Unable to remove timer for: " + timerId);
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 330 */       JDBCUtil.safeClose(rs);
/* 331 */       JDBCUtil.safeClose(st);
/* 332 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void clearTimers()
/*     */     throws SQLException
/*     */   {
/* 340 */     Connection con = null;
/* 341 */     PreparedStatement st = null;
/* 342 */     ResultSet rs = null;
/*     */     try
/*     */     {
/* 345 */       con = this.ds.getConnection();
/* 346 */       st = con.prepareStatement("delete from " + getTableName());
/* 347 */       st.executeUpdate();
/*     */     }
/*     */     finally
/*     */     {
/* 351 */       JDBCUtil.safeClose(rs);
/* 352 */       JDBCUtil.safeClose(st);
/* 353 */       JDBCUtil.safeClose(con);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getTableName()
/*     */   {
/* 360 */     return this.tableName;
/*     */   }
/*     */ 
/*     */   public String getColumnTimerID()
/*     */   {
/* 366 */     return "TIMERID";
/*     */   }
/*     */ 
/*     */   public String getColumnTargetID()
/*     */   {
/* 372 */     return "TARGETID";
/*     */   }
/*     */ 
/*     */   public String getColumnInitialDate()
/*     */   {
/* 378 */     return "INITIALDATE";
/*     */   }
/*     */ 
/*     */   public String getColumnTimerInterval()
/*     */   {
/* 385 */     return "TIMERINTERVAL";
/*     */   }
/*     */ 
/*     */   public String getColumnInstancePK()
/*     */   {
/* 391 */     return "INSTANCEPK";
/*     */   }
/*     */ 
/*     */   public String getColumnInfo()
/*     */   {
/* 397 */     return "INFO";
/*     */   }
/*     */ 
/*     */   protected byte[] serialize(Object obj)
/*     */   {
/* 403 */     if (obj == null) {
/* 404 */       return null;
/*     */     }
/* 406 */     ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
/*     */     try
/*     */     {
/* 409 */       ObjectOutputStream oos = new ObjectOutputStream(baos);
/* 410 */       oos.writeObject(obj);
/* 411 */       oos.close();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 415 */       log.error("Cannot serialize: " + obj, e);
/*     */     }
/* 417 */     return baos.toByteArray();
/*     */   }
/*     */ 
/*     */   protected Object deserialize(byte[] bytes)
/*     */   {
/* 423 */     if (bytes == null) {
/* 424 */       return null;
/*     */     }
/* 426 */     ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
/*     */     try
/*     */     {
/* 431 */       ObjectInputStream oos = new MarshalledValueInputStream(bais);
/* 432 */       return oos.readObject();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 436 */       log.error("Cannot deserialize", e);
/* 437 */     }return null;
/*     */   }
/*     */ 
/*     */   protected Object deserialize(InputStream input)
/*     */   {
/* 445 */     if (input == null) {
/* 446 */       return null;
/*     */     }
/* 448 */     byte[] barr = new byte[1024];
/* 449 */     ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
/*     */     try
/*     */     {
/* 452 */       for (int b = 0; (b = input.read(barr)) > 0; )
/*     */       {
/* 454 */         baos.write(barr, 0, b);
/*     */       }
/* 456 */       return deserialize(baos.toByteArray());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 460 */       log.error("Cannot deserialize", e);
/* 461 */     }return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb.txtimer.GeneralPurposeDatabasePersistencePlugin
 * JD-Core Version:    0.6.0
 */