/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Properties;
/*     */ import javassist.bytecode.AnnotationsAttribute;
/*     */ import javassist.bytecode.ClassFile;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.LinkRef;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.deployment.DeploymentInfo;
/*     */ import org.jboss.deployment.MainDeployerMBean;
/*     */ import org.jboss.deployment.SubDeployer;
/*     */ import org.jboss.deployment.SubDeployerSupport;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.metadata.XmlFileLoader;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory.LoaderRepositoryConfig;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.mx.util.ObjectNameConverter;
/*     */ import org.jboss.system.ServiceControllerMBean;
/*     */ import org.jboss.util.file.ArchiveBrowser;
/*     */ import org.jboss.util.file.ClassFileFilter;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ @Deprecated
/*     */ public class EJB3Deployer extends SubDeployerSupport
/*     */   implements SubDeployer, EJB3DeployerMBean
/*     */ {
/*  71 */   private static final Logger log = Logger.getLogger(EJB3Deployer.class);
/*     */   private ServiceControllerMBean serviceController;
/*  76 */   private HashMap deployments = new HashMap();
/*     */   private SubDeployer thisProxy;
/*     */   private Properties DefaultProperties;
/*     */   private boolean deployEjb3ExtensionOnly;
/*     */   private HashSet ignoredJarsSet;
/*  86 */   private HashMap<DeploymentInfo, String> jmxNames = new HashMap();
/*     */   private boolean requireDeploymentDescriptor;
/*     */ 
/*     */   public EJB3Deployer()
/*     */   {
/*  97 */     setSuffixes(new String[] { ".jar", ".ejb3", ".par" });
/*  98 */     setRelativeOrder(400);
/*     */   }
/*     */ 
/*     */   public static boolean hasFile(DeploymentInfo di, String filePath)
/*     */   {
/* 103 */     String urlStr = di.url.getFile();
/*     */     try
/*     */     {
/* 106 */       URL dd = di.localCl.findResource(filePath);
/* 107 */       if (dd != null)
/*     */       {
/* 113 */         if (di.localUrl != null)
/*     */         {
/* 115 */           urlStr = di.localUrl.toString();
/*     */         }
/*     */ 
/* 118 */         String ddStr = dd.toString();
/* 119 */         if (ddStr.indexOf(urlStr) >= 0)
/*     */         {
/* 121 */           return true;
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/* 128 */     return false;
/*     */   }
/*     */ 
/*     */   public static boolean hasPersistenceXml(DeploymentInfo di)
/*     */   {
/* 133 */     return hasFile(di, "META-INF/persistence.xml");
/*     */   }
/*     */ 
/*     */   public static boolean has30EjbJarXml(DeploymentInfo di)
/*     */   {
/* 138 */     if (!hasFile(di, "META-INF/ejb-jar.xml")) return false;
/* 139 */     InputStream ddStream = di.localCl.getResourceAsStream("META-INF/ejb-jar.xml");
/*     */ 
/* 141 */     return has30EjbJarXml(ddStream);
/*     */   }
/*     */ 
/*     */   public static boolean has30EjbJarXml(InputStream ddStream)
/*     */   {
/*     */     try
/*     */     {
/* 149 */       byte[] stringToFind = "version=\"3.0\"".getBytes();
/* 150 */       InputStreamReader reader = new InputStreamReader(ddStream);
/*     */       try
/*     */       {
/* 153 */         int idx = 0;
/* 154 */         int len = stringToFind.length;
/* 155 */         while (reader.ready())
/*     */         {
/* 157 */           int read = reader.read();
/* 158 */           if (read == stringToFind[idx])
/*     */           {
/* 160 */             idx++;
/* 161 */             if (idx == len)
/*     */             {
/* 163 */               int i = 1;
/*     */               return i;
/*     */             }
/*     */           }
/*     */           else
/*     */           {
/* 168 */             idx = 0;
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */       finally
/*     */       {
/*     */         try
/*     */         {
/* 177 */           reader.close();
/* 178 */           ddStream.close();
/*     */         }
/*     */         catch (IOException ignored)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/* 188 */     return false;
/*     */   }
/*     */ 
/*     */   protected boolean hasJbossXml(DeploymentInfo di)
/*     */   {
/* 193 */     return hasFile(di, "META-INF/jboss.xml");
/*     */   }
/*     */ 
/*     */   protected boolean hasOnlyJbossXml(DeploymentInfo di)
/*     */   {
/* 201 */     return (!hasFile(di, "META-INF/ejb-jar.xml")) && (hasJbossXml(di));
/*     */   }
/*     */ 
/*     */   public boolean hasEjbAnnotation(DeploymentInfo di)
/*     */   {
/* 208 */     Iterator it = ArchiveBrowser.getBrowser(di.localUrl, new ClassFileFilter());
/*     */     try
/*     */     {
/* 211 */       while (it.hasNext())
/*     */       {
/* 213 */         InputStream stream = (InputStream)it.next();
/* 214 */         DataInputStream dstream = new DataInputStream(new BufferedInputStream(stream));
/* 215 */         ClassFile cf = null;
/*     */         try
/*     */         {
/* 218 */           cf = new ClassFile(dstream);
/* 219 */           AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
/* 220 */           if (visible != null)
/*     */           {
/* 222 */             int i;
/* 222 */             if (EJB3Util.isStateless(visible)) { i = 1;
/*     */               return i;
/*     */             }
/* 223 */             if (EJB3Util.isStatefulSession(visible)) { i = 1;
/*     */               return i;
/*     */             }
/* 224 */             if (EJB3Util.isMessageDriven(visible)) { i = 1;
/*     */               return i;
/*     */             }
/* 225 */             if (EJB3Util.isConsumer(visible)) { i = 1;
/*     */               return i;
/*     */             }
/* 226 */             if (EJB3Util.isService(visible)) { i = 1;
/*     */               return i;
/*     */             }
/*     */           }
/*     */         }
/*     */         finally
/*     */         {
/* 231 */           dstream.close();
/* 232 */           stream.close();
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 238 */       throw new RuntimeException(e);
/*     */     }
/* 240 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean accepts(DeploymentInfo di)
/*     */   {
/* 255 */     if ((getRequireDeploymentDescriptor()) && (!has30EjbJarXml(di)) && (!hasJbossXml(di)))
/*     */     {
/* 257 */       log.trace(EJB3Deployer.class.getSimpleName() + " skipping deployment of \"" + di.localUrl + "\"; deployer is configured to require DD and none was found.");
/*     */ 
/* 259 */       return false;
/*     */     }
/*     */ 
/* 262 */     String urlStr = di.url.getFile();
/* 263 */     if ((urlStr.endsWith(".ejb3")) || (urlStr.endsWith(".ejb3/")) || (urlStr.endsWith(".par")) || (urlStr.endsWith(".par/")))
/*     */     {
/* 265 */       return true;
/*     */     }
/*     */ 
/* 269 */     if ((!urlStr.endsWith(".jar")) && (!urlStr.endsWith(".jar/")))
/*     */     {
/* 271 */       return false;
/*     */     }
/*     */ 
/* 274 */     if (this.ignoredJarsSet.contains(di.shortName))
/*     */     {
/* 276 */       return false;
/*     */     }
/*     */ 
/* 279 */     if (has30EjbJarXml(di)) return true;
/*     */ 
/* 281 */     if (!this.deployEjb3ExtensionOnly)
/*     */     {
/* 283 */       if (hasPersistenceXml(di)) return true;
/* 284 */       if (hasOnlyJbossXml(di)) return true;
/* 285 */       if (hasEjbAnnotation(di)) return true;
/*     */     }
/*     */ 
/* 288 */     return false;
/*     */   }
/*     */ 
/*     */   public Properties getDefaultProperties()
/*     */   {
/* 293 */     return this.DefaultProperties;
/*     */   }
/*     */ 
/*     */   public void setJarsIgnoredForScanning(JarsIgnoredForScanningMBean mbean)
/*     */   {
/* 298 */     this.ignoredJarsSet = mbean.getIgnoredJarsSet();
/*     */   }
/*     */ 
/*     */   public boolean getDeployEjb3ExtensionOnly()
/*     */   {
/* 303 */     return this.deployEjb3ExtensionOnly;
/*     */   }
/*     */ 
/*     */   public void setDeployEjb3ExtensionOnly(boolean deployEjb3ExtensionOnly)
/*     */   {
/* 308 */     this.deployEjb3ExtensionOnly = deployEjb3ExtensionOnly;
/*     */   }
/*     */ 
/*     */   public boolean getRequireDeploymentDescriptor()
/*     */   {
/* 314 */     return this.requireDeploymentDescriptor;
/*     */   }
/*     */ 
/*     */   public void setRequireDeploymentDescriptor(boolean requireDeploymentDescriptor)
/*     */   {
/* 319 */     this.requireDeploymentDescriptor = requireDeploymentDescriptor;
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/* 329 */     URL propsUrl = getClass().getClassLoader().getResource("META-INF/persistence.properties");
/* 330 */     this.DefaultProperties = new Properties();
/* 331 */     this.DefaultProperties.load(propsUrl.openStream());
/* 332 */     log.debug("Default persistence.properties: " + this.DefaultProperties);
/*     */ 
/* 336 */     String bcprovider = this.DefaultProperties.getProperty("hibernate.bytecode.provider", "javassist");
/* 337 */     System.setProperty("hibernate.bytecode.provider", bcprovider);
/* 338 */     super.createService();
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 346 */     this.serviceController = ((ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, ServiceControllerMBean.OBJECT_NAME, this.server));
/*     */ 
/* 352 */     this.thisProxy = ((EJB3DeployerMBean)MBeanProxyExt.create(EJB3DeployerMBean.class, super.getServiceName(), super.getServer()));
/*     */ 
/* 356 */     this.mainDeployer.addDeployer(this.thisProxy);
/*     */ 
/* 359 */     InitialContext iniCtx = InitialContextFactory.getInitialContext();
/* 360 */     initializeJavaComp(iniCtx);
/*     */   }
/*     */ 
/*     */   public static void initializeJavaComp(InitialContext iniCtx)
/*     */     throws NamingException
/*     */   {
/* 366 */     Context ctx = (Context)iniCtx.lookup("java:");
/* 367 */     ctx.rebind("comp.ejb3", new LinkRef("java:comp"));
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */     throws Exception
/*     */   {
/* 376 */     Iterator modules = this.deployments.values().iterator();
/* 377 */     while (modules.hasNext())
/*     */     {
/* 379 */       DeploymentInfo di = (DeploymentInfo)modules.next();
/* 380 */       stop(di);
/*     */     }
/* 382 */     Iterator modules = new ArrayList(this.deployments.values()).iterator();
/* 383 */     while (modules.hasNext())
/*     */     {
/* 385 */       DeploymentInfo di = (DeploymentInfo)modules.next();
/* 386 */       destroy(di);
/*     */     }
/* 388 */     this.deployments.clear();
/*     */ 
/* 391 */     this.mainDeployer.removeDeployer(this.thisProxy);
/*     */ 
/* 393 */     this.serviceController = null;
/*     */   }
/*     */ 
/*     */   public void init(DeploymentInfo di) throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 400 */       if (di.url.getProtocol().equalsIgnoreCase("file"))
/*     */       {
/* 402 */         File file = new File(di.url.getFile());
/*     */ 
/* 404 */         if (!file.isDirectory())
/*     */         {
/* 407 */           di.watch = di.url;
/*     */         }
/*     */         else
/*     */         {
/* 412 */           di.watch = new URL(di.url, "META-INF/ejb-jar.xml");
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 418 */         di.watch = di.url;
/*     */       }
/*     */ 
/* 421 */       XmlFileLoader xfl = new XmlFileLoader();
/* 422 */       InputStream in = di.localCl.getResourceAsStream("META-INF/jboss.xml");
/* 423 */       if (in != null)
/*     */       {
/*     */         try
/*     */         {
/* 427 */           Element jboss = xfl.getDocument(in, "META-INF/jboss.xml").getDocumentElement();
/*     */ 
/* 429 */           Element loader = MetaData.getOptionalChild(jboss, "loader-repository");
/* 430 */           if (loader != null)
/*     */           {
/* 432 */             LoaderRepositoryFactory.LoaderRepositoryConfig config = LoaderRepositoryFactory.parseRepositoryConfig(loader);
/*     */ 
/* 434 */             di.setRepositoryInfo(config);
/*     */           }
/*     */ 
/* 437 */           Element jmxNameElement = MetaData.getOptionalChild(jboss, "jmx-name");
/* 438 */           if (jmxNameElement != null)
/*     */           {
/* 440 */             this.jmxNames.put(di, jmxNameElement.getChildNodes().item(0).getNodeValue());
/*     */           }
/*     */         }
/*     */         finally
/*     */         {
/* 445 */           in.close();
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 451 */       if ((e instanceof DeploymentException))
/*     */       {
/* 453 */         throw ((DeploymentException)e);
/*     */       }
/* 455 */       throw new DeploymentException("failed to initialize", e);
/*     */     }
/*     */ 
/* 459 */     super.init(di);
/*     */   }
/*     */ 
/*     */   public synchronized void create(DeploymentInfo di) throws DeploymentException
/*     */   {
/* 464 */     log.debug("create, " + di.shortName);
/*     */     try
/*     */     {
/* 469 */       URL loaderURL = di.localUrl != null ? di.localUrl : di.url;
/* 470 */       di.annotationsCl = new URLClassLoader(new URL[] { loaderURL }, di.ucl);
/*     */ 
/* 472 */       Ejb3Module ejbModule = new Ejb3Module(di);
/* 473 */       String name = (String)this.jmxNames.get(di);
/* 474 */       if (name == null) {
/* 475 */         name = "jboss.j2ee:service=EJB3,module=" + di.shortName;
/*     */       }
/* 477 */       ObjectName ejbModuleName = ObjectNameConverter.convert(name);
/*     */ 
/* 479 */       if (this.server.isRegistered(ejbModuleName) == true)
/*     */       {
/* 481 */         log.debug("The EJBModule name: " + ejbModuleName + "is already registered, adding uid=" + System.identityHashCode(ejbModule));
/*     */ 
/* 483 */         name = name + ",uid=" + System.identityHashCode(ejbModule);
/* 484 */         ejbModuleName = ObjectNameConverter.convert(name);
/*     */       }
/* 486 */       this.server.registerMBean(ejbModule, ejbModuleName);
/* 487 */       di.deployedObject = ejbModuleName;
/* 488 */       log.debug("Deploying: " + di.url);
/*     */ 
/* 490 */       this.serviceController.create(di.deployedObject);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 494 */       throw new DeploymentException("Error during create of EjbModule: " + di.url, e);
/*     */     }
/*     */ 
/* 497 */     super.create(di);
/*     */   }
/*     */ 
/*     */   public synchronized void start(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 506 */       log.debug("start application, deploymentInfo: " + di + ", short name: " + di.shortName + ", parent short name: " + (di.parent == null ? "null" : di.parent.shortName));
/*     */ 
/* 510 */       this.serviceController.start(di.deployedObject);
/* 511 */       log.info("Deployed: " + di.url);
/*     */ 
/* 513 */       this.deployments.put(di.url, di);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 517 */       stop(di);
/* 518 */       destroy(di);
/* 519 */       throw new DeploymentException("Could not deploy " + di.url, e);
/*     */     }
/* 521 */     super.start(di);
/*     */   }
/*     */ 
/*     */   public void stop(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/* 527 */     log.debug("init, " + di.shortName);
/*     */     try
/*     */     {
/* 530 */       this.serviceController.stop(di.deployedObject);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 534 */       throw new DeploymentException("problem stopping ejb module: " + di.url, e);
/*     */     }
/*     */ 
/* 538 */     super.stop(di);
/*     */   }
/*     */ 
/*     */   public void destroy(DeploymentInfo di)
/*     */     throws DeploymentException
/*     */   {
/* 545 */     this.deployments.remove(di.url);
/*     */     try
/*     */     {
/* 548 */       this.serviceController.destroy(di.deployedObject);
/* 549 */       this.serviceController.remove(di.deployedObject);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 553 */       throw new DeploymentException("problem destroying ejb module: " + di.url, e);
/*     */     }
/*     */ 
/* 557 */     this.jmxNames.remove(di);
/*     */ 
/* 559 */     super.destroy(di);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.EJB3Deployer
 * JD-Core Version:    0.6.0
 */