/*    */ package org.jboss.ejb3;
/*    */ 
/*    */ import javassist.bytecode.AnnotationsAttribute;
/*    */ import javassist.bytecode.annotation.Annotation;
/*    */ import javassist.bytecode.annotation.StringMemberValue;
/*    */ import javax.ejb.MessageDriven;
/*    */ import javax.ejb.Stateful;
/*    */ import javax.ejb.Stateless;
/*    */ import javax.persistence.Entity;
/*    */ import org.jboss.ejb3.annotation.AspectDomain;
/*    */ import org.jboss.ejb3.annotation.Consumer;
/*    */ import org.jboss.ejb3.annotation.Service;
/*    */ 
/*    */ public class EJB3Util
/*    */ {
/*    */   public static boolean isStateless(AnnotationsAttribute group)
/*    */   {
/* 41 */     return group.getAnnotation(Stateless.class.getName()) != null;
/*    */   }
/*    */ 
/*    */   public static boolean isStatefulSession(AnnotationsAttribute group)
/*    */   {
/* 46 */     return group.getAnnotation(Stateful.class.getName()) != null;
/*    */   }
/*    */ 
/*    */   public static boolean isEntity(AnnotationsAttribute group)
/*    */   {
/* 51 */     return group.getAnnotation(Entity.class.getName()) != null;
/*    */   }
/*    */ 
/*    */   public static boolean isMessageDriven(AnnotationsAttribute group)
/*    */   {
/* 56 */     return group.getAnnotation(MessageDriven.class.getName()) != null;
/*    */   }
/*    */ 
/*    */   public static boolean isService(AnnotationsAttribute group)
/*    */   {
/* 61 */     return group.getAnnotation(Service.class.getName()) != null;
/*    */   }
/*    */ 
/*    */   public static boolean isConsumer(AnnotationsAttribute group)
/*    */   {
/* 66 */     return group.getAnnotation(Consumer.class.getName()) != null;
/*    */   }
/*    */ 
/*    */   public static String getAspectDomain(AnnotationsAttribute visible, String defaultContainerName)
/*    */   {
/* 71 */     if (visible != null)
/*    */     {
/* 73 */       Annotation dinfo = visible.getAnnotation(AspectDomain.class.getName());
/*    */ 
/* 75 */       if (dinfo != null)
/*    */       {
/* 77 */         StringMemberValue dmv = (StringMemberValue)dinfo.getMemberValue("value");
/*    */ 
/* 79 */         if (dmv != null)
/*    */         {
/* 81 */           return dmv.getValue();
/*    */         }
/*    */       }
/*    */     }
/*    */ 
/* 86 */     return defaultContainerName;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.EJB3Util
 * JD-Core Version:    0.6.0
 */