/*      */ package org.jboss.ejb3;
/*      */ 
/*      */ import gnu.trove.TLongObjectHashMap;
/*      */ import java.lang.annotation.Annotation;
/*      */ import java.lang.annotation.Retention;
/*      */ import java.lang.annotation.RetentionPolicy;
/*      */ import java.lang.reflect.AccessibleObject;
/*      */ import java.lang.reflect.Constructor;
/*      */ import java.lang.reflect.Field;
/*      */ import java.lang.reflect.InvocationTargetException;
/*      */ import java.lang.reflect.Method;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Iterator;
/*      */ import java.util.LinkedHashSet;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import javax.annotation.PostConstruct;
/*      */ import javax.annotation.PreDestroy;
/*      */ import javax.ejb.EJBContext;
/*      */ import javax.ejb.EJBException;
/*      */ import javax.ejb.Local;
/*      */ import javax.ejb.Remote;
/*      */ import javax.ejb.Timeout;
/*      */ import javax.management.MalformedObjectNameException;
/*      */ import javax.management.ObjectName;
/*      */ import javax.naming.Context;
/*      */ import javax.naming.InitialContext;
/*      */ import javax.naming.LinkRef;
/*      */ import javax.naming.NameNotFoundException;
/*      */ import javax.naming.NamingException;
/*      */ import javax.naming.Reference;
/*      */ import javax.naming.StringRefAddr;
/*      */ import org.jboss.aop.AspectManager;
/*      */ import org.jboss.aop.ClassContainer;
/*      */ import org.jboss.aop.MethodInfo;
/*      */ import org.jboss.aop.advice.Interceptor;
/*      */ import org.jboss.aop.annotation.AnnotationElement;
/*      */ import org.jboss.aop.annotation.AnnotationRepository;
/*      */ import org.jboss.aop.joinpoint.ConstructorInvocation;
/*      */ import org.jboss.aop.util.MethodHashing;
/*      */ import org.jboss.ejb3.annotation.Clustered;
/*      */ import org.jboss.ejb3.annotation.SecurityDomain;
/*      */ import org.jboss.ejb3.deployers.Ejb3Deployer;
/*      */ import org.jboss.ejb3.deployers.JBoss5DependencyPolicy;
/*      */ import org.jboss.ejb3.entity.PersistenceUnitDeployment;
/*      */ import org.jboss.ejb3.interceptor.InterceptorInfo;
/*      */ import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
/*      */ import org.jboss.ejb3.interceptor.InterceptorInjector;
/*      */ import org.jboss.ejb3.interceptor.LifecycleInterceptorHandler;
/*      */ import org.jboss.ejb3.javaee.JavaEEComponent;
/*      */ import org.jboss.ejb3.javaee.JavaEEComponentHelper;
/*      */ import org.jboss.ejb3.javaee.JavaEEModule;
/*      */ import org.jboss.ejb3.pool.PoolFactory;
/*      */ import org.jboss.ejb3.pool.PoolFactoryRegistry;
/*      */ import org.jboss.ejb3.security.JaccHelper;
/*      */ import org.jboss.ejb3.security.SecurityDomainManager;
/*      */ import org.jboss.ejb3.statistics.InvocationStatistics;
/*      */ import org.jboss.ejb3.tx.UserTransactionImpl;
/*      */ import org.jboss.iiop.CorbaORBService;
/*      */ import org.jboss.injection.DependsHandler;
/*      */ import org.jboss.injection.EJBHandler;
/*      */ import org.jboss.injection.EncInjector;
/*      */ import org.jboss.injection.InjectionContainer;
/*      */ import org.jboss.injection.InjectionHandler;
/*      */ import org.jboss.injection.InjectionUtil;
/*      */ import org.jboss.injection.Injector;
/*      */ import org.jboss.injection.JndiInjectHandler;
/*      */ import org.jboss.injection.PersistenceContextHandler;
/*      */ import org.jboss.injection.PersistenceUnitHandler;
/*      */ import org.jboss.injection.ResourceHandler;
/*      */ import org.jboss.injection.WebServiceRefHandler;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
/*      */ import org.jboss.metadata.javaee.spec.Environment;
/*      */ import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
/*      */ import org.jboss.naming.Util;
/*      */ import org.jboss.util.StringPropertyReplacer;
/*      */ import org.jboss.virtual.VirtualFile;
/*      */ 
/*      */ public abstract class EJBContainer extends ClassContainer
/*      */   implements Container, InjectionContainer, JavaEEComponent
/*      */ {
/*      */   private static final Logger log;
/*  118 */   protected EjbEncFactory encFactory = new DefaultEjbEncFactory();
/*      */   protected org.jboss.ejb3.pool.Pool pool;
/*      */   protected String ejbName;
/*      */   protected ObjectName objectName;
/*      */   protected int defaultConstructorIndex;
/*      */   protected String beanClassName;
/*      */   protected ClassLoader classloader;
/*  133 */   protected List<Injector> injectors = new ArrayList();
/*      */   protected Context enc;
/*      */   protected LifecycleInterceptorHandler callbackHandler;
/*      */   protected Hashtable initialContextProperties;
/*  142 */   protected Map<String, EncInjector> encInjectors = new HashMap();
/*      */   protected JBossEnterpriseBeanMetaData xml;
/*      */   protected JBossAssemblyDescriptorMetaData assembly;
/*  147 */   protected Map<String, Map<AccessibleObject, Injector>> encInjections = new HashMap();
/*      */   protected InterceptorInfoRepository interceptorRepository;
/*  151 */   protected List<InterceptorInfo> classInterceptors = new ArrayList();
/*      */   protected LinkedHashSet<InterceptorInfo> applicableInterceptors;
/*  155 */   private HashMap<Class, InterceptorInjector> interceptorInjectors = new HashMap();
/*      */   private Ejb3Deployment deployment;
/*      */   private DependencyPolicy dependencyPolicy;
/*      */   private String jaccContextId;
/*  163 */   protected HashMap invokedMethod = new HashMap();
/*      */ 
/*  165 */   protected InvocationStatistics invokeStats = new InvocationStatistics();
/*      */   private String partitionName;
/*      */   private List<Class<?>> businessInterfaces;
/*  171 */   private ThreadLocalStack<BeanContext<?>> currentBean = new ThreadLocalStack();
/*      */   public static final String MANAGED_ENTITY_MANAGER_FACTORY = "ManagedEntityManagerFactory";
/*      */   public static final String ENTITY_MANAGER_FACTORY = "EntityManagerFactory";
/*      */ 
/*      */   public EJBContainer(String name, AspectManager manager, ClassLoader cl, String beanClassName, String ejbName, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment)
/*      */   {
/*  188 */     super(name, manager);
/*      */ 
/*  190 */     assert (interceptorRepository != null) : "interceptorRepository is null";
/*  191 */     assert (deployment != null) : "deployment is null";
/*      */ 
/*  193 */     this.deployment = deployment;
/*  194 */     this.beanClassName = beanClassName;
/*  195 */     this.classloader = cl;
/*      */ 
/*  197 */     super.setChainOverridingForInheritedMethods(true);
/*      */     try
/*      */     {
/*  201 */       this.clazz = this.classloader.loadClass(beanClassName);
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*  205 */       throw new RuntimeException(e);
/*      */     }
/*  207 */     this.ejbName = ejbName;
/*  208 */     String on = createObjectName(ejbName);
/*      */     try
/*      */     {
/*  211 */       this.objectName = new ObjectName(on);
/*      */     }
/*      */     catch (MalformedObjectNameException e)
/*      */     {
/*  215 */       throw new RuntimeException("failed to create object name for: " + on, e);
/*      */     }
/*      */ 
/*  218 */     this.annotations = new AnnotationRepositoryToMetaData(this);
/*      */ 
/*  220 */     this.initialContextProperties = ctxProperties;
/*      */     try
/*      */     {
/*  223 */       Util.createSubcontext(getEnc(), "env");
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  227 */       throw new RuntimeException(e);
/*      */     }
/*  229 */     this.interceptorRepository = interceptorRepository;
/*  230 */     this.interceptorRepository.addBeanClass(this.clazz.getName());
/*  231 */     bindORB();
/*  232 */     bindEJBContext();
/*      */ 
/*  234 */     this.dependencyPolicy = deployment.createDependencyPolicy(this);
/*      */   }
/*      */ 
/*      */   private void bindEJBContext()
/*      */   {
/*      */     try
/*      */     {
/*  241 */       Reference ref = new Reference(EJBContext.class.getName(), EJBContextFactory.class.getName(), null);
/*  242 */       ref.add(new StringRefAddr("containerGuid", Ejb3Registry.guid(this)));
/*  243 */       ref.add(new StringRefAddr("containerClusterUid", Ejb3Registry.clusterUid(this)));
/*  244 */       ref.add(new StringRefAddr("isClustered", Boolean.toString(isClustered())));
/*  245 */       Util.rebind(getEnc(), "EJBContext", ref);
/*      */     }
/*      */     catch (NamingException e)
/*      */     {
/*  249 */       throw new RuntimeException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void bindORB()
/*      */   {
/*      */     try
/*      */     {
/*  257 */       Util.rebind(getEnc(), "ORB", new LinkRef("java:/" + CorbaORBService.ORB_NAME));
/*      */     }
/*      */     catch (NamingException e)
/*      */     {
/*  261 */       throw new RuntimeException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public abstract BeanContext<?> createBeanContext();
/*      */ 
/*      */   public String createObjectName(String ejbName) {
/*  269 */     return JavaEEComponentHelper.createObjectName(this.deployment, ejbName);
/*      */   }
/*      */ 
/*      */   public String createObjectName(String unitName, String ejbName)
/*      */   {
/*  274 */     return JavaEEComponentHelper.createObjectName(this.deployment, unitName, ejbName);
/*      */   }
/*      */ 
/*      */   public void pushContext(BeanContext<?> beanContext)
/*      */   {
/*  279 */     this.currentBean.push(beanContext);
/*      */   }
/*      */ 
/*      */   protected void pushEnc()
/*      */   {
/*  290 */     this.encFactory.pushEnc(this);
/*      */   }
/*      */ 
/*      */   public BeanContext<?> peekContext()
/*      */   {
/*  295 */     BeanContext ctx = (BeanContext)this.currentBean.get();
/*  296 */     assert (ctx != null) : "ctx is null";
/*  297 */     return ctx;
/*      */   }
/*      */ 
/*      */   public BeanContext<?> popContext()
/*      */   {
/*  302 */     return (BeanContext)this.currentBean.pop();
/*      */   }
/*      */ 
/*      */   protected void popEnc()
/*      */   {
/*  312 */     this.encFactory.popEnc(this);
/*      */   }
/*      */ 
/*      */   public Environment getEnvironmentRefGroup()
/*      */   {
/*  317 */     return this.xml;
/*      */   }
/*      */ 
/*      */   public List<Injector> getInjectors()
/*      */   {
/*  322 */     return this.injectors;
/*      */   }
/*      */ 
/*      */   public String getJaccContextId()
/*      */   {
/*  328 */     return this.jaccContextId;
/*      */   }
/*      */ 
/*      */   public void setJaccContextId(String jaccContextId)
/*      */   {
/*  333 */     this.jaccContextId = jaccContextId;
/*      */   }
/*      */ 
/*      */   public VirtualFile getRootFile()
/*      */   {
/*  338 */     return getDeploymentUnit().getRootFile();
/*      */   }
/*      */ 
/*      */   public List<Class<?>> getBusinessInterfaces()
/*      */   {
/*  350 */     if (this.businessInterfaces == null) throw new IllegalStateException("businessInterfaces not yet initialized");
/*  351 */     return this.businessInterfaces;
/*      */   }
/*      */ 
/*      */   public String getDeploymentQualifiedName()
/*      */   {
/*  363 */     return this.objectName.getCanonicalName();
/*      */   }
/*      */ 
/*      */   public DeploymentUnit getDeploymentUnit()
/*      */   {
/*  368 */     return this.deployment.getDeploymentUnit();
/*      */   }
/*      */ 
/*      */   public Ejb3Deployment getDeployment()
/*      */   {
/*  373 */     return this.deployment;
/*      */   }
/*      */ 
/*      */   public DependencyPolicy getDependencyPolicy()
/*      */   {
/*  378 */     return this.dependencyPolicy;
/*      */   }
/*      */ 
/*      */   public boolean isBusinessMethod(Method businessMethod)
/*      */   {
/*  389 */     for (Class businessInterface : getBusinessInterfaces())
/*      */     {
/*  391 */       for (Method method : businessInterface.getMethods())
/*      */       {
/*  393 */         if (isCallable(method, businessMethod))
/*  394 */           return true;
/*      */       }
/*      */     }
/*  397 */     return false;
/*      */   }
/*      */ 
/*      */   private static boolean isCallable(Method method, Method other)
/*      */   {
/*  411 */     if ((method.getDeclaringClass().isAssignableFrom(other.getDeclaringClass())) && (method.getName() == other.getName()))
/*      */     {
/*  413 */       if (!method.getReturnType().equals(other.getReturnType()))
/*  414 */         return false;
/*  415 */       Class[] params1 = method.getParameterTypes();
/*  416 */       Class[] params2 = other.getParameterTypes();
/*  417 */       if (params1.length == params2.length)
/*      */       {
/*  419 */         for (int i = 0; i < params1.length; i++)
/*      */         {
/*  421 */           if (params1[i] != params2[i])
/*  422 */             return false;
/*      */         }
/*  424 */         return true;
/*      */       }
/*      */     }
/*  427 */     return false;
/*      */   }
/*      */ 
/*      */   public void processMetadata()
/*      */   {
/*  443 */     Collection handlers = new ArrayList();
/*  444 */     handlers.add(new EJBHandler());
/*  445 */     handlers.add(new DependsHandler());
/*  446 */     handlers.add(new JndiInjectHandler());
/*  447 */     handlers.add(new PersistenceContextHandler());
/*  448 */     handlers.add(new PersistenceUnitHandler());
/*  449 */     handlers.add(new ResourceHandler());
/*  450 */     handlers.add(new WebServiceRefHandler());
/*      */ 
/*  452 */     ClassLoader old = Thread.currentThread().getContextClassLoader();
/*  453 */     Thread.currentThread().setContextClassLoader(this.classloader);
/*      */     try
/*      */     {
/*  457 */       InjectionHandler handler;
/*  457 */       for (Iterator i$ = handlers.iterator(); i$.hasNext(); handler.loadXml(this.xml, this)) handler = (InjectionHandler)i$.next();
/*      */ 
/*  459 */       Map tmp = InjectionUtil.processAnnotations(this, handlers, getBeanClass());
/*  460 */       this.injectors.addAll(tmp.values());
/*      */ 
/*  462 */       initialiseInterceptors();
/*  463 */       for (Iterator i$ = this.applicableInterceptors.iterator(); i$.hasNext(); ) { interceptorInfo = (InterceptorInfo)i$.next();
/*      */ 
/*  465 */         for (InjectionHandler handler : handlers)
/*      */         {
/*  467 */           handler.loadXml(interceptorInfo.getXml(), this);
/*      */         }
/*      */       }
/*      */       InterceptorInfo interceptorInfo;
/*  470 */       for (InterceptorInfo interceptorInfo : this.applicableInterceptors)
/*      */       {
/*  472 */         Map tmpInterceptor = InjectionUtil.processAnnotations(this, handlers, interceptorInfo.getClazz());
/*  473 */         InterceptorInjector injector = new InterceptorInjector(this, interceptorInfo, tmpInterceptor);
/*  474 */         this.interceptorInjectors.put(interceptorInfo.getClazz(), injector);
/*      */       }
/*      */       ServiceReferenceMetaData sref;
/*  479 */       if ((this.xml != null) && (this.xml.getServiceReferences() != null))
/*      */       {
/*  481 */         for (Iterator i$ = this.xml.getServiceReferences().iterator(); i$.hasNext(); sref = (ServiceReferenceMetaData)i$.next());
/*      */       }
/*      */ 
/*  507 */       checkForDuplicateLocalAndRemoteInterfaces();
/*      */ 
/*  509 */       for (Class businessInterface : getBusinessInterfaces()) {
/*  510 */         ((JBoss5DependencyPolicy)getDependencyPolicy()).addSupply(businessInterface);
/*      */       }
/*  512 */       Class localHomeInterface = ProxyFactoryHelper.getLocalHomeInterface(this);
/*  513 */       if (localHomeInterface != null) {
/*  514 */         ((JBoss5DependencyPolicy)getDependencyPolicy()).addSupply(localHomeInterface);
/*      */       }
/*  516 */       Class remoteHomeInterface = ProxyFactoryHelper.getRemoteHomeInterface(this);
/*  517 */       if (remoteHomeInterface != null)
/*  518 */         ((JBoss5DependencyPolicy)getDependencyPolicy()).addSupply(remoteHomeInterface);
/*      */     }
/*      */     finally
/*      */     {
/*  522 */       Thread.currentThread().setContextClassLoader(old);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void checkForDuplicateLocalAndRemoteInterfaces()
/*      */     throws EJBException
/*      */   {
/*  534 */     String issue = "(EJBTHREE-1025)";
/*      */ 
/*  537 */     Local local = (Local)resolveAnnotation(Local.class);
/*  538 */     Remote remote = (Remote)resolveAnnotation(Remote.class);
/*      */ 
/*  541 */     if ((local == null) || (remote == null))
/*      */     {
/*  543 */       return;
/*      */     }
/*      */ 
/*  547 */     if ((local.value().length < 1) && (local.value().length < 1))
/*      */     {
/*  549 */       throw new EJBException("Cannot designate both " + Local.class.getName() + " and " + Remote.class.getName() + " annotations without 'value' attribute on " + getEjbName() + ". " + issue);
/*      */     }
/*      */ 
/*  554 */     for (Class localClass : local.value())
/*      */     {
/*  556 */       for (Class remoteClass : remote.value())
/*      */       {
/*  558 */         if (!localClass.equals(remoteClass))
/*      */           continue;
/*  560 */         throw new EJBException("Cannot designate " + localClass.getName() + " as both " + Local.class.getName() + " and " + Remote.class.getName() + " on " + getEjbName() + ". " + issue);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public JBossEnterpriseBeanMetaData getXml()
/*      */   {
/*  569 */     return this.xml;
/*      */   }
/*      */ 
/*      */   public void setXml(JBossEnterpriseBeanMetaData xml)
/*      */   {
/*  574 */     this.xml = xml;
/*      */   }
/*      */ 
/*      */   public JBossAssemblyDescriptorMetaData getAssemblyDescriptor()
/*      */   {
/*  579 */     return this.assembly;
/*      */   }
/*      */ 
/*      */   public void setAssemblyDescriptor(JBossAssemblyDescriptorMetaData assembly)
/*      */   {
/*  584 */     this.assembly = assembly;
/*      */   }
/*      */ 
/*      */   protected abstract List<Class<?>> resolveBusinessInterfaces();
/*      */ 
/*      */   public InterceptorInfoRepository getInterceptorRepository() {
/*  591 */     return this.interceptorRepository;
/*      */   }
/*      */ 
/*      */   public List<InterceptorInfo> getClassInterceptors()
/*      */   {
/*  596 */     initialiseInterceptors();
/*  597 */     return this.classInterceptors;
/*      */   }
/*      */ 
/*      */   public HashSet<InterceptorInfo> getApplicableInterceptors()
/*      */   {
/*  602 */     initialiseInterceptors();
/*  603 */     return this.applicableInterceptors;
/*      */   }
/*      */ 
/*      */   public HashMap<Class, InterceptorInjector> getInterceptorInjectors()
/*      */   {
/*  608 */     initialiseInterceptors();
/*  609 */     return this.interceptorInjectors;
/*      */   }
/*      */ 
/*      */   public Map<String, EncInjector> getEncInjectors()
/*      */   {
/*  615 */     return this.encInjectors;
/*      */   }
/*      */ 
/*      */   public ClassLoader getClassloader()
/*      */   {
/*  620 */     return this.classloader;
/*      */   }
/*      */ 
/*      */   public InitialContext getInitialContext()
/*      */   {
/*      */     try
/*      */     {
/*  627 */       return InitialContextFactory.getInitialContext(this.initialContextProperties);
/*      */     }
/*      */     catch (NamingException e) {
/*      */     }
/*  631 */     throw new RuntimeException(e);
/*      */   }
/*      */ 
/*      */   public Map<String, Map<AccessibleObject, Injector>> getEncInjections()
/*      */   {
/*  637 */     return this.encInjections;
/*      */   }
/*      */ 
/*      */   public Context getEnc()
/*      */   {
/*  642 */     if (this.enc == null)
/*      */     {
/*  644 */       this.enc = this.encFactory.getEnc(this);
/*      */     }
/*  646 */     return this.enc;
/*      */   }
/*      */ 
/*      */   public Hashtable getInitialContextProperties()
/*      */   {
/*  651 */     return this.initialContextProperties;
/*      */   }
/*      */ 
/*      */   public ObjectName getObjectName()
/*      */   {
/*  656 */     return this.objectName;
/*      */   }
/*      */ 
/*      */   public String getEjbName()
/*      */   {
/*  661 */     return this.ejbName;
/*      */   }
/*      */ 
/*      */   public String getBeanClassName()
/*      */   {
/*  666 */     return this.beanClassName;
/*      */   }
/*      */ 
/*      */   public Class<?> getBeanClass()
/*      */   {
/*  671 */     return this.clazz;
/*      */   }
/*      */ 
/*      */   public org.jboss.ejb3.pool.Pool getPool()
/*      */   {
/*  676 */     return this.pool;
/*      */   }
/*      */ 
/*      */   public String getPartitionName()
/*      */   {
/*  689 */     if (this.partitionName == null)
/*  690 */       findPartitionName();
/*  691 */     return this.partitionName;
/*      */   }
/*      */ 
/*      */   protected Object construct()
/*      */   {
/*  696 */     Interceptor[] cInterceptors = this.constructorInterceptors[this.defaultConstructorIndex];
/*  697 */     if (cInterceptors == null)
/*      */     {
/*      */       try
/*      */       {
/*  701 */         return this.constructors[this.defaultConstructorIndex].newInstance(new Object[0]);
/*      */       }
/*      */       catch (InstantiationException e)
/*      */       {
/*  705 */         throw new RuntimeException(e);
/*      */       }
/*      */       catch (IllegalAccessException e)
/*      */       {
/*  709 */         throw new RuntimeException(e);
/*      */       }
/*      */       catch (InvocationTargetException e)
/*      */       {
/*  713 */         throw new RuntimeException(e);
/*      */       }
/*      */     }
/*  716 */     ConstructorInvocation invocation = new ConstructorInvocation(cInterceptors);
/*      */ 
/*  719 */     invocation.setAdvisor(this);
/*  720 */     invocation.setConstructor(this.constructors[this.defaultConstructorIndex]);
/*      */     try
/*      */     {
/*  723 */       return invocation.invokeNext();
/*      */     }
/*      */     catch (Throwable throwable) {
/*      */     }
/*  727 */     throw new RuntimeException(throwable);
/*      */   }
/*      */ 
/*      */   public void create()
/*      */     throws Exception
/*      */   {
/*  734 */     initializeClassContainer();
/*  735 */     for (int i = 0; i < this.constructors.length; i++)
/*      */     {
/*  737 */       if (this.constructors[i].getParameterTypes().length != 0)
/*      */         continue;
/*  739 */       this.defaultConstructorIndex = i;
/*  740 */       break;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void start()
/*      */     throws Exception
/*      */   {
/*  748 */     initializePool();
/*      */ 
/*  750 */     for (EncInjector injector : this.encInjectors.values())
/*      */     {
/*  752 */       injector.inject(this);
/*      */     }
/*      */ 
/*  759 */     Injector[] injectors2 = (Injector[])this.injectors.toArray(new Injector[this.injectors.size()]);
/*  760 */     if (this.pool != null) this.pool.setInjectors(injectors2);
/*      */ 
/*  762 */     createCallbackHandler();
/*      */ 
/*  764 */     JaccHelper.configureContainer(this.jaccContextId, this);
/*      */ 
/*  767 */     findPartitionName();
/*      */ 
/*  769 */     log.info("STARTED EJB: " + this.clazz.getName() + " ejbName: " + this.ejbName);
/*      */   }
/*      */ 
/*      */   public void stop() throws Exception
/*      */   {
/*  774 */     this.encFactory.cleanupEnc(this);
/*      */ 
/*  776 */     if (this.pool != null)
/*      */     {
/*  778 */       this.pool.destroy();
/*  779 */       this.pool = null;
/*      */     }
/*      */ 
/*  782 */     log.info("STOPPED EJB: " + this.clazz.getName() + " ejbName: " + this.ejbName);
/*      */   }
/*      */ 
/*      */   public void destroy() throws Exception
/*      */   {
/*  787 */     super.cleanup();
/*      */   }
/*      */ 
/*      */   public <T> T getSecurityManager(Class<T> type)
/*      */   {
/*      */     try
/*      */     {
/*  795 */       InitialContext ctx = getInitialContext();
/*  796 */       SecurityDomain securityAnnotation = (SecurityDomain)resolveAnnotation(SecurityDomain.class);
/*  797 */       if ((securityAnnotation != null) && (securityAnnotation.value().length() > 0))
/*      */       {
/*  799 */         return SecurityDomainManager.getSecurityManager(securityAnnotation.value(), ctx);
/*      */       }
/*  801 */       return null;
/*      */     }
/*      */     catch (NamingException e) {
/*      */     }
/*  805 */     throw new RuntimeException(e);
/*      */   }
/*      */ 
/*      */   protected void initializePool()
/*      */     throws Exception
/*      */   {
/*  811 */     org.jboss.ejb3.annotation.Pool poolAnnotation = (org.jboss.ejb3.annotation.Pool)getAnnotation(org.jboss.ejb3.annotation.Pool.class);
/*  812 */     if (poolAnnotation == null)
/*  813 */       throw new IllegalStateException("No pool annotation");
/*  814 */     String registeredPoolName = poolAnnotation.value();
/*      */ 
/*  816 */     if ((registeredPoolName == null) || (registeredPoolName.trim().equals("")))
/*      */     {
/*  819 */       registeredPoolName = "ThreadlocalPool";
/*      */     }
/*  821 */     int maxSize = poolAnnotation.maxSize();
/*  822 */     long timeout = poolAnnotation.timeout();
/*  823 */     Ejb3Deployer deployer = this.deployment.getDeployer();
/*  824 */     PoolFactoryRegistry registry = deployer.getPoolFactoryRegistry();
/*  825 */     PoolFactory factory = registry.getPoolFactory(registeredPoolName);
/*  826 */     this.pool = factory.createPool();
/*  827 */     this.pool.initialize(this, maxSize, timeout);
/*      */ 
/*  829 */     resolveInjectors();
/*  830 */     this.pool.setInjectors((Injector[])this.injectors.toArray(new Injector[this.injectors.size()]));
/*      */   }
/*      */ 
/*      */   public void invokePostConstruct(BeanContext beanContext, Object[] params)
/*      */   {
/*  835 */     this.callbackHandler.postConstruct(beanContext, params);
/*      */   }
/*      */ 
/*      */   public void invokePreDestroy(BeanContext beanContext)
/*      */   {
/*  840 */     this.callbackHandler.preDestroy(beanContext);
/*      */   }
/*      */ 
/*      */   public void invokePostActivate(BeanContext beanContext)
/*      */   {
/*  845 */     throw new RuntimeException("PostActivate not implemented for container");
/*      */   }
/*      */ 
/*      */   public void invokePrePassivate(BeanContext beanContext)
/*      */   {
/*  850 */     throw new RuntimeException("PrePassivate not implemented for container");
/*      */   }
/*      */ 
/*      */   public void invokeInit(Object bean, Class[] initParameterTypes, Object[] initParameterValues)
/*      */   {
/*      */   }
/*      */ 
/*      */   protected void resolveInjectors()
/*      */     throws Exception
/*      */   {
/*  865 */     pushEnc();
/*      */     try
/*      */     {
/*  868 */       Thread.currentThread().setContextClassLoader(this.classloader);
/*      */       try
/*      */       {
/*  871 */         Util.rebind(getEnc(), "UserTransaction", new UserTransactionImpl());
/*      */       }
/*      */       catch (NamingException e)
/*      */       {
/*  875 */         NamingException namingException = new NamingException("Could not bind user transaction for ejb name " + this.ejbName + " into JNDI under jndiName: " + getEnc().getNameInNamespace() + "/" + "UserTransaction");
/*  876 */         namingException.setRootCause(e);
/*  877 */         throw namingException;
/*      */       }
/*      */       try
/*      */       {
/*  881 */         Util.rebind(getEnc(), "TransactionSynchronizationRegistry", new LinkRef("java:TransactionSynchronizationRegistry"));
/*  882 */         log.debug("Linked java:comp/TransactionSynchronizationRegistry to JNDI name: java:TransactionSynchronizationRegistry");
/*      */       }
/*      */       catch (NamingException e)
/*      */       {
/*  886 */         NamingException namingException = new NamingException("Could not bind TransactionSynchronizationRegistry for ejb name " + this.ejbName + " into JNDI under jndiName: " + getEnc().getNameInNamespace() + "/" + "TransactionSynchronizationRegistry");
/*  887 */         namingException.setRootCause(e);
/*  888 */         throw namingException;
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  893 */       popEnc();
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void createCallbackHandler()
/*      */   {
/*      */     try
/*      */     {
/*  901 */       this.callbackHandler = new LifecycleInterceptorHandler(this, getHandledCallbacks());
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  906 */       throw new RuntimeException("Error creating callback handler for bean " + this.beanClassName, e);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected Class[] getHandledCallbacks()
/*      */   {
/*  913 */     return new Class[] { PostConstruct.class, PreDestroy.class, Timeout.class };
/*      */   }
/*      */ 
/*      */   private void initialiseInterceptors()
/*      */   {
/*  919 */     if (this.applicableInterceptors == null)
/*      */     {
/*  921 */       log.debug("Initialising interceptors for " + getEjbName() + "...");
/*  922 */       HashSet defaultInterceptors = this.interceptorRepository.getDefaultInterceptors();
/*  923 */       log.debug("Default interceptors: " + defaultInterceptors);
/*      */ 
/*  925 */       this.classInterceptors = this.interceptorRepository.getClassInterceptors(this);
/*  926 */       log.debug("Class interceptors: " + this.classInterceptors);
/*      */ 
/*  928 */       this.applicableInterceptors = new LinkedHashSet();
/*  929 */       if (defaultInterceptors != null) this.applicableInterceptors.addAll(defaultInterceptors);
/*  930 */       if (this.classInterceptors != null) this.applicableInterceptors.addAll(this.classInterceptors);
/*      */ 
/*  932 */       Method[] methods = this.clazz.getMethods();
/*  933 */       for (int i = 0; i < methods.length; i++)
/*      */       {
/*  935 */         List methodIcptrs = this.interceptorRepository.getMethodInterceptors(this, methods[i]);
/*  936 */         if ((methodIcptrs == null) || (methodIcptrs.size() <= 0))
/*      */           continue;
/*  938 */         log.debug("Method interceptors for  " + methods[i] + ": " + methodIcptrs);
/*  939 */         this.applicableInterceptors.addAll(methodIcptrs);
/*      */       }
/*      */ 
/*  942 */       log.debug("All applicable interceptor classes: " + this.applicableInterceptors);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void findPartitionName()
/*      */   {
/*  948 */     Clustered clustered = (Clustered)resolveAnnotation(Clustered.class);
/*  949 */     if (clustered == null)
/*      */     {
/*  951 */       this.partitionName = null;
/*  952 */       return;
/*      */     }
/*      */ 
/*  955 */     String value = clustered.partition();
/*      */     try
/*      */     {
/*  958 */       String replacedValue = StringPropertyReplacer.replaceProperties(value);
/*  959 */       if (value != replacedValue)
/*      */       {
/*  961 */         log.debug("Replacing @Clustered partition attribute " + value + " with " + replacedValue);
/*  962 */         value = replacedValue;
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  967 */       log.warn("Unable to replace @Clustered partition attribute " + value + ". Caused by " + e.getClass() + " " + e.getMessage());
/*      */     }
/*      */ 
/*  971 */     this.partitionName = value;
/*      */   }
/*      */ 
/*      */   public <T> T getBusinessObject(BeanContext<?> beanContext, Class<T> businessInterface) throws IllegalStateException
/*      */   {
/*  976 */     throw new IllegalStateException("Not implemented");
/*      */   }
/*      */ 
/*      */   public Object getInvokedBusinessInterface(BeanContext beanContext) throws IllegalStateException
/*      */   {
/*  981 */     throw new IllegalStateException("Not implemented");
/*      */   }
/*      */ 
/*      */   protected Object getInvokedInterface(Method method)
/*      */   {
/*  986 */     Remote remoteAnnotation = (Remote)resolveAnnotation(Remote.class);
/*  987 */     if (remoteAnnotation != null)
/*      */     {
/*  989 */       Class[] remotes = remoteAnnotation.value();
/*  990 */       for (int i = 0; i < remotes.length; i++)
/*      */       {
/*      */         try
/*      */         {
/*  994 */           remotes[i].getMethod(method.getName(), method.getParameterTypes());
/*  995 */           return remotes[i];
/*      */         }
/*      */         catch (NoSuchMethodException e)
/*      */         {
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1003 */     Local localAnnotation = (Local)resolveAnnotation(Local.class);
/* 1004 */     if (localAnnotation != null)
/*      */     {
/* 1006 */       Class[] locals = localAnnotation.value();
/* 1007 */       for (int i = 0; i < locals.length; i++)
/*      */       {
/* 1009 */         Method[] interfaceMethods = locals[i].getMethods();
/* 1010 */         for (int j = 0; j < interfaceMethods.length; j++)
/*      */         {
/* 1012 */           if (interfaceMethods[j].equals(method)) {
/* 1013 */             return locals[i];
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 1018 */     return null;
/*      */   }
/*      */ 
/*      */   private Class loadPublicAnnotation(String annotation)
/*      */   {
/*      */     try
/*      */     {
/* 1026 */       Class ann = this.classloader.loadClass(annotation);
/* 1027 */       if (!ann.isAnnotation()) return null;
/* 1028 */       Retention retention = (Retention)ann.getAnnotation(Retention.class);
/* 1029 */       if ((retention != null) && (retention.value() == RetentionPolicy.RUNTIME)) return ann;
/*      */     }
/*      */     catch (ClassNotFoundException ignored)
/*      */     {
/*      */     }
/*      */ 
/* 1035 */     return null;
/*      */   }
/*      */ 
/*      */   public boolean hasAnnotation(Class tgt, String annotation)
/*      */   {
/* 1041 */     if (this.annotations.hasClassAnnotation(annotation)) return true;
/* 1042 */     if (tgt == null) return false;
/*      */     try
/*      */     {
/* 1045 */       Class ann = loadPublicAnnotation(annotation);
/*      */ 
/* 1047 */       if (ann == null) return AnnotationElement.isAnyAnnotationPresent(tgt, annotation);
/* 1048 */       return tgt.isAnnotationPresent(ann);
/*      */     }
/*      */     catch (Exception e) {
/*      */     }
/* 1052 */     throw new RuntimeException(e);
/*      */   }
/*      */ 
/*      */   public boolean hasAnnotation(Method m, String annotation)
/*      */   {
/* 1060 */     if (this.annotations.hasAnnotation(m, annotation)) return true;
/*      */     try
/*      */     {
/* 1063 */       Class ann = loadPublicAnnotation(annotation);
/*      */ 
/* 1065 */       if (ann == null) return AnnotationElement.isAnyAnnotationPresent(m, annotation);
/* 1066 */       return m.isAnnotationPresent(ann);
/*      */     }
/*      */     catch (Exception e) {
/*      */     }
/* 1070 */     throw new RuntimeException(e);
/*      */   }
/*      */ 
/*      */   public boolean hasAnnotation(Field m, String annotation)
/*      */   {
/* 1077 */     if (this.annotations.hasAnnotation(m, annotation)) return true;
/*      */     try
/*      */     {
/* 1080 */       Class ann = loadPublicAnnotation(annotation);
/*      */ 
/* 1082 */       if (ann == null) return AnnotationElement.isAnyAnnotationPresent(m, annotation);
/* 1083 */       return m.isAnnotationPresent(ann);
/*      */     }
/*      */     catch (Exception e) {
/*      */     }
/* 1087 */     throw new RuntimeException(e);
/*      */   }
/*      */ 
/*      */   public boolean hasAnnotation(Constructor m, String annotation)
/*      */   {
/* 1094 */     if (this.annotations.hasAnnotation(m, annotation)) return true;
/*      */     try
/*      */     {
/* 1097 */       Class ann = loadPublicAnnotation(annotation);
/*      */ 
/* 1099 */       if (ann == null) return AnnotationElement.isAnyAnnotationPresent(m, annotation);
/* 1100 */       return m.isAnnotationPresent(ann);
/*      */     }
/*      */     catch (Exception e) {
/*      */     }
/* 1104 */     throw new RuntimeException(e);
/*      */   }
/*      */ 
/*      */   public Container resolveEjbContainer(String link, Class businessIntf)
/*      */   {
/* 1110 */     return this.deployment.getEjbContainer(link, businessIntf);
/*      */   }
/*      */ 
/*      */   public Container resolveEjbContainer(Class businessIntf) throws NameNotFoundException
/*      */   {
/* 1115 */     return this.deployment.getEjbContainer(businessIntf);
/*      */   }
/*      */ 
/*      */   public String resolveMessageDestination(String link)
/*      */   {
/* 1120 */     return this.deployment.resolveMessageDestination(link);
/*      */   }
/*      */ 
/*      */   public <T extends Annotation> T getAnnotation(Class<T> annotationType)
/*      */   {
/* 1126 */     return (Annotation)resolveAnnotation(annotationType);
/*      */   }
/*      */ 
/*      */   public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz)
/*      */   {
/* 1131 */     if (clazz == getBeanClass())
/*      */     {
/* 1133 */       return (Annotation)resolveAnnotation(annotationType);
/*      */     }
/* 1135 */     return clazz.getAnnotation(annotationType);
/*      */   }
/*      */ 
/*      */   public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Method method)
/*      */   {
/* 1140 */     if (clazz == getBeanClass())
/*      */     {
/* 1142 */       return (Annotation)resolveAnnotation(method, annotationType);
/*      */     }
/* 1144 */     return method.getAnnotation(annotationType);
/*      */   }
/*      */ 
/*      */   public <T extends Annotation> T getAnnotation(Class<T> annotationType, Method method)
/*      */   {
/* 1149 */     return (Annotation)resolveAnnotation(method, annotationType);
/*      */   }
/*      */ 
/*      */   public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Field field)
/*      */   {
/* 1154 */     if (clazz == getBeanClass())
/*      */     {
/* 1156 */       return (Annotation)resolveAnnotation(field, annotationType);
/*      */     }
/* 1158 */     return field.getAnnotation(annotationType);
/*      */   }
/*      */ 
/*      */   public <T extends Annotation> T getAnnotation(Class<T> annotationType, Field field)
/*      */   {
/* 1163 */     return (Annotation)resolveAnnotation(field, annotationType);
/*      */   }
/*      */ 
/*      */   public Object resolveAnnotation(Method m, Class annotation)
/*      */   {
/* 1169 */     Object value = super.resolveAnnotation(m, annotation);
/* 1170 */     if ((value == null) && (m.isBridge())) value = getBridgedAnnotation(m, annotation);
/* 1171 */     return value;
/*      */   }
/*      */ 
/*      */   protected Object getBridgedAnnotation(Method bridgeMethod, Class annotation)
/*      */   {
/* 1176 */     Method[] methods = bridgeMethod.getDeclaringClass().getMethods();
/* 1177 */     int i = 0;
/* 1178 */     boolean found = false;
/* 1179 */     Class[] bridgeParams = bridgeMethod.getParameterTypes();
/* 1180 */     while ((i < methods.length) && (!found))
/*      */     {
/* 1182 */       if ((!methods[i].isBridge()) && (methods[i].getName().equals(bridgeMethod.getName())))
/*      */       {
/* 1184 */         Class[] params = methods[i].getParameterTypes();
/* 1185 */         if (params.length == bridgeParams.length)
/*      */         {
/* 1187 */           int j = 0;
/* 1188 */           boolean matches = true;
/* 1189 */           while ((j < params.length) && (matches))
/*      */           {
/* 1191 */             if (!bridgeParams[j].isAssignableFrom(params[j]))
/* 1192 */               matches = false;
/* 1193 */             j++;
/*      */           }
/*      */ 
/* 1196 */           if (matches)
/* 1197 */             return resolveAnnotation(methods[i], annotation);
/*      */         }
/*      */       }
/* 1200 */       i++;
/*      */     }
/*      */ 
/* 1203 */     return null;
/*      */   }
/*      */ 
/*      */   public Object resolveAnnotation(Method m, Class[] annotationChoices)
/*      */   {
/* 1208 */     Object value = null;
/* 1209 */     int i = 0;
/* 1210 */     while ((value == null) && (i < annotationChoices.length)) {
/* 1211 */       value = resolveAnnotation(m, annotationChoices[(i++)]);
/*      */     }
/*      */ 
/* 1214 */     return value;
/*      */   }
/*      */ 
/*      */   public String getIdentifier()
/*      */   {
/* 1219 */     return getEjbName();
/*      */   }
/*      */ 
/*      */   public String getDeploymentDescriptorType()
/*      */   {
/* 1224 */     return "ejb-jar.xml";
/*      */   }
/*      */ 
/*      */   public PersistenceUnitDeployment getPersistenceUnitDeployment(String unitName) throws NameNotFoundException
/*      */   {
/* 1229 */     return this.deployment.getPersistenceUnitDeployment(unitName);
/*      */   }
/*      */ 
/*      */   public String getEjbJndiName(Class businessInterface) throws NameNotFoundException
/*      */   {
/* 1234 */     return this.deployment.getEjbJndiName(businessInterface);
/*      */   }
/*      */ 
/*      */   public String getEjbJndiName(String link, Class businessInterface)
/*      */   {
/* 1239 */     return this.deployment.getEjbJndiName(link, businessInterface);
/*      */   }
/*      */ 
/*      */   public InvocationStatistics getInvokeStats()
/*      */   {
/* 1244 */     return this.invokeStats;
/*      */   }
/*      */ 
/*      */   public MethodInfo getMethodInfo(Method method)
/*      */   {
/* 1250 */     long hash = MethodHashing.calculateHash(method);
/* 1251 */     MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
/* 1252 */     if (info == null)
/*      */     {
/* 1254 */       throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
/*      */     }
/* 1256 */     return info;
/*      */   }
/*      */ 
/*      */   public boolean isClustered()
/*      */   {
/* 1261 */     return false;
/*      */   }
/*      */ 
/*      */   public JavaEEModule getModule()
/*      */   {
/* 1266 */     return this.deployment;
/*      */   }
/*      */ 
/*      */   public abstract boolean hasJNDIBinding(String paramString);
/*      */ 
/*      */   public void instantiated()
/*      */   {
/* 1277 */     this.businessInterfaces = resolveBusinessInterfaces();
/*      */ 
/* 1280 */     initializeClassContainer();
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/* 1285 */     return getObjectName().getCanonicalName();
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*  116 */     log = Logger.getLogger(EJBContainer.class);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.EJBContainer
 * JD-Core Version:    0.6.0
 */