/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Map;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class EJBContainerInvocationWrapper<A extends EJBContainer, T extends BeanContext> extends EJBContainerInvocation<A, T>
/*     */ {
/*     */   private static final long serialVersionUID = 5402917625526438235L;
/*  41 */   private static final Logger log = Logger.getLogger(EJBContainerInvocationWrapper.class);
/*     */   protected EJBContainerInvocation<A, T> wrapped;
/*     */ 
/*     */   public EJBContainerInvocationWrapper(EJBContainerInvocation<A, T> wrapped, Interceptor[] interceptors)
/*     */   {
/*  47 */     this.wrapped = wrapped;
/*  48 */     this.interceptors = interceptors;
/*     */   }
/*     */ 
/*     */   public Object invokeNext()
/*     */     throws Throwable
/*     */   {
/*     */     Object localObject1;
/*  53 */     if (this.currentInterceptor < this.interceptors.length)
/*     */     {
/*     */       try
/*     */       {
/*  57 */         localObject1 = this.interceptors[(this.currentInterceptor++)].invoke(this);
/*     */         return localObject1; } finally { this.currentInterceptor -= 1;
/*     */       }
/*     */     }
/*     */     try
/*     */     {
/*  67 */       localObject1 = this.wrapped.invokeNext();
/*     */       return localObject1; } finally { this.responseContextInfo = this.wrapped.getResponseContextInfo(); } throw localObject3;
/*     */   }
/*     */ 
/*     */   public Method getMethod()
/*     */   {
/*  77 */     return this.wrapped.getMethod();
/*     */   }
/*     */ 
/*     */   public long getMethodHash()
/*     */   {
/*  82 */     return this.wrapped.getMethodHash();
/*     */   }
/*     */ 
/*     */   public Object getTargetObject()
/*     */   {
/*  87 */     return this.wrapped.getTargetObject();
/*     */   }
/*     */ 
/*     */   public void setTargetObject(Object targetObject)
/*     */   {
/*  92 */     this.wrapped.setTargetObject(targetObject);
/*     */   }
/*     */ 
/*     */   public Object[] getArguments()
/*     */   {
/*  97 */     return this.wrapped.getArguments();
/*     */   }
/*     */ 
/*     */   public void setArguments(Object[] args)
/*     */   {
/* 102 */     this.wrapped.setArguments(args);
/*     */   }
/*     */ 
/*     */   public Object resolveClassAnnotation(Class annotation)
/*     */   {
/* 107 */     return this.wrapped.resolveClassAnnotation(annotation);
/*     */   }
/*     */ 
/*     */   public Object resolveAnnotation(Class annotation)
/*     */   {
/* 112 */     return this.wrapped.resolveAnnotation(annotation);
/*     */   }
/*     */ 
/*     */   public Object getMetaData(Object key, Object attr)
/*     */   {
/* 117 */     return this.wrapped.getMetaData(key, attr);
/*     */   }
/*     */ 
/*     */   public Invocation getWrapper(Interceptor[] newchain)
/*     */   {
/* 122 */     return this.wrapped.getWrapper(newchain);
/*     */   }
/*     */ 
/*     */   public Invocation copy()
/*     */   {
/* 127 */     return this.wrapped.copy();
/*     */   }
/*     */ 
/*     */   public Map getResponseContextInfo()
/*     */   {
/* 132 */     return this.wrapped.getResponseContextInfo();
/*     */   }
/*     */ 
/*     */   public void setResponseContextInfo(Map responseContextInfo)
/*     */   {
/* 137 */     this.wrapped.setResponseContextInfo(responseContextInfo);
/*     */   }
/*     */ 
/*     */   public void addResponseAttachment(Object key, Object val)
/*     */   {
/* 142 */     this.wrapped.addResponseAttachment(key, val);
/*     */   }
/*     */ 
/*     */   public Object getResponseAttachment(Object key)
/*     */   {
/* 147 */     return this.wrapped.getResponseAttachment(key);
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getMetaData()
/*     */   {
/* 152 */     return this.wrapped.getMetaData();
/*     */   }
/*     */ 
/*     */   public void setMetaData(SimpleMetaData data)
/*     */   {
/* 157 */     this.wrapped.setMetaData(data);
/*     */   }
/*     */ 
/*     */   public Object resolveClassMetaData(Object key, Object attr)
/*     */   {
/* 162 */     return this.wrapped.resolveClassMetaData(key, attr);
/*     */   }
/*     */ 
/*     */   public Object invokeNext(Interceptor[] newInterceptors) throws Throwable
/*     */   {
/* 167 */     return this.wrapped.invokeNext(newInterceptors);
/*     */   }
/*     */ 
/*     */   public A getAdvisor()
/*     */   {
/* 172 */     return this.wrapped.getAdvisor();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.EJBContainerInvocationWrapper
 * JD-Core Version:    0.6.0
 */