/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.io.BufferedInputStream;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.InputStream;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import javassist.bytecode.ClassFile;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import javax.naming.NamingException;
/*     */ import javax.persistence.Entity;
/*     */ import javax.security.jacc.PolicyConfiguration;
/*     */ import javax.security.jacc.PolicyConfigurationFactory;
/*     */ import org.hibernate.ejb.packaging.PersistenceMetadata;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.ejb3.cache.CacheFactoryRegistry;
/*     */ import org.jboss.ejb3.cache.persistence.PersistenceManagerFactoryRegistry;
/*     */ import org.jboss.ejb3.deployers.Ejb3Deployer;
/*     */ import org.jboss.ejb3.enc.EjbModuleEjbResolver;
/*     */ import org.jboss.ejb3.enc.EjbModulePersistenceUnitResolver;
/*     */ import org.jboss.ejb3.enc.MessageDestinationResolver;
/*     */ import org.jboss.ejb3.entity.PersistenceUnitDeployment;
/*     */ import org.jboss.ejb3.entity.SecondLevelCacheUtil;
/*     */ import org.jboss.ejb3.javaee.JavaEEApplication;
/*     */ import org.jboss.ejb3.javaee.JavaEEComponent;
/*     */ import org.jboss.ejb3.javaee.JavaEEModule;
/*     */ import org.jboss.ejb3.metadata.jpa.spec.PersistenceUnitMetaData;
/*     */ import org.jboss.ejb3.metadata.jpa.spec.PersistenceUnitsMetaData;
/*     */ import org.jboss.ejb3.remoting.RemoteProxyFactoryRegistry;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
/*     */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public abstract class Ejb3Deployment
/*     */   implements JavaEEModule
/*     */ {
/*     */   private static final Logger log;
/*     */   public static final String ACTUAL_ENTITY_MANAGER_FACTORY_CONTEXT = "java:/ActualEntityManagerFactories";
/*     */   public static final String MANAGED_ENTITY_FACTORY_CONTEXT = "java:/managedEntityFactories";
/*     */   private JBossMetaData metaData;
/*     */   private PersistenceUnitsMetaData persistenceUnitsMetaData;
/*     */   protected DeploymentUnit unit;
/*     */   protected Ejb3Deployer deployer;
/*  89 */   protected LinkedHashMap<ObjectName, Container> ejbContainers = new LinkedHashMap();
/*     */   protected boolean hasEntities;
/*  93 */   protected List<String> explicitEntityClasses = new ArrayList();
/*     */ 
/*  95 */   protected List<PersistenceUnitDeployment> persistenceUnitDeployments = new ArrayList();
/*     */ 
/*  97 */   protected String defaultSLSBDomain = "Stateless Bean";
/*     */ 
/*  99 */   protected String defaultSFSBDomain = "Stateful Bean";
/*     */ 
/* 101 */   protected String defaultMDBDomain = "Message Driven Bean";
/*     */ 
/* 103 */   protected String defaultConsumerDomain = "Consumer Bean";
/*     */ 
/* 105 */   protected String defaultServiceDomain = "Service Bean";
/*     */   protected InitialContext initialContext;
/*     */   protected KernelAbstraction kernelAbstraction;
/*     */   protected MBeanServer mbeanServer;
/*     */   protected DeploymentScope deploymentScope;
/*     */   protected EjbModuleEjbResolver ejbRefResolver;
/*     */   protected EjbModulePersistenceUnitResolver persistenceUnitResolver;
/*     */   protected MessageDestinationResolver messageDestinationResolver;
/*     */   PolicyConfiguration pc;
/*     */ 
/*     */   public Ejb3Deployment(DeploymentUnit unit, DeploymentScope deploymentScope, JBossMetaData metaData, PersistenceUnitsMetaData persistenceUnitsMetaData, Ejb3Deployer deployer)
/*     */   {
/* 128 */     assert (unit != null) : "unit is null";
/* 129 */     assert (deployer != null) : "deployer is null";
/*     */ 
/* 131 */     this.unit = unit;
/* 132 */     this.deployer = deployer;
/* 133 */     this.deploymentScope = deploymentScope;
/* 134 */     this.metaData = metaData;
/* 135 */     this.persistenceUnitsMetaData = persistenceUnitsMetaData;
/*     */     try
/*     */     {
/* 138 */       this.initialContext = InitialContextFactory.getInitialContext(unit.getJndiProperties());
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 142 */       throw new RuntimeException(e);
/*     */     }
/* 144 */     this.ejbRefResolver = new EjbModuleEjbResolver(deploymentScope, unit.getShortName(), this.ejbContainers, this);
/* 145 */     this.persistenceUnitResolver = new EjbModulePersistenceUnitResolver(this.persistenceUnitDeployments, deploymentScope, this.ejbContainers);
/*     */ 
/* 147 */     MessageDestinationsMetaData destinations = null;
/* 148 */     if ((metaData != null) && (metaData.getAssemblyDescriptor() != null))
/* 149 */       destinations = metaData.getAssemblyDescriptor().getMessageDestinations();
/* 150 */     this.messageDestinationResolver = new MessageDestinationResolver(deploymentScope, destinations);
/*     */   }
/*     */ 
/*     */   public JavaEEApplication getApplication()
/*     */   {
/* 155 */     return this.deploymentScope;
/*     */   }
/*     */ 
/*     */   public DeploymentScope getEar()
/*     */   {
/* 160 */     return this.deploymentScope;
/*     */   }
/*     */ 
/*     */   public KernelAbstraction getKernelAbstraction()
/*     */   {
/* 165 */     return this.kernelAbstraction;
/*     */   }
/*     */ 
/*     */   public MBeanServer getMbeanServer()
/*     */   {
/* 170 */     return this.mbeanServer;
/*     */   }
/*     */ 
/*     */   public void setMbeanServer(MBeanServer mbeanServer)
/*     */   {
/* 175 */     this.mbeanServer = mbeanServer;
/*     */   }
/*     */ 
/*     */   public DeploymentUnit getDeploymentUnit()
/*     */   {
/* 180 */     return this.unit;
/*     */   }
/*     */ 
/*     */   public String getDefaultSLSBDomain()
/*     */   {
/* 185 */     return this.defaultSLSBDomain;
/*     */   }
/*     */ 
/*     */   public Ejb3Deployer getDeployer()
/*     */   {
/* 190 */     return this.deployer;
/*     */   }
/*     */ 
/*     */   public CacheFactoryRegistry getCacheFactoryRegistry()
/*     */   {
/* 195 */     return getDeployer().getCacheFactoryRegistry();
/*     */   }
/*     */ 
/*     */   public RemoteProxyFactoryRegistry getRemoteProxyFactoryRegistry()
/*     */   {
/* 200 */     return getDeployer().getRemoteProxyFactoryRegistry();
/*     */   }
/*     */ 
/*     */   public PersistenceManagerFactoryRegistry getPersistenceManagerFactoryRegistry()
/*     */   {
/* 205 */     return getDeployer().getPersistenceManagerFactoryRegistry();
/*     */   }
/*     */ 
/*     */   public String getScopeKernelName()
/*     */   {
/* 216 */     String scopedKernelName = "";
/* 217 */     if (this.deploymentScope != null)
/* 218 */       scopedKernelName = scopedKernelName + ",ear=" + this.deploymentScope.getShortName();
/* 219 */     scopedKernelName = scopedKernelName + ",jar=" + this.unit.getShortName();
/* 220 */     return scopedKernelName;
/*     */   }
/*     */ 
/*     */   public void setDefaultSLSBDomain(String defaultSLSBDomain)
/*     */   {
/* 230 */     this.defaultSLSBDomain = defaultSLSBDomain;
/*     */   }
/*     */ 
/*     */   public String getDefaultSFSBDomain()
/*     */   {
/* 235 */     return this.defaultSFSBDomain;
/*     */   }
/*     */ 
/*     */   public String getDefaultConsumerDomain()
/*     */   {
/* 240 */     return this.defaultConsumerDomain;
/*     */   }
/*     */ 
/*     */   public void setDefaultSFSBDomain(String defaultSFSBDomain)
/*     */   {
/* 250 */     this.defaultSFSBDomain = defaultSFSBDomain;
/*     */   }
/*     */ 
/*     */   public String getDefaultMDBDomain()
/*     */   {
/* 255 */     return this.defaultMDBDomain;
/*     */   }
/*     */ 
/*     */   public void setDefaultMDBDomain(String defaultMDBDomain)
/*     */   {
/* 265 */     this.defaultMDBDomain = defaultMDBDomain;
/*     */   }
/*     */ 
/*     */   public String getDefaultServiceDomain()
/*     */   {
/* 270 */     return this.defaultServiceDomain;
/*     */   }
/*     */ 
/*     */   public void setDefaultServiceDomain(String defaultServiceDomain)
/*     */   {
/* 280 */     this.defaultServiceDomain = defaultServiceDomain;
/*     */   }
/*     */ 
/*     */   protected String getJaccContextId()
/*     */   {
/* 285 */     return this.unit.getShortName();
/*     */   }
/*     */ 
/*     */   public Container getContainer(ObjectName name)
/*     */   {
/* 290 */     return (Container)this.ejbContainers.get(name);
/*     */   }
/*     */ 
/*     */   public Map getEjbContainers()
/*     */   {
/* 295 */     return this.ejbContainers;
/*     */   }
/*     */ 
/*     */   public PersistenceUnitDeployment getPersistenceUnitDeployment(String unitName) throws NameNotFoundException
/*     */   {
/* 300 */     return this.persistenceUnitResolver.getPersistenceUnitDeployment(unitName);
/*     */   }
/*     */ 
/*     */   public PersistenceUnitDeployment getPersistenceUnitDeploymentInternal(String unitName)
/*     */   {
/* 305 */     return this.persistenceUnitResolver.getPersistenceUnitDeploymentInternal(unitName);
/*     */   }
/*     */ 
/*     */   public List<PersistenceUnitDeployment> getPersistenceUnitDeployments()
/*     */   {
/* 310 */     return this.persistenceUnitDeployments;
/*     */   }
/*     */ 
/*     */   public EJBContainer getEjbContainer(String ejbLink, Class businessIntf)
/*     */   {
/* 315 */     return this.ejbRefResolver.getEjbContainer(ejbLink, businessIntf);
/*     */   }
/*     */ 
/*     */   public String getEjbJndiName(String ejbLink, Class businessIntf)
/*     */   {
/* 320 */     return this.ejbRefResolver.getEjbJndiName(ejbLink, businessIntf);
/*     */   }
/*     */ 
/*     */   public EJBContainer getEjbContainer(Ejb3Deployment deployment, Class businessIntf) throws NameNotFoundException
/*     */   {
/* 325 */     return this.ejbRefResolver.getEjbContainer(deployment, businessIntf);
/*     */   }
/*     */ 
/*     */   public EJBContainer getEjbContainer(Class businessIntf) throws NameNotFoundException
/*     */   {
/* 330 */     return this.ejbRefResolver.getEjbContainer(businessIntf);
/*     */   }
/*     */ 
/*     */   public String getEjbJndiName(Class businessIntf) throws NameNotFoundException
/*     */   {
/* 335 */     return this.ejbRefResolver.getEjbJndiName(businessIntf);
/*     */   }
/*     */ 
/*     */   protected void processEJBContainerMetadata(Container container) throws Exception
/*     */   {
/* 340 */     log.trace("Process EJB container metadata " + container);
/* 341 */     ObjectName on = container.getObjectName();
/* 342 */     this.ejbContainers.put(on, container);
/* 343 */     container.processMetadata();
/*     */   }
/*     */ 
/*     */   protected void registerEJBContainer(Container container) throws Exception
/*     */   {
/* 348 */     ObjectName on = container.getObjectName();
/* 349 */     String name = on.getCanonicalName();
/* 350 */     this.kernelAbstraction.install(name, container.getDependencyPolicy(), container);
/* 351 */     this.mbeanServer.registerMBean(container.getMBean(), on);
/* 352 */     log.debug("Bound ejb3 container " + name);
/*     */   }
/*     */ 
/*     */   protected abstract PolicyConfiguration createPolicyConfiguration()
/*     */     throws Exception;
/*     */ 
/*     */   protected abstract void putJaccInService(PolicyConfiguration paramPolicyConfiguration, DeploymentUnit paramDeploymentUnit);
/*     */ 
/*     */   public void create()
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 372 */       long start = System.currentTimeMillis();
/*     */ 
/* 374 */       this.pc = createPolicyConfiguration();
/*     */ 
/* 376 */       deploy();
/*     */ 
/* 378 */       initializePersistenceUnits();
/*     */ 
/* 380 */       log.debug("EJB3 deployment time took: " + (System.currentTimeMillis() - start));
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       try
/*     */       {
/* 386 */         destroy();
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/*     */       }
/*     */ 
/* 392 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 400 */       startPersistenceUnits();
/*     */ 
/* 402 */       for (Object o : this.ejbContainers.values())
/*     */       {
/* 404 */         Container con = (Container)o;
/* 405 */         processEJBContainerMetadata(con);
/*     */       }
/*     */ 
/* 408 */       for (Object o : this.ejbContainers.values())
/*     */       {
/* 410 */         Container con = (Container)o;
/* 411 */         registerEJBContainer(con);
/*     */       }
/*     */ 
/* 414 */       putJaccInService(this.pc, this.unit);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*     */       try
/*     */       {
/* 420 */         stop();
/* 421 */         destroy();
/*     */       }
/*     */       catch (Exception ignored)
/*     */       {
/*     */       }
/* 426 */       throw ex;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void deploy() throws Exception
/*     */   {
/* 432 */     Ejb3HandlerFactory factory = Ejb3HandlerFactory.getInstance(this);
/* 433 */     if (this.unit.getUrl() != null) {
/* 434 */       deployUrl(factory);
/*     */     }
/* 436 */     if (this.unit.getClasses() != null)
/*     */     {
/* 438 */       for (Class explicit : this.unit.getClasses())
/*     */       {
/* 440 */         if (explicit.isAnnotationPresent(Entity.class))
/*     */         {
/*     */           continue;
/*     */         }
/* 444 */         String name = explicit.getName().replace('.', '/') + ".class";
/* 445 */         InputStream stream = explicit.getClassLoader().getResourceAsStream(name);
/* 446 */         deployElement(stream, factory, this.initialContext);
/*     */       }
/*     */     }
/*     */ 
/* 450 */     deployBeansFromLib(this.initialContext);
/*     */   }
/*     */ 
/*     */   protected void deployUrl(Ejb3HandlerFactory factory)
/*     */     throws Exception
/*     */   {
/* 456 */     List clientDescriptors = this.unit.getResources(new ClientDescriptorFileFilter());
/*     */ 
/* 458 */     if (clientDescriptors.size() > 0) {
/* 459 */       return;
/*     */     }
/* 461 */     InitialContext ctx = this.initialContext;
/*     */ 
/* 464 */     List classes = this.unit.getResources(new ClassFileFilter());
/* 465 */     for (VirtualFile classFile : classes)
/*     */     {
/* 467 */       InputStream stream = classFile.openStream();
/* 468 */       deployElement(stream, factory, ctx);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void deployElement(InputStream stream, Ejb3HandlerFactory factory, InitialContext ctx) throws Exception
/*     */   {
/* 474 */     DataInputStream dstream = new DataInputStream(new BufferedInputStream(stream));
/* 475 */     ClassFile cf = null;
/*     */     try
/*     */     {
/* 478 */       cf = new ClassFile(dstream);
/*     */     }
/*     */     finally
/*     */     {
/* 482 */       dstream.close();
/* 483 */       stream.close();
/*     */     }
/*     */ 
/* 486 */     deployElement(factory, cf, ctx);
/*     */   }
/*     */ 
/*     */   protected void deployBeansFromLib(InitialContext ctx)
/*     */     throws Exception
/*     */   {
/* 492 */     JBossMetaData dd = getMetaData();
/* 493 */     if (dd != null)
/*     */     {
/* 495 */       Ejb3DescriptorHandler handler = new Ejb3DescriptorHandler(this, dd);
/* 496 */       handler.setCtxProperties(this.unit.getJndiProperties());
/*     */ 
/* 498 */       Map localContainers = new HashMap();
/* 499 */       Iterator containerIterator = this.ejbContainers.values().iterator();
/* 500 */       while (containerIterator.hasNext())
/*     */       {
/* 502 */         Container container = (Container)containerIterator.next();
/* 503 */         localContainers.put(container.getEjbName(), container);
/*     */       }
/*     */ 
/* 506 */       List containers = handler.getContainers(this, localContainers);
/* 507 */       for (Container con : containers)
/*     */       {
/* 512 */         ((EJBContainer)con).instantiated();
/* 513 */         this.ejbContainers.put(con.getObjectName(), con);
/* 514 */         Ejb3Registry.register(con);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void deployElement(Ejb3HandlerFactory factory, ClassFile cf, InitialContext ctx) throws Exception
/*     */   {
/* 521 */     Ejb3Handler handler = factory.createHandler(cf);
/* 522 */     handler.setCtxProperties(this.unit.getJndiProperties());
/*     */ 
/* 524 */     if ((handler.isEjb()) || (handler.isJBossBeanType()))
/*     */     {
/* 526 */       List containers = handler.getContainers(cf, this);
/* 527 */       for (Container con : containers)
/*     */       {
/*     */         try
/*     */         {
/* 534 */           ((EJBContainer)con).instantiated();
/* 535 */           this.ejbContainers.put(con.getObjectName(), con);
/* 536 */           Ejb3Registry.register(con);
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 540 */           throw new DeploymentException("Error creating ejb container " + con.getEjbName() + ": " + t.getMessage(), t);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initializePersistenceUnits()
/*     */     throws Exception
/*     */   {
/* 549 */     this.hasEntities = (this.persistenceUnitsMetaData != null);
/*     */ 
/* 551 */     if (!this.hasEntities) {
/* 552 */       return;
/*     */     }
/* 554 */     if (this.unit.getClasses() != null)
/*     */     {
/* 556 */       for (Class explicit : this.unit.getClasses())
/*     */       {
/* 558 */         if (explicit.isAnnotationPresent(Entity.class))
/*     */         {
/* 560 */           this.explicitEntityClasses.add(explicit.getName());
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 567 */     for (PersistenceUnitMetaData persistenceUnitMetaData : this.persistenceUnitsMetaData)
/*     */     {
/* 569 */       PersistenceMetadata metadata = persistenceUnitMetaData.getLegacyMetadata();
/*     */ 
/* 571 */       String earShortName = this.deploymentScope == null ? null : this.deploymentScope.getShortName();
/* 572 */       boolean isScoped = this.ejbContainers.size() > 0;
/*     */ 
/* 575 */       String cache_prefix = metadata.getProps().getProperty("hibernate.cache.region_prefix");
/* 576 */       if (cache_prefix == null)
/*     */       {
/* 580 */         String jarName = isScoped ? this.unit.getShortName() : null;
/* 581 */         cache_prefix = SecondLevelCacheUtil.createCacheRegionPrefix(earShortName, jarName, metadata.getName());
/* 582 */         metadata.getProps().setProperty("hibernate.cache.region_prefix", cache_prefix);
/*     */       }
/* 584 */       PersistenceUnitDeployment deployment = new PersistenceUnitDeployment(this.initialContext, this, this.explicitEntityClasses, persistenceUnitMetaData, earShortName, this.unit.getShortName(), isScoped);
/*     */ 
/* 586 */       PersistenceUnitRegistry.register(deployment);
/* 587 */       this.persistenceUnitDeployments.add(deployment);
/*     */     }
/*     */   }
/*     */ 
/*     */   public abstract DependencyPolicy createDependencyPolicy(JavaEEComponent paramJavaEEComponent);
/*     */ 
/*     */   protected void startPersistenceUnits() {
/* 595 */     if (this.persistenceUnitDeployments == null) {
/* 596 */       return;
/*     */     }
/* 598 */     for (PersistenceUnitDeployment entityDeployment : this.persistenceUnitDeployments)
/*     */     {
/* 600 */       if (entityDeployment != null)
/*     */       {
/* 602 */         DependencyPolicy policy = createDependencyPolicy(entityDeployment);
/* 603 */         entityDeployment.addDependencies(policy);
/* 604 */         this.kernelAbstraction.install(entityDeployment.getKernelName(), policy, entityDeployment);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopPersistenceUnits()
/*     */   {
/* 611 */     if (this.persistenceUnitDeployments == null) {
/* 612 */       return;
/*     */     }
/* 614 */     for (PersistenceUnitDeployment entityDeployment : this.persistenceUnitDeployments)
/*     */     {
/*     */       try
/*     */       {
/* 618 */         PersistenceUnitRegistry.unregister(entityDeployment);
/* 619 */         if (entityDeployment != null)
/*     */         {
/* 621 */           this.kernelAbstraction.uninstall(entityDeployment.getKernelName());
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 626 */         log.debug("error trying to shut down persistence unit", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/* 634 */     for (ObjectName on : this.ejbContainers.keySet())
/*     */     {
/*     */       try
/*     */       {
/* 638 */         this.mbeanServer.unregisterMBean(on);
/* 639 */         this.kernelAbstraction.uninstall(on.getCanonicalName());
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 643 */         log.debug("error trying to shut down ejb container", e);
/*     */       }
/*     */     }
/* 646 */     stopPersistenceUnits();
/*     */   }
/*     */ 
/*     */   public void destroy() throws Exception
/*     */   {
/* 651 */     undeploy();
/*     */ 
/* 653 */     PolicyConfigurationFactory pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
/* 654 */     PolicyConfiguration pc = pcFactory.getPolicyConfiguration(getJaccContextId(), true);
/* 655 */     pc.delete();
/*     */   }
/*     */ 
/*     */   private void undeploy()
/*     */   {
/* 660 */     for (Container container : this.ejbContainers.values())
/*     */     {
/* 662 */       Ejb3Registry.unregister(container);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String resolveMessageDestination(String link)
/*     */   {
/* 724 */     return this.messageDestinationResolver.resolveMessageDestination(link);
/*     */   }
/*     */ 
/*     */   public MessageDestinationResolver getMessageDestinationResolver()
/*     */   {
/* 729 */     return this.messageDestinationResolver;
/*     */   }
/*     */ 
/*     */   public JBossMetaData getMetaData()
/*     */   {
/* 739 */     return this.metaData;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 744 */     return this.unit.getShortName();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  75 */     log = Logger.getLogger(Ejb3Deployment.class);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.Ejb3Deployment
 * JD-Core Version:    0.6.0
 */