/*      */ package org.jboss.ejb3;
/*      */ 
/*      */ import java.lang.annotation.Annotation;
/*      */ import java.lang.reflect.Field;
/*      */ import java.lang.reflect.Member;
/*      */ import java.lang.reflect.Method;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Arrays;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import java.util.StringTokenizer;
/*      */ import javassist.bytecode.ClassFile;
/*      */ import javax.annotation.PostConstruct;
/*      */ import javax.annotation.PreDestroy;
/*      */ import javax.annotation.Resource;
/*      */ import javax.annotation.security.DeclareRoles;
/*      */ import javax.annotation.security.DenyAll;
/*      */ import javax.annotation.security.PermitAll;
/*      */ import javax.annotation.security.RolesAllowed;
/*      */ import javax.ejb.Init;
/*      */ import javax.ejb.Local;
/*      */ import javax.ejb.MessageDriven;
/*      */ import javax.ejb.PostActivate;
/*      */ import javax.ejb.PrePassivate;
/*      */ import javax.ejb.Remote;
/*      */ import javax.ejb.Remove;
/*      */ import javax.ejb.SessionBean;
/*      */ import javax.ejb.Stateless;
/*      */ import javax.ejb.TransactionAttribute;
/*      */ import javax.ejb.TransactionManagement;
/*      */ import javax.ejb.TransactionManagementType;
/*      */ import javax.interceptor.AroundInvoke;
/*      */ import javax.interceptor.ExcludeClassInterceptors;
/*      */ import javax.interceptor.ExcludeDefaultInterceptors;
/*      */ import javax.interceptor.Interceptors;
/*      */ import org.jboss.aop.annotation.AnnotationRepository;
/*      */ import org.jboss.ejb.ActivationConfigPropertyImpl;
/*      */ import org.jboss.ejb.AroundInvokeImpl;
/*      */ import org.jboss.ejb.DeclareRolesImpl;
/*      */ import org.jboss.ejb.DenyAllImpl;
/*      */ import org.jboss.ejb.InitImpl;
/*      */ import org.jboss.ejb.InterceptorsImpl;
/*      */ import org.jboss.ejb.LocalImpl;
/*      */ import org.jboss.ejb.MessageDrivenImpl;
/*      */ import org.jboss.ejb.PermitAllImpl;
/*      */ import org.jboss.ejb.PostActivateImpl;
/*      */ import org.jboss.ejb.PostConstructImpl;
/*      */ import org.jboss.ejb.PreDestroyImpl;
/*      */ import org.jboss.ejb.PrePassivateImpl;
/*      */ import org.jboss.ejb.RemoteImpl;
/*      */ import org.jboss.ejb.RemoveImpl;
/*      */ import org.jboss.ejb.ResourceImpl;
/*      */ import org.jboss.ejb.RolesAllowedImpl;
/*      */ import org.jboss.ejb.RunAsImpl;
/*      */ import org.jboss.ejb.StatelessImpl;
/*      */ import org.jboss.ejb.TransactionAttributeImpl;
/*      */ import org.jboss.ejb.TransactionManagementImpl;
/*      */ import org.jboss.ejb3.annotation.Cache;
/*      */ import org.jboss.ejb3.annotation.CacheConfig;
/*      */ import org.jboss.ejb3.annotation.Clustered;
/*      */ import org.jboss.ejb3.annotation.Consumer;
/*      */ import org.jboss.ejb3.annotation.CurrentMessage;
/*      */ import org.jboss.ejb3.annotation.DefaultActivationSpecs;
/*      */ import org.jboss.ejb3.annotation.DefaultInterceptorMarker;
/*      */ import org.jboss.ejb3.annotation.DeliveryMode;
/*      */ import org.jboss.ejb3.annotation.Depends;
/*      */ import org.jboss.ejb3.annotation.IgnoreDependency;
/*      */ import org.jboss.ejb3.annotation.LocalBinding;
/*      */ import org.jboss.ejb3.annotation.LocalHomeBinding;
/*      */ import org.jboss.ejb3.annotation.Management;
/*      */ import org.jboss.ejb3.annotation.MessageProperties;
/*      */ import org.jboss.ejb3.annotation.PersistenceManager;
/*      */ import org.jboss.ejb3.annotation.Pool;
/*      */ import org.jboss.ejb3.annotation.Producers;
/*      */ import org.jboss.ejb3.annotation.RemoteBinding;
/*      */ import org.jboss.ejb3.annotation.RemoteBindings;
/*      */ import org.jboss.ejb3.annotation.RemoteHomeBinding;
/*      */ import org.jboss.ejb3.annotation.ResourceAdapter;
/*      */ import org.jboss.ejb3.annotation.SecurityDomain;
/*      */ import org.jboss.ejb3.annotation.SerializedConcurrentAccess;
/*      */ import org.jboss.ejb3.annotation.Service;
/*      */ import org.jboss.ejb3.annotation.TransactionTimeout;
/*      */ import org.jboss.ejb3.annotation.impl.CacheConfigImpl;
/*      */ import org.jboss.ejb3.annotation.impl.CacheImpl;
/*      */ import org.jboss.ejb3.annotation.impl.ClusteredImpl;
/*      */ import org.jboss.ejb3.annotation.impl.ConsumerImpl;
/*      */ import org.jboss.ejb3.annotation.impl.CurrentMessageImpl;
/*      */ import org.jboss.ejb3.annotation.impl.DefaultActivationSpecsImpl;
/*      */ import org.jboss.ejb3.annotation.impl.DefaultInterceptorMarkerImpl;
/*      */ import org.jboss.ejb3.annotation.impl.DependsImpl;
/*      */ import org.jboss.ejb3.annotation.impl.ExcludeClassInterceptorsImpl;
/*      */ import org.jboss.ejb3.annotation.impl.ExcludeDefaultInterceptorsImpl;
/*      */ import org.jboss.ejb3.annotation.impl.IgnoreDependencyImpl;
/*      */ import org.jboss.ejb3.annotation.impl.LocalBindingImpl;
/*      */ import org.jboss.ejb3.annotation.impl.LocalHomeBindingImpl;
/*      */ import org.jboss.ejb3.annotation.impl.LocalHomeImpl;
/*      */ import org.jboss.ejb3.annotation.impl.ManagementImpl;
/*      */ import org.jboss.ejb3.annotation.impl.MessagePropertiesImpl;
/*      */ import org.jboss.ejb3.annotation.impl.PersistenceManagerImpl;
/*      */ import org.jboss.ejb3.annotation.impl.PoolImpl;
/*      */ import org.jboss.ejb3.annotation.impl.ProducerImpl;
/*      */ import org.jboss.ejb3.annotation.impl.ProducersImpl;
/*      */ import org.jboss.ejb3.annotation.impl.RemoteBindingImpl;
/*      */ import org.jboss.ejb3.annotation.impl.RemoteBindingsImpl;
/*      */ import org.jboss.ejb3.annotation.impl.RemoteHomeBindingImpl;
/*      */ import org.jboss.ejb3.annotation.impl.RemoteHomeImpl;
/*      */ import org.jboss.ejb3.annotation.impl.ResourceAdapterImpl;
/*      */ import org.jboss.ejb3.annotation.impl.RunAsPrincipalImpl;
/*      */ import org.jboss.ejb3.annotation.impl.SecurityDomainImpl;
/*      */ import org.jboss.ejb3.annotation.impl.SerializedConcurrentAccessImpl;
/*      */ import org.jboss.ejb3.annotation.impl.ServiceImpl;
/*      */ import org.jboss.ejb3.annotation.impl.TransactionTimeoutImpl;
/*      */ import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
/*      */ import org.jboss.ejb3.lang.ClassHelper;
/*      */ import org.jboss.ejb3.mdb.ConsumerContainer;
/*      */ import org.jboss.ejb3.mdb.MDB;
/*      */ import org.jboss.ejb3.service.ServiceContainer;
/*      */ import org.jboss.ejb3.stateful.StatefulContainer;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.jboss.metadata.ejb.jboss.CacheConfigMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.ClusterConfigMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.JBossConsumerBeanMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.JBossGenericBeanMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.JBossMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.JBossServiceBeanMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.MessagePropertiesMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.MethodAttributeMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.MethodAttributesMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.PoolConfigMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.ProducerMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.RemoteBindingMetaData;
/*      */ import org.jboss.metadata.ejb.jboss.ResourceManagerMetaData;
/*      */ import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
/*      */ import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
/*      */ import org.jboss.metadata.ejb.spec.AroundInvokeMetaData;
/*      */ import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
/*      */ import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
/*      */ import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
/*      */ import org.jboss.metadata.ejb.spec.ContainerTransactionMetaData;
/*      */ import org.jboss.metadata.ejb.spec.ContainerTransactionsMetaData;
/*      */ import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
/*      */ import org.jboss.metadata.ejb.spec.InitMethodMetaData;
/*      */ import org.jboss.metadata.ejb.spec.InitMethodsMetaData;
/*      */ import org.jboss.metadata.ejb.spec.InterceptorBindingMetaData;
/*      */ import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
/*      */ import org.jboss.metadata.ejb.spec.InterceptorClassesMetaData;
/*      */ import org.jboss.metadata.ejb.spec.MethodMetaData;
/*      */ import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
/*      */ import org.jboss.metadata.ejb.spec.MethodPermissionMetaData;
/*      */ import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
/*      */ import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
/*      */ import org.jboss.metadata.ejb.spec.RemoveMethodMetaData;
/*      */ import org.jboss.metadata.ejb.spec.RemoveMethodsMetaData;
/*      */ import org.jboss.metadata.ejb.spec.SecurityIdentityMetaData;
/*      */ import org.jboss.metadata.ejb.spec.SubscriptionDurability;
/*      */ import org.jboss.metadata.javaee.jboss.AnnotationMetaData;
/*      */ import org.jboss.metadata.javaee.jboss.AnnotationPropertiesMetaData;
/*      */ import org.jboss.metadata.javaee.jboss.AnnotationPropertyMetaData;
/*      */ import org.jboss.metadata.javaee.jboss.AnnotationsMetaData;
/*      */ import org.jboss.metadata.javaee.jboss.IgnoreDependencyMetaData;
/*      */ import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
/*      */ import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
/*      */ import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
/*      */ import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
/*      */ import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
/*      */ import org.jboss.metadata.javaee.spec.RunAsMetaData;
/*      */ import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
/*      */ import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
/*      */ 
/*      */ public class Ejb3DescriptorHandler extends Ejb3AnnotationHandler
/*      */ {
/*      */   private static final Logger log;
/*      */   protected JBossMetaData dd;
/*  214 */   protected List<JBossEnterpriseBeanMetaData> ejbs = new ArrayList();
/*      */ 
/*      */   public Ejb3DescriptorHandler(Ejb3Deployment deployment, ClassFile cf, JBossMetaData dd)
/*      */   {
/*  218 */     super(deployment, cf);
/*  219 */     assert (dd != null) : "dd is null";
/*  220 */     this.dd = dd;
/*      */   }
/*      */ 
/*      */   public Ejb3DescriptorHandler(Ejb3Deployment deployment, JBossMetaData dd)
/*      */   {
/*  225 */     super(deployment);
/*  226 */     assert (dd != null) : "dd is null";
/*  227 */     this.dd = dd;
/*      */   }
/*      */ 
/*      */   private Interceptors createInterceptorsFromInterceptorBinding(Interceptors original, InterceptorBindingMetaData binding)
/*      */     throws ClassNotFoundException
/*      */   {
/*  237 */     assert (binding != null) : "binding is null";
/*      */     InterceptorClassesMetaData classes;
/*      */     InterceptorsImpl impl;
/*      */     InterceptorClassesMetaData classes;
/*  241 */     if (binding.isTotalOrdering())
/*      */     {
/*  243 */       InterceptorsImpl impl = new InterceptorsImpl();
/*  244 */       classes = binding.getInterceptorOrder();
/*      */     }
/*      */     else
/*      */     {
/*  248 */       impl = InterceptorsImpl.getImpl(original);
/*  249 */       classes = binding.getInterceptorClasses();
/*      */     }
/*  251 */     if (classes != null)
/*      */     {
/*  253 */       for (String name : classes)
/*      */       {
/*  255 */         Class clazz = this.di.getClassLoader().loadClass(name);
/*  256 */         impl.addValue(clazz);
/*      */       }
/*      */     }
/*  259 */     return impl;
/*      */   }
/*      */ 
/*      */   private List<JBossEnterpriseBeanMetaData> findEjbsByClass(JBossMetaData dd, String className)
/*      */   {
/*  271 */     assert (dd != null) : "dd is null";
/*  272 */     assert (className != null) : "className is null";
/*      */ 
/*  274 */     List result = new ArrayList();
/*      */ 
/*  276 */     JBossEnterpriseBeansMetaData enterpriseBeans = dd.getEnterpriseBeans();
/*  277 */     if (enterpriseBeans == null) {
/*  278 */       return result;
/*      */     }
/*  280 */     for (JBossEnterpriseBeanMetaData bean : enterpriseBeans)
/*      */     {
/*  282 */       if ((bean.getEjbClass() != null) && (bean.getEjbClass().equals(className))) {
/*  283 */         result.add(bean);
/*      */       }
/*      */     }
/*  286 */     return result;
/*      */   }
/*      */ 
/*      */   public boolean isEjb()
/*      */   {
/*  291 */     if (super.isEjb()) {
/*  292 */       return true;
/*      */     }
/*  294 */     JBossEnterpriseBeansMetaData enterpriseBeans = this.dd.getEnterpriseBeans();
/*  295 */     if (enterpriseBeans == null)
/*      */     {
/*  297 */       return false;
/*      */     }
/*      */ 
/*  300 */     return findEjbsByClass(this.dd, this.cf.getName()).size() > 0;
/*      */   }
/*      */ 
/*      */   private Class<?> loadClass(EJBContainer container, String name)
/*      */   {
/*  313 */     if (name == null)
/*  314 */       return container.getBeanClass();
/*      */     try
/*      */     {
/*  317 */       return this.di.getClassLoader().loadClass(name);
/*      */     }
/*      */     catch (ClassNotFoundException e)
/*      */     {
/*      */     }
/*  322 */     throw new RuntimeException(e);
/*      */   }
/*      */ 
/*      */   protected void populateBaseInfo()
/*      */     throws Exception
/*      */   {
/*  328 */     super.populateBaseInfo();
/*      */ 
/*  330 */     List ejbsByClass = findEjbsByClass(this.dd, this.cf.getName());
/*      */ 
/*  332 */     for (int i = 0; i < this.ejbNames.size(); i++)
/*      */     {
/*  334 */       String ejbNameFromAnnotation = (String)this.ejbNames.get(i);
/*  335 */       this.ejbs.add(this.dd.getEnterpriseBean(ejbNameFromAnnotation));
/*      */ 
/*  337 */       boolean removed = false;
/*  338 */       int j = 0;
/*  339 */       while ((!removed) && (j < ejbsByClass.size()))
/*      */       {
/*  341 */         JBossEnterpriseBeanMetaData ejbByClass = (JBossEnterpriseBeanMetaData)ejbsByClass.get(j);
/*  342 */         if (ejbByClass.getEjbName().equals(ejbNameFromAnnotation))
/*      */         {
/*  344 */           ejbsByClass.remove(j);
/*      */         }
/*  346 */         else j++;
/*      */       }
/*      */     }
/*      */ 
/*  350 */     for (JBossEnterpriseBeanMetaData enterpriseBean : ejbsByClass)
/*      */     {
/*  352 */       String ejbName = enterpriseBean.getEjbName();
/*      */ 
/*  354 */       this.ejbs.add(enterpriseBean);
/*  355 */       this.ejbNames.add(ejbName);
/*      */ 
/*  357 */       this.ejbType = getEjbType(enterpriseBean);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected Ejb3AnnotationHandler.EJB_TYPE getEjbType(JBossEnterpriseBeanMetaData enterpriseBean)
/*      */   {
/*  363 */     if (enterpriseBean.isSession())
/*      */     {
/*  365 */       if (((JBossSessionBeanMetaData)enterpriseBean).isStateless()) {
/*  366 */         return Ejb3AnnotationHandler.EJB_TYPE.STATELESS;
/*      */       }
/*  368 */       return Ejb3AnnotationHandler.EJB_TYPE.STATEFUL;
/*  369 */     }if (enterpriseBean.isEntity())
/*  370 */       return Ejb3AnnotationHandler.EJB_TYPE.ENTITY;
/*  371 */     if (enterpriseBean.isMessageDriven())
/*  372 */       return Ejb3AnnotationHandler.EJB_TYPE.MESSAGE_DRIVEN;
/*  373 */     if (enterpriseBean.isService())
/*  374 */       return Ejb3AnnotationHandler.EJB_TYPE.SERVICE;
/*  375 */     if (enterpriseBean.isConsumer()) {
/*  376 */       return Ejb3AnnotationHandler.EJB_TYPE.CONSUMER;
/*      */     }
/*  378 */     throw new IllegalStateException("unknown bean type encountered " + enterpriseBean);
/*      */   }
/*      */ 
/*      */   public List<Container> getContainers(Ejb3Deployment deployment, Map<String, Container> preexistingContainers) throws Exception
/*      */   {
/*  383 */     List containers = new ArrayList();
/*      */ 
/*  385 */     JBossEnterpriseBeansMetaData allXmlEjbs = this.dd.getEnterpriseBeans() != null ? this.dd.getEnterpriseBeans() : new JBossEnterpriseBeansMetaData();
/*      */ 
/*  387 */     this.ejbNames = new ArrayList();
/*  388 */     for (JBossEnterpriseBeanMetaData ejb : allXmlEjbs)
/*      */     {
/*  390 */       String ejbName = ejb.getEjbName();
/*  391 */       if (preexistingContainers.get(ejbName) == null)
/*      */       {
/*  393 */         this.ejbNames.add(ejbName);
/*  394 */         this.ejbs.add(ejb);
/*      */       }
/*      */     }
/*      */ 
/*  398 */     for (int ejbIndex = 0; ejbIndex < this.ejbNames.size(); ejbIndex++)
/*      */     {
/*  400 */       String ejbName = (String)this.ejbNames.get(ejbIndex);
/*  401 */       JBossEnterpriseBeanMetaData enterpriseBean = (JBossEnterpriseBeanMetaData)this.ejbs.get(ejbIndex);
/*  402 */       this.ejbType = getEjbType(enterpriseBean);
/*  403 */       this.className = enterpriseBean.getEjbClass();
/*      */ 
/*  405 */       if (this.className == null) {
/*  406 */         log.warn("Descriptor based bean has no ejb-class defined: " + ejbName);
/*      */       }
/*      */       else {
/*  409 */         this.ejbClass = this.di.getClassLoader().loadClass(this.className);
/*  410 */         if (this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.STATELESS)
/*      */         {
/*  412 */           EJBContainer container = getStatelessContainer(ejbIndex);
/*  413 */           container.setJaccContextId(getJaccContextId());
/*  414 */           containers.add(container);
/*      */         }
/*  416 */         else if (this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.STATEFUL)
/*      */         {
/*  418 */           StatefulContainer container = getStatefulContainer(ejbIndex);
/*  419 */           container.setJaccContextId(getJaccContextId());
/*  420 */           containers.add(container);
/*      */         }
/*  422 */         else if (this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.MESSAGE_DRIVEN)
/*      */         {
/*  424 */           MDB container = getMDB(ejbIndex);
/*  425 */           container.setJaccContextId(getJaccContextId());
/*  426 */           containers.add(container);
/*      */         }
/*  428 */         else if (this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.SERVICE)
/*      */         {
/*  430 */           ServiceContainer container = getServiceContainer(ejbIndex);
/*  431 */           container.setJaccContextId(getJaccContextId());
/*  432 */           containers.add(container);
/*      */         }
/*  434 */         else if (this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.CONSUMER)
/*      */         {
/*  436 */           ConsumerContainer container = getConsumerContainer(ejbIndex);
/*  437 */           container.setJaccContextId(getJaccContextId());
/*  438 */           containers.add(container);
/*      */         }
/*  440 */         log.debug("found EJB3: ejbName=" + ejbName + ", class=" + this.className + ", type=" + this.ejbType);
/*      */       }
/*      */     }
/*      */ 
/*  444 */     return containers;
/*      */   }
/*      */ 
/*      */   protected StatefulContainer getStatefulContainer(int ejbIndex)
/*      */     throws Exception
/*      */   {
/*  450 */     String ejbName = (String)this.ejbNames.get(ejbIndex);
/*      */ 
/*  452 */     JBossEnterpriseBeanMetaData enterpriseBean = (JBossEnterpriseBeanMetaData)this.ejbs.get(ejbIndex);
/*      */ 
/*  454 */     StatefulContainer container = super.getStatefulContainer(ejbIndex);
/*      */ 
/*  456 */     container.setAssemblyDescriptor(this.dd.getAssemblyDescriptor());
/*      */ 
/*  458 */     if ((enterpriseBean instanceof JBossSessionBeanMetaData))
/*  459 */       addInterfaces(container, (JBossSessionBeanMetaData)enterpriseBean);
/*      */     else {
/*  461 */       log.trace("Not analyzing interfaces on " + enterpriseBean);
/*      */     }
/*  463 */     addDescriptorAnnotations(container, enterpriseBean, ejbName, true);
/*      */ 
/*  465 */     return container;
/*      */   }
/*      */ 
/*      */   private void addHomeAnnotations(EJBContainer container, JBossSessionBeanMetaData sessionBean)
/*      */     throws Exception
/*      */   {
/*  471 */     if (sessionBean.getHome() != null)
/*      */     {
/*  473 */       RemoteHomeImpl annotation = new RemoteHomeImpl(this.di.getClassLoader().loadClass(sessionBean.getHome()));
/*      */ 
/*  475 */       addClassAnnotation(container, annotation.annotationType(), annotation);
/*      */     }
/*      */ 
/*  478 */     if (sessionBean.getLocalHome() != null)
/*      */     {
/*  480 */       LocalHomeImpl annotation = new LocalHomeImpl(this.di.getClassLoader().loadClass(sessionBean.getLocalHome()));
/*      */ 
/*  482 */       addClassAnnotation(container, annotation.annotationType(), annotation);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected EJBContainer getStatelessContainer(int ejbIndex)
/*      */     throws Exception
/*      */   {
/*  489 */     String ejbName = (String)this.ejbNames.get(ejbIndex);
/*      */ 
/*  491 */     JBossEnterpriseBeanMetaData enterpriseBean = (JBossEnterpriseBeanMetaData)this.ejbs.get(ejbIndex);
/*      */ 
/*  493 */     EJBContainer container = super.getStatelessContainer(ejbIndex);
/*      */ 
/*  495 */     container.setAssemblyDescriptor(this.dd.getAssemblyDescriptor());
/*      */ 
/*  497 */     StatelessImpl annotation = new StatelessImpl(ejbName);
/*  498 */     if ((enterpriseBean != null) && (!isAnnotatedBean()))
/*      */     {
/*  500 */       addClassAnnotation(container, Stateless.class, annotation);
/*      */     }
/*      */ 
/*  503 */     if ((enterpriseBean instanceof JBossSessionBeanMetaData))
/*  504 */       addInterfaces(container, (JBossSessionBeanMetaData)enterpriseBean);
/*      */     else {
/*  506 */       log.debug("Not analyzing interfaces on " + enterpriseBean);
/*      */     }
/*  508 */     addDescriptorAnnotations(container, enterpriseBean, ejbName);
/*      */ 
/*  510 */     return container;
/*      */   }
/*      */ 
/*      */   protected ServiceContainer getServiceContainer(int ejbIndex)
/*      */     throws Exception
/*      */   {
/*  516 */     String ejbName = (String)this.ejbNames.get(ejbIndex);
/*      */ 
/*  518 */     JBossServiceBeanMetaData service = (JBossServiceBeanMetaData)this.ejbs.get(ejbIndex);
/*      */ 
/*  520 */     ServiceContainer container = super.getServiceContainer(ejbIndex);
/*  521 */     ServiceImpl annotation = new ServiceImpl((Service)container.resolveAnnotation(Service.class));
/*      */ 
/*  524 */     container.setAssemblyDescriptor(this.dd.getAssemblyDescriptor());
/*      */ 
/*  526 */     if ((service != null) && (!isAnnotatedBean()))
/*      */     {
/*  528 */       if (service.getObjectName() != null)
/*  529 */         annotation.setObjectName(service.getObjectName());
/*  530 */       if (service.getEjbName() != null)
/*  531 */         annotation.setName(service.getEjbName());
/*  532 */       if (service.getXmbean() != null)
/*  533 */         annotation.setXMBean(service.getXmbean());
/*  534 */       addClassAnnotation(container, Service.class, annotation);
/*      */     }
/*      */ 
/*  537 */     addInterfaces(container, service);
/*      */ 
/*  539 */     addDescriptorAnnotations(container, service, ejbName);
/*      */ 
/*  541 */     addServiceAnnotations(container, service);
/*      */ 
/*  543 */     return container;
/*      */   }
/*      */ 
/*      */   protected ConsumerContainer getConsumerContainer(int ejbIndex)
/*      */     throws Exception
/*      */   {
/*  549 */     String ejbName = (String)this.ejbNames.get(ejbIndex);
/*      */ 
/*  551 */     JBossConsumerBeanMetaData consumer = (JBossConsumerBeanMetaData)this.ejbs.get(ejbIndex);
/*      */ 
/*  553 */     ConsumerContainer container = super.getConsumerContainer(ejbIndex);
/*  554 */     ConsumerImpl annotation = new ConsumerImpl((Consumer)container.resolveAnnotation(Consumer.class));
/*      */ 
/*  557 */     container.setAssemblyDescriptor(this.dd.getAssemblyDescriptor());
/*      */ 
/*  559 */     if ((consumer != null) && (!isAnnotatedBean()))
/*      */     {
/*  561 */       if (consumer.getMessageDestination() != null)
/*      */       {
/*  563 */         ActivationConfigPropertyImpl property = new ActivationConfigPropertyImpl("destination", consumer.getMessageDestination());
/*      */ 
/*  565 */         annotation.addActivationConfig(property);
/*      */       }
/*      */ 
/*  568 */       if (consumer.getMessageDestinationType() != null)
/*      */       {
/*  570 */         ActivationConfigPropertyImpl property = new ActivationConfigPropertyImpl("destinationType", consumer.getMessageDestinationType());
/*      */ 
/*  572 */         annotation.addActivationConfig(property);
/*      */       }
/*      */ 
/*  575 */       addClassAnnotation(container, Consumer.class, annotation);
/*      */     }
/*      */ 
/*  581 */     addDescriptorAnnotations(container, consumer, ejbName);
/*      */ 
/*  583 */     addConsumerAnnotations(container, consumer);
/*      */ 
/*  585 */     return container;
/*      */   }
/*      */ 
/*      */   protected String getMDBDomainName(int ejbIndex)
/*      */   {
/*  590 */     return this.defaultMDBDomain;
/*      */   }
/*      */ 
/*      */   protected MDB getMDB(int ejbIndex) throws Exception
/*      */   {
/*  595 */     String ejbName = (String)this.ejbNames.get(ejbIndex);
/*      */ 
/*  597 */     JBossEnterpriseBeanMetaData enterpriseBean = (JBossEnterpriseBeanMetaData)this.ejbs.get(ejbIndex);
/*      */ 
/*  599 */     MDB container = super.getMDB(ejbIndex);
/*      */ 
/*  601 */     container.setAssemblyDescriptor(this.dd.getAssemblyDescriptor());
/*      */ 
/*  603 */     if ((enterpriseBean instanceof JBossMessageDrivenBeanMetaData)) {
/*  604 */       addMDBAnnotations(container, ejbName, (JBossMessageDrivenBeanMetaData)enterpriseBean);
/*  605 */     } else if ((enterpriseBean instanceof JBossGenericBeanMetaData))
/*      */     {
/*  608 */       JBossMessageDrivenBeanMetaData mdb = new JBossMessageDrivenBeanMetaData();
/*  609 */       mdb.setDestinationJndiName(enterpriseBean.getMappedName());
/*      */ 
/*  611 */       addMDBAnnotations(container, ejbName, mdb);
/*      */     }
/*      */ 
/*  617 */     addDescriptorAnnotations(container, enterpriseBean, ejbName);
/*      */ 
/*  619 */     return container;
/*      */   }
/*      */ 
/*      */   protected String getAspectDomain(int ejbIndex, String defaultDomain)
/*      */   {
/*  624 */     JBossEnterpriseBeanMetaData enterpriseBean = (JBossEnterpriseBeanMetaData)this.ejbs.get(ejbIndex);
/*  625 */     if (enterpriseBean != null)
/*      */     {
/*  627 */       String aopDomainName = enterpriseBean.getAopDomainName();
/*  628 */       if (aopDomainName != null)
/*      */       {
/*  630 */         log.debug("Found aop-domain-name element for annotation " + aopDomainName + " for ejbName " + enterpriseBean.getEjbName());
/*      */ 
/*  634 */         return aopDomainName;
/*      */       }
/*      */     }
/*  637 */     return super.getAspectDomain(ejbIndex, defaultDomain);
/*      */   }
/*      */ 
/*      */   protected boolean isAnnotatedBean()
/*      */   {
/*  642 */     return (super.isEjb()) || (super.isJBossBeanType());
/*      */   }
/*      */ 
/*      */   private void addMDBAnnotations(MDB container, String ejbName, JBossMessageDrivenBeanMetaData mdb)
/*      */   {
/*  647 */     if (mdb != null)
/*      */     {
/*  649 */       if (mdb.getResourceAdapterName() != null)
/*      */       {
/*  651 */         ResourceAdapter adapter = new ResourceAdapterImpl(mdb.getResourceAdapterName());
/*  652 */         addClassAnnotation(container, ResourceAdapter.class, adapter);
/*      */       }
/*      */ 
/*  655 */       ArrayList properties = new ArrayList();
/*      */ 
/*  657 */       if (mdb.isJMS())
/*      */       {
/*  659 */         if (mdb.getAcknowledgeMode() != null) {
/*  660 */           properties.add(new ActivationConfigPropertyImpl("acknowledgeMode", mdb.getAcknowledgeMode()));
/*      */         }
/*  662 */         if (mdb.getMessageDestinationType() != null)
/*      */         {
/*  664 */           properties.add(new ActivationConfigPropertyImpl("destinationType", mdb.getMessageDestinationType()));
/*      */         }
/*  666 */         SubscriptionDurability subscriptionDurability = mdb.getSubscriptionDurability();
/*  667 */         if (subscriptionDurability != null)
/*      */         {
/*  669 */           String durable = "false";
/*  670 */           if (subscriptionDurability.equals(SubscriptionDurability.Durable))
/*  671 */             durable = "true";
/*  672 */           properties.add(new ActivationConfigPropertyImpl("subscriptionDurability", durable));
/*  673 */           if (subscriptionDurability.equals(SubscriptionDurability.Durable)) {
/*  674 */             properties.add(new ActivationConfigPropertyImpl("subscriptionName", "subscriptionName"));
/*      */           }
/*      */         }
/*      */ 
/*  678 */         if (mdb.getDestinationJndiName() != null)
/*      */         {
/*  680 */           properties.add(new ActivationConfigPropertyImpl("destination", mdb.getDestinationJndiName()));
/*      */         }
/*  683 */         else if (mdb.getMessageDestinationLink() != null)
/*      */         {
/*  685 */           log.warn("Message destination link on a MDB is not yet implemented, specify a jndi name in jboss.xml");
/*      */         }
/*      */ 
/*  693 */         if (mdb.getMdbSubscriptionId() != null)
/*      */         {
/*  695 */           properties.add(new ActivationConfigPropertyImpl("subscriptionName", mdb.getMdbSubscriptionId()));
/*      */         }
/*      */ 
/*  702 */         if (mdb.getMdbUser() != null)
/*      */         {
/*  704 */           properties.add(new ActivationConfigPropertyImpl("user", mdb.getMdbUser()));
/*      */         }
/*      */ 
/*  708 */         if (mdb.getMdbPassword() != null)
/*      */         {
/*  710 */           properties.add(new ActivationConfigPropertyImpl("password", mdb.getMdbPassword()));
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  716 */       ActivationConfigMetaData activationConfig = mdb.getActivationConfig();
/*  717 */       if ((activationConfig != null) && (activationConfig.getActivationConfigProperties() != null))
/*      */       {
/*  719 */         for (ActivationConfigPropertyMetaData property : activationConfig.getActivationConfigProperties())
/*      */         {
/*  721 */           properties.add(new ActivationConfigPropertyImpl(property.getName(), property.getValue()));
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  726 */       ActivationConfigPropertyImpl[] propsArray = new ActivationConfigPropertyImpl[properties.size()];
/*      */ 
/*  728 */       properties.toArray(propsArray);
/*  729 */       MessageDrivenImpl annotation = new MessageDrivenImpl(ejbName, propsArray);
/*      */ 
/*  731 */       if (mdb.getMessagingType() != null)
/*      */       {
/*      */         try
/*      */         {
/*  735 */           annotation.setMessageListenerInterface(container.getClassloader().loadClass(mdb.getMessagingType()));
/*      */         }
/*      */         catch (ClassNotFoundException e)
/*      */         {
/*  739 */           throw new RuntimeException(e);
/*      */         }
/*      */       }
/*      */ 
/*  743 */       if (isAnnotatedBean())
/*      */       {
/*  745 */         annotation.merge((MessageDriven)this.ejbClass.getAnnotation(MessageDriven.class));
/*      */       }
/*      */ 
/*  748 */       addClassAnnotation(container, MessageDriven.class, annotation);
/*      */ 
/*  750 */       addDefaultActivationConfig(container, mdb);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addDefaultActivationConfig(MDB container, JBossMessageDrivenBeanMetaData mdb)
/*      */   {
/*  756 */     ActivationConfigMetaData defaultActivationConfig = mdb.getDefaultActivationConfig();
/*  757 */     if (defaultActivationConfig != null)
/*      */     {
/*  759 */       DefaultActivationSpecsImpl activationAnnotation = new DefaultActivationSpecsImpl();
/*  760 */       for (ActivationConfigPropertyMetaData property : defaultActivationConfig.getActivationConfigProperties())
/*      */       {
/*  762 */         activationAnnotation.addActivationConfigProperty(new ActivationConfigPropertyImpl(property.getName(), property.getValue()));
/*      */       }
/*      */ 
/*  766 */       DefaultActivationSpecs existingAnnotation = (DefaultActivationSpecs)this.ejbClass.getAnnotation(DefaultActivationSpecs.class);
/*  767 */       if (existingAnnotation != null) {
/*  768 */         activationAnnotation.merge(existingAnnotation);
/*      */       }
/*  770 */       addClassAnnotation(container, DefaultActivationSpecs.class, activationAnnotation);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addInterfaces(EJBContainer container, JBossSessionBeanMetaData enterpriseBean) throws ClassNotFoundException
/*      */   {
/*  776 */     if (enterpriseBean != null)
/*      */     {
/*  779 */       List localClasses = new ArrayList();
/*  780 */       List remoteClasses = new ArrayList();
/*  781 */       List localClassNames = new ArrayList();
/*  782 */       List remoteClassNames = new ArrayList();
/*      */ 
/*  785 */       BusinessLocalsMetaData businessLocals = enterpriseBean.getBusinessLocals();
/*  786 */       BusinessRemotesMetaData businessRemotes = enterpriseBean.getBusinessRemotes();
/*      */ 
/*  789 */       String local = enterpriseBean.getLocal();
/*  790 */       String remote = enterpriseBean.getRemote();
/*      */ 
/*  793 */       if (businessLocals != null)
/*      */       {
/*  795 */         localClassNames.addAll(businessLocals);
/*      */       }
/*      */ 
/*  799 */       if (businessRemotes != null)
/*      */       {
/*  801 */         remoteClassNames.addAll(businessRemotes);
/*      */       }
/*      */ 
/*  805 */       if (local != null)
/*      */       {
/*  808 */         StringTokenizer classes = new StringTokenizer(local, ",");
/*  809 */         while (classes.hasMoreTokens())
/*      */         {
/*  811 */           String token = classes.nextToken();
/*  812 */           String classname = token.trim();
/*  813 */           localClassNames.add(classname);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  818 */       if (remote != null)
/*      */       {
/*  821 */         StringTokenizer classes = new StringTokenizer(remote, ",");
/*  822 */         while (classes.hasMoreTokens())
/*      */         {
/*  824 */           String token = classes.nextToken();
/*  825 */           String classname = token.trim();
/*  826 */           remoteClassNames.add(classname);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  831 */       for (String localClassName : localClassNames)
/*      */       {
/*  834 */         Class localClass = this.di.getClassLoader().loadClass(localClassName);
/*      */ 
/*  837 */         if (!localClass.isInterface())
/*      */         {
/*  839 */           throw new RuntimeException("Specified class for @Local " + localClass.getName() + " is not an interface");
/*      */         }
/*      */ 
/*  844 */         log.debug("Adding @Local interface " + localClass.getName() + " as specified in metadata");
/*  845 */         localClasses.add(localClass);
/*      */       }
/*      */ 
/*  849 */       for (String remoteClassName : remoteClassNames)
/*      */       {
/*  852 */         Class remoteClass = this.di.getClassLoader().loadClass(remoteClassName);
/*      */ 
/*  855 */         if (!remoteClass.isInterface())
/*      */         {
/*  857 */           throw new RuntimeException("Specified class for @Remote " + remoteClass.getName() + " is not an interface");
/*      */         }
/*      */ 
/*  862 */         log.debug("Adding @Remote interface " + remoteClass.getName() + " as specified in metadata");
/*  863 */         remoteClasses.add(remoteClass);
/*      */       }
/*      */ 
/*  867 */       if (localClasses.size() > 0)
/*      */       {
/*  869 */         Class[] lIntfs = new Class[localClasses.size()];
/*  870 */         lIntfs = (Class[])localClasses.toArray(lIntfs);
/*  871 */         addClassAnnotation(container, Local.class, new LocalImpl(lIntfs));
/*      */       }
/*      */ 
/*  875 */       if (remoteClasses.size() > 0)
/*      */       {
/*  877 */         Class[] rIntfs = new Class[remoteClasses.size()];
/*  878 */         rIntfs = (Class[])remoteClasses.toArray(rIntfs);
/*  879 */         addClassAnnotation(container, Remote.class, new RemoteImpl(rIntfs));
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addDescriptorAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, String ejbName)
/*      */     throws Exception
/*      */   {
/*  894 */     addDescriptorAnnotations(container, enterpriseBean, ejbName, false);
/*      */   }
/*      */ 
/*      */   private void addDescriptorAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, String ejbName, boolean isStateful)
/*      */     throws Exception
/*      */   {
/*  901 */     if ((enterpriseBean instanceof JBossGenericBeanMetaData))
/*      */     {
/*  903 */       Class[] remoteAndBusinessRemoteInterfaces = ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(container);
/*  904 */       if (remoteAndBusinessRemoteInterfaces.length == 0)
/*      */       {
/*  906 */         enterpriseBean.setLocalJndiName(enterpriseBean.getMappedName());
/*  907 */         enterpriseBean.setMappedName(null);
/*      */       }
/*      */     }
/*      */ 
/*  911 */     container.setXml(enterpriseBean);
/*      */ 
/*  913 */     addTransactionAnnotations(container, enterpriseBean, ejbName);
/*      */ 
/*  915 */     addAssemblyAnnotations(container, enterpriseBean, ejbName);
/*      */ 
/*  917 */     addSecurityAnnotations(container, enterpriseBean, ejbName);
/*      */ 
/*  919 */     addEjbAnnotations(container, enterpriseBean);
/*      */ 
/*  921 */     addEjb21Annotations(container, isStateful);
/*      */   }
/*      */ 
/*      */   private void addEjb21Annotations(EJBContainer container, boolean isStateful)
/*      */     throws Exception
/*      */   {
/*  936 */     Class[] interfaces = this.ejbClass.getInterfaces();
/*  937 */     for (Class beanInterface : interfaces)
/*      */     {
/*  939 */       if (!beanInterface.equals(SessionBean.class))
/*      */         continue;
/*  941 */       MethodMetaData method = new MethodMetaData();
/*  942 */       method.setEjbName(container.getEjbName());
/*      */ 
/*  948 */       if (hasPublicMethod(this.ejbClass, "ejbCreate"))
/*      */       {
/*      */         Annotation annotation;
/*      */         Annotation annotation;
/*  950 */         if (isStateful)
/*      */         {
/*  952 */           annotation = new InitImpl();
/*      */         }
/*      */         else
/*      */         {
/*  956 */           annotation = new PostConstructImpl();
/*      */         }
/*  958 */         Class annotationClass = annotation.annotationType();
/*  959 */         method.setMethodName("ejbCreate");
/*  960 */         addAnnotations(annotationClass, annotation, container, method);
/*      */       }
/*      */ 
/*  963 */       Annotation annotation = new PostActivateImpl();
/*  964 */       Class annotationClass = PostActivate.class;
/*  965 */       method.setMethodName("ejbActivate");
/*  966 */       addAnnotations(annotationClass, annotation, container, method);
/*      */ 
/*  968 */       annotation = new PrePassivateImpl();
/*  969 */       annotationClass = PrePassivate.class;
/*  970 */       method.setMethodName("ejbPassivate");
/*  971 */       addAnnotations(annotationClass, annotation, container, method);
/*      */ 
/*  973 */       annotation = new PreDestroyImpl();
/*  974 */       annotationClass = PreDestroy.class;
/*  975 */       method.setMethodName("ejbRemove");
/*  976 */       addAnnotations(annotationClass, annotation, container, method);
/*      */ 
/*  978 */       annotation = new ResourceImpl();
/*  979 */       annotationClass = Resource.class;
/*  980 */       method.setMethodName("setSessionContext");
/*      */ 
/*  982 */       addAnnotations(annotationClass, annotation, container, method);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addAssemblyAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, String ejbName)
/*      */     throws Exception
/*      */   {
/*  990 */     JBossAssemblyDescriptorMetaData assembly = this.dd.getAssemblyDescriptor();
/*  991 */     if (assembly != null)
/*      */     {
/*  993 */       addExcludeAnnotations(container, assembly.getExcludeList(), ejbName);
/*      */ 
/*  995 */       addInterceptorBindingAnnotations(container, enterpriseBean, ejbName);
/*      */     }
/*      */ 
/*  998 */     if ((enterpriseBean instanceof JBossSessionBeanMetaData))
/*      */     {
/* 1000 */       JBossSessionBeanMetaData sessionBean = (JBossSessionBeanMetaData)enterpriseBean;
/* 1001 */       addInitAnnotations(container, sessionBean.getInitMethods(), ejbName);
/* 1002 */       addRemoveAnnotations(container, sessionBean.getRemoveMethods(), ejbName);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addExcludeAnnotations(EJBContainer container, ExcludeListMetaData list, String ejbName)
/*      */     throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException
/*      */   {
/* 1009 */     if ((list != null) && (list.getMethods() != null))
/*      */     {
/* 1011 */       for (MethodMetaData method : list.getMethods())
/*      */       {
/* 1013 */         if (method.getEjbName().equals(ejbName))
/*      */         {
/* 1015 */           DenyAllImpl annotation = new DenyAllImpl();
/* 1016 */           addAnnotations(DenyAll.class, annotation, container, method);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addInitAnnotations(EJBContainer container, InitMethodsMetaData list, String ejbName)
/*      */     throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException
/*      */   {
/* 1025 */     if (list != null)
/*      */     {
/* 1027 */       for (InitMethodMetaData initMethod : list)
/*      */       {
/* 1029 */         NamedMethodMetaData method = initMethod.getBeanMethod();
/* 1030 */         InitImpl annotation = new InitImpl();
/* 1031 */         addAnnotations(Init.class, annotation, container, method);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addRemoveAnnotations(EJBContainer container, RemoveMethodsMetaData list, String ejbName)
/*      */     throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException
/*      */   {
/* 1040 */     if (list != null)
/*      */     {
/* 1042 */       for (RemoveMethodMetaData removeMethod : list)
/*      */       {
/* 1044 */         NamedMethodMetaData method = removeMethod.getBeanMethod();
/* 1045 */         RemoveImpl annotation = new RemoveImpl(removeMethod.isRetainIfException());
/* 1046 */         addAnnotations(Remove.class, annotation, container, method);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addSecurityAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, String ejbName)
/*      */     throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException
/*      */   {
/* 1054 */     JBossAssemblyDescriptorMetaData assembly = this.dd.getAssemblyDescriptor();
/*      */     Iterator i$;
/* 1055 */     if (assembly != null)
/*      */     {
/* 1057 */       SecurityRolesMetaData securityRoles = assembly.getSecurityRoles();
/*      */ 
/* 1059 */       if ((securityRoles != null) && (securityRoles.size() > 0))
/*      */       {
/* 1061 */         List roleList = new ArrayList();
/* 1062 */         for (SecurityRoleMetaData securityRole : securityRoles)
/*      */         {
/* 1064 */           roleList.add(securityRole.getRoleName());
/*      */         }
/*      */ 
/* 1067 */         DeclareRolesImpl annotation = new DeclareRolesImpl((String[])roleList.toArray(new String[roleList.size()]));
/* 1068 */         addClassAnnotation(container, DeclareRoles.class, annotation);
/*      */       }
/*      */ 
/* 1071 */       MethodPermissionsMetaData methodPermissions = assembly.getMethodPermissions();
/* 1072 */       if (methodPermissions != null)
/*      */       {
/* 1074 */         for (i$ = methodPermissions.iterator(); i$.hasNext(); ) { permission = (MethodPermissionMetaData)i$.next();
/*      */ 
/* 1076 */           for (MethodMetaData method : permission.getMethods())
/*      */           {
/* 1078 */             if (method.getEjbName().equals(ejbName))
/*      */             {
/* 1080 */               if (permission.isNotChecked())
/*      */               {
/* 1082 */                 PermitAllImpl annotation = new PermitAllImpl();
/* 1083 */                 addAnnotations(PermitAll.class, annotation, container, method);
/*      */               }
/*      */               else {
/* 1086 */                 RolesAllowedImpl annotation = new RolesAllowedImpl();
/*      */ 
/* 1088 */                 for (String roleName : permission.getRoles())
/*      */                 {
/* 1090 */                   annotation.addValue(roleName);
/*      */                 }
/* 1092 */                 addAnnotations(RolesAllowed.class, annotation, container, method);
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     MethodPermissionMetaData permission;
/* 1100 */     if ((enterpriseBean != null) && (enterpriseBean.getSecurityDomain() != null))
/*      */     {
/* 1102 */       String securityDomain = enterpriseBean.getSecurityDomain();
/*      */ 
/* 1104 */       SecurityDomainImpl annotation = new SecurityDomainImpl(securityDomain);
/*      */ 
/* 1106 */       if (this.dd.getUnauthenticatedPrincipal() != null) {
/* 1107 */         annotation.setUnauthenticatedPrincipal(this.dd.getUnauthenticatedPrincipal());
/*      */       }
/*      */ 
/* 1110 */       addClassAnnotation(container, annotation.annotationType(), annotation);
/* 1111 */     } else if (this.dd.getSecurityDomain() != null)
/*      */     {
/* 1113 */       String securityDomain = this.dd.getSecurityDomain();
/*      */ 
/* 1115 */       SecurityDomainImpl annotation = new SecurityDomainImpl(securityDomain);
/*      */ 
/* 1117 */       if (this.dd.getUnauthenticatedPrincipal() != null) {
/* 1118 */         annotation.setUnauthenticatedPrincipal(this.dd.getUnauthenticatedPrincipal());
/*      */       }
/*      */ 
/* 1121 */       addClassAnnotation(container, annotation.annotationType(), annotation);
/* 1122 */     } else if (this.dd.getUnauthenticatedPrincipal() != null)
/*      */     {
/* 1124 */       SecurityDomain annotation = (SecurityDomain)this.ejbClass.getAnnotation(SecurityDomain.class);
/*      */       SecurityDomainImpl override;
/* 1126 */       if (annotation != null)
/*      */       {
/* 1128 */         SecurityDomainImpl override = new SecurityDomainImpl(annotation.value());
/* 1129 */         override.setUnauthenticatedPrincipal(this.dd.getUnauthenticatedPrincipal());
/*      */       }
/*      */       else
/*      */       {
/* 1134 */         override = new SecurityDomainImpl();
/* 1135 */         override.setUnauthenticatedPrincipal(this.dd.getUnauthenticatedPrincipal());
/*      */       }
/* 1137 */       addClassAnnotation(container, override.annotationType(), override);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addTransactionAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, String ejbName)
/*      */     throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException
/*      */   {
/* 1144 */     if (enterpriseBean != null)
/*      */     {
/* 1146 */       TransactionManagementType transactionType = enterpriseBean.getTransactionType();
/* 1147 */       if (transactionType != null)
/*      */       {
/* 1149 */         TransactionManagementImpl annotation = new TransactionManagementImpl();
/* 1150 */         annotation.setValue(transactionType);
/* 1151 */         addClassAnnotation(container, TransactionManagement.class, annotation);
/*      */       }
/*      */ 
/* 1154 */       MethodAttributesMetaData attributes = enterpriseBean.getMethodAttributes();
/* 1155 */       if (attributes != null)
/*      */       {
/* 1157 */         for (MethodAttributeMetaData method : attributes)
/*      */         {
/* 1159 */           TransactionTimeout timeoutAnnotation = new TransactionTimeoutImpl(method.getTransactionTimeout());
/* 1160 */           addAnnotations(TransactionTimeout.class, timeoutAnnotation, container, method.getMethodName(), null);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1165 */     JBossAssemblyDescriptorMetaData descriptor = this.dd.getAssemblyDescriptor();
/*      */     Iterator i$;
/* 1166 */     if ((descriptor != null) && (descriptor.getContainerTransactions() != null))
/*      */     {
/* 1168 */       for (i$ = descriptor.getContainerTransactions().iterator(); i$.hasNext(); ) { transaction = (ContainerTransactionMetaData)i$.next();
/*      */ 
/* 1170 */         for (MethodMetaData method : transaction.getMethods())
/*      */         {
/* 1172 */           if (method.getEjbName().equals(ejbName))
/*      */           {
/* 1174 */             TransactionAttributeImpl annotation = new TransactionAttributeImpl();
/* 1175 */             annotation.setType(transaction.getTransAttribute());
/* 1176 */             addAnnotations(TransactionAttribute.class, annotation, container, method);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     ContainerTransactionMetaData transaction;
/*      */   }
/*      */ 
/*      */   private void addInterceptorBindingAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, String ejbName)
/*      */     throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException
/*      */   {
/* 1192 */     boolean definesInterceptors = false;
/*      */ 
/* 1194 */     InterceptorBindingsMetaData interceptorBindings = this.dd.getAssemblyDescriptor().getInterceptorBindings();
/* 1195 */     if (interceptorBindings != null)
/*      */     {
/* 1197 */       for (InterceptorBindingMetaData binding : interceptorBindings)
/*      */       {
/* 1206 */         if (binding.getEjbName().equals(ejbName))
/*      */         {
/* 1208 */           if (binding.getMethod() == null)
/*      */           {
/* 1210 */             addClassLevelInterceptorBindingAnnotations(container, binding);
/* 1211 */             definesInterceptors = true;
/*      */           }
/*      */           else
/*      */           {
/* 1215 */             definesInterceptors = addMethodLevelInterceptorBindingAnnotations(container, binding);
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1223 */     if ((!definesInterceptors) && (this.di.getInterceptorInfoRepository().hasDefaultInterceptors()))
/*      */     {
/* 1226 */       addClassAnnotation(container, DefaultInterceptorMarker.class, new DefaultInterceptorMarkerImpl());
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addClassLevelInterceptorBindingAnnotations(EJBContainer container, InterceptorBindingMetaData binding)
/*      */     throws ClassNotFoundException
/*      */   {
/* 1239 */     Interceptors interceptors = (Interceptors)container.resolveAnnotation(Interceptors.class);
/*      */ 
/* 1241 */     if (binding != null)
/*      */     {
/* 1243 */       Interceptors impl = createInterceptorsFromInterceptorBinding(interceptors, binding);
/*      */ 
/* 1245 */       addClassAnnotation(container, impl.annotationType(), impl);
/*      */     }
/*      */ 
/* 1248 */     boolean exclude = false;
/* 1249 */     if (binding != null)
/* 1250 */       exclude = binding.isExcludeDefaultInterceptors();
/* 1251 */     if ((exclude) && (container.resolveAnnotation(ExcludeDefaultInterceptors.class) == null))
/*      */     {
/* 1254 */       addClassAnnotation(container, ExcludeDefaultInterceptors.class, new ExcludeDefaultInterceptorsImpl());
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean addMethodLevelInterceptorBindingAnnotations(EJBContainer container, InterceptorBindingMetaData binding)
/*      */     throws ClassNotFoundException
/*      */   {
/* 1268 */     boolean addedAnnotations = false;
/* 1269 */     for (Method method : container.getBeanClass().getMethods())
/*      */     {
/* 1272 */       boolean matches = false;
/*      */       Class[] methodParams;
/*      */       int i;
/* 1273 */       if (method.getName().equals(binding.getMethod().getMethodName()))
/*      */       {
/* 1275 */         if (binding.getMethod().getMethodParams() == null)
/*      */         {
/* 1277 */           matches = true;
/*      */         }
/*      */         else {
/* 1280 */           methodParams = method.getParameterTypes();
/* 1281 */           MethodParametersMetaData bindingParams = binding.getMethod().getMethodParams();
/*      */ 
/* 1283 */           if (methodParams.length == bindingParams.size())
/*      */           {
/* 1285 */             matches = true;
/* 1286 */             i = 0;
/* 1287 */             for (String paramName : bindingParams)
/*      */             {
/* 1289 */               String methodParamName = InterceptorInfoRepository.simpleType(methodParams[(i++)]);
/*      */ 
/* 1291 */               if (!paramName.equals(methodParamName))
/*      */               {
/* 1293 */                 matches = false;
/* 1294 */                 break;
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/* 1301 */       if (!matches)
/*      */         continue;
/* 1303 */       Interceptors interceptors = (Interceptors)container.resolveAnnotation(method, Interceptors.class);
/*      */ 
/* 1305 */       if (binding != null)
/*      */       {
/* 1307 */         Interceptors impl = createInterceptorsFromInterceptorBinding(interceptors, binding);
/* 1308 */         log.debug("adding " + Interceptors.class.getName() + " method annotation to " + method);
/*      */ 
/* 1310 */         container.getAnnotations().addAnnotation(method, Interceptors.class, impl);
/*      */       }
/*      */ 
/* 1314 */       boolean excludeDefault = false;
/* 1315 */       if (binding != null)
/* 1316 */         excludeDefault = binding.isExcludeDefaultInterceptors();
/* 1317 */       if ((excludeDefault) && (container.resolveAnnotation(method, ExcludeDefaultInterceptors.class) == null))
/*      */       {
/* 1321 */         log.debug("adding " + ExcludeDefaultInterceptors.class.getName() + " method annotation to " + method);
/*      */ 
/* 1323 */         container.getAnnotations().addAnnotation(method, ExcludeDefaultInterceptors.class, new ExcludeDefaultInterceptorsImpl());
/*      */       }
/*      */ 
/* 1328 */       boolean excludeClass = false;
/* 1329 */       if (binding != null)
/* 1330 */         excludeClass = binding.isExcludeClassInterceptors();
/* 1331 */       if ((excludeClass) && (container.resolveAnnotation(method, ExcludeClassInterceptors.class) == null))
/*      */       {
/* 1335 */         log.debug("adding " + ExcludeClassInterceptors.class.getName() + " method annotation to " + method);
/*      */ 
/* 1337 */         container.getAnnotations().addAnnotation(method, ExcludeClassInterceptors.class, new ExcludeClassInterceptorsImpl());
/*      */       }
/*      */ 
/* 1341 */       matches = false;
/* 1342 */       addedAnnotations = true;
/*      */     }
/*      */ 
/* 1346 */     return addedAnnotations;
/*      */   }
/*      */ 
/*      */   private void addEjbAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean)
/*      */     throws Exception
/*      */   {
/* 1352 */     if (enterpriseBean != null)
/*      */     {
/* 1354 */       if ((enterpriseBean instanceof JBossSessionBeanMetaData))
/*      */       {
/* 1356 */         addHomeAnnotations(container, (JBossSessionBeanMetaData)enterpriseBean);
/*      */ 
/* 1358 */         addJndiAnnotations(container, (JBossSessionBeanMetaData)enterpriseBean);
/*      */       }
/*      */ 
/* 1361 */       addInterceptorMethodAnnotations(container, enterpriseBean);
/*      */ 
/* 1363 */       handleResourceRefs(container, enterpriseBean.getResourceReferences());
/*      */ 
/* 1365 */       addMessageDestinationAnnotations(container, enterpriseBean.getMessageDestinationReferences());
/*      */ 
/* 1367 */       addSecurityIdentityAnnotation(container, enterpriseBean.getSecurityIdentity());
/*      */ 
/* 1369 */       addDependencies(container, enterpriseBean);
/*      */ 
/* 1371 */       addPoolAnnotations(container, enterpriseBean);
/*      */ 
/* 1373 */       addXmlAnnotations(container, enterpriseBean);
/*      */ 
/* 1375 */       if ((enterpriseBean instanceof JBossSessionBeanMetaData))
/*      */       {
/* 1377 */         addConcurrentAnnotations(container, (JBossSessionBeanMetaData)enterpriseBean);
/* 1378 */         addClusterAnnotations(container, (JBossSessionBeanMetaData)enterpriseBean);
/* 1379 */         addCacheAnnotations(container, (JBossSessionBeanMetaData)enterpriseBean);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addConcurrentAnnotations(EJBContainer container, JBossSessionBeanMetaData enterpriseBean)
/*      */     throws Exception
/*      */   {
/* 1387 */     if (enterpriseBean.isConcurrent() != null)
/*      */     {
/* 1389 */       if (enterpriseBean.isConcurrent().booleanValue())
/*      */       {
/* 1391 */         SerializedConcurrentAccessImpl annotation = new SerializedConcurrentAccessImpl();
/* 1392 */         addClassAnnotation(container, SerializedConcurrentAccess.class, annotation);
/*      */       }
/*      */       else
/*      */       {
/* 1396 */         container.getAnnotations().disableAnnotation(SerializedConcurrentAccess.class.getName());
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addPoolAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean)
/*      */     throws Exception
/*      */   {
/* 1404 */     if (enterpriseBean.getPoolConfig() != null)
/*      */     {
/* 1406 */       PoolConfigMetaData config = enterpriseBean.getPoolConfig();
/*      */ 
/* 1408 */       PoolImpl poolAnnotation = new PoolImpl();
/*      */ 
/* 1410 */       if ((config.getValue() != null) && (!config.getValue().trim().equals(""))) {
/* 1411 */         poolAnnotation.setValue(config.getValue());
/*      */       }
/*      */ 
/* 1414 */       if ((config.getValue() == null) || (config.getValue().trim().equals("")))
/*      */       {
/* 1417 */         poolAnnotation.setValue("ThreadlocalPool");
/*      */       }
/*      */ 
/* 1420 */       if (config.getMaxSize() != null) {
/* 1421 */         poolAnnotation.setMaxSize(config.getMaxSize().intValue());
/*      */       }
/* 1423 */       if (config.getTimeout() != null) {
/* 1424 */         poolAnnotation.setTimeout(config.getTimeout().intValue());
/*      */       }
/* 1426 */       addClassAnnotation(container, Pool.class, poolAnnotation);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addXmlAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean)
/*      */     throws Exception
/*      */   {
/* 1433 */     AnnotationsMetaData annotations = enterpriseBean.getAnnotations();
/* 1434 */     if (annotations == null) {
/* 1435 */       return;
/*      */     }
/* 1437 */     for (AnnotationMetaData xmlAnnotation : annotations)
/*      */     {
/* 1439 */       Class annotationClass = this.di.getClassLoader().loadClass(xmlAnnotation.getAnnotationClass());
/* 1440 */       Class annotationImplementationClass = this.di.getClassLoader().loadClass(xmlAnnotation.getAnnotationImplementationClass());
/* 1441 */       Annotation annotation = (Annotation)annotationImplementationClass.newInstance();
/*      */ 
/* 1443 */       AnnotationPropertiesMetaData properties = xmlAnnotation.getProperties();
/* 1444 */       if (properties != null)
/*      */       {
/* 1446 */         for (AnnotationPropertyMetaData property : properties)
/*      */         {
/* 1448 */           Field field = annotationImplementationClass.getDeclaredField(property.getName());
/* 1449 */           setAnnotationPropertyField(field, annotation, property.getPropertyValue());
/*      */         }
/*      */       }
/*      */ 
/* 1453 */       if (xmlAnnotation.getInjectionTarget() == null)
/*      */       {
/* 1455 */         addClassAnnotation(container, annotationClass, annotation);
/*      */       }
/*      */       else
/*      */       {
/* 1459 */         MethodMetaData method = new MethodMetaData();
/* 1460 */         method.setMethodName(xmlAnnotation.getInjectionTarget().getInjectionTargetName());
/* 1461 */         addAnnotations(annotationClass, annotation, container, method);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void setAnnotationPropertyField(Field field, Object annotation, String value)
/*      */     throws Exception
/*      */   {
/* 1470 */     if (field.getType() == String.class)
/* 1471 */       field.set(annotation, value);
/* 1472 */     else if ((field.getType() == Long.class) || (field.getType() == Long.TYPE))
/* 1473 */       field.setLong(annotation, Long.parseLong(value));
/* 1474 */     else if ((field.getType() == Integer.class) || (field.getType() == Integer.TYPE))
/* 1475 */       field.setInt(annotation, Integer.parseInt(value));
/* 1476 */     else if (field.getType() == Class.class)
/* 1477 */       field.set(annotation, this.di.getClassLoader().loadClass(value));
/* 1478 */     else if ((field.getType() == Boolean.class) || (field.getType() == Boolean.TYPE))
/* 1479 */       field.setBoolean(annotation, Boolean.parseBoolean(value));
/*      */     else
/* 1481 */       throw new IllegalArgumentException("unsupported field type " + field.getType() + " on field " + field);
/*      */   }
/*      */ 
/*      */   private void addCacheAnnotations(EJBContainer container, JBossSessionBeanMetaData enterpriseBean)
/*      */     throws Exception
/*      */   {
/* 1487 */     if (enterpriseBean.getCacheConfig() != null)
/*      */     {
/* 1489 */       CacheConfigMetaData config = enterpriseBean.getCacheConfig();
/* 1490 */       if ((config.getValue() != null) && (!config.getValue().equals("")))
/*      */       {
/* 1492 */         String cacheValue = config.getValue();
/* 1493 */         CacheImpl cacheAnnotation = new CacheImpl(cacheValue);
/* 1494 */         addClassAnnotation(container, Cache.class, cacheAnnotation);
/*      */ 
/* 1498 */         if (cacheValue.equals("SimpleStatefulCache"))
/*      */         {
/* 1500 */           if (!this.ejbClass.isAnnotationPresent(PersistenceManager.class))
/*      */           {
/* 1502 */             PersistenceManagerImpl persistenceAnnotation = new PersistenceManagerImpl();
/* 1503 */             if (config.getPersistenceManager() != null)
/*      */             {
/* 1505 */               persistenceAnnotation.setValue(config.getPersistenceManager());
/*      */             }
/* 1507 */             addClassAnnotation(container, PersistenceManager.class, persistenceAnnotation);
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/* 1512 */       if (config.getName() != null)
/*      */       {
/* 1514 */         CacheConfigImpl configAnnotation = new CacheConfigImpl();
/*      */ 
/* 1516 */         configAnnotation.setName(config.getName());
/*      */ 
/* 1518 */         if (config.getMaxSize() != null) {
/* 1519 */           configAnnotation.setMaxSize(config.getMaxSize().intValue());
/*      */         }
/* 1521 */         if (config.getIdleTimeoutSeconds() != null) {
/* 1522 */           configAnnotation.setIdleTimeoutSeconds(config.getIdleTimeoutSeconds().intValue());
/*      */         }
/* 1524 */         if (config.getReplicationIsPassivation() != null) {
/* 1525 */           configAnnotation.setReplicationIsPassivation(Boolean.parseBoolean(config.getReplicationIsPassivation()));
/*      */         }
/* 1527 */         if (config.getRemoveTimeoutSeconds() != null) {
/* 1528 */           configAnnotation.setRemovalTimeoutSeconds(config.getRemoveTimeoutSeconds().intValue());
/*      */         }
/* 1530 */         CacheConfig existingConfig = (CacheConfig)this.ejbClass.getAnnotation(CacheConfig.class);
/* 1531 */         if (existingConfig != null) {
/* 1532 */           configAnnotation.merge(existingConfig);
/*      */         }
/* 1534 */         addClassAnnotation(container, CacheConfig.class, configAnnotation);
/*      */       }
/*      */       else
/*      */       {
/* 1538 */         CacheConfigImpl configAnnotation = new CacheConfigImpl();
/*      */ 
/* 1540 */         if (config.getMaxSize() != null) {
/* 1541 */           configAnnotation.setMaxSize(config.getMaxSize().intValue());
/*      */         }
/* 1543 */         if (config.getIdleTimeoutSeconds() != null) {
/* 1544 */           configAnnotation.setIdleTimeoutSeconds(config.getIdleTimeoutSeconds().intValue());
/*      */         }
/* 1546 */         if (config.getRemoveTimeoutSeconds() != null) {
/* 1547 */           configAnnotation.setRemovalTimeoutSeconds(config.getRemoveTimeoutSeconds().intValue());
/*      */         }
/* 1549 */         CacheConfig existingConfig = (CacheConfig)this.ejbClass.getAnnotation(CacheConfig.class);
/* 1550 */         if (existingConfig != null) {
/* 1551 */           configAnnotation.merge(existingConfig);
/*      */         }
/* 1553 */         addClassAnnotation(container, CacheConfig.class, configAnnotation);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addClusterAnnotations(EJBContainer container, JBossSessionBeanMetaData enterpriseBean)
/*      */     throws Exception
/*      */   {
/* 1562 */     if (!enterpriseBean.isClustered())
/*      */     {
/* 1565 */       Clustered existingAnnotation = (Clustered)this.ejbClass.getAnnotation(Clustered.class);
/* 1566 */       if (existingAnnotation != null)
/* 1567 */         container.getAnnotations().disableAnnotation(Clustered.class.getName());
/* 1568 */       return;
/*      */     }
/*      */ 
/* 1571 */     ClusterConfigMetaData config = enterpriseBean.getClusterConfig();
/* 1572 */     if (config != null)
/*      */     {
/* 1574 */       ClusteredImpl clusteredAnnotation = new ClusteredImpl();
/*      */ 
/* 1576 */       if (config.getBeanLoadBalancePolicy() != null)
/*      */       {
/* 1578 */         Class policy = this.di.getClassLoader().loadClass(config.getBeanLoadBalancePolicy());
/*      */ 
/* 1580 */         clusteredAnnotation.setLoadBalancePolicy(policy);
/*      */       }
/*      */ 
/* 1583 */       if (config.getHomeLoadBalancePolicy() != null)
/*      */       {
/* 1585 */         Class policy = this.di.getClassLoader().loadClass(config.getHomeLoadBalancePolicy());
/*      */ 
/* 1587 */         clusteredAnnotation.setHomeLoadBalancePolicy(policy);
/*      */       }
/*      */ 
/* 1590 */       if (config.getPartitionName() != null)
/*      */       {
/* 1592 */         clusteredAnnotation.setPartition(config.getPartitionName());
/*      */       }
/*      */ 
/* 1595 */       addClassAnnotation(container, Clustered.class, clusteredAnnotation);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addDependencies(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean)
/*      */     throws Exception
/*      */   {
/* 1602 */     Set depends = enterpriseBean.getDepends();
/* 1603 */     if ((depends != null) && (depends.size() > 0))
/*      */     {
/* 1605 */       DependsImpl annotation = new DependsImpl();
/* 1606 */       Iterator dependencies = enterpriseBean.getDepends().iterator();
/*      */ 
/* 1608 */       while (dependencies.hasNext())
/*      */       {
/* 1610 */         annotation.addDependency((String)dependencies.next());
/*      */       }
/*      */ 
/* 1613 */       addClassAnnotation(container, Depends.class, annotation);
/*      */     }
/*      */ 
/* 1616 */     if (enterpriseBean.getIgnoreDependency() != null)
/*      */     {
/* 1618 */       for (ResourceInjectionTargetMetaData ignore : enterpriseBean.getIgnoreDependency().getInjectionTargets())
/*      */       {
/* 1620 */         IgnoreDependencyImpl annotation = new IgnoreDependencyImpl();
/*      */ 
/* 1622 */         MethodMetaData method = new MethodMetaData();
/* 1623 */         method.setMethodName(ignore.getInjectionTargetName());
/*      */ 
/* 1625 */         addAnnotations(IgnoreDependency.class, annotation, container, method);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addServiceAnnotations(EJBContainer container, JBossServiceBeanMetaData service)
/*      */     throws ClassNotFoundException
/*      */   {
/* 1633 */     if (service == null) {
/* 1634 */       return;
/*      */     }
/* 1636 */     String management = service.getManagement();
/*      */ 
/* 1638 */     if (management != null)
/*      */     {
/* 1640 */       ManagementImpl annotation = new ManagementImpl(this.di.getClassLoader().loadClass(management));
/* 1641 */       addClassAnnotation(container, Management.class, annotation);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addConsumerAnnotations(EJBContainer container, JBossConsumerBeanMetaData consumer)
/*      */     throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException
/*      */   {
/* 1649 */     if (consumer == null) {
/* 1650 */       return;
/*      */     }
/* 1652 */     if ((consumer.getProducers().size() > 0) || (consumer.getLocalProducers().size() > 0))
/*      */     {
/* 1655 */       ProducersImpl producersAnnotation = new ProducersImpl();
/*      */ 
/* 1657 */       for (ProducerMetaData producer : consumer.getProducers())
/*      */       {
/* 1659 */         ProducerImpl annotation = new ProducerImpl(this.di.getClassLoader().loadClass(producer.getClassName()));
/*      */ 
/* 1661 */         if (producer.getConnectionFactory() != null)
/* 1662 */           annotation.setConnectionFactory(producer.getConnectionFactory());
/* 1663 */         producersAnnotation.addProducer(annotation);
/*      */       }
/*      */ 
/* 1666 */       for (ProducerMetaData producer : consumer.getLocalProducers())
/*      */       {
/* 1668 */         ProducerImpl annotation = new ProducerImpl(this.di.getClassLoader().loadClass(producer.getClassName()));
/*      */ 
/* 1670 */         if (producer.getConnectionFactory() != null)
/* 1671 */           annotation.setConnectionFactory(producer.getConnectionFactory());
/* 1672 */         producersAnnotation.addProducer(annotation);
/*      */       }
/* 1674 */       addClassAnnotation(container, Producers.class, producersAnnotation);
/*      */     }
/*      */ 
/* 1677 */     MethodAttributesMetaData currentMessage = consumer.getCurrentMessage();
/*      */     CurrentMessageImpl annotation;
/* 1679 */     if (currentMessage != null)
/*      */     {
/* 1681 */       annotation = new CurrentMessageImpl();
/* 1682 */       for (MethodAttributeMetaData method : currentMessage)
/*      */       {
/* 1684 */         addAnnotations(CurrentMessage.class, annotation, container, method);
/*      */       }
/*      */     }
/*      */ 
/* 1688 */     List propertiesList = consumer.getMessageProperties();
/* 1689 */     if (propertiesList != null)
/*      */     {
/* 1691 */       for (MessagePropertiesMetaData properties : propertiesList)
/*      */       {
/* 1693 */         MessagePropertiesImpl annotation = new MessagePropertiesImpl();
/*      */ 
/* 1695 */         String delivery = properties.getDelivery();
/* 1696 */         if ((delivery != null) && (delivery.equals("Persistent")))
/* 1697 */           annotation.setDelivery(DeliveryMode.PERSISTENT);
/*      */         else {
/* 1699 */           annotation.setDelivery(DeliveryMode.NON_PERSISTENT);
/*      */         }
/* 1701 */         Integer priority = properties.getPriority();
/* 1702 */         if (priority != null) {
/* 1703 */           annotation.setDelivery(DeliveryMode.PERSISTENT);
/*      */         }
/* 1705 */         String interfac = properties.getClassName();
/* 1706 */         if (interfac != null)
/*      */         {
/* 1708 */           Class clazz = this.di.getClassLoader().loadClass(interfac);
/* 1709 */           annotation.setInterface(clazz);
/*      */         }
/*      */ 
/* 1712 */         MethodAttributeMetaData method = properties.getMethod();
/* 1713 */         addAnnotations(MessageProperties.class, annotation, container, method);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addJndiAnnotations(EJBContainer container, JBossSessionBeanMetaData enterpriseBean)
/*      */     throws ClassNotFoundException
/*      */   {
/* 1721 */     addLocalJndiAnnotations(container, enterpriseBean);
/* 1722 */     addRemoteJndiAnnotations(container, enterpriseBean);
/*      */   }
/*      */ 
/*      */   private void addLocalJndiAnnotations(EJBContainer container, JBossSessionBeanMetaData enterpriseBean)
/*      */     throws ClassNotFoundException
/*      */   {
/* 1728 */     String localJndiName = enterpriseBean.getLocalJndiName();
/* 1729 */     if (localJndiName != null)
/*      */     {
/* 1731 */       LocalBindingImpl localBinding = new LocalBindingImpl(localJndiName);
/* 1732 */       addClassAnnotation(container, LocalBinding.class, localBinding);
/*      */     }
/*      */ 
/* 1735 */     String localHomeJndiName = enterpriseBean.getLocalHomeJndiName();
/* 1736 */     if (localHomeJndiName != null)
/*      */     {
/* 1738 */       LocalHomeBindingImpl localHomeBinding = new LocalHomeBindingImpl(localHomeJndiName);
/* 1739 */       addClassAnnotation(container, LocalHomeBinding.class, localHomeBinding);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addRemoteJndiAnnotations(EJBContainer container, JBossSessionBeanMetaData enterpriseBean)
/*      */     throws ClassNotFoundException
/*      */   {
/* 1746 */     String homeJndiName = enterpriseBean.getHomeJndiName();
/* 1747 */     if ((homeJndiName != null) && (!homeJndiName.trim().equals("")))
/*      */     {
/* 1749 */       RemoteHomeBindingImpl homeBinding = new RemoteHomeBindingImpl(homeJndiName);
/* 1750 */       addClassAnnotation(container, RemoteHomeBinding.class, homeBinding);
/*      */     }
/*      */ 
/* 1755 */     String jndiName = enterpriseBean.getJndiName();
/* 1756 */     if ((jndiName != null) && (!jndiName.trim().equals("")))
/*      */     {
/* 1758 */       RemoteBindingImpl remoteBindingAnnotation = new RemoteBindingImpl();
/* 1759 */       remoteBindingAnnotation.setJndiBinding(jndiName);
/* 1760 */       addClassAnnotation(container, RemoteBinding.class, remoteBindingAnnotation);
/* 1761 */       log.debug("Adding " + RemoteBinding.class.getName() + " to " + container.toString() + ": " + remoteBindingAnnotation.toString());
/*      */ 
/* 1763 */       return;
/*      */     }
/*      */ 
/* 1766 */     List bindingsList = enterpriseBean.getRemoteBindings();
/* 1767 */     if ((bindingsList == null) || (bindingsList.size() == 0))
/*      */     {
/* 1769 */       addSimpleJndiAnnotations(container, enterpriseBean);
/* 1770 */       return;
/*      */     }
/*      */ 
/* 1773 */     AnnotationRepository annotations = container.getAnnotations();
/*      */ 
/* 1775 */     annotations.disableAnnotation(RemoteBinding.class.getName());
/*      */ 
/* 1777 */     List bindingAnnotationsList = new ArrayList();
/*      */ 
/* 1779 */     for (RemoteBindingMetaData binding : bindingsList)
/*      */     {
/* 1781 */       RemoteBindingImpl bindingAnnotation = new RemoteBindingImpl();
/*      */ 
/* 1783 */       if (binding.getJndiName() != null) {
/* 1784 */         bindingAnnotation.setJndiBinding(binding.getJndiName());
/*      */       }
/* 1786 */       if (binding.getClientBindUrl() != null) {
/* 1787 */         bindingAnnotation.setBindUrl(binding.getClientBindUrl());
/*      */       }
/* 1789 */       if (binding.getInterceptorStack() != null) {
/* 1790 */         bindingAnnotation.setStack(binding.getInterceptorStack());
/*      */       }
/* 1792 */       if (binding.getProxyFactory() != null) {
/* 1793 */         bindingAnnotation.setFactory(binding.getProxyFactory());
/*      */       }
/* 1795 */       bindingAnnotationsList.add(bindingAnnotation);
/*      */     }
/*      */ 
/* 1799 */     RemoteBindingsImpl bindingsAnnotation = new RemoteBindingsImpl(bindingAnnotationsList);
/* 1800 */     addClassAnnotation(container, RemoteBindings.class, bindingsAnnotation);
/*      */   }
/*      */ 
/*      */   private void addSimpleJndiAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean)
/*      */     throws ClassNotFoundException
/*      */   {
/* 1806 */     RemoteBindingImpl remoteBinding = null;
/*      */ 
/* 1808 */     String jndiName = enterpriseBean.getMappedName();
/* 1809 */     if (jndiName != null)
/*      */     {
/* 1811 */       remoteBinding = new RemoteBindingImpl();
/* 1812 */       remoteBinding.setJndiBinding(jndiName);
/* 1813 */       addClassAnnotation(container, RemoteBinding.class, remoteBinding);
/*      */     }
/*      */ 
/* 1816 */     if (remoteBinding != null)
/*      */     {
/* 1818 */       RemoteBinding existingBinding = (RemoteBinding)this.ejbClass.getAnnotation(RemoteBinding.class);
/* 1819 */       if (existingBinding != null) {
/* 1820 */         remoteBinding.merge(existingBinding);
/*      */       }
/* 1822 */       addClassAnnotation(container, RemoteBinding.class, remoteBinding);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void handleResourceRefs(EJBContainer container, ResourceReferencesMetaData resourceRefList)
/*      */   {
/* 1828 */     if (resourceRefList == null) {
/* 1829 */       return;
/*      */     }
/* 1831 */     for (ResourceReferenceMetaData ref : resourceRefList)
/*      */     {
/* 1833 */       if (ref.getResourceName() != null)
/*      */       {
/* 1836 */         ResourceManagerMetaData resourceManager = this.dd.getResourceManager(ref.getResourceName());
/* 1837 */         if (resourceManager != null)
/*      */         {
/* 1839 */           ref.setJndiName(resourceManager.getResJndiName());
/* 1840 */           ref.setMappedName(resourceManager.getResJndiName());
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addMessageDestinationAnnotations(EJBContainer container, MessageDestinationReferencesMetaData refs)
/*      */   {
/* 1848 */     if (refs == null) {
/* 1849 */       return;
/*      */     }
/* 1851 */     for (MessageDestinationReferenceMetaData ref : refs)
/*      */     {
/* 1853 */       if ((ref.getMappedName() == null) || (ref.getMappedName().equals("")))
/*      */       {
/* 1855 */         JBossAssemblyDescriptorMetaData descriptor = this.dd.getAssemblyDescriptor();
/* 1856 */         if (descriptor != null)
/*      */         {
/* 1858 */           MessageDestinationMetaData destination = descriptor.getMessageDestination(ref.getLink());
/* 1859 */           if (destination != null)
/*      */           {
/* 1861 */             ref.setMappedName(destination.getJndiName());
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addInterceptorMethodAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean)
/*      */   {
/* 1871 */     if ((enterpriseBean instanceof JBossSessionBeanMetaData))
/*      */     {
/* 1873 */       JBossSessionBeanMetaData sessionBean = (JBossSessionBeanMetaData)enterpriseBean;
/* 1874 */       addInterceptorMethodAnnotation(container, enterpriseBean, sessionBean.getAroundInvokes(), AroundInvoke.class, "around-invoke-method");
/*      */ 
/* 1877 */       addInterceptorMethodAnnotation(container, enterpriseBean, sessionBean.getPostConstructs(), PostConstruct.class, "post-construct-method");
/*      */ 
/* 1880 */       addInterceptorMethodAnnotation(container, enterpriseBean, sessionBean.getPostActivates(), PostActivate.class, "post-activate-method");
/*      */ 
/* 1883 */       addInterceptorMethodAnnotation(container, enterpriseBean, sessionBean.getPrePassivates(), PrePassivate.class, "pre-passivate-method");
/*      */ 
/* 1886 */       addInterceptorMethodAnnotation(container, enterpriseBean, sessionBean.getPreDestroys(), PreDestroy.class, "pre-destroy-method");
/*      */     }
/* 1890 */     else if ((enterpriseBean instanceof JBossMessageDrivenBeanMetaData))
/*      */     {
/* 1892 */       JBossMessageDrivenBeanMetaData messageDriven = (JBossMessageDrivenBeanMetaData)enterpriseBean;
/* 1893 */       addInterceptorMethodAnnotation(container, enterpriseBean, messageDriven.getAroundInvokes(), AroundInvoke.class, "around-invoke-method");
/*      */ 
/* 1896 */       addInterceptorMethodAnnotation(container, enterpriseBean, messageDriven.getPostConstructs(), PostConstruct.class, "post-construct-method");
/*      */ 
/* 1899 */       addInterceptorMethodAnnotation(container, enterpriseBean, messageDriven.getPreDestroys(), PreDestroy.class, "pre-destroy-method");
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addInterceptorMethodAnnotation(EJBContainer container, Class<?> cls, String methodName, Class<? extends Annotation> ann, String xmlName)
/*      */   {
/* 1907 */     Method found = null;
/* 1908 */     for (Method rm : cls.getDeclaredMethods())
/*      */     {
/* 1910 */       if (!rm.getName().equals(methodName))
/*      */         continue;
/* 1912 */       if (ann == AroundInvoke.class)
/*      */       {
/* 1914 */         if (!InterceptorInfoRepository.checkValidBusinessSignature(rm))
/*      */           continue;
/* 1916 */         found = rm;
/* 1917 */         break;
/*      */       }
/*      */ 
/* 1921 */       if (!InterceptorInfoRepository.checkValidBeanLifecycleSignature(rm)) {
/*      */         continue;
/*      */       }
/* 1924 */       found = rm;
/* 1925 */       break;
/*      */     }
/*      */ 
/* 1931 */     if (found == null)
/*      */     {
/* 1933 */       log.warn("No method found within " + cls.getName() + " with name " + methodName + " with the right signature for " + xmlName + "was found");
/*      */ 
/* 1936 */       return;
/*      */     }
/*      */ 
/* 1939 */     if (container.resolveAnnotation(found, ann) == null)
/*      */     {
/* 1941 */       log.debug("adding " + ann.getName() + " method annotation to " + found);
/*      */ 
/* 1944 */       container.getAnnotations().addAnnotation(found, ann, getInterceptorImpl(ann));
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addInterceptorMethodAnnotation(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, AroundInvokesMetaData callbacks, Class<? extends Annotation> ann, String xmlName)
/*      */   {
/* 1951 */     if (callbacks == null) {
/* 1952 */       return;
/*      */     }
/* 1954 */     for (AroundInvokeMetaData callback : callbacks)
/*      */     {
/* 1956 */       Class callbackClass = loadClass(container, callback.getClassName());
/*      */ 
/* 1958 */       addInterceptorMethodAnnotation(container, callbackClass, callback.getMethodName(), ann, xmlName);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addInterceptorMethodAnnotation(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, LifecycleCallbacksMetaData callbacks, Class<? extends Annotation> ann, String xmlName)
/*      */   {
/* 1965 */     if (callbacks == null) {
/* 1966 */       return;
/*      */     }
/* 1968 */     for (LifecycleCallbackMetaData callback : callbacks)
/*      */     {
/* 1970 */       Class callbackClass = loadClass(container, callback.getClassName());
/*      */ 
/* 1972 */       addInterceptorMethodAnnotation(container, callbackClass, callback.getMethodName(), ann, xmlName);
/*      */     }
/*      */   }
/*      */ 
/*      */   private Object getInterceptorImpl(Class<?> ann)
/*      */   {
/* 1978 */     if (ann == AroundInvoke.class)
/*      */     {
/* 1980 */       return new AroundInvokeImpl();
/* 1981 */     }if (ann == PostConstruct.class)
/*      */     {
/* 1983 */       return new PostConstructImpl();
/* 1984 */     }if (ann == PostActivate.class)
/*      */     {
/* 1986 */       return new PostActivateImpl();
/* 1987 */     }if (ann == PrePassivate.class)
/*      */     {
/* 1989 */       return new PrePassivateImpl();
/* 1990 */     }if (ann == PreDestroy.class)
/*      */     {
/* 1992 */       return new PreDestroyImpl();
/*      */     }
/*      */ 
/* 1995 */     return null;
/*      */   }
/*      */ 
/*      */   private void addSecurityIdentityAnnotation(EJBContainer container, SecurityIdentityMetaData identity)
/*      */   {
/* 2001 */     if ((identity != null) && (!identity.isUseCallerId()))
/*      */     {
/* 2003 */       RunAsMetaData runAs = identity.getRunAs();
/* 2004 */       RunAsImpl annotation = null;
/* 2005 */       if (runAs != null)
/*      */       {
/* 2007 */         annotation = new RunAsImpl(runAs.getRoleName());
/* 2008 */         addClassAnnotation(container, annotation.annotationType(), annotation);
/*      */       }
/*      */ 
/* 2012 */       String runAsPrincipal = identity.getRunAsPrincipal();
/* 2013 */       if (runAsPrincipal != null)
/*      */       {
/* 2015 */         RunAsPrincipalImpl principalAnnotation = new RunAsPrincipalImpl(runAsPrincipal);
/* 2016 */         addClassAnnotation(container, principalAnnotation.annotationType(), principalAnnotation);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void overrideAnnotations(EJBContainer container, Member m, String annotation, Object value)
/*      */   {
/* 2025 */     AnnotationRepository annotations = container.getAnnotations();
/*      */ 
/* 2027 */     if ((value instanceof DenyAll))
/*      */     {
/* 2029 */       annotations.disableAnnotation(m, PermitAll.class.getName());
/*      */ 
/* 2031 */       annotations.disableAnnotation(m, RolesAllowed.class.getName());
/*      */     }
/* 2033 */     else if ((value instanceof PermitAll))
/*      */     {
/* 2035 */       annotations.disableAnnotation(m, DenyAll.class.getName());
/*      */ 
/* 2037 */       annotations.disableAnnotation(m, RolesAllowed.class.getName());
/*      */     }
/* 2039 */     else if ((value instanceof RolesAllowed))
/*      */     {
/* 2041 */       annotations.disableAnnotation(m, PermitAll.class.getName());
/*      */ 
/* 2043 */       annotations.disableAnnotation(m, DenyAll.class.getName());
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addClassAnnotation(EJBContainer container, Class<? extends Annotation> annotationClass, Annotation annotation)
/*      */   {
/* 2050 */     log.debug("adding class annotation " + annotationClass.getName() + " to " + container + " " + annotation);
/*      */ 
/* 2052 */     container.getAnnotations().addClassAnnotation(annotationClass, annotation);
/*      */   }
/*      */ 
/*      */   private <A extends Annotation> void addAnnotations(Class<A> annotationClass, A annotation, EJBContainer container, MethodAttributeMetaData method)
/*      */   {
/* 2058 */     addAnnotations(annotationClass, annotation, container, method.getMethodName(), null);
/*      */   }
/*      */ 
/*      */   private void addAnnotations(Class<? extends Annotation> annotationClass, Annotation annotation, EJBContainer container, String methodName, MethodParametersMetaData params)
/*      */   {
/*      */     try
/*      */     {
/* 2065 */       AnnotationRepository annotations = container.getAnnotations();
/* 2066 */       if (methodName.equals("*"))
/*      */       {
/* 2068 */         log.debug("adding " + annotationClass.getName() + " annotation to " + this.ejbClass.getName() + "." + methodName);
/*      */ 
/* 2071 */         for (Method declaredMethod : this.ejbClass.getDeclaredMethods())
/*      */         {
/* 2074 */           annotations.addAnnotation(declaredMethod, annotationClass, annotation);
/*      */ 
/* 2076 */           overrideAnnotations(container, declaredMethod, annotationClass.getName(), annotation);
/*      */         }
/*      */ 
/*      */       }
/* 2081 */       else if (params == null)
/*      */       {
/* 2083 */         Method[] methods = this.ejbClass.getMethods();
/* 2084 */         boolean foundMethod = false;
/* 2085 */         for (int methodIndex = 0; methodIndex < methods.length; methodIndex++)
/*      */         {
/* 2087 */           if (!methods[methodIndex].getName().equals(methodName))
/*      */             continue;
/* 2089 */           log.debug("adding " + annotationClass.getName() + " method annotation to " + methods[methodIndex]);
/*      */ 
/* 2091 */           annotations.addAnnotation(methods[methodIndex], annotationClass, annotation);
/*      */ 
/* 2093 */           overrideAnnotations(container, methods[methodIndex], annotationClass.getName(), annotation);
/*      */ 
/* 2095 */           foundMethod = true;
/*      */         }
/*      */ 
/* 2100 */         if (!foundMethod)
/*      */         {
/* 2102 */           methods = this.ejbClass.getDeclaredMethods();
/* 2103 */           for (int methodIndex = 0; methodIndex < methods.length; methodIndex++)
/*      */           {
/* 2105 */             if (!methods[methodIndex].getName().equals(methodName))
/*      */               continue;
/* 2107 */             log.debug("adding " + annotationClass.getName() + " method annotation to " + methods[methodIndex]);
/*      */ 
/* 2109 */             annotations.addAnnotation(methods[methodIndex], annotationClass, annotation);
/*      */ 
/* 2111 */             overrideAnnotations(container, methods[methodIndex], annotationClass.getName(), annotation);
/*      */ 
/* 2113 */             foundMethod = true;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 2119 */         if (!foundMethod)
/*      */         {
/* 2121 */           Field member = this.ejbClass.getDeclaredField(methodName);
/*      */ 
/* 2123 */           if (member != null)
/*      */           {
/* 2125 */             log.debug("adding " + annotationClass.getName() + " field annotation to " + member);
/*      */ 
/* 2127 */             annotations.addAnnotation(member, annotationClass, annotation);
/*      */ 
/* 2129 */             overrideAnnotations(container, member, annotationClass.getName(), annotation);
/*      */           }
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 2135 */         Class[] methodSignature = new Class[params.size()];
/* 2136 */         int paramIndex = 0;
/* 2137 */         for (String param : params)
/*      */         {
/* 2139 */           Class paramClass = null;
/* 2140 */           if (param.equals("boolean"))
/* 2141 */             paramClass = Boolean.TYPE;
/* 2142 */           else if (param.equals("int"))
/* 2143 */             paramClass = Integer.TYPE;
/* 2144 */           else if (param.equals("long"))
/* 2145 */             paramClass = Long.TYPE;
/* 2146 */           else if (param.equals("short"))
/* 2147 */             paramClass = Short.TYPE;
/* 2148 */           else if (param.equals("byte"))
/* 2149 */             paramClass = Byte.TYPE;
/* 2150 */           else if (param.equals("char"))
/* 2151 */             paramClass = Character.TYPE;
/*      */           else
/* 2153 */             paramClass = this.di.getClassLoader().loadClass(param);
/* 2154 */           methodSignature[(paramIndex++)] = paramClass;
/*      */         }
/* 2156 */         if (log.isTraceEnabled())
/* 2157 */           log.trace("Looking for method " + methodName + Arrays.toString(methodSignature) + " on class " + this.ejbClass);
/* 2158 */         Member member = ClassHelper.getPrivateMethod(this.ejbClass, methodName, methodSignature);
/* 2159 */         log.debug("adding " + annotationClass.getName() + " method annotation to " + member);
/*      */ 
/* 2161 */         annotations.addAnnotation(member, annotationClass, annotation);
/* 2162 */         overrideAnnotations(container, member, annotationClass.getName(), annotation);
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 2169 */       throw new RuntimeException("Unable to create annotation for method/field " + methodName + " for EJB " + container.getEjbName(), e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addAnnotations(Class<? extends Annotation> annotationClass, Annotation annotation, EJBContainer container, NamedMethodMetaData method)
/*      */   {
/* 2175 */     addAnnotations(annotationClass, annotation, container, method.getMethodName(), method.getMethodParams());
/*      */   }
/*      */ 
/*      */   private void addAnnotations(Class<? extends Annotation> annotationClass, Annotation annotation, EJBContainer container, MethodMetaData method)
/*      */     throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException
/*      */   {
/* 2182 */     addAnnotations(annotationClass, annotation, container, method.getMethodName(), method.getMethodParams());
/*      */   }
/*      */ 
/*      */   private boolean hasPublicMethod(Class<?> cls, String methodName)
/*      */   {
/* 2194 */     assert (cls != null) : "cls is null";
/* 2195 */     assert (methodName != null) : "methodName is null";
/*      */ 
/* 2197 */     for (Method m : cls.getMethods())
/*      */     {
/* 2199 */       if (m.getName().equals(methodName)) {
/* 2200 */         return true;
/*      */       }
/*      */     }
/* 2203 */     return false;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*  209 */     log = Logger.getLogger(Ejb3DescriptorHandler.class);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.Ejb3DescriptorHandler
 * JD-Core Version:    0.6.0
 */