/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.rmi.dgc.VMID;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class Ejb3Registry
/*     */ {
/*  40 */   private static final Logger log = Logger.getLogger(Ejb3Registry.class);
/*     */ 
/*  42 */   private static Map<String, Container> containers = new HashMap();
/*  43 */   private static Map<String, Container> clusterContainers = new HashMap();
/*     */ 
/*  45 */   private static final VMID vmid = new VMID();
/*     */ 
/*     */   public static Container findContainer(String oid)
/*     */   {
/*  55 */     return (Container)containers.get(oid);
/*     */   }
/*     */ 
/*     */   public static VMID getVMID()
/*     */   {
/*  60 */     return vmid;
/*     */   }
/*     */ 
/*     */   public static boolean hasContainer(Container container)
/*     */   {
/*  71 */     return hasContainer(oid(container));
/*     */   }
/*     */ 
/*     */   private static boolean hasContainer(String oid)
/*     */   {
/*  82 */     return containers.containsKey(oid);
/*     */   }
/*     */ 
/*     */   private static final String oid(Container container)
/*     */   {
/*  87 */     return container.getObjectName().getCanonicalName();
/*     */   }
/*     */ 
/*     */   public static boolean hasClusterContainer(String oid)
/*     */   {
/*  92 */     return clusterContainers.containsKey(oid);
/*     */   }
/*     */ 
/*     */   public static final String guid(Container container, VMID vmid)
/*     */   {
/*  97 */     return container.getObjectName().getCanonicalName() + ",VMID=" + vmid;
/*     */   }
/*     */ 
/*     */   public static final String guid(Container container)
/*     */   {
/* 102 */     return guid(container, vmid);
/*     */   }
/*     */ 
/*     */   public static final String clusterUid(Container container)
/*     */   {
/* 107 */     if (container.isClustered()) {
/* 108 */       return container.getObjectName().getCanonicalName() + ",Partition=" + ((EJBContainer)container).getPartitionName();
/*     */     }
/* 110 */     return container.getObjectName().getCanonicalName();
/*     */   }
/*     */ 
/*     */   public static final String clusterUid(String oid, String partitionName)
/*     */   {
/* 115 */     return oid + ",Partition=" + partitionName;
/*     */   }
/*     */ 
/*     */   public static void register(Container container)
/*     */   {
/* 126 */     String guid = guid(container);
/* 127 */     if (hasContainer(guid))
/* 128 */       throw new IllegalStateException("Container " + guid + " + is already registered");
/* 129 */     containers.put(guid, container);
/*     */ 
/* 131 */     if (container.isClustered()) {
/* 132 */       clusterContainers.put(clusterUid(container), container);
/*     */     }
/* 134 */     log.debug("Registered container " + guid);
/*     */   }
/*     */ 
/*     */   public static void unregister(Container container)
/*     */   {
/* 145 */     String guid = guid(container);
/* 146 */     if (!hasContainer(guid))
/* 147 */       throw new IllegalStateException("Container " + guid + " + is not registered");
/* 148 */     containers.remove(guid);
/*     */ 
/* 150 */     if (container.isClustered()) {
/* 151 */       clusterContainers.remove(clusterUid(container));
/*     */     }
/* 153 */     log.debug("Unregistered container " + guid);
/*     */   }
/*     */ 
/*     */   public static Container getContainer(String guid)
/*     */   {
/* 166 */     if (!hasContainer(guid)) {
/* 167 */       throw new IllegalStateException("Container " + guid + " is not registered");
/*     */     }
/* 169 */     return (Container)containers.get(guid);
/*     */   }
/*     */ 
/*     */   public static Container getClusterContainer(String clusterUid)
/*     */   {
/* 182 */     Container container = (Container)clusterContainers.get(clusterUid);
/* 183 */     if (container == null) {
/* 184 */       throw new IllegalStateException("Container " + clusterUid + " is not registered " + clusterContainers);
/*     */     }
/* 186 */     return container;
/*     */   }
/*     */ 
/*     */   public static <T extends Container> T getContainer(String oid, Class<T> type)
/*     */   {
/* 202 */     return getContainer(oid);
/*     */   }
/*     */ 
/*     */   public static Collection<Container> getContainers()
/*     */   {
/* 212 */     return Collections.unmodifiableCollection(containers.values());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.Ejb3Registry
 * JD-Core Version:    0.6.0
 */