/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.management.DynamicMBean;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.deployment.DeploymentInfo;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.system.ServiceControllerMBean;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class JmxKernelAbstraction extends JmxClientKernelAbstraction
/*     */   implements KernelAbstraction
/*     */ {
/*  43 */   private static final Logger log = Logger.getLogger(JmxKernelAbstraction.class);
/*     */   private MBeanServer server;
/*     */   private ServiceControllerMBean serviceController;
/*     */   private DeploymentInfo di;
/*     */ 
/*     */   public JmxKernelAbstraction(DeploymentInfo di)
/*     */   {
/*  51 */     super(di.getServer());
/*  52 */     this.server = di.getServer();
/*  53 */     this.serviceController = ((ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, ServiceControllerMBean.OBJECT_NAME, di.getServer()));
/*     */ 
/*  55 */     this.di = di;
/*     */   }
/*     */ 
/*     */   public JmxKernelAbstraction(MBeanServer server)
/*     */   {
/*  60 */     super(server);
/*  61 */     this.serviceController = ((ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, ServiceControllerMBean.OBJECT_NAME, server));
/*     */   }
/*     */ 
/*     */   public void setMbeanServer(MBeanServer server)
/*     */   {
/*  67 */     this.server = server;
/*     */   }
/*     */ 
/*     */   public void install(String name, DependencyPolicy dependencies, Object service)
/*     */   {
/*  73 */     if ((!(service instanceof ServiceMBeanSupport)) && (!(service instanceof DynamicMBean)))
/*     */     {
/*  75 */       log.debug("creating wrapper delegate for: " + service.getClass().getName());
/*     */ 
/*  77 */       service = new ServiceDelegateWrapper(service);
/*     */     }
/*  79 */     JmxDependencyPolicy policy = (JmxDependencyPolicy)dependencies;
/*     */     try
/*     */     {
/*  82 */       log.info("installing MBean: " + name + " with dependencies:");
/*  83 */       for (Iterator i$ = policy.getDependencies().iterator(); i$.hasNext(); ) { Object obj = i$.next();
/*     */ 
/*  85 */         log.info("\t" + obj);
/*     */       }
/*  87 */       ObjectName on = new ObjectName(name);
/*     */ 
/*  89 */       if (policy.getDependencies().contains(on)) {
/*  90 */         throw new IllegalStateException("circular dependencies detected");
/*     */       }
/*  92 */       this.server.registerMBean(service, on);
/*  93 */       addParentDependency(on);
/*     */ 
/*  95 */       this.serviceController.create(on, policy.getDependencies());
/*  96 */       this.serviceController.start(on);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 100 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addParentDependency(ObjectName on)
/*     */   {
/* 112 */     DeploymentInfo parent = this.di;
/* 113 */     while (parent.parent != null)
/*     */     {
/* 115 */       parent = parent.parent;
/*     */     }
/* 117 */     parent.mbeans.add(on);
/*     */   }
/*     */ 
/*     */   private void removeParentDependency(ObjectName on)
/*     */   {
/* 123 */     DeploymentInfo parent = this.di;
/* 124 */     while (parent.parent != null)
/*     */     {
/* 126 */       parent = parent.parent;
/*     */     }
/* 128 */     parent.mbeans.remove(on);
/*     */   }
/*     */ 
/*     */   public void installMBean(ObjectName on, DependencyPolicy dependencies, Object service)
/*     */   {
/* 133 */     JmxDependencyPolicy policy = (JmxDependencyPolicy)dependencies;
/*     */     try
/*     */     {
/* 136 */       this.server.registerMBean(service, on);
/* 137 */       addParentDependency(on);
/* 138 */       this.serviceController.create(on, policy.getDependencies());
/* 139 */       this.serviceController.start(on);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 143 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void uninstallMBean(ObjectName on)
/*     */   {
/*     */     try
/*     */     {
/* 151 */       this.serviceController.stop(on);
/* 152 */       this.serviceController.destroy(on);
/* 153 */       this.serviceController.remove(on);
/* 154 */       removeParentDependency(on);
/* 155 */       if (this.server.isRegistered(on))
/* 156 */         this.server.unregisterMBean(on);
/*     */       else
/* 158 */         log.warn(on + " is not registered");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 162 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void uninstall(String name)
/*     */   {
/*     */     ObjectName on;
/*     */     try {
/* 171 */       on = new ObjectName(name);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 175 */       throw new RuntimeException(e);
/*     */     }
/*     */ 
/* 178 */     uninstallMBean(on);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.JmxKernelAbstraction
 * JD-Core Version:    0.6.0
 */