/*    */ package org.jboss.ejb3;
/*    */ 
/*    */ import javax.management.MBeanServer;
/*    */ import javax.management.MBeanServerConnection;
/*    */ import javax.naming.InitialContext;
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.mx.util.MBeanServerLocator;
/*    */ 
/*    */ public class KernelAbstractionFactory
/*    */ {
/* 36 */   private static final Logger log = Logger.getLogger(KernelAbstractionFactory.class);
/*    */ 
/* 38 */   private static ClientKernelAbstraction clientKernelAbstraction = null;
/* 39 */   private static KernelAbstraction kernelAbstraction = null;
/* 40 */   private static Kernel kernel = null;
/*    */ 
/*    */   public static KernelAbstraction getInstance() throws Exception
/*    */   {
/* 44 */     if (kernelAbstraction == null)
/*    */     {
/* 46 */       MBeanServer mbeanServer = (MBeanServer)getMBeanServer();
/* 47 */       if (kernel != null) {
/* 48 */         kernelAbstraction = new MCKernelAbstraction(kernel, mbeanServer);
/*    */       }
/*    */       else {
/* 51 */         kernelAbstraction = new JmxKernelAbstraction(mbeanServer);
/*    */       }
/*    */     }
/*    */ 
/* 55 */     return kernelAbstraction;
/*    */   }
/*    */ 
/*    */   public static ClientKernelAbstraction getClientInstance() throws Exception
/*    */   {
/* 60 */     if (clientKernelAbstraction == null)
/*    */     {
/* 62 */       if (kernel != null)
/*    */       {
/* 64 */         clientKernelAbstraction = new MCClientKernelAbstraction(kernel);
/*    */       }
/*    */       else
/*    */       {
/* 68 */         MBeanServerConnection mbeanServer = getMBeanServer();
/* 69 */         clientKernelAbstraction = new JmxClientKernelAbstraction(mbeanServer);
/*    */       }
/*    */     }
/*    */ 
/* 73 */     return clientKernelAbstraction;
/*    */   }
/*    */ 
/*    */   public static void setKernel(Kernel k)
/*    */   {
/* 78 */     kernel = k;
/* 79 */     kernelAbstraction = null;
/* 80 */     clientKernelAbstraction = null;
/*    */   }
/*    */ 
/*    */   protected static MBeanServerConnection getMBeanServer() throws Exception
/*    */   {
/*    */     MBeanServerConnection mbeanServer;
/*    */     try
/*    */     {
/* 89 */       mbeanServer = MBeanServerLocator.locateJBoss();
/*    */     }
/*    */     catch (IllegalStateException e)
/*    */     {
/* 93 */       String adaptorName = System.getProperty("jbosstest.server.name", "jmx/invoker/RMIAdaptor");
/* 94 */       mbeanServer = (MBeanServerConnection)InitialContextFactory.getInitialContext().lookup(adaptorName);
/*    */     }
/*    */ 
/* 97 */     return mbeanServer;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.KernelAbstractionFactory
 * JD-Core Version:    0.6.0
 */