/*     */ package org.jboss.ejb3;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBObject;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.util.MethodHashing;
/*     */ import org.jboss.aop.util.PayloadKey;
/*     */ import org.jboss.aspects.asynch.AsynchMixin;
/*     */ import org.jboss.aspects.asynch.AsynchProvider;
/*     */ import org.jboss.aspects.asynch.AsynchProxyInterceptor;
/*     */ import org.jboss.aspects.asynch.FutureHolder;
/*     */ import org.jboss.ejb3.remoting.Proxy;
/*     */ 
/*     */ public class ProxyUtils
/*     */ {
/*  45 */   public static final Class ASYNCH_PROVIDER_CLASS = AsynchProvider.class;
/*     */   public static final long GET_ASYNCHRONOUS;
/*     */   public static final long TO_STRING;
/*     */   public static final long EQUALS;
/*     */   public static final long HASHCODE;
/*     */   public static final Method GET_PRIMARY_KEY;
/*     */   public static final Method GET_HANDLE;
/*     */   public static final Method GET_EJB_HOME;
/*     */   public static final Method IS_IDENTICAL;
/*     */   public static final Method GET_HOME_HANDLE;
/*     */   public static final Method GET_EJB_METADATA;
/*     */   public static final Method REMOVE;
/*     */ 
/*     */   public static boolean isAsynchronous(Class[] infs)
/*     */   {
/*  87 */     for (int i = 0; i < infs.length; i++)
/*     */     {
/*  89 */       if (infs[i] == ASYNCH_PROVIDER_CLASS)
/*     */       {
/*  91 */         return true;
/*     */       }
/*     */     }
/*  94 */     return false;
/*     */   }
/*     */ 
/*     */   public static Class[] addAsynchProviderInterface(Class[] infs)
/*     */   {
/*  99 */     ArrayList interfaces = new ArrayList();
/*     */ 
/* 101 */     for (int i = 0; i < infs.length; i++)
/*     */     {
/* 103 */       if (infs[i] == ASYNCH_PROVIDER_CLASS)
/*     */       {
/*     */         continue;
/*     */       }
/*     */ 
/* 108 */       interfaces.add(infs[i]);
/*     */     }
/*     */ 
/* 111 */     interfaces.add(ASYNCH_PROVIDER_CLASS);
/* 112 */     return (Class[])(Class[])interfaces.toArray(new Class[interfaces.size()]);
/*     */   }
/*     */ 
/*     */   public static Interceptor[] addAsynchProxyInterceptor(AsynchMixin mixin, Interceptor[] interceptors)
/*     */   {
/* 117 */     AsynchProxyInterceptor interceptor = new AsynchProxyInterceptor(mixin);
/* 118 */     Interceptor[] newInterceptors = null;
/* 119 */     newInterceptors = new Interceptor[interceptors.length + 1];
/* 120 */     newInterceptors[0] = interceptor;
/* 121 */     System.arraycopy(interceptors, 0, newInterceptors, 1, interceptors.length);
/* 122 */     return newInterceptors;
/*     */   }
/*     */ 
/*     */   public static void addLocalAsynchronousInfo(MethodInvocation invocation, FutureHolder provider)
/*     */   {
/* 127 */     if (provider != null)
/*     */     {
/* 129 */       invocation.getMetaData().addMetaData("ASYNCH", "INVOKE_ASYNCH", "YES", PayloadKey.AS_IS);
/* 130 */       invocation.getMetaData().addMetaData("ASYNCH", "FUTURE_HOLDER", provider, PayloadKey.AS_IS);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Object handleCallLocally(Object jbproxy, Proxy ih, Method m, Object[] args)
/*     */   {
/* 136 */     long hash = MethodHashing.calculateHash(m);
/* 137 */     return handleCallLocally(hash, jbproxy, ih, m, args);
/*     */   }
/*     */ 
/*     */   public static Object handleCallLocally(long hash, Object jbproxy, Proxy ih, Method m, Object[] args)
/*     */   {
/* 142 */     if (hash == GET_ASYNCHRONOUS)
/*     */     {
/* 144 */       return ih.getAsynchronousProxy((JBossProxy)jbproxy);
/*     */     }
/* 146 */     if (hash == TO_STRING)
/*     */     {
/* 148 */       return ih.toString();
/*     */     }
/* 150 */     if (hash == HASHCODE)
/*     */     {
/* 152 */       return new Integer(ih.toString().hashCode());
/*     */     }
/* 154 */     if (hash == EQUALS)
/*     */     {
/* 156 */       return new Boolean(ih.toString().equals(args[0].toString()));
/*     */     }
/* 158 */     return null;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  62 */       Class[] empty = new Class[0];
/*     */ 
/*  64 */       Method method = JBossProxy.class.getMethod("getAsynchronousProxy", empty);
/*  65 */       GET_ASYNCHRONOUS = MethodHashing.calculateHash(method);
/*  66 */       TO_STRING = MethodHashing.calculateHash(Object.class.getDeclaredMethod("toString", empty));
/*  67 */       EQUALS = MethodHashing.calculateHash(Object.class.getDeclaredMethod("equals", new Class[] { Object.class }));
/*  68 */       HASHCODE = MethodHashing.calculateHash(Object.class.getDeclaredMethod("hashCode", empty));
/*     */ 
/*  70 */       GET_PRIMARY_KEY = EJBObject.class.getMethod("getPrimaryKey", empty);
/*  71 */       GET_HANDLE = EJBObject.class.getMethod("getHandle", empty);
/*  72 */       GET_EJB_HOME = EJBObject.class.getMethod("getEJBHome", empty);
/*  73 */       IS_IDENTICAL = EJBObject.class.getMethod("isIdentical", new Class[] { EJBObject.class });
/*  74 */       REMOVE = EJBObject.class.getMethod("remove", empty);
/*     */ 
/*  76 */       GET_HOME_HANDLE = EJBHome.class.getMethod("getHomeHandle", empty);
/*  77 */       GET_EJB_METADATA = EJBHome.class.getMethod("getEJBMetaData", empty);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*  81 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.ProxyUtils
 * JD-Core Version:    0.6.0
 */