/*     */ package org.jboss.ejb3.cache.impl;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import org.jboss.ejb3.cache.Identifiable;
/*     */ import org.jboss.ejb3.cache.ObjectStore;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.serial.io.JBossObjectInputStream;
/*     */ import org.jboss.serial.io.JBossObjectOutputStream;
/*     */ 
/*     */ public class FileObjectStore<T extends Identifiable>
/*     */   implements ObjectStore<T>
/*     */ {
/*     */   private static final Logger log;
/*     */   private File storageDirectory;
/*     */ 
/*     */   protected File getFile(Object key)
/*     */   {
/* 160 */     return new File(this.storageDirectory, String.valueOf(key) + ".ser");
/*     */   }
/*     */ 
/*     */   public T load(Object key)
/*     */   {
/* 166 */     File file = getFile(key);
/* 167 */     if (!file.exists()) {
/* 168 */       return null;
/*     */     }
/* 170 */     log.debug("loading state from " + file);
/*     */     try
/*     */     {
/* 173 */       FileInputStream fis = FISAction.open(file);
/* 174 */       ObjectInputStream in = new JBossObjectInputStream(fis);
/*     */       try
/*     */       {
/* 177 */         Identifiable localIdentifiable = (Identifiable)in.readObject();
/*     */         return localIdentifiable;
/*     */       }
/*     */       finally
/*     */       {
/* 181 */         in.close();
/* 182 */         DeleteFileAction.delete(file);
/*     */       }
/*     */     }
/*     */     catch (ClassNotFoundException e)
/*     */     {
/* 187 */       throw new RuntimeException("failed to load object " + key, e);
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 191 */     throw new RuntimeException("failed to load object " + key, e);
/*     */   }
/*     */ 
/*     */   public void setStorageDirectory(String dirName)
/*     */   {
/* 197 */     this.storageDirectory = new File(dirName);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/* 202 */     assert (this.storageDirectory != null) : "storageDirectory is null";
/*     */ 
/* 204 */     if (!this.storageDirectory.exists())
/*     */     {
/* 206 */       if (!MkdirsFileAction.mkdirs(this.storageDirectory))
/* 207 */         throw new RuntimeException("Unable to create storage directory " + this.storageDirectory);
/* 208 */       this.storageDirectory.deleteOnExit();
/*     */     }
/*     */ 
/* 211 */     if (!this.storageDirectory.isDirectory())
/* 212 */       throw new RuntimeException("Storage directory " + this.storageDirectory + " is not a directory");
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void store(T obj)
/*     */   {
/* 222 */     File file = getFile(obj.getId());
/* 223 */     file.deleteOnExit();
/* 224 */     log.debug("saving state to " + file);
/*     */     try
/*     */     {
/* 227 */       FileOutputStream fos = FOSAction.open(file);
/* 228 */       ObjectOutputStream out = new JBossObjectOutputStream(fos);
/*     */       try
/*     */       {
/* 231 */         out.writeObject(obj);
/* 232 */         out.flush();
/*     */       }
/*     */       finally
/*     */       {
/* 236 */         out.close();
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 241 */       throw new RuntimeException("failed to store object " + obj.getId(), e);
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  50 */     log = Logger.getLogger(FileObjectStore.class);
/*     */   }
/*     */ 
/*     */   private static class MkdirsFileAction
/*     */     implements PrivilegedAction<Boolean>
/*     */   {
/*     */     File file;
/*     */ 
/*     */     MkdirsFileAction(File file)
/*     */     {
/* 143 */       this.file = file;
/*     */     }
/*     */ 
/*     */     public Boolean run()
/*     */     {
/* 148 */       return Boolean.valueOf(this.file.mkdirs());
/*     */     }
/*     */ 
/*     */     static boolean mkdirs(File file)
/*     */     {
/* 153 */       MkdirsFileAction action = new MkdirsFileAction(file);
/* 154 */       return ((Boolean)AccessController.doPrivileged(action)).booleanValue();
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class FOSAction
/*     */     implements PrivilegedExceptionAction<FileOutputStream>
/*     */   {
/*     */     File file;
/*     */ 
/*     */     FOSAction(File file)
/*     */     {
/* 112 */       this.file = file;
/*     */     }
/*     */ 
/*     */     public FileOutputStream run() throws FileNotFoundException
/*     */     {
/* 117 */       FileOutputStream fis = new FileOutputStream(this.file);
/* 118 */       return fis;
/*     */     }
/*     */ 
/*     */     static FileOutputStream open(File file) throws FileNotFoundException
/*     */     {
/* 123 */       FOSAction action = new FOSAction(file);
/* 124 */       FileOutputStream fos = null;
/*     */       try
/*     */       {
/* 127 */         fos = (FileOutputStream)AccessController.doPrivileged(action);
/*     */       }
/*     */       catch (PrivilegedActionException e)
/*     */       {
/* 131 */         throw ((FileNotFoundException)e.getException());
/*     */       }
/* 133 */       return fos;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class FISAction
/*     */     implements PrivilegedExceptionAction<FileInputStream>
/*     */   {
/*     */     File file;
/*     */ 
/*     */     FISAction(File file)
/*     */     {
/*  81 */       this.file = file;
/*     */     }
/*     */ 
/*     */     public FileInputStream run() throws FileNotFoundException
/*     */     {
/*  86 */       FileInputStream fis = new FileInputStream(this.file);
/*  87 */       return fis;
/*     */     }
/*     */ 
/*     */     static FileInputStream open(File file) throws FileNotFoundException
/*     */     {
/*  92 */       FISAction action = new FISAction(file);
/*  93 */       FileInputStream fis = null;
/*     */       try
/*     */       {
/*  96 */         fis = (FileInputStream)AccessController.doPrivileged(action);
/*     */       }
/*     */       catch (PrivilegedActionException e)
/*     */       {
/* 100 */         throw ((FileNotFoundException)e.getException());
/*     */       }
/* 102 */       return fis;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class DeleteFileAction
/*     */     implements PrivilegedAction<Boolean>
/*     */   {
/*     */     File file;
/*     */ 
/*     */     DeleteFileAction(File file)
/*     */     {
/*  60 */       this.file = file;
/*     */     }
/*     */ 
/*     */     public Boolean run()
/*     */     {
/*  65 */       return Boolean.valueOf(this.file.delete());
/*     */     }
/*     */ 
/*     */     static boolean delete(File file)
/*     */     {
/*  70 */       DeleteFileAction action = new DeleteFileAction(file);
/*  71 */       return ((Boolean)AccessController.doPrivileged(action)).booleanValue();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.cache.impl.FileObjectStore
 * JD-Core Version:    0.6.0
 */