/*    */ package org.jboss.ejb3.cache.impl;
/*    */ 
/*    */ import java.util.HashMap;
/*    */ import java.util.Map;
/*    */ import javax.ejb.NoSuchEJBException;
/*    */ import org.jboss.ejb3.cache.Cache;
/*    */ import org.jboss.ejb3.cache.Identifiable;
/*    */ import org.jboss.ejb3.cache.StatefulObjectFactory;
/*    */ 
/*    */ public class SimpleCache<T extends Identifiable>
/*    */   implements Cache<T>
/*    */ {
/*    */   private StatefulObjectFactory<T> factory;
/*    */   private Map<Object, T> cache;
/*    */ 
/*    */   public SimpleCache(StatefulObjectFactory<T> factory)
/*    */   {
/* 46 */     assert (factory != null);
/*    */ 
/* 48 */     this.factory = factory;
/* 49 */     this.cache = new HashMap();
/*    */   }
/*    */ 
/*    */   public T create(Class<?>[] initTypes, Object[] initValues)
/*    */   {
/* 54 */     Identifiable obj = (Identifiable)this.factory.create(initTypes, initValues);
/* 55 */     synchronized (this.cache)
/*    */     {
/* 57 */       this.cache.put(obj.getId(), obj);
/*    */     }
/* 59 */     return obj;
/*    */   }
/*    */ 
/*    */   public T get(Object key)
/*    */     throws NoSuchEJBException
/*    */   {
/*    */     Identifiable obj;
/* 65 */     synchronized (this.cache)
/*    */     {
/* 67 */       obj = (Identifiable)this.cache.get(key);
/*    */     }
/* 69 */     if (obj == null)
/* 70 */       throw new NoSuchEJBException(String.valueOf(key));
/* 71 */     return obj;
/*    */   }
/*    */ 
/*    */   public T peek(Object key) throws NoSuchEJBException
/*    */   {
/* 76 */     return get(key);
/*    */   }
/*    */ 
/*    */   public void release(T obj)
/*    */   {
/*    */   }
/*    */ 
/*    */   public void remove(Object key)
/*    */   {
/*    */     Identifiable obj;
/* 87 */     synchronized (this.cache)
/*    */     {
/* 89 */       obj = (Identifiable)this.cache.remove(key);
/*    */     }
/* 91 */     if (obj != null)
/* 92 */       this.factory.destroy(obj);
/*    */   }
/*    */ 
/*    */   public void start()
/*    */   {
/*    */   }
/*    */ 
/*    */   public void stop()
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.cache.impl.SimpleCache
 * JD-Core Version:    0.6.0
 */