/*     */ package org.jboss.ejb3.cache.tree;
/*     */ 
/*     */ import org.jboss.cache.Fqn;
/*     */ import org.jboss.cache.Region;
/*     */ import org.jboss.cache.eviction.EvictionPolicy;
/*     */ import org.jboss.cache.eviction.LRUAlgorithm;
/*     */ import org.jboss.cache.lock.TimeoutException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class AbortableLRUAlgorithm extends LRUAlgorithm
/*     */ {
/*  41 */   private static final Logger log = Logger.getLogger(AbortableLRUAlgorithm.class);
/*     */ 
/*     */   protected boolean evictCacheNode(Fqn fqn)
/*     */   {
/*  56 */     if (log.isTraceEnabled())
/*     */     {
/*  58 */       log.trace("Attempting to evict cache node with fqn of " + fqn);
/*     */     }
/*     */ 
/*  61 */     EvictionPolicy policy = this.region.getEvictionPolicy();
/*     */     try
/*     */     {
/*  64 */       policy.evict(fqn);
/*     */     }
/*     */     catch (ContextInUseException e)
/*     */     {
/*  69 */       if (log.isTraceEnabled())
/*  70 */         log.trace("Eviction of " + fqn + " aborted as bean is in use");
/*  71 */       return false;
/*     */     }
/*     */     catch (TimeoutException e)
/*     */     {
/*  75 */       log.warn("Eviction of " + fqn + " timed out, retrying later");
/*  76 */       log.debug(e, e);
/*  77 */       return false;
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/*  81 */       Throwable cause = e.getCause();
/*  82 */       if ((cause instanceof ContextInUseException))
/*     */       {
/*  85 */         if (log.isTraceEnabled())
/*  86 */           log.trace("Eviction of " + fqn + " aborted as bean is in use");
/*  87 */         return false;
/*     */       }
/*  89 */       log.error("Eviction of " + fqn + " failed", e);
/*  90 */       return false;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  94 */       log.error("Eviction of " + fqn + " failed", e);
/*  95 */       return false;
/*     */     }
/*     */ 
/*  98 */     if (log.isTraceEnabled())
/*     */     {
/* 100 */       log.trace("Eviction of cache node with fqn of " + fqn + " successful");
/*     */     }
/*     */ 
/* 103 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.cache.tree.AbortableLRUAlgorithm
 * JD-Core Version:    0.6.0
 */