/*     */ package org.jboss.ejb3.client;
/*     */ 
/*     */ import java.net.URL;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.client.AppClientLauncher;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.client.jboss.JBossClientMetaData;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ 
/*     */ public class ClientLauncher
/*     */   implements AppClientLauncher
/*     */ {
/*  55 */   private static final Logger log = Logger.getLogger(ClientLauncher.class);
/*     */ 
/*     */   public static void launch(JBossClientMetaData xml, String mainClassName, String applicationClientName, String[] args)
/*     */     throws Exception
/*     */   {
/*  68 */     Class mainClass = Class.forName(mainClassName);
/*     */ 
/*  70 */     ClientContainer container = new ClientContainer(xml, mainClass, applicationClientName);
/*     */ 
/*  74 */     container.invokeMain(args);
/*     */   }
/*     */ 
/*     */   public static JBossClientMetaData loadXML(String applicationClientName)
/*     */     throws NamingException
/*     */   {
/*  95 */     log.warn("FIXME: using an unsupported hack to get metadata");
/*  96 */     InitialContext ctx = new InitialContext();
/*  97 */     JBossClientMetaData metaData = (JBossClientMetaData)ctx.lookup(applicationClientName + "/metaData");
/*  98 */     return metaData;
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*     */     try
/*     */     {
/* 110 */       if (args.length < 1) {
/* 111 */         throw new IllegalArgumentException("expected a jar filename as argument");
/*     */       }
/*     */ 
/* 115 */       String name = args[0];
/* 116 */       if (name.endsWith(".jar"))
/*     */       {
/* 118 */         throw new NotImplementedException();
/*     */       }
/*     */ 
/* 123 */       String mainClassName = name;
/* 124 */       Class mainClass = Class.forName(mainClassName);
/*     */ 
/* 127 */       URL appXmlURL = mainClass.getClassLoader().getResource("META-INF/application-client.xml");
/* 128 */       if (appXmlURL == null) {
/* 129 */         throw new RuntimeException("Can't find META-INF/application-client.xml");
/*     */       }
/*     */ 
/* 132 */       JBossClientMetaData xml = null;
/*     */ 
/* 135 */       throw new RuntimeException("NYI");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 152 */       e.printStackTrace();
/* 153 */       System.exit(1);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void launch(String mainClassName, String clientName, String[] args)
/*     */     throws Throwable
/*     */   {
/* 168 */     JBossClientMetaData xml = loadXML(clientName);
/* 169 */     launch(xml, mainClassName, clientName, args);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.client.ClientLauncher
 * JD-Core Version:    0.6.0
 */