/*     */ package org.jboss.ejb3.dependency;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Iterator;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.beans.metadata.spi.DemandMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitor;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.dependency.plugins.AbstractDependencyItem;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.ejb3.javaee.JavaEEComponent;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.util.JBossObject;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class EjbLinkDemandMetaData extends JBossObject
/*     */   implements DemandMetaData, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private ObjectName demand;
/*  59 */   private ControllerState whenRequired = ControllerState.DESCRIBED;
/*     */ 
/*     */   public EjbLinkDemandMetaData(JavaEEComponent component, String ejbName)
/*     */   {
/*     */     try
/*     */     {
/*  70 */       this.demand = new ObjectName(component.createObjectName(null, ejbName));
/*     */     }
/*     */     catch (MalformedObjectNameException e)
/*     */     {
/*  74 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getDemand()
/*     */   {
/*  80 */     return this.demand;
/*     */   }
/*     */ 
/*     */   public ControllerState getWhenRequired()
/*     */   {
/*  85 */     return this.whenRequired;
/*     */   }
/*     */ 
/*     */   public void describeVisit(MetaDataVisitor vistor)
/*     */   {
/*  90 */     vistor.describeVisit(this);
/*     */   }
/*     */ 
/*     */   public Iterator<? extends MetaDataVisitorNode> getChildren()
/*     */   {
/*  95 */     return null;
/*     */   }
/*     */ 
/*     */   public void initialVisit(MetaDataVisitor visitor)
/*     */   {
/* 100 */     KernelControllerContext context = visitor.getControllerContext();
/* 101 */     DependencyItem item = new EjbLinkDemandDependencyItem(context.getName());
/* 102 */     visitor.addDependency(item);
/* 103 */     visitor.initialVisit(this);
/*     */   }
/*     */ 
/*     */   public void toString(JBossStringBuilder buffer)
/*     */   {
/* 109 */     buffer.append("demand=").append(this.demand);
/* 110 */     if (this.whenRequired != null)
/* 111 */       buffer.append(" whenRequired=").append(this.whenRequired.getStateString());
/*     */   }
/*     */ 
/*     */   public void toShortString(JBossStringBuilder buffer)
/*     */   {
/* 117 */     buffer.append(this.demand);
/*     */   }
/*     */ 
/*     */   private class EjbLinkDemandDependencyItem extends AbstractDependencyItem
/*     */   {
/*     */     public EjbLinkDemandDependencyItem(Object name)
/*     */     {
/* 124 */       super(null, EjbLinkDemandMetaData.this.whenRequired, null);
/*     */     }
/*     */ 
/*     */     public boolean resolve(Controller controller)
/*     */     {
/* 130 */       for (ControllerContext context : controller.getContextsByState(ControllerState.INSTALLED))
/*     */       {
/*     */         try
/*     */         {
/* 134 */           ObjectName otherName = new ObjectName(context.getName().toString());
/*     */ 
/* 136 */           if (EjbLinkDemandMetaData.this.demand.apply(otherName))
/*     */           {
/* 138 */             setIDependOn(context.getName());
/* 139 */             addDependsOnMe(controller, context);
/* 140 */             setResolved(true);
/* 141 */             return isResolved();
/*     */           }
/*     */         }
/*     */         catch (MalformedObjectNameException e)
/*     */         {
/*     */         }
/*     */       }
/*     */ 
/* 149 */       setResolved(false);
/* 150 */       return isResolved();
/*     */     }
/*     */ 
/*     */     public void toString(JBossStringBuilder buffer)
/*     */     {
/* 156 */       super.toString(buffer);
/* 157 */       buffer.append(" demand=").append(EjbLinkDemandMetaData.this.demand.getCanonicalName());
/*     */     }
/*     */ 
/*     */     public void toShortString(JBossStringBuilder buffer)
/*     */     {
/* 163 */       buffer.append(getName()).append(" demands ").append(EjbLinkDemandMetaData.this.demand.getCanonicalName());
/*     */     }
/*     */ 
/*     */     public String toHumanReadableString()
/*     */     {
/* 169 */       StringBuilder builder = new StringBuilder();
/* 170 */       builder.append("Demands '").append(EjbLinkDemandMetaData.this.demand.getCanonicalName());
/* 171 */       return builder.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.dependency.EjbLinkDemandMetaData
 * JD-Core Version:    0.6.0
 */