/*     */ package org.jboss.ejb3.deployers;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import javax.management.MBeanServer;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.vfs.spi.deployer.AbstractVFSRealDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.deployment.security.JaccPolicyUtil;
/*     */ import org.jboss.ejb3.DeploymentScope;
/*     */ import org.jboss.ejb3.EJB3Deployer;
/*     */ import org.jboss.ejb3.Ejb3Deployment;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ @Deprecated
/*     */ public class EJBRegistrationDeployer extends AbstractVFSRealDeployer
/*     */ {
/*  54 */   private static final Logger log = Logger.getLogger(EJBRegistrationDeployer.class);
/*     */   private HashSet ignoredJarsSet;
/*     */   private MBeanServer mbeanServer;
/*     */   private Kernel kernel;
/*     */   private Properties defaultPersistenceProperties;
/*     */   private List<String> allowedSuffixes;
/*     */   private boolean requireDeploymentDescriptor;
/*     */ 
/*     */   public EJBRegistrationDeployer()
/*     */   {
/*  69 */     setRelativeOrder(-1);
/*  70 */     setOutputs(new String[] { Ejb3Deployment.class.getName(), JaccPolicyUtil.IGNORE_ME_NAME });
/*     */   }
/*     */ 
/*     */   public List<String> getAllowedSuffixes()
/*     */   {
/*  75 */     return this.allowedSuffixes;
/*     */   }
/*     */ 
/*     */   public void setAllowedSuffixes(List<String> allowedSuffixes)
/*     */   {
/*  80 */     this.allowedSuffixes = allowedSuffixes;
/*     */   }
/*     */ 
/*     */   public HashSet getIgnoredJarsSet()
/*     */   {
/*  85 */     return this.ignoredJarsSet;
/*     */   }
/*     */ 
/*     */   public void setIgnoredJarsSet(HashSet ignoredJarsSet)
/*     */   {
/*  90 */     this.ignoredJarsSet = ignoredJarsSet;
/*     */   }
/*     */ 
/*     */   public MBeanServer getMbeanServer()
/*     */   {
/*  95 */     return this.mbeanServer;
/*     */   }
/*     */ 
/*     */   public void setMbeanServer(MBeanServer mbeanServer)
/*     */   {
/* 100 */     this.mbeanServer = mbeanServer;
/*     */   }
/*     */ 
/*     */   public Kernel getKernel()
/*     */   {
/* 105 */     return this.kernel;
/*     */   }
/*     */ 
/*     */   public void setKernel(Kernel kernel)
/*     */   {
/* 110 */     this.kernel = kernel;
/*     */   }
/*     */ 
/*     */   public Properties getDefaultPersistenceProperties()
/*     */   {
/* 115 */     return this.defaultPersistenceProperties;
/*     */   }
/*     */ 
/*     */   public void setDefaultPersistenceProperties(Properties defaultPersistenceProperties)
/*     */   {
/* 120 */     this.defaultPersistenceProperties = defaultPersistenceProperties;
/*     */   }
/*     */ 
/*     */   public boolean getRequireDeploymentDescriptor()
/*     */   {
/* 125 */     return this.requireDeploymentDescriptor;
/*     */   }
/*     */ 
/*     */   public void setRequireDeploymentDescriptor(boolean requireDeploymentDescriptor)
/*     */   {
/* 130 */     this.requireDeploymentDescriptor = requireDeploymentDescriptor;
/*     */   }
/*     */ 
/*     */   public void deploy(VFSDeploymentUnit unit)
/*     */     throws DeploymentException
/*     */   {
/*     */     try
/*     */     {
/* 138 */       boolean hasEjbDd = false;
/* 139 */       boolean hasJbossDd = false;
/*     */ 
/* 141 */       VirtualFile jar = unit.getRoot();
/* 142 */       if ((jar.isLeaf()) || (this.ignoredJarsSet.contains(jar.getName())))
/*     */       {
/* 144 */         log.trace("EJBRegistrationDeployer ignoring: " + jar.getName());
/* 145 */         return;
/*     */       }
/* 147 */       if (!hasAllowedSuffix(jar.getName()))
/*     */       {
/* 149 */         log.trace("EJBRegistrationDeployer suffix not allowed: " + jar.getName());
/* 150 */         return;
/*     */       }
/*     */ 
/* 153 */       VirtualFile ejbjar = unit.getMetaDataFile("ejb-jar.xml");
/* 154 */       if (ejbjar != null)
/*     */       {
/* 156 */         InputStream is = ejbjar.openStream();
/* 157 */         boolean has30EjbJarXml = EJB3Deployer.has30EjbJarXml(is);
/* 158 */         is.close();
/* 159 */         if (!has30EjbJarXml) {
/* 160 */           return;
/*     */         }
/*     */ 
/* 163 */         hasEjbDd = true;
/*     */       }
/*     */ 
/* 168 */       hasJbossDd = unit.getMetaDataFile("jboss.xml") != null;
/*     */ 
/* 172 */       if ((getRequireDeploymentDescriptor()) && (!hasJbossDd) && (!hasEjbDd))
/*     */       {
/* 174 */         log.trace(EJBRegistrationDeployer.class.getSimpleName() + " skipping deployment \"" + unit.getSimpleName() + "\", jar: \"" + jar.getName() + "\" - either EJB3 Deployment Descriptor or \"jboss.xml\" is required and neither were found.");
/*     */ 
/* 177 */         return;
/*     */       }
/*     */ 
/* 180 */       log.debug("********* EJBRegistrationDepoyer Begin Unit: " + unit.getSimpleName() + " jar: " + jar.getName());
/* 181 */       DeploymentScope scope = null;
/* 182 */       VFSDeploymentUnit parent = unit.getParent();
/* 183 */       if ((parent != null) && (parent.getSimpleName().endsWith(".ear")))
/*     */       {
/* 185 */         scope = (DeploymentScope)parent.getAttachment(DeploymentScope.class);
/* 186 */         if (scope == null)
/*     */         {
/* 188 */           scope = new JBoss5DeploymentScope(unit.getParent());
/* 189 */           parent.addAttachment(DeploymentScope.class, scope);
/*     */         }
/*     */       }
/* 192 */       JBoss5DeploymentUnit du = new JBoss5DeploymentUnit(unit);
/* 193 */       du.setDefaultPersistenceProperties(this.defaultPersistenceProperties);
/* 194 */       Ejb3JBoss5Deployment deployment = new Ejb3JBoss5Deployment(du, this.kernel, this.mbeanServer, unit, scope, null, null, null);
/* 195 */       if (scope != null) scope.register(deployment);
/*     */ 
/* 197 */       deployment.create();
/* 198 */       if ((deployment.getEjbContainers().size() == 0) && (deployment.getPersistenceUnitDeployments().size() == 0))
/*     */       {
/* 200 */         log.trace("EJBRegistrationDeployer no containers in scanned jar, consider adding it to the ignore list: " + jar.getName() + " url: " + jar.toURL() + " unit: " + unit.getSimpleName());
/* 201 */         return;
/*     */       }
/* 203 */       unit.addAttachment(Ejb3Deployment.class, deployment);
/*     */ 
/* 205 */       unit.addAttachment(JaccPolicyUtil.IGNORE_ME_NAME, Boolean.valueOf(true), Boolean.class);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 209 */       throw new DeploymentException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean hasAllowedSuffix(String name)
/*     */   {
/* 215 */     if (this.allowedSuffixes == null) {
/* 216 */       return true;
/*     */     }
/* 218 */     for (String suffix : this.allowedSuffixes)
/*     */     {
/* 220 */       if (name.endsWith(suffix))
/*     */       {
/* 222 */         return true;
/*     */       }
/*     */     }
/* 225 */     return false;
/*     */   }
/*     */ 
/*     */   public void undeploy(VFSDeploymentUnit unit)
/*     */   {
/* 230 */     Ejb3Deployment deployment = (Ejb3Deployment)unit.getAttachment(Ejb3Deployment.class);
/* 231 */     if (deployment == null) return;
/*     */     try
/*     */     {
/* 234 */       deployment.stop();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 238 */       log.error("failed to stop deployment", e);
/*     */     }
/*     */     try
/*     */     {
/* 242 */       deployment.destroy();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 246 */       log.error("failed to destroy deployment", e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.deployers.EJBRegistrationDeployer
 * JD-Core Version:    0.6.0
 */