/*     */ package org.jboss.ejb3.embedded;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Map;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import javax.security.auth.login.Configuration;
/*     */ import org.jboss.ejb3.InitialContextFactory;
/*     */ import org.jboss.ejb3.naming.BrainlessContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.security.auth.callback.SecurityAssociationHandler;
/*     */ import org.jboss.security.auth.login.XMLLoginConfigImpl;
/*     */ import org.jboss.security.plugins.JBossAuthorizationManager;
/*     */ import org.jboss.security.plugins.JaasSecurityManager;
/*     */ import org.jboss.security.plugins.SecurityDomainContext;
/*     */ 
/*     */ public class JaasSecurityManagerService
/*     */ {
/*  47 */   private static final Logger log = Logger.getLogger(JaasSecurityManager.class);
/*     */   private static final String SECURITY_MGR_PATH = "java:/jaas";
/*  51 */   private static Map<String, JaasSecurityManager> cache = new HashMap();
/*     */   private Hashtable initialContextProperties;
/*     */ 
/*     */   public void setInitialContextProperties(Hashtable initialContextProperties)
/*     */   {
/*  62 */     this.initialContextProperties = initialContextProperties;
/*     */   }
/*     */ 
/*     */   private InitialContext getInitialContext() throws NamingException
/*     */   {
/*  67 */     return InitialContextFactory.getInitialContext(this.initialContextProperties);
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/*  72 */     XMLLoginConfigImpl configuration = new XMLLoginConfigImpl();
/*  73 */     configuration.setConfigResource("login-config.xml");
/*  74 */     configuration.loadConfig();
/*     */ 
/*  76 */     Configuration.setConfiguration(configuration);
/*     */ 
/*  78 */     Context ctx = getInitialContext();
/*     */ 
/*  80 */     String factoryName = SecurityDomainObjectFactory.class.getName();
/*  81 */     Reference ref = new Reference("nl.wolfc.embedded.security.plugins.JaasSecurityManager", factoryName, null);
/*  82 */     ctx.rebind("java:/jaas", ref);
/*     */   }
/*     */ 
/*     */   private static JaasSecurityManager getSecurityManager(String name)
/*     */   {
/*  87 */     JaasSecurityManager manager = (JaasSecurityManager)cache.get(name);
/*  88 */     if (manager != null)
/*     */     {
/*  91 */       return manager;
/*     */     }
/*  93 */     synchronized (cache)
/*     */     {
/*  95 */       if (manager != null) {
/*  96 */         return manager;
/*     */       }
/*  98 */       manager = new JaasSecurityManager(name, new SecurityAssociationHandler());
/*  99 */       cache.put(name, manager);
/*     */     }
/* 101 */     return manager;
/*     */   }
/*     */ 
/*     */   public static class SecurityDomainObjectFactory
/*     */     implements ObjectFactory
/*     */   {
/* 107 */     private static final Logger log = Logger.getLogger(SecurityDomainObjectFactory.class);
/*     */ 
/*     */     public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment)
/*     */       throws Exception
/*     */     {
/* 115 */       String securityDomainName = name.get(1);
/* 116 */       SecurityDomainContext ctx = new SecurityDomainContext(JaasSecurityManagerService.access$000(securityDomainName), null);
/* 117 */       ctx.setAuthorizationManager(new JBossAuthorizationManager(securityDomainName, new SecurityAssociationHandler()));
/* 118 */       return new BrainlessContext(ctx)
/*     */       {
/*     */         public Object lookup(Name name) throws NamingException
/*     */         {
/* 122 */           JaasSecurityManagerService.SecurityDomainObjectFactory.log.debug("lookup " + name);
/* 123 */           if (name.size() < 2) {
/* 124 */             return lookup(name.get(0));
/*     */           }
/* 126 */           return this.val$ctx.lookup(name.get(1));
/*     */         }
/*     */ 
/*     */         public Object lookup(String name) throws NamingException
/*     */         {
/* 131 */           JaasSecurityManagerService.SecurityDomainObjectFactory.log.debug("lookup " + name);
/* 132 */           return JaasSecurityManagerService.access$000(name);
/*     */         }
/*     */       };
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.embedded.JaasSecurityManagerService
 * JD-Core Version:    0.6.0
 */