/*    */ package org.jboss.ejb3.embedded;
/*    */ 
/*    */ import java.util.Hashtable;
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.NamingException;
/*    */ import org.jboss.ejb3.InitialContextFactory;
/*    */ import org.jboss.ejb3.NonSerializableFactory;
/*    */ import org.jboss.naming.Util;
/*    */ 
/*    */ public class JndiBinder
/*    */ {
/*    */   private String bindTo;
/*    */   private Object target;
/*    */   private boolean serializable;
/*    */   private Hashtable properties;
/*    */ 
/*    */   public void setBindTo(String bindTo)
/*    */   {
/* 47 */     this.bindTo = bindTo;
/*    */   }
/*    */ 
/*    */   public void setTarget(Object target)
/*    */   {
/* 52 */     this.target = target;
/*    */   }
/*    */ 
/*    */   public void setSerializable(boolean serializable)
/*    */   {
/* 57 */     this.serializable = serializable;
/*    */   }
/*    */ 
/*    */   public void setJndiProperties(Hashtable properties)
/*    */   {
/* 62 */     this.properties = properties;
/*    */   }
/*    */ 
/*    */   public void start() throws Exception
/*    */   {
/* 67 */     InitialContext ctx = InitialContextFactory.getInitialContext(this.properties);
/*    */     try
/*    */     {
/* 71 */       if (this.serializable)
/*    */       {
/* 73 */         Util.rebind(ctx, this.bindTo, this.target);
/*    */       }
/*    */       else
/*    */       {
/* 77 */         NonSerializableFactory.rebind(ctx, this.bindTo, this.target);
/*    */       }
/*    */     }
/*    */     catch (NamingException e) {
/* 81 */       NamingException namingException = new NamingException("Could not bind JndiBinder service into JNDI under jndiName:" + ctx.getNameInNamespace() + "/" + this.bindTo);
/* 82 */       namingException.setRootCause(e);
/* 83 */       throw namingException;
/*    */     }
/*    */   }
/*    */ 
/*    */   public void stop() throws Exception
/*    */   {
/* 89 */     InitialContext ctx = InitialContextFactory.getInitialContext(this.properties);
/* 90 */     if (this.serializable)
/*    */     {
/* 92 */       Util.unbind(ctx, this.bindTo);
/*    */     }
/*    */     else
/*    */     {
/* 96 */       NonSerializableFactory.unbind(ctx, this.bindTo);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.embedded.JndiBinder
 * JD-Core Version:    0.6.0
 */