/*     */ package org.jboss.ejb3.embedded;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import org.jboss.dependency.spi.Controller;
/*     */ import org.jboss.dependency.spi.ControllerContext;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.dependency.spi.DependencyInfo;
/*     */ import org.jboss.dependency.spi.DependencyItem;
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ 
/*     */ public class KernelErrors
/*     */ {
/*  45 */   private static final Logger log = Logger.getLogger(KernelErrors.class);
/*     */ 
/*     */   public static boolean validate(Kernel kernel)
/*     */   {
/*  49 */     Controller controller = kernel.getController();
/*  50 */     Set notInstalled = new HashSet(controller.getNotInstalled());
/*  51 */     if (notInstalled.isEmpty()) return true;
/*     */ 
/*  53 */     for (Iterator i = notInstalled.iterator(); i.hasNext(); )
/*     */     {
/*  55 */       KernelControllerContext context = (KernelControllerContext)i.next();
/*  56 */       if (context.getState().equals(context.getRequiredState())) {
/*  57 */         i.remove();
/*     */       }
/*     */     }
/*  60 */     if (notInstalled.isEmpty()) return true;
/*     */ 
/*  62 */     HashSet errors = new HashSet();
/*  63 */     HashSet incomplete = new HashSet();
/*  64 */     for (Iterator i = notInstalled.iterator(); i.hasNext(); )
/*     */     {
/*  66 */       KernelControllerContext ctx = (KernelControllerContext)i.next();
/*  67 */       if (ctx.getState().equals(ControllerState.ERROR))
/*  68 */         errors.add(ctx);
/*     */       else
/*  70 */         incomplete.add(ctx);
/*     */     }
/*     */     Iterator i;
/*  72 */     if (errors.size() != 0)
/*     */     {
/*  74 */       log.error("*** DEPLOYMENTS IN ERROR:\n");
/*  75 */       for (i = errors.iterator(); i.hasNext(); )
/*     */       {
/*  77 */         KernelControllerContext ctx = (KernelControllerContext)i.next();
/*  78 */         log.error("Failed deployment: " + ctx.getName(), ctx.getError());
/*     */       }
/*     */     }
/*  81 */     if (incomplete.size() != 0)
/*     */     {
/*  83 */       JBossStringBuilder buffer = new JBossStringBuilder();
/*  84 */       buffer.append("\n*** DEPLOYMENTS MISSING DEPENDENCIES:\n");
/*  85 */       for (Iterator i = incomplete.iterator(); i.hasNext(); )
/*     */       {
/*  87 */         KernelControllerContext ctx = (KernelControllerContext)i.next();
/*  88 */         buffer.append(ctx.getName()).append(" depends on: \n");
/*  89 */         DependencyInfo dependsInfo = ctx.getDependencyInfo();
/*  90 */         Set depends = dependsInfo.getIDependOn(null);
/*  91 */         for (Iterator j = depends.iterator(); j.hasNext(); )
/*     */         {
/*  93 */           DependencyItem item = (DependencyItem)j.next();
/*  94 */           buffer.append("                     ").append(item.getIDependOn()).append("'{").append(item.getWhenRequired().getStateString());
/*  95 */           buffer.append(':');
/*  96 */           ControllerContext other = controller.getContext(item.getIDependOn(), null);
/*  97 */           if (other == null)
/*  98 */             buffer.append("NOT FOUND");
/*     */           else
/* 100 */             buffer.append(other.getState().getStateString());
/* 101 */           buffer.append('}');
/* 102 */           if (j.hasNext())
/* 103 */             buffer.append("\n");
/*     */         }
/* 105 */         buffer.append('\n');
/*     */       }
/* 107 */       log.error(buffer.toString());
/*     */     }
/*     */ 
/* 111 */     return (errors.size() <= 0) && (incomplete.size() <= 0);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.embedded.KernelErrors
 * JD-Core Version:    0.6.0
 */