/*     */ package org.jboss.ejb3.embedded.resource;
/*     */ 
/*     */ import javax.resource.spi.work.ExecutionContext;
/*     */ import javax.resource.spi.work.Work;
/*     */ import javax.resource.spi.work.WorkCompletedException;
/*     */ import javax.resource.spi.work.WorkEvent;
/*     */ import javax.resource.spi.work.WorkException;
/*     */ import javax.resource.spi.work.WorkListener;
/*     */ import javax.resource.spi.work.WorkRejectedException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.JBossStringBuilder;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ import org.jboss.util.threadpool.BasicTaskWrapper;
/*     */ import org.jboss.util.threadpool.StartTimeoutException;
/*     */ import org.jboss.util.threadpool.Task;
/*     */ 
/*     */ public class WorkWrapper extends BasicTaskWrapper
/*     */   implements Task
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(WorkWrapper.class);
/*     */ 
/*  52 */   private boolean trace = log.isTraceEnabled();
/*     */   private Work work;
/*     */   private ExecutionContext executionContext;
/*     */   private WorkListener workListener;
/*     */   private long startTimeout;
/*     */   private JBossWorkManager workManager;
/*     */   private int waitType;
/*     */   private long blockedTime;
/*     */   private WorkException exception;
/*     */ 
/*     */   public WorkWrapper(JBossWorkManager workManager, Work work, int waitType, long startTimeout, ExecutionContext executionContext, WorkListener workListener)
/*     */   {
/*  92 */     if (work == null)
/*  93 */       throw new IllegalArgumentException("Null work");
/*  94 */     if (executionContext == null)
/*  95 */       throw new IllegalArgumentException("Null execution context");
/*  96 */     if (startTimeout < 0L) {
/*  97 */       throw new IllegalArgumentException("Illegal start timeout: " + startTimeout);
/*     */     }
/*  99 */     this.workManager = workManager;
/* 100 */     this.work = work;
/* 101 */     this.waitType = waitType;
/* 102 */     this.startTimeout = startTimeout;
/* 103 */     this.executionContext = executionContext;
/* 104 */     this.workListener = workListener;
/*     */ 
/* 106 */     setTask(this);
/*     */   }
/*     */ 
/*     */   public JBossWorkManager getWorkManager()
/*     */   {
/* 116 */     return this.workManager;
/*     */   }
/*     */ 
/*     */   public Work getWork()
/*     */   {
/* 126 */     return this.work;
/*     */   }
/*     */ 
/*     */   public WorkListener getWorkListener()
/*     */   {
/* 136 */     return this.workListener;
/*     */   }
/*     */ 
/*     */   public ExecutionContext getExecutionContext()
/*     */   {
/* 146 */     return this.executionContext;
/*     */   }
/*     */ 
/*     */   public long getBlockedElapsed()
/*     */   {
/* 156 */     return this.blockedTime;
/*     */   }
/*     */ 
/*     */   public WorkException getWorkException()
/*     */   {
/* 166 */     return this.exception;
/*     */   }
/*     */ 
/*     */   public int getWaitType()
/*     */   {
/* 171 */     return this.waitType;
/*     */   }
/*     */ 
/*     */   public int getPriority()
/*     */   {
/* 176 */     return 5;
/*     */   }
/*     */ 
/*     */   public long getStartTimeout()
/*     */   {
/* 181 */     return this.startTimeout;
/*     */   }
/*     */ 
/*     */   public long getCompletionTimeout()
/*     */   {
/* 186 */     return this.executionContext.getTransactionTimeout();
/*     */   }
/*     */ 
/*     */   public void execute()
/*     */   {
/* 191 */     if (this.trace)
/* 192 */       log.trace("Executing work " + this);
/*     */     try
/*     */     {
/* 195 */       this.workManager.startWork(this);
/*     */     }
/*     */     catch (WorkException e)
/*     */     {
/* 199 */       e.printStackTrace();
/* 200 */       taskRejected(new NestedRuntimeException(e));
/* 201 */       return;
/*     */     }
/*     */     try
/*     */     {
/* 205 */       this.work.run();
/*     */     }
/*     */     finally
/*     */     {
/* 209 */       this.workManager.endWork(this);
/*     */     }
/* 211 */     if (this.trace)
/* 212 */       log.trace("Executed work " + this);
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 217 */     if (this.trace) {
/* 218 */       log.trace("Stopping work " + this);
/*     */     }
/* 220 */     this.work.release();
/*     */   }
/*     */ 
/*     */   public void accepted(long time)
/*     */   {
/* 225 */     this.blockedTime = time;
/*     */ 
/* 227 */     if (this.trace) {
/* 228 */       log.trace("Accepted work " + this);
/*     */     }
/* 230 */     if (this.workListener != null)
/*     */     {
/* 232 */       WorkEvent event = new WorkEvent(this.workManager, 1, this.work, null);
/* 233 */       this.workListener.workAccepted(event);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void rejected(long time, Throwable throwable)
/*     */   {
/* 239 */     this.blockedTime = time;
/*     */ 
/* 241 */     if (this.trace)
/*     */     {
/* 243 */       if (throwable != null)
/* 244 */         log.trace("Rejecting work " + this, throwable);
/*     */       else {
/* 246 */         log.trace("Rejecting work " + this);
/*     */       }
/*     */     }
/* 249 */     if (throwable != null)
/*     */     {
/* 251 */       this.exception = new WorkRejectedException(throwable);
/* 252 */       if ((throwable instanceof StartTimeoutException)) {
/* 253 */         this.exception.setErrorCode("1");
/*     */       }
/*     */     }
/* 256 */     this.workManager.cancelWork(this);
/*     */ 
/* 258 */     if (this.workListener != null)
/*     */     {
/* 260 */       WorkEvent event = new WorkEvent(this.workManager, 1, this.work, this.exception);
/* 261 */       this.workListener.workRejected(event);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void started(long time)
/*     */   {
/* 267 */     if (this.waitType != 0) {
/* 268 */       this.blockedTime = time;
/*     */     }
/* 270 */     if (this.workListener != null)
/*     */     {
/* 272 */       WorkEvent event = new WorkEvent(this.workManager, 3, this.work, null);
/* 273 */       this.workListener.workStarted(event);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void completed(long time, Throwable throwable)
/*     */   {
/* 279 */     if (this.waitType == 2) {
/* 280 */       this.blockedTime = time;
/*     */     }
/* 282 */     if (throwable != null) {
/* 283 */       this.exception = new WorkCompletedException(throwable);
/*     */     }
/* 285 */     if (this.trace) {
/* 286 */       log.trace("Completed work " + this);
/*     */     }
/* 288 */     if (this.workListener != null)
/*     */     {
/* 290 */       WorkEvent event = new WorkEvent(this.workManager, 4, this.work, this.exception);
/* 291 */       this.workListener.workCompleted(event);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 297 */     JBossStringBuilder buffer = new JBossStringBuilder(100);
/* 298 */     buffer.append("WorkWrapper@").append(Integer.toHexString(System.identityHashCode(this)));
/* 299 */     buffer.append("[workManger=").append(this.workManager);
/* 300 */     buffer.append(" work=").append(this.work);
/* 301 */     buffer.append(" state=").append(getStateString());
/* 302 */     if ((this.executionContext != null) && (this.executionContext.getXid() != null))
/*     */     {
/* 304 */       buffer.append(" xid=").append(this.executionContext.getXid());
/* 305 */       buffer.append(" txTimeout=").append(this.executionContext.getTransactionTimeout());
/*     */     }
/* 307 */     buffer.append(" waitType=");
/* 308 */     switch (this.waitType)
/*     */     {
/*     */     case 0:
/* 312 */       buffer.append("WAIT_NONE");
/* 313 */       break;
/*     */     case 1:
/* 317 */       buffer.append("WAIT_FOR_START");
/* 318 */       break;
/*     */     case 2:
/* 322 */       buffer.append("WAIT_FOR_COMPLETE");
/* 323 */       break;
/*     */     default:
/* 326 */       buffer.append("???");
/*     */     }
/* 328 */     if (this.startTimeout != 9223372036854775807L)
/* 329 */       buffer.append(" startTimeout=").append(this.startTimeout);
/* 330 */     long completionTimeout = getCompletionTimeout();
/* 331 */     if (completionTimeout != -1L)
/* 332 */       buffer.append(" completionTimeout=").append(completionTimeout);
/* 333 */     if (this.blockedTime != 0L)
/* 334 */       buffer.append(" blockTime=").append(this.blockedTime);
/* 335 */     buffer.append(" elapsedTime=").append(getElapsedTime());
/* 336 */     if (this.workListener != null)
/* 337 */       buffer.append(" workListener=").append(this.workListener);
/* 338 */     if (this.exception != null)
/* 339 */       buffer.append(" exception=").append(this.exception);
/* 340 */     buffer.append("]");
/* 341 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.embedded.resource.WorkWrapper
 * JD-Core Version:    0.6.0
 */