/*     */ package org.jboss.ejb3.enc;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import org.jboss.ejb3.Container;
/*     */ import org.jboss.ejb3.DeploymentScope;
/*     */ import org.jboss.ejb3.DeploymentUnit;
/*     */ import org.jboss.ejb3.EJBContainer;
/*     */ import org.jboss.ejb3.Ejb3Deployment;
/*     */ import org.jboss.ejb3.Ejb3Registry;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class DeploymentEjbResolver
/*     */ {
/*  47 */   private static final Logger log = Logger.getLogger(DeploymentEjbResolver.class);
/*     */   protected DeploymentScope deploymentScope;
/*     */   protected String errorName;
/*     */ 
/*     */   protected DeploymentEjbResolver(DeploymentScope deploymentScope, String errorName)
/*     */   {
/*  54 */     this.deploymentScope = deploymentScope;
/*  55 */     this.errorName = errorName;
/*     */   }
/*     */ 
/*     */   protected abstract EJBContainer searchDeploymentInternally(String paramString, Class paramClass);
/*     */ 
/*     */   public EJBContainer getEjbContainer(String ejbLink, Class businessIntf) {
/*  62 */     int hashIndex = ejbLink.indexOf('#');
/*  63 */     if (hashIndex != -1)
/*     */     {
/*  65 */       if (this.deploymentScope == null)
/*     */       {
/*  67 */         log.warn("ejb link '" + ejbLink + "' is relative, but no deployment scope found");
/*  68 */         return null;
/*     */       }
/*  70 */       String relativePath = ejbLink.substring(0, hashIndex);
/*  71 */       Ejb3Deployment dep = this.deploymentScope.findRelativeDeployment(relativePath);
/*  72 */       if (dep == null)
/*     */       {
/*  74 */         log.warn("can't find a deployment for path '" + relativePath + "' of ejb link '" + ejbLink + "'");
/*  75 */         return null;
/*     */       }
/*  77 */       String ejbName = ejbLink.substring(hashIndex + 1);
/*  78 */       return dep.getEjbContainer(ejbName, businessIntf);
/*     */     }
/*     */ 
/*  81 */     EJBContainer ejb = searchDeploymentInternally(ejbLink, businessIntf);
/*  82 */     if (ejb != null) return ejb;
/*  83 */     for (Object obj : Ejb3Registry.getContainers())
/*     */     {
/*  85 */       EJBContainer container = (EJBContainer)obj;
/*  86 */       if (container.getEjbName().equals(ejbLink))
/*     */       {
/*  88 */         return container;
/*     */       }
/*     */     }
/*  91 */     return null;
/*     */   }
/*     */ 
/*     */   public String getEjbJndiName(String ejbLink, Class businessIntf)
/*     */   {
/*  96 */     EJBContainer container = getEjbContainer(ejbLink, businessIntf);
/*  97 */     if (container == null)
/*     */     {
/*  99 */       return null;
/*     */     }
/* 101 */     return ProxyFactoryHelper.getJndiName(container, businessIntf);
/*     */   }
/*     */ 
/*     */   public EJBContainer getEjbContainer(Ejb3Deployment deployment, Class businessIntf) throws NameNotFoundException
/*     */   {
/* 106 */     EJBContainer container = null;
/*     */ 
/* 108 */     for (Iterator i$ = deployment.getEjbContainers().values().iterator(); i$.hasNext(); ) { Object obj = i$.next();
/*     */ 
/* 110 */       EJBContainer newContainer = (EJBContainer)obj;
/* 111 */       if (container != newContainer)
/* 112 */         if (ProxyFactoryHelper.publishesInterface(newContainer, businessIntf))
/*     */         {
/* 114 */           if (container != null) throw new NameNotFoundException("duplicated in " + this.errorName);
/* 115 */           container = newContainer;
/*     */         }
/*     */     }
/* 118 */     return container;
/*     */   }
/*     */ 
/*     */   public EJBContainer getEjbContainer(Class businessIntf) throws NameNotFoundException
/*     */   {
/* 123 */     EJBContainer rtnContainer = null;
/*     */ 
/* 125 */     rtnContainer = searchForEjbContainerInternally(businessIntf);
/* 126 */     if (rtnContainer != null) return rtnContainer;
/*     */ 
/* 128 */     String jarName = null;
/* 129 */     if (this.deploymentScope != null)
/*     */     {
/* 131 */       for (Ejb3Deployment deployment : this.deploymentScope.getEjbDeployments())
/*     */       {
/* 133 */         EJBContainer newContainer = getEjbContainer(deployment, businessIntf);
/* 134 */         if (rtnContainer != newContainer) {
/* 135 */           if ((rtnContainer != null) && (newContainer != null))
/*     */           {
/* 137 */             throw new NameNotFoundException("duplicated in .ear within " + jarName + " and " + deployment.getDeploymentUnit().getShortName());
/*     */           }
/*     */ 
/* 140 */           if (newContainer != null)
/*     */           {
/* 142 */             rtnContainer = newContainer;
/* 143 */             jarName = deployment.getDeploymentUnit().getShortName();
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 147 */     if (rtnContainer != null)
/*     */     {
/* 149 */       return rtnContainer;
/*     */     }
/*     */ 
/* 152 */     Iterator containers = Ejb3Registry.getContainers().iterator();
/* 153 */     while (containers.hasNext())
/*     */     {
/* 155 */       Container container = (Container)containers.next();
/* 156 */       EJBContainer ejbContainer = (EJBContainer)container;
/* 157 */       if (ejbContainer != rtnContainer)
/* 158 */         if (ProxyFactoryHelper.publishesInterface(container, businessIntf))
/*     */         {
/* 160 */           if (rtnContainer != null)
/*     */           {
/* 162 */             throw new NameNotFoundException("duplicated in " + ejbContainer.getDeployment().getDeploymentUnit().getShortName() + " and " + jarName);
/*     */           }
/*     */ 
/* 165 */           rtnContainer = ejbContainer;
/* 166 */           jarName = ejbContainer.getDeployment().getDeploymentUnit().getShortName();
/*     */         }
/*     */     }
/* 169 */     if (rtnContainer != null) return rtnContainer;
/* 170 */     throw new NameNotFoundException("not used by any EJBs");
/*     */   }
/*     */ 
/*     */   protected abstract EJBContainer searchForEjbContainerInternally(Class paramClass) throws NameNotFoundException;
/*     */ 
/*     */   public String getEjbJndiName(Class businessIntf) throws NameNotFoundException {
/* 177 */     EJBContainer container = getEjbContainer(businessIntf);
/* 178 */     String jndiName = ProxyFactoryHelper.getJndiName(container, businessIntf);
/* 179 */     if (jndiName == null) throw new NameNotFoundException("not used by any EJBs");
/* 180 */     return jndiName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.enc.DeploymentEjbResolver
 * JD-Core Version:    0.6.0
 */