/*     */ package org.jboss.ejb3.enc;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import org.jboss.ejb3.DeploymentScope;
/*     */ import org.jboss.ejb3.DeploymentUnit;
/*     */ import org.jboss.ejb3.Ejb3Deployment;
/*     */ import org.jboss.ejb3.PersistenceUnitRegistry;
/*     */ import org.jboss.ejb3.entity.PersistenceUnitDeployment;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class DeploymentPersistenceUnitResolver
/*     */ {
/*  43 */   private static final Logger log = Logger.getLogger(DeploymentPersistenceUnitResolver.class);
/*     */   protected List<PersistenceUnitDeployment> persistenceUnitDeployments;
/*     */   protected DeploymentScope deploymentScope;
/*     */   protected LinkedHashMap ejbContainers;
/*     */ 
/*     */   public DeploymentPersistenceUnitResolver(List<PersistenceUnitDeployment> persistenceUnitDeployments, DeploymentScope deploymentScope, LinkedHashMap ejbContainers)
/*     */   {
/*  51 */     this.persistenceUnitDeployments = persistenceUnitDeployments;
/*  52 */     this.deploymentScope = deploymentScope;
/*  53 */     this.ejbContainers = ejbContainers;
/*     */   }
/*     */ 
/*     */   public PersistenceUnitDeployment getPersistenceUnitDeployment(String unitName) throws NameNotFoundException
/*     */   {
/*  58 */     if ((unitName == null) || ("".equals(unitName)))
/*     */     {
/*  60 */       if (this.persistenceUnitDeployments == null)
/*     */       {
/*  62 */         throw new NameNotFoundException("EMPTY STRING unitName but there is no deployments in scope");
/*     */       }
/*  64 */       if ((this.persistenceUnitDeployments.size() == 1) && (this.ejbContainers.size() > 0))
/*     */       {
/*  66 */         return (PersistenceUnitDeployment)this.persistenceUnitDeployments.get(0);
/*     */       }
/*  68 */       if (this.persistenceUnitDeployments.size() > 1)
/*     */       {
/*  70 */         throw new NameNotFoundException("EMPTY STRING unitName and there is more than one scoped persistence unit");
/*     */       }
/*     */ 
/*  74 */       if (this.deploymentScope != null)
/*     */       {
/*  76 */         Collection deployments = this.deploymentScope.getEjbDeployments();
/*  77 */         if (deployments != null)
/*     */         {
/*  79 */           for (Ejb3Deployment deployment : deployments)
/*     */           {
/*  81 */             if (deployment.getPersistenceUnitDeployments().size() == 1)
/*     */             {
/*  83 */               return (PersistenceUnitDeployment)deployment.getPersistenceUnitDeployments().get(0);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*  88 */       throw new NameNotFoundException("There is no default persistence unit in this deployment.");
/*     */     }
/*     */ 
/*  92 */     int hashIndex = unitName.indexOf('#');
/*  93 */     if (hashIndex != -1)
/*     */     {
/*  95 */       String relativePath = unitName.substring(0, hashIndex);
/*  96 */       String name = unitName.substring(hashIndex + 1);
/*  97 */       if (this.deploymentScope == null)
/*     */       {
/*  99 */         String relativeJarName = relativePath.substring(3);
/*     */ 
/* 101 */         for (PersistenceUnitDeployment pud : PersistenceUnitRegistry.getPersistenceUnits())
/*     */         {
/* 103 */           String jarName = pud.getDeployment().getDeploymentUnit().getShortName() + ".jar";
/* 104 */           if ((pud.getDeployment().getEar() == null) && (jarName.equals(relativeJarName)) && (pud.getEntityManagerName().equals(name)) && (pud.isScoped()))
/*     */           {
/* 109 */             return pud;
/*     */           }
/*     */         }
/* 112 */         return null;
/*     */       }
/* 114 */       Ejb3Deployment dep = this.deploymentScope.findRelativeDeployment(relativePath);
/* 115 */       if (dep == null)
/*     */       {
/* 117 */         return null;
/*     */       }
/* 119 */       PersistenceUnitDeployment rtn = dep.getPersistenceUnitDeploymentInternal(name);
/* 120 */       return rtn;
/*     */     }
/* 122 */     PersistenceUnitDeployment rtn = getPersistenceUnitDeploymentInternal(unitName);
/* 123 */     if (rtn != null) return rtn;
/*     */ 
/* 125 */     for (PersistenceUnitDeployment deployment : PersistenceUnitRegistry.getPersistenceUnits())
/*     */     {
/* 127 */       if (!deployment.isScoped())
/* 128 */         if (deployment.getEntityManagerName().equals(unitName)) return deployment;
/*     */     }
/* 130 */     return rtn;
/*     */   }
/*     */ 
/*     */   public PersistenceUnitDeployment getPersistenceUnitDeploymentInternal(String unitName)
/*     */   {
/* 135 */     if (this.persistenceUnitDeployments != null)
/*     */     {
/* 137 */       for (PersistenceUnitDeployment deployment : this.persistenceUnitDeployments)
/*     */       {
/* 139 */         if (deployment.getEntityManagerName().equals(unitName))
/*     */         {
/* 141 */           return deployment;
/*     */         }
/*     */       }
/*     */     }
/* 145 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.enc.DeploymentPersistenceUnitResolver
 * JD-Core Version:    0.6.0
 */