/*     */ package org.jboss.ejb3.enc;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.ejb3.DeploymentScope;
/*     */ import org.jboss.ejb3.Ejb3Deployment;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
/*     */ 
/*     */ public class MessageDestinationResolver
/*     */ {
/*  42 */   private static final Logger log = Logger.getLogger(MessageDestinationResolver.class);
/*     */   private DeploymentScope deploymentScope;
/*  45 */   private Map<String, MessageDestinationMetaData> messageDestinations = new HashMap();
/*     */ 
/*     */   public MessageDestinationResolver(DeploymentScope deploymentScope, MessageDestinationsMetaData mergedMessageDestinations)
/*     */   {
/*  49 */     this.deploymentScope = deploymentScope;
/*  50 */     if (mergedMessageDestinations != null)
/*     */     {
/*  52 */       for (MessageDestinationMetaData dest : mergedMessageDestinations)
/*     */       {
/*  54 */         this.messageDestinations.put(dest.getMessageDestinationName(), dest);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getMessageDestinationJNDIName(String name)
/*     */   {
/*  62 */     MessageDestinationMetaData dest = (MessageDestinationMetaData)this.messageDestinations.get(name);
/*  63 */     if (dest != null)
/*  64 */       return dest.getJndiName();
/*  65 */     return null;
/*     */   }
/*     */ 
/*     */   public String resolveMessageDestination(String link)
/*     */   {
/*  77 */     int hashIndex = link.indexOf('#');
/*  78 */     if (hashIndex != -1)
/*     */     {
/*  80 */       if (this.deploymentScope == null)
/*     */       {
/*  82 */         log.warn("Message destination link '" + link + "' is relative, but no deployment scope found");
/*  83 */         return null;
/*     */       }
/*  85 */       String relativePath = link.substring(0, hashIndex);
/*  86 */       Ejb3Deployment dep = this.deploymentScope.findRelativeDeployment(relativePath);
/*  87 */       if (dep == null)
/*     */       {
/*  89 */         log.warn("Can't find a deployment for path '" + relativePath + "' of message destination link '" + link + "'");
/*  90 */         return null;
/*     */       }
/*  92 */       String name = link.substring(hashIndex + 1);
/*  93 */       return dep.resolveMessageDestination(name);
/*     */     }
/*  95 */     String jndiName = getMessageDestinationJNDIName(link);
/*  96 */     if (jndiName != null)
/*  97 */       return jndiName;
/*  98 */     for (Ejb3Deployment dep : this.deploymentScope.getEjbDeployments())
/*     */     {
/* 100 */       jndiName = dep.getMessageDestinationResolver().getMessageDestinationJNDIName(link);
/* 101 */       if (jndiName != null)
/* 102 */         return jndiName;
/*     */     }
/* 104 */     log.warn("Can't find a message destination for link '" + link + "' anywhere");
/* 105 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.enc.MessageDestinationResolver
 * JD-Core Version:    0.6.0
 */