/*    */ package org.jboss.ejb3.entity;
/*    */ 
/*    */ import java.util.Map;
/*    */ import javax.persistence.EntityManager;
/*    */ import javax.transaction.TransactionManager;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.ejb3.PersistenceUnitRegistry;
/*    */ import org.jboss.ejb3.stateful.StatefulBeanContext;
/*    */ import org.jboss.ejb3.stateful.StatefulContainerInvocation;
/*    */ import org.jboss.ejb3.tx.TxUtil;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class ExtendedPersistenceContextPropagationInterceptor
/*    */   implements Interceptor
/*    */ {
/* 41 */   private static final Logger log = Logger.getLogger(ExtendedPersistenceContextPropagationInterceptor.class);
/*    */ 
/*    */   public String getName()
/*    */   {
/* 45 */     return getClass().getName();
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable
/*    */   {
/* 50 */     log.debug("++++ LongLivedSessionPropagationInterceptor");
/* 51 */     StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
/* 52 */     StatefulBeanContext ctx = (StatefulBeanContext)ejb.getBeanContext();
/*    */ 
/* 54 */     Map extendedPCs = ctx.getExtendedPersistenceContexts();
/* 55 */     if ((extendedPCs == null) || (extendedPCs.size() == 0))
/*    */     {
/* 57 */       return invocation.invokeNext();
/*    */     }
/*    */ 
/* 60 */     TransactionManager tm = TxUtil.getTransactionManager();
/* 61 */     if (tm.getTransaction() != null)
/*    */     {
/* 63 */       for (String kernelname : extendedPCs.keySet())
/*    */       {
/* 65 */         EntityManager manager = (EntityManager)extendedPCs.get(kernelname);
/* 66 */         ManagedEntityManagerFactory factory = PersistenceUnitRegistry.getPersistenceUnit(kernelname).getManagedFactory();
/* 67 */         factory.registerExtendedWithTransaction(manager);
/*    */       }
/*    */     }
/*    */ 
/* 71 */     return invocation.invokeNext();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.ExtendedPersistenceContextPropagationInterceptor
 * JD-Core Version:    0.6.0
 */