/*    */ package org.jboss.ejb3.entity;
/*    */ 
/*    */ import java.util.Properties;
/*    */ import javax.management.ObjectName;
/*    */ import org.hibernate.cache.CacheException;
/*    */ import org.jboss.cache.config.Configuration;
/*    */ import org.jboss.cache.jmx.CacheJmxWrapperMBean;
/*    */ import org.jboss.ejb3.tx.TxUtil;
/*    */ import org.jboss.mx.util.MBeanProxyExt;
/*    */ import org.jboss.mx.util.MBeanServerLocator;
/*    */ 
/*    */ class JBCCacheFactory extends TransactionalCacheFactory
/*    */ {
/*    */   private org.jboss.cache.Cache cache;
/*    */   private boolean optimistic;
/*    */ 
/*    */   protected void configure(Properties hibernateConfig)
/*    */   {
/*    */     try
/*    */     {
/* 28 */       String cacheName = (String)hibernateConfig.get("hibernate.treecache.mbean.object_name");
/* 29 */       if (cacheName == null)
/*    */       {
/* 31 */         cacheName = "jboss.cache:service=EJB3EntityTreeCache";
/*    */       }
/* 33 */       ObjectName mbeanObjectName = new ObjectName(cacheName);
/* 34 */       CacheJmxWrapperMBean mbean = (CacheJmxWrapperMBean)MBeanProxyExt.create(CacheJmxWrapperMBean.class, mbeanObjectName, MBeanServerLocator.locateJBoss());
/* 35 */       this.cache = mbean.getCache();
/* 36 */       this.optimistic = this.cache.getConfiguration().isNodeLockingOptimistic();
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 40 */       throw new CacheException(e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public org.hibernate.cache.Cache buildCache(String regionName, Properties properties) throws CacheException
/*    */   {
/* 46 */     String regionPrefix = properties.getProperty("hibernate.cache.region_prefix");
/*    */ 
/* 48 */     if (this.optimistic)
/*    */     {
/* 50 */       return new OptimisticJBCCache(this.cache, regionName, regionPrefix);
/*    */     }
/*    */ 
/* 54 */     return new JBCCache(this.cache, regionName, regionPrefix, TxUtil.getTransactionManager());
/*    */   }
/*    */ 
/*    */   public boolean isOptimistic()
/*    */   {
/* 61 */     return this.optimistic;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.JBCCacheFactory
 * JD-Core Version:    0.6.0
 */