/*     */ package org.jboss.ejb3.entity;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.hibernate.HibernateException;
/*     */ import org.hibernate.dialect.Dialect;
/*     */ import org.hibernate.engine.SessionFactoryImplementor;
/*     */ import org.hibernate.engine.SessionImplementor;
/*     */ import org.hibernate.exception.JDBCExceptionHelper;
/*     */ import org.hibernate.id.Configurable;
/*     */ import org.hibernate.id.IdentifierGenerationException;
/*     */ import org.hibernate.id.IdentifierGeneratorFactory;
/*     */ import org.hibernate.id.PersistentIdentifierGenerator;
/*     */ import org.hibernate.jdbc.Batcher;
/*     */ import org.hibernate.transaction.TransactionManagerLookup;
/*     */ import org.hibernate.type.Type;
/*     */ import org.hibernate.util.PropertiesHelper;
/*     */ 
/*     */ public class JTATableIdGenerator
/*     */   implements PersistentIdentifierGenerator, Configurable
/*     */ {
/*     */   public static final String COLUMN = "column";
/*     */   public static final String DEFAULT_COLUMN_NAME = "next_hi";
/*     */   public static final String TABLE = "table";
/*     */   public static final String DEFAULT_TABLE_NAME = "next_hi";
/*     */   public static final String ALLOCATION_SIZE = "allocationSize";
/*     */   public static final int DEFAULT_ALLOCATION_SIZE = 20;
/* 101 */   private static final Log log = LogFactory.getLog(JTATableIdGenerator.class);
/*     */   private String tableName;
/*     */   private String columnName;
/*     */   private String query;
/*     */   private String update;
/*     */   private TransactionManagerLookup transactionManagerLookup;
/*     */   private Class returnClass;
/*     */   private int allocationSize;
/*     */ 
/*     */   public void configure(Type type, Properties params, Dialect dialect)
/*     */   {
/* 141 */     this.tableName = PropertiesHelper.getString("table", params, "next_hi");
/* 142 */     this.columnName = PropertiesHelper.getString("column", params, "next_hi");
/* 143 */     this.allocationSize = PropertiesHelper.getInt("allocationSize", params, 20);
/* 144 */     String schemaName = params.getProperty("schema");
/* 145 */     String catalogName = params.getProperty("catalog");
/*     */ 
/* 147 */     throw new RuntimeException("DOES ANYBODY USE THIS?  It IS CURRENTLY BROKEN");
/*     */   }
/*     */ 
/*     */   public synchronized Serializable generate(SessionImplementor session, Object object)
/*     */     throws HibernateException
/*     */   {
/* 198 */     TransactionManager tm = this.transactionManagerLookup.getTransactionManager(new Properties());
/* 199 */     Transaction surroundingTransaction = null;
/* 200 */     Connection conn = null;
/* 201 */     String sql = null;
/*     */     try
/*     */     {
/* 207 */       surroundingTransaction = tm.suspend();
/* 208 */       if (log.isDebugEnabled())
/*     */       {
/* 210 */         log.debug("surrounding tx suspended"); } tm.begin();
/*     */ 
/* 215 */       conn = session.getBatcher().openConnection();
/*     */ 
/* 218 */       sql = this.query;
/* 219 */       PreparedStatement qps = conn.prepareStatement(this.query);
/*     */       long result;
/*     */       try { ResultSet rs = qps.executeQuery();
/* 223 */         if (!rs.next())
/*     */         {
/* 225 */           String err = "could not read sequence value - you need to populate the table: " + this.tableName;
/* 226 */           log.error(err);
/* 227 */           throw new IdentifierGenerationException(err);
/*     */         }
/* 229 */         result = rs.getLong(1);
/* 230 */         rs.close();
/*     */       }
/*     */       catch (SQLException sqle)
/*     */       {
/* 234 */         log.error("could not read a sequence value", sqle);
/* 235 */         throw sqle;
/*     */       }
/*     */       finally
/*     */       {
/* 239 */         qps.close();
/*     */       }
/*     */ 
/* 243 */       sql = this.update;
/* 244 */       long sequence = result + 1L;
/* 245 */       PreparedStatement ups = conn.prepareStatement(this.update);
/*     */       try
/*     */       {
/* 248 */         ups.setLong(1, sequence);
/* 249 */         ups.setLong(2, result);
/* 250 */         ups.executeUpdate();
/*     */       }
/*     */       catch (SQLException sqle)
/*     */       {
/* 254 */         log.error("could not update sequence value in: " + this.tableName, sqle);
/* 255 */         throw sqle;
/*     */       }
/*     */       finally
/*     */       {
/* 259 */         ups.close();
/*     */       }
/*     */ 
/* 263 */       tm.commit();
/*     */ 
/* 266 */       Number typedSequence = IdentifierGeneratorFactory.createNumber(sequence, this.returnClass);
/* 267 */       if (log.isDebugEnabled())
/*     */       {
/* 269 */         log.debug("generate() returned: " + typedSequence);
/*     */       }
/* 271 */       Number localNumber1 = typedSequence;
/*     */       return localNumber1;
/*     */     }
/*     */     catch (SQLException sqle)
/*     */     {
/* 275 */       throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not get or update next value", sql);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       try
/*     */       {
/* 284 */         tm.rollback();
/* 285 */         throw new HibernateException(e);
/*     */       }
/*     */       catch (SystemException e1)
/*     */       {
/* 289 */         throw new HibernateException(e1);
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 294 */       if (conn != null) {
/*     */         try
/*     */         {
/* 297 */           conn.close();
/*     */         }
/*     */         catch (SQLException e)
/*     */         {
/*     */         }
/*     */       }
/*     */ 
/* 304 */       if (surroundingTransaction != null)
/*     */       {
/*     */         try
/*     */         {
/* 308 */           tm.resume(surroundingTransaction);
/* 309 */           if (log.isDebugEnabled())
/*     */           {
/* 311 */             log.debug("surrounding tx resumed");
/*     */           }
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 316 */           throw new HibernateException(e); } 
/*     */       }
/* 316 */     }throw localObject3;
/*     */   }
/*     */ 
/*     */   public String[] sqlCreateStrings(Dialect dialect)
/*     */     throws HibernateException
/*     */   {
/* 325 */     return new String[] { "create table " + this.tableName + " ( " + this.columnName + " " + dialect.getTypeName(-5) + " )", "insert into " + this.tableName + " values ( 0 )" };
/*     */   }
/*     */ 
/*     */   public String[] sqlDropStrings(Dialect dialect)
/*     */   {
/* 334 */     StringBuffer sqlDropString = new StringBuffer().append("drop table ");
/*     */ 
/* 336 */     if (dialect.supportsIfExistsBeforeTableName())
/*     */     {
/* 338 */       sqlDropString.append("if exists ");
/*     */     }
/* 340 */     sqlDropString.append(this.tableName).append(dialect.getCascadeConstraintsString());
/*     */ 
/* 342 */     if (dialect.supportsIfExistsAfterTableName())
/*     */     {
/* 344 */       sqlDropString.append(" if exists");
/*     */     }
/* 346 */     return new String[] { sqlDropString.toString() };
/*     */   }
/*     */ 
/*     */   public Object generatorKey()
/*     */   {
/* 351 */     return this.tableName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.JTATableIdGenerator
 * JD-Core Version:    0.6.0
 */