/*     */ package org.jboss.ejb3.entity;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.persistence.PersistenceException;
/*     */ import javax.persistence.spi.PersistenceUnitTransactionType;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.hibernate.cfg.EJB3DTDEntityResolver;
/*     */ import org.hibernate.ejb.packaging.PersistenceMetadata;
/*     */ import org.hibernate.ejb.packaging.XmlHelper;
/*     */ import org.hibernate.ejb.util.ConfigurationHelper;
/*     */ import org.hibernate.util.StringHelper;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ import org.xml.sax.EntityResolver;
/*     */ import org.xml.sax.ErrorHandler;
/*     */ import org.xml.sax.InputSource;
/*     */ import org.xml.sax.SAXParseException;
/*     */ 
/*     */ @Deprecated
/*     */ public final class PersistenceXmlLoader
/*     */ {
/*  64 */   private static Log log = LogFactory.getLog(PersistenceXmlLoader.class);
/*     */ 
/*     */   private static Document loadURL(URL configURL, EntityResolver resolver)
/*     */     throws Exception
/*     */   {
/*  70 */     InputStream is = configURL != null ? configURL.openStream() : null;
/*  71 */     if (is == null) {
/*  72 */       throw new IOException("Failed to obtain InputStream from url: " + configURL);
/*     */     }
/*  74 */     List errors = new ArrayList();
/*  75 */     DocumentBuilderFactory docBuilderFactory = null;
/*  76 */     docBuilderFactory = DocumentBuilderFactory.newInstance();
/*  77 */     docBuilderFactory.setValidating(true);
/*  78 */     docBuilderFactory.setNamespaceAware(true);
/*     */     try
/*     */     {
/*  81 */       docBuilderFactory.setAttribute("http://apache.org/xml/features/validation/schema", Boolean.valueOf(true));
/*     */     }
/*     */     catch (IllegalArgumentException e) {
/*  84 */       docBuilderFactory.setValidating(false);
/*  85 */       docBuilderFactory.setNamespaceAware(false);
/*     */     }
/*  87 */     InputSource source = new InputSource(is);
/*  88 */     DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
/*  89 */     docBuilder.setEntityResolver(resolver);
/*  90 */     docBuilder.setErrorHandler(new ErrorLogger("XML InputStream", errors, resolver));
/*  91 */     Document doc = docBuilder.parse(source);
/*  92 */     if (errors.size() != 0) {
/*  93 */       throw new PersistenceException("invalid persistence.xml", (Throwable)errors.get(0));
/*     */     }
/*  95 */     return doc;
/*     */   }
/*     */ 
/*     */   public static List<PersistenceMetadata> deploy(URL url, Map overrides, EntityResolver resolver) throws Exception {
/*  99 */     return deploy(url, overrides, resolver, PersistenceUnitTransactionType.RESOURCE_LOCAL);
/*     */   }
/*     */ 
/*     */   public static List<PersistenceMetadata> deploy(URL url, Map overrides, EntityResolver resolver, PersistenceUnitTransactionType defaultTransactionType) throws Exception
/*     */   {
/* 104 */     Document doc = loadURL(url, resolver);
/* 105 */     Element top = doc.getDocumentElement();
/* 106 */     NodeList children = top.getChildNodes();
/* 107 */     ArrayList units = new ArrayList();
/* 108 */     for (int i = 0; i < children.getLength(); i++) {
/* 109 */       if (children.item(i).getNodeType() == 1) {
/* 110 */         Element element = (Element)children.item(i);
/* 111 */         String tag = element.getTagName();
/* 112 */         if (tag.equals("persistence-unit")) {
/* 113 */           PersistenceMetadata metadata = parsePersistenceUnit(element, defaultTransactionType);
/*     */ 
/* 115 */           String provider = (String)overrides.get("javax.persistence.provider");
/* 116 */           if (provider != null) {
/* 117 */             metadata.setProvider(provider);
/*     */           }
/* 119 */           String transactionType = (String)overrides.get("javax.persistence.transactionType");
/* 120 */           if (StringHelper.isNotEmpty(transactionType)) {
/* 121 */             metadata.setTransactionType(getTransactionType(transactionType));
/*     */           }
/* 123 */           String dataSource = (String)overrides.get("javax.persistence.jtaDataSource");
/* 124 */           if (dataSource != null) {
/* 125 */             metadata.setJtaDatasource(dataSource);
/*     */           }
/* 127 */           dataSource = (String)overrides.get("javax.persistence.nonJtaDataSource");
/* 128 */           if (dataSource != null) {
/* 129 */             metadata.setNonJtaDatasource(dataSource);
/*     */           }
/* 131 */           Properties properties = metadata.getProps();
/* 132 */           ConfigurationHelper.overrideProperties(properties, overrides);
/* 133 */           units.add(metadata);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 138 */     return units;
/*     */   }
/*     */ 
/*     */   private static PersistenceMetadata parsePersistenceUnit(Element top, PersistenceUnitTransactionType defaultTransactionType) throws Exception
/*     */   {
/* 143 */     PersistenceMetadata metadata = new PersistenceMetadata();
/* 144 */     String puName = top.getAttribute("name");
/* 145 */     if (StringHelper.isNotEmpty(puName)) {
/* 146 */       log.trace("Persistent Unit name from persistence.xml: " + puName);
/* 147 */       metadata.setName(puName);
/*     */     }
/* 149 */     PersistenceUnitTransactionType transactionType = getTransactionType(top.getAttribute("transaction-type"));
/*     */ 
/* 151 */     transactionType = transactionType != null ? transactionType : defaultTransactionType;
/* 152 */     metadata.setTransactionType(transactionType);
/* 153 */     NodeList children = top.getChildNodes();
/* 154 */     for (int i = 0; i < children.getLength(); i++) {
/* 155 */       if (children.item(i).getNodeType() == 1) {
/* 156 */         Element element = (Element)children.item(i);
/* 157 */         String tag = element.getTagName();
/*     */ 
/* 164 */         if (tag.equals("non-jta-data-source")) {
/* 165 */           metadata.setNonJtaDatasource(XmlHelper.getElementContent(element));
/*     */         }
/* 167 */         else if (tag.equals("jta-data-source")) {
/* 168 */           metadata.setJtaDatasource(XmlHelper.getElementContent(element));
/*     */         }
/* 170 */         else if (tag.equals("provider")) {
/* 171 */           metadata.setProvider(XmlHelper.getElementContent(element));
/*     */         }
/* 173 */         else if (tag.equals("class")) {
/* 174 */           metadata.getClasses().add(XmlHelper.getElementContent(element));
/*     */         }
/* 176 */         else if (tag.equals("mapping-file")) {
/* 177 */           metadata.getMappingFiles().add(XmlHelper.getElementContent(element));
/*     */         }
/* 179 */         else if (tag.equals("jar-file")) {
/* 180 */           metadata.getJarFiles().add(XmlHelper.getElementContent(element));
/*     */         }
/* 182 */         else if (tag.equals("exclude-unlisted-classes")) {
/* 183 */           metadata.setExcludeUnlistedClasses(true);
/*     */         }
/* 185 */         else if (tag.equals("properties")) {
/* 186 */           NodeList props = element.getChildNodes();
/* 187 */           for (int j = 0; j < props.getLength(); j++) {
/* 188 */             if (props.item(j).getNodeType() == 1) {
/* 189 */               Element propElement = (Element)props.item(j);
/* 190 */               if ("property".equals(propElement.getTagName())) {
/* 191 */                 String propName = propElement.getAttribute("name").trim();
/* 192 */                 String propValue = propElement.getAttribute("value").trim();
/* 193 */                 if (StringHelper.isEmpty(propValue))
/*     */                 {
/* 195 */                   propValue = XmlHelper.getElementContent(propElement, "");
/*     */                 }
/* 197 */                 metadata.getProps().put(propName, propValue);
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 205 */     return metadata;
/*     */   }
/*     */ 
/*     */   public static PersistenceUnitTransactionType getTransactionType(String elementContent) {
/* 209 */     if (StringHelper.isEmpty(elementContent)) {
/* 210 */       return null;
/*     */     }
/* 212 */     if (elementContent.equalsIgnoreCase("JTA")) {
/* 213 */       return PersistenceUnitTransactionType.JTA;
/*     */     }
/* 215 */     if (elementContent.equalsIgnoreCase("RESOURCE_LOCAL")) {
/* 216 */       return PersistenceUnitTransactionType.RESOURCE_LOCAL;
/*     */     }
/*     */ 
/* 219 */     throw new PersistenceException("Unknown TransactionType: " + elementContent);
/*     */   }
/*     */   public static class ErrorLogger implements ErrorHandler {
/*     */     private String file;
/*     */     private List errors;
/*     */     private EntityResolver resolver;
/*     */ 
/*     */     ErrorLogger(String file, List errors, EntityResolver resolver) {
/* 230 */       this.file = file;
/* 231 */       this.errors = errors;
/* 232 */       this.resolver = resolver;
/*     */     }
/*     */ 
/*     */     public void error(SAXParseException error) {
/* 236 */       if (((this.resolver instanceof EJB3DTDEntityResolver)) && 
/* 237 */         (!((EJB3DTDEntityResolver)this.resolver).isResolved())) return;
/*     */ 
/* 239 */       PersistenceXmlLoader.log.error("Error parsing XML: " + this.file + '(' + error.getLineNumber() + ") " + error.getMessage());
/* 240 */       this.errors.add(error);
/*     */     }
/*     */ 
/*     */     public void fatalError(SAXParseException error) {
/* 244 */       PersistenceXmlLoader.log.error("Error parsing XML: " + this.file + '(' + error.getLineNumber() + ") " + error.getMessage());
/* 245 */       this.errors.add(error);
/*     */     }
/*     */ 
/*     */     public void warning(SAXParseException warn) {
/* 249 */       PersistenceXmlLoader.log.warn("Warning parsing XML: " + this.file + '(' + warn.getLineNumber() + ") " + warn.getMessage());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.PersistenceXmlLoader
 * JD-Core Version:    0.6.0
 */