/*     */ package org.jboss.ejb3.entity;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import javax.persistence.EntityManager;
/*     */ import javax.persistence.EntityTransaction;
/*     */ import javax.persistence.FlushModeType;
/*     */ import javax.persistence.LockModeType;
/*     */ import javax.persistence.Query;
/*     */ import org.hibernate.Session;
/*     */ import org.hibernate.ejb.HibernateEntityManager;
/*     */ import org.jboss.ejb3.PersistenceUnitRegistry;
/*     */ 
/*     */ public class TransactionScopedEntityManager
/*     */   implements EntityManager, HibernateSession, Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = 4260828563883650376L;
/*     */   private transient ManagedEntityManagerFactory factory;
/*     */ 
/*     */   public Session getHibernateSession()
/*     */   {
/*  47 */     EntityManager em = this.factory.getTransactionScopedEntityManager();
/*  48 */     if ((em instanceof HibernateEntityManager))
/*     */     {
/*  50 */       return ((HibernateEntityManager)em).getSession();
/*     */     }
/*  52 */     throw new RuntimeException("ILLEGAL ACTION:  Not a Hibernate persistence provider");
/*     */   }
/*     */ 
/*     */   public TransactionScopedEntityManager(ManagedEntityManagerFactory factory)
/*     */   {
/*  58 */     if (factory == null) throw new NullPointerException("factory must not be null");
/*  59 */     this.factory = factory;
/*     */   }
/*     */ 
/*     */   public TransactionScopedEntityManager()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out) throws IOException
/*     */   {
/*  68 */     out.writeUTF(this.factory.getKernelName());
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*     */   {
/*  73 */     String kernelName = in.readUTF();
/*  74 */     PersistenceUnitDeployment deployment = PersistenceUnitRegistry.getPersistenceUnit(kernelName);
/*  75 */     if (deployment == null) throw new IOException("Unable to find persistence unit in registry: " + kernelName);
/*  76 */     this.factory = deployment.getManagedFactory();
/*     */   }
/*     */ 
/*     */   public Object getDelegate()
/*     */   {
/*  81 */     return this.factory.getTransactionScopedEntityManager().getDelegate();
/*     */   }
/*     */ 
/*     */   public void joinTransaction()
/*     */   {
/*  86 */     this.factory.verifyInTx();
/*  87 */     this.factory.getTransactionScopedEntityManager().joinTransaction();
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/*  92 */     this.factory.getTransactionScopedEntityManager().clear();
/*     */   }
/*     */ 
/*     */   public FlushModeType getFlushMode()
/*     */   {
/*  97 */     return this.factory.getTransactionScopedEntityManager().getFlushMode();
/*     */   }
/*     */ 
/*     */   public void lock(Object entity, LockModeType lockMode)
/*     */   {
/* 102 */     this.factory.verifyInTx();
/* 103 */     this.factory.getTransactionScopedEntityManager().lock(entity, lockMode);
/*     */   }
/*     */ 
/*     */   public <T> T getReference(Class<T> entityClass, Object primaryKey)
/*     */   {
/* 108 */     EntityManager em = this.factory.getTransactionScopedEntityManager();
/* 109 */     if (!this.factory.isInTx()) em.clear();
/*     */     try
/*     */     {
/* 112 */       Object localObject1 = em.getReference(entityClass, primaryKey);
/*     */       return localObject1; } finally { if (!this.factory.isInTx()) em.clear();  }
/* 116 */     throw localObject2;
/*     */   }
/*     */ 
/*     */   public void setFlushMode(FlushModeType flushMode)
/*     */   {
/* 122 */     this.factory.getTransactionScopedEntityManager().setFlushMode(flushMode);
/*     */   }
/*     */ 
/*     */   public Query createQuery(String ejbqlString)
/*     */   {
/* 127 */     EntityManager em = this.factory.getTransactionScopedEntityManager();
/* 128 */     if (!this.factory.isInTx()) em.clear();
/* 129 */     return em.createQuery(ejbqlString);
/*     */   }
/*     */ 
/*     */   public Query createNamedQuery(String name)
/*     */   {
/* 134 */     EntityManager em = this.factory.getTransactionScopedEntityManager();
/* 135 */     if (!this.factory.isInTx()) em.clear();
/* 136 */     return em.createNamedQuery(name);
/*     */   }
/*     */ 
/*     */   public Query createNativeQuery(String sqlString)
/*     */   {
/* 141 */     EntityManager em = this.factory.getTransactionScopedEntityManager();
/* 142 */     if (!this.factory.isInTx()) em.clear();
/* 143 */     return em.createNativeQuery(sqlString);
/*     */   }
/*     */ 
/*     */   public Query createNativeQuery(String sqlString, Class resultClass)
/*     */   {
/* 148 */     EntityManager em = this.factory.getTransactionScopedEntityManager();
/* 149 */     if (!this.factory.isInTx()) em.clear();
/* 150 */     return em.createNativeQuery(sqlString, resultClass);
/*     */   }
/*     */ 
/*     */   public Query createNativeQuery(String sqlString, String resultSetMapping)
/*     */   {
/* 155 */     EntityManager em = this.factory.getTransactionScopedEntityManager();
/* 156 */     if (!this.factory.isInTx()) em.clear();
/* 157 */     return em.createNativeQuery(sqlString, resultSetMapping);
/*     */   }
/*     */ 
/*     */   public <A> A find(Class<A> entityClass, Object primaryKey)
/*     */   {
/* 162 */     EntityManager em = this.factory.getTransactionScopedEntityManager();
/* 163 */     if (!this.factory.isInTx()) em.clear();
/*     */     try
/*     */     {
/* 166 */       Object localObject1 = em.find(entityClass, primaryKey);
/*     */       return localObject1; } finally { if (!this.factory.isInTx()) em.clear();  }
/* 170 */     throw localObject2;
/*     */   }
/*     */ 
/*     */   public void persist(Object entity)
/*     */   {
/* 176 */     this.factory.verifyInTx();
/* 177 */     this.factory.getTransactionScopedEntityManager().persist(entity);
/*     */   }
/*     */ 
/*     */   public <A> A merge(A entity)
/*     */   {
/* 182 */     this.factory.verifyInTx();
/* 183 */     return this.factory.getTransactionScopedEntityManager().merge(entity);
/*     */   }
/*     */ 
/*     */   public void remove(Object entity)
/*     */   {
/* 188 */     this.factory.verifyInTx();
/* 189 */     this.factory.getTransactionScopedEntityManager().remove(entity);
/*     */   }
/*     */ 
/*     */   public void refresh(Object entity)
/*     */   {
/* 194 */     this.factory.verifyInTx();
/* 195 */     this.factory.getTransactionScopedEntityManager().refresh(entity);
/*     */   }
/*     */ 
/*     */   public boolean contains(Object entity)
/*     */   {
/* 200 */     return this.factory.getTransactionScopedEntityManager().contains(entity);
/*     */   }
/*     */ 
/*     */   public void flush()
/*     */   {
/* 205 */     this.factory.verifyInTx();
/* 206 */     this.factory.getTransactionScopedEntityManager().flush();
/*     */   }
/*     */ 
/*     */   public void close()
/*     */   {
/* 211 */     throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
/*     */   }
/*     */ 
/*     */   public boolean isOpen()
/*     */   {
/* 216 */     throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
/*     */   }
/*     */ 
/*     */   public EntityTransaction getTransaction()
/*     */   {
/* 221 */     throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.entity.TransactionScopedEntityManager
 * JD-Core Version:    0.6.0
 */