/*     */ package org.jboss.ejb3.iiop;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.net.URL;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.rmi.PortableRemoteObject;
/*     */ import org.jboss.classloading.spi.RealClassLoader;
/*     */ import org.jboss.ejb3.InitialContextFactory;
/*     */ import org.jboss.ejb3.NonSerializableFactory;
/*     */ import org.jboss.ejb3.ProxyFactoryHelper;
/*     */ import org.jboss.ejb3.annotation.IIOP;
/*     */ import org.jboss.ejb3.annotation.RemoteBinding;
/*     */ import org.jboss.ejb3.remoting.RemoteProxyFactory;
/*     */ import org.jboss.ejb3.session.SessionContainer;
/*     */ import org.jboss.iiop.CorbaNamingService;
/*     */ import org.jboss.iiop.CorbaORBService;
/*     */ import org.jboss.iiop.rmi.InterfaceAnalysis;
/*     */ import org.jboss.iiop.rmi.ir.InterfaceRepository;
/*     */ import org.jboss.invocation.iiop.ReferenceFactory;
/*     */ import org.jboss.invocation.iiop.ServantRegistries;
/*     */ import org.jboss.invocation.iiop.ServantRegistry;
/*     */ import org.jboss.invocation.iiop.ServantRegistryKind;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.IorSecurityConfigMetaData;
/*     */ import org.jboss.mx.util.MBeanProxyExt;
/*     */ import org.jboss.proxy.ejb.handle.HandleDelegateImpl;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.web.WebClassLoader;
/*     */ import org.jboss.web.WebServiceMBean;
/*     */ import org.omg.CORBA.Any;
/*     */ import org.omg.CORBA.InterfaceDef;
/*     */ import org.omg.CORBA.InterfaceDefHelper;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CORBA.Policy;
/*     */ import org.omg.CORBA.Repository;
/*     */ import org.omg.CosNaming.NameComponent;
/*     */ import org.omg.CosNaming.NamingContext;
/*     */ import org.omg.CosNaming.NamingContextExt;
/*     */ import org.omg.CosNaming.NamingContextExtHelper;
/*     */ import org.omg.CosNaming.NamingContextHelper;
/*     */ import org.omg.CosNaming.NamingContextPackage.NotFound;
/*     */ import org.omg.PortableServer.Current;
/*     */ import org.omg.PortableServer.CurrentHelper;
/*     */ import org.omg.PortableServer.POA;
/*     */ import org.omg.PortableServer.Servant;
/*     */ 
/*     */ public class IORFactory
/*     */   implements RemoteProxyFactory
/*     */ {
/*     */   private static final Logger log;
/*     */   private SessionContainer container;
/*     */   private RemoteBinding binding;
/*  89 */   private String webServiceName = "jboss:service=WebService";
/*     */   private String[] beanRepositoryIds;
/*     */   private String[] homeRepositoryIds;
/*     */   private ORB orb;
/*     */   private POA irPoa;
/*     */   private InterfaceRepository iri;
/*     */   private ServantRegistry servantRegistry;
/*     */   private ServantRegistry homeServantRegistry;
/*     */   private WebClassLoader wcl;
/*     */   private ReferenceFactory referenceFactory;
/*     */   private ReferenceFactory homeReferenceFactory;
/*     */   private static final IIOP defaultIIOP;
/*     */ 
/*     */   public IORFactory(SessionContainer container, RemoteBinding binding)
/*     */   {
/* 107 */     assert (container != null) : "container is null";
/* 108 */     assert (binding != null) : "binding is null";
/*     */ 
/* 110 */     this.container = container;
/* 111 */     this.binding = binding;
/*     */   }
/*     */ 
/*     */   public java.lang.Object createHomeProxy()
/*     */   {
/*     */     try
/*     */     {
/* 138 */       org.omg.CORBA.Object corbaRef = this.homeReferenceFactory.createReference(this.homeRepositoryIds[0]);
/*     */ 
/* 140 */       EJBHome corbaObj = (EJBHome)PortableRemoteObject.narrow(corbaRef, EJBHome.class);
/*     */ 
/* 142 */       return corbaObj;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 146 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public java.lang.Object createProxy()
/*     */   {
/*     */     try
/*     */     {
/* 154 */       org.omg.CORBA.Object corbaRef = this.referenceFactory.createReference(this.beanRepositoryIds[0]);
/*     */ 
/* 156 */       EJBObject corbaObj = (EJBObject)PortableRemoteObject.narrow(corbaRef, EJBObject.class);
/*     */ 
/* 158 */       return corbaObj;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 162 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public java.lang.Object createProxy(java.lang.Object id)
/*     */   {
/*     */     try
/*     */     {
/* 170 */       org.omg.CORBA.Object corbaRef = this.referenceFactory.createReferenceWithId(id, this.beanRepositoryIds[0]);
/*     */ 
/* 172 */       EJBObject corbaObj = (EJBObject)PortableRemoteObject.narrow(corbaRef, EJBObject.class);
/*     */ 
/* 174 */       return corbaObj;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 178 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   private IIOP getIIOP()
/*     */   {
/* 184 */     IIOP iiop = (IIOP)this.container.getAnnotation(IIOP.class);
/* 185 */     if (iiop != null) {
/* 186 */       return iiop;
/*     */     }
/* 188 */     return defaultIIOP;
/*     */   }
/*     */ 
/*     */   private String getJndiName()
/*     */   {
/* 193 */     return ProxyFactoryHelper.getDefaultRemoteJndiName(this.container);
/*     */   }
/*     */ 
/*     */   private String getServantName()
/*     */   {
/* 199 */     return "Servant/" + getJndiName();
/*     */   }
/*     */ 
/*     */   private WebServiceMBean getWebServer() throws MalformedObjectNameException
/*     */   {
/* 204 */     if (this.webServiceName == null) {
/* 205 */       throw new IllegalStateException("iiop is not going to work without a web service");
/*     */     }
/* 207 */     return (WebServiceMBean)MBeanProxyExt.create(WebServiceMBean.class, this.webServiceName);
/*     */   }
/*     */ 
/*     */   private void rebind(NamingContextExt ctx, String strName, org.omg.CORBA.Object obj)
/*     */     throws Exception
/*     */   {
/* 215 */     NameComponent[] name = ctx.to_name(strName);
/* 216 */     NamingContext intermediateCtx = ctx;
/*     */ 
/* 218 */     for (int i = 0; i < name.length - 1; i++) {
/* 219 */       NameComponent[] relativeName = { name[i] };
/*     */       try {
/* 221 */         intermediateCtx = NamingContextHelper.narrow(intermediateCtx.resolve(relativeName));
/*     */       }
/*     */       catch (NotFound e)
/*     */       {
/* 225 */         intermediateCtx = intermediateCtx.bind_new_context(relativeName);
/*     */       }
/*     */     }
/* 228 */     intermediateCtx.rebind(new NameComponent[] { name[(name.length - 1)] }, obj);
/*     */   }
/*     */ 
/*     */   private void removeWebClassLoader() throws MalformedObjectNameException
/*     */   {
/* 233 */     getWebServer().removeClassLoader(this.wcl);
/*     */   }
/*     */ 
/*     */   public void setWebServiceName(String name)
/*     */   {
/* 238 */     this.webServiceName = name;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 244 */     Class[] remoteInterfaces = ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(this.container);
/* 245 */     if (remoteInterfaces.length > 1)
/* 246 */       log.warn("IIOP binding only works on 1 interface, using: " + remoteInterfaces[0].getName());
/* 247 */     InterfaceAnalysis interfaceAnalysis = InterfaceAnalysis.getInterfaceAnalysis(remoteInterfaces[0]);
/* 248 */     this.beanRepositoryIds = interfaceAnalysis.getAllTypeIds();
/*     */ 
/* 250 */     InterfaceAnalysis homeInterfaceAnalysis = null;
/* 251 */     Class homeInterface = ProxyFactoryHelper.getRemoteHomeInterface(this.container);
/* 252 */     if (homeInterface != null)
/*     */     {
/* 254 */       if (!EJBHome.class.isAssignableFrom(homeInterface))
/* 255 */         throw new IllegalArgumentException("home interface " + homeInterface.getName() + " must extend javax.ejb.EJBHome (EJB3 4.6.8)");
/* 256 */       homeInterfaceAnalysis = InterfaceAnalysis.getInterfaceAnalysis(homeInterface);
/* 257 */       this.homeRepositoryIds = homeInterfaceAnalysis.getAllTypeIds();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 263 */       this.orb = ((ORB)InitialContextFactory.getInitialContext().lookup("java:/" + CorbaORBService.ORB_NAME));
/*     */     }
/*     */     catch (NamingException e) {
/* 266 */       throw new Exception("Cannot lookup java:/" + CorbaORBService.ORB_NAME + ": " + e);
/*     */     }
/*     */     try {
/* 269 */       this.irPoa = ((POA)InitialContextFactory.getInitialContext().lookup("java:/" + CorbaORBService.IR_POA_NAME));
/*     */     }
/*     */     catch (NamingException e) {
/* 272 */       throw new Exception("Cannot lookup java:/" + CorbaORBService.IR_POA_NAME + ": " + e);
/*     */     }
/*     */ 
/* 275 */     IIOP iiop = getIIOP();
/* 276 */     if (iiop.interfaceRepositorySupported())
/*     */     {
/* 278 */       this.iri = new InterfaceRepository(this.orb, this.irPoa, getJndiName());
/* 279 */       this.iri.mapClass(remoteInterfaces[0]);
/* 280 */       if (homeInterface != null)
/* 281 */         this.iri.mapClass(homeInterface);
/* 282 */       this.iri.finishBuild();
/*     */     }
/*     */ 
/* 286 */     ObjectName invokerName = new ObjectName("jboss:service=invoker,type=iiop");
/* 287 */     ServantRegistries servantRegistries = (ServantRegistries)Registry.lookup(invokerName);
/* 288 */     if (servantRegistries == null)
/* 289 */       throw new Exception("can't find iiop invoker");
/*     */     ServantRegistryKind registryWithPersistentPOA;
/* 292 */     if (iiop.poa().equals("per-servant"))
/*     */     {
/* 294 */       ServantRegistryKind registryWithTransientPOA = ServantRegistryKind.TRANSIENT_POA_PER_SERVANT;
/* 295 */       registryWithPersistentPOA = ServantRegistryKind.PERSISTENT_POA_PER_SERVANT;
/*     */     }
/*     */     else
/*     */     {
/*     */       ServantRegistryKind registryWithPersistentPOA;
/* 297 */       if (iiop.poa().equals("shared"))
/*     */       {
/* 299 */         ServantRegistryKind registryWithTransientPOA = ServantRegistryKind.SHARED_TRANSIENT_POA;
/* 300 */         registryWithPersistentPOA = ServantRegistryKind.SHARED_PERSISTENT_POA;
/*     */       }
/*     */       else {
/* 303 */         throw new IllegalArgumentException("@IIOP.poa can only be 'per-servant' or 'shared'");
/*     */       }
/*     */     }
/*     */     ServantRegistryKind registryWithPersistentPOA;
/*     */     ServantRegistryKind registryWithTransientPOA;
/* 305 */     this.servantRegistry = servantRegistries.getServantRegistry(registryWithTransientPOA);
/* 306 */     this.homeServantRegistry = servantRegistries.getServantRegistry(registryWithPersistentPOA);
/*     */ 
/* 310 */     ObjectName on = this.container.getObjectName();
/* 311 */     this.wcl = new EJB3IIOPWebClassLoader(on, (RealClassLoader)this.container.getClassloader(), getJndiName());
/* 312 */     WebServiceMBean webServer = getWebServer();
/* 313 */     URL[] codebaseURLs = { webServer.addClassLoader(this.wcl) };
/* 314 */     this.wcl.setWebURLs(codebaseURLs);
/*     */ 
/* 317 */     String codebaseString = this.wcl.getCodebaseString();
/* 318 */     log.debug("codebase = " + codebaseString);
/* 319 */     Any codebase = this.orb.create_any();
/* 320 */     codebase.insert_string(codebaseString);
/*     */ 
/* 322 */     Policy codebasePolicy = this.orb.create_policy(305419896, codebase);
/*     */ 
/* 326 */     Any secPolicy = this.orb.create_any();
/*     */ 
/* 329 */     IorSecurityConfigMetaData iorSecurityConfigMetaData = new IorSecurityConfigMetaData();
/* 330 */     secPolicy.insert_Value(iorSecurityConfigMetaData);
/* 331 */     Policy csiv2Policy = this.orb.create_policy(-2023406815, secPolicy);
/*     */ 
/* 333 */     Policy[] policies = { codebasePolicy, csiv2Policy };
/*     */ 
/* 335 */     InterfaceDef interfaceDef = null;
/* 336 */     if (this.iri != null)
/*     */     {
/* 338 */       Repository ir = this.iri.getReference();
/* 339 */       interfaceDef = InterfaceDefHelper.narrow(ir.lookup_id(this.beanRepositoryIds[0]));
/*     */     }
/*     */ 
/* 342 */     Current poaCurrent = CurrentHelper.narrow(this.orb.resolve_initial_references("POACurrent"));
/*     */ 
/* 344 */     NamingContextExt ctx = getNamingContextExt();
/*     */ 
/* 346 */     log.debug("binding servant name " + getServantName());
/*     */ 
/* 348 */     Servant servant = new BeanCorbaServant(this, poaCurrent, this.container, interfaceDef, interfaceAnalysis);
/* 349 */     this.referenceFactory = this.servantRegistry.bind(getServantName(), servant, policies);
/*     */ 
/* 351 */     EJBObject corbaObj = (EJBObject)createProxy();
/*     */ 
/* 353 */     rebind(ctx, getJndiName(), (org.omg.CORBA.Object)corbaObj);
/*     */ 
/* 356 */     if (homeInterfaceAnalysis != null)
/*     */     {
/* 358 */       servant = new BeanCorbaServant(this, poaCurrent, this.container, null, homeInterfaceAnalysis);
/* 359 */       this.homeReferenceFactory = this.homeServantRegistry.bind(getServantName() + "Home", servant, policies);
/*     */ 
/* 361 */       java.lang.Object homeObject = createHomeProxy();
/*     */ 
/* 363 */       rebind(ctx, ProxyFactoryHelper.getHomeJndiName(this.container), (org.omg.CORBA.Object)homeObject);
/*     */     }
/*     */ 
/* 367 */     Context compCtx = (Context)InitialContextFactory.getInitialContext().lookup("java:comp");
/* 368 */     NonSerializableFactory.rebind(compCtx, "ORB", this.orb);
/* 369 */     NonSerializableFactory.rebind(compCtx, "HandleDelegate", new HandleDelegateImpl());
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 374 */     if (this.homeReferenceFactory != null)
/*     */     {
/* 376 */       unbind(ProxyFactoryHelper.getHomeJndiName(this.container));
/* 377 */       unbindHomeServant();
/*     */     }
/* 379 */     unbind(getJndiName());
/*     */ 
/* 381 */     unbindServant();
/*     */ 
/* 383 */     removeWebClassLoader();
/*     */   }
/*     */ 
/*     */   private void unbind(String strName)
/*     */   {
/*     */     try
/*     */     {
/* 393 */       NamingContextExt corbaContext = getNamingContextExt();
/* 394 */       NameComponent[] n = corbaContext.to_name(strName);
/* 395 */       getNamingContextExt().unbind(n);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 399 */       log.warn("unable to unbind '" + strName + "'", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void unbindHomeServant()
/*     */   {
/*     */     try
/*     */     {
/* 407 */       this.homeServantRegistry.unbind(getServantName() + "Home");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 411 */       log.warn("unable to unbind home servant", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void unbindServant()
/*     */   {
/*     */     try
/*     */     {
/* 419 */       this.servantRegistry.unbind(getServantName());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 423 */       log.warn("unable to unbind servant", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private NamingContextExt getNamingContextExt() throws NamingException
/*     */   {
/* 429 */     Context initialContext = InitialContextFactory.getInitialContext();
/*     */ 
/* 433 */     return NamingContextExtHelper.narrow((org.omg.CORBA.Object)initialContext.lookup("java:/" + CorbaNamingService.NAMING_NAME));
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  85 */     log = Logger.getLogger(IORFactory.class);
/*     */ 
/* 115 */     defaultIIOP = new IIOP()
/*     */     {
/*     */       public boolean interfaceRepositorySupported()
/*     */       {
/* 119 */         return false;
/*     */       }
/*     */ 
/*     */       public String poa()
/*     */       {
/* 124 */         return "per-servant";
/*     */       }
/*     */ 
/*     */       public Class<? extends Annotation> annotationType()
/*     */       {
/* 129 */         return IIOP.class;
/*     */       }
/*     */     };
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.iiop.IORFactory
 * JD-Core Version:    0.6.0
 */