/*     */ package org.jboss.ejb3.jndipolicy.impl;
/*     */ 
/*     */ import org.jboss.ejb3.jndipolicy.DefaultJndiBindingPolicy;
/*     */ import org.jboss.ejb3.jndipolicy.Ejb3DeploymentSummary;
/*     */ 
/*     */ public class PackagingBasedJndiBindingPolicy
/*     */   implements DefaultJndiBindingPolicy
/*     */ {
/*     */   private static final String JNDI_SUFFIX_REMOTE = "/remote";
/*     */   private static final String JNDI_SUFFIX_LOCAL = "/local";
/*     */   private static final String JNDI_SUFFIX_REMOTE_HOME = "/home";
/*     */   private static final String JNDI_SUFFIX_LOCAL_HOME = "/localHome";
/*     */ 
/*     */   public String getJndiName(Ejb3DeploymentSummary summary)
/*     */   {
/*  53 */     if (!summary.isLocal())
/*     */     {
/*  56 */       if (summary.isHome())
/*     */       {
/*  58 */         return getDefaultRemoteHomeJndiName(summary);
/*     */       }
/*     */ 
/*  63 */       return getDefaultRemoteJndiName(summary);
/*     */     }
/*     */ 
/*  69 */     if (summary.isHome())
/*     */     {
/*  71 */       return getDefaultLocalHomeJndiName(summary);
/*     */     }
/*     */ 
/*  75 */     return getDefaultLocalJndiName(summary);
/*     */   }
/*     */ 
/*     */   public String getDefaultRemoteJndiName(Ejb3DeploymentSummary summary)
/*     */   {
/*  83 */     String name = summary.getEjbName() + "/remote";
/*  84 */     if (summary.getDeploymentScopeBaseName() != null)
/*  85 */       name = summary.getDeploymentScopeBaseName() + "/" + name;
/*  86 */     return name;
/*     */   }
/*     */ 
/*     */   public String getDefaultRemoteHomeJndiName(Ejb3DeploymentSummary summary)
/*     */   {
/*  91 */     return summary.getEjbName() + "/home";
/*     */   }
/*     */ 
/*     */   public String getDefaultLocalHomeJndiName(Ejb3DeploymentSummary summary)
/*     */   {
/*  96 */     return summary.getEjbName() + "/localHome";
/*     */   }
/*     */ 
/*     */   public String getDefaultLocalJndiName(Ejb3DeploymentSummary summary)
/*     */   {
/* 101 */     String name = summary.getEjbName() + "/local";
/* 102 */     if (summary.getDeploymentScopeBaseName() != null)
/* 103 */       name = summary.getDeploymentScopeBaseName() + "/" + name;
/* 104 */     return name;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.jndipolicy.impl.PackagingBasedJndiBindingPolicy
 * JD-Core Version:    0.6.0
 */