/*    */ package org.jboss.ejb3.mdb;
/*    */ 
/*    */ import java.lang.reflect.Field;
/*    */ import java.lang.reflect.Method;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.metadata.SimpleMetaData;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class CurrentMessageInjectorInterceptor
/*    */   implements Interceptor
/*    */ {
/* 38 */   protected static final Logger log = Logger.getLogger(CurrentMessageInjectorInterceptor.class);
/*    */   private Field[] fields;
/*    */   private Method[] methods;
/*    */ 
/*    */   public CurrentMessageInjectorInterceptor(Field[] fields, Method[] methods)
/*    */   {
/* 45 */     this.fields = fields;
/* 46 */     if (fields != null)
/*    */     {
/* 48 */       for (Field field : fields)
/*    */       {
/* 50 */         field.setAccessible(true);
/*    */       }
/*    */     }
/* 53 */     this.methods = methods;
/* 54 */     if (methods != null)
/*    */     {
/* 56 */       for (Method method : methods)
/*    */       {
/* 58 */         method.setAccessible(true);
/*    */       }
/*    */     }
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 66 */     return getClass().getName();
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable
/*    */   {
/* 71 */     Object target = invocation.getTargetObject();
/* 72 */     Object message = invocation.getMetaData().getMetaData("CONSUMER_MESSAGE", "CONSUMER_MESSAGE");
/* 73 */     if (this.fields != null)
/*    */     {
/* 75 */       for (Field field : this.fields)
/*    */       {
/* 77 */         field.set(target, message);
/*    */       }
/*    */     }
/* 80 */     if (this.methods != null)
/*    */     {
/* 82 */       for (Method method : this.methods)
/*    */       {
/* 84 */         method.invoke(target, new Object[] { message });
/*    */       }
/*    */     }
/*    */ 
/*    */     try
/*    */     {
/* 90 */       ??? = invocation.invokeNext();
/*    */     }
/*    */     finally
/*    */     {
/* 95 */       if (this.fields != null)
/*    */       {
/* 97 */         for (Field field : this.fields)
/*    */         {
/* 99 */           field.set(target, null);
/*    */         }
/*    */       }
/* 102 */       if (this.methods != null)
/*    */       {
/* 104 */         for (Method method : this.methods)
/*    */         {
/* 106 */           Object[] args = new Object[method.getParameterTypes().length];
/* 107 */           for (int i = 0; i < args.length; i++)
/* 108 */             args[i] = null;
/* 109 */           method.invoke(target, args);
/*    */         }
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.mdb.CurrentMessageInjectorInterceptor
 * JD-Core Version:    0.6.0
 */