/*     */ package org.jboss.ejb3.mdb.inflow;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import javax.resource.ResourceException;
/*     */ import javax.resource.spi.endpoint.MessageEndpointFactory;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import javax.transaction.xa.XAResource;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.ejb3.mdb.MessagingContainer;
/*     */ import org.jboss.ejb3.tx.TxUtil;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class MessageInflowLocalProxy
/*     */   implements InvocationHandler
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(MessageInflowLocalProxy.class);
/*     */   public static final String MESSAGE_ENDPOINT_FACTORY = "MessageEndpoint.Factory";
/*     */   public static final String MESSAGE_ENDPOINT_XARESOURCE = "MessageEndpoint.XAResource";
/*  58 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*  61 */   private String cachedProxyString = null;
/*     */ 
/*  64 */   protected SynchronizedBoolean released = new SynchronizedBoolean(false);
/*     */ 
/*  67 */   protected boolean delivered = false;
/*     */ 
/*  70 */   protected Thread inUseThread = null;
/*     */ 
/*  73 */   protected ClassLoader oldClassLoader = null;
/*     */ 
/*  76 */   protected Transaction transaction = null;
/*     */ 
/*  79 */   protected Transaction suspended = null;
/*     */   private JBossMessageEndpointFactory endpointFactory;
/*     */   private XAResource resource;
/*     */   private MessageEndpointFactory messageEndpointFactory;
/*     */   MessagingContainer container;
/*     */ 
/*     */   protected MessageInflowLocalProxy(MessagingContainer container)
/*     */   {
/*  91 */     this.container = container;
/*     */   }
/*     */ 
/*     */   public void setMessageEndpointFactory(MessageEndpointFactory messageEndpointFactory)
/*     */   {
/*  96 */     this.messageEndpointFactory = messageEndpointFactory;
/*     */   }
/*     */ 
/*     */   public void setXaResource(XAResource resource)
/*     */   {
/* 101 */     this.resource = resource;
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 108 */     if (this.released.get()) {
/* 109 */       throw new IllegalStateException("This message endpoint + " + getProxyString(proxy) + " has been released");
/*     */     }
/*     */ 
/* 112 */     Thread currentThread = Thread.currentThread();
/* 113 */     if ((this.inUseThread != null) && (!this.inUseThread.equals(currentThread)))
/* 114 */       throw new IllegalStateException("This message endpoint + " + getProxyString(proxy) + " is already in use by another thread " + this.inUseThread);
/* 115 */     this.inUseThread = currentThread;
/*     */ 
/* 117 */     if (this.trace) {
/* 118 */       log.trace("MessageEndpoint " + getProxyString(proxy) + " in use by " + method + " " + this.inUseThread);
/*     */     }
/*     */ 
/* 121 */     if (method.getName().equals("release"))
/*     */     {
/* 123 */       release(proxy);
/* 124 */       return null;
/*     */     }
/* 126 */     if (method.getName().equals("beforeDelivery"))
/*     */     {
/* 128 */       before(proxy, this.container, method, args);
/* 129 */       return null;
/*     */     }
/* 131 */     if (method.getName().equals("afterDelivery"))
/*     */     {
/* 133 */       after(proxy);
/* 134 */       return null;
/*     */     }
/*     */ 
/* 137 */     return delivery(proxy, this.container, method, args);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 142 */     return this.container.getEjbName().toString();
/*     */   }
/*     */ 
/*     */   protected void release(Object proxy)
/*     */     throws Throwable
/*     */   {
/* 156 */     this.released.set(true);
/*     */ 
/* 158 */     if (this.trace) {
/* 159 */       log.trace("MessageEndpoint " + getProxyString(proxy) + " release " + Thread.currentThread());
/*     */     }
/*     */ 
/* 162 */     if (this.oldClassLoader != null)
/*     */     {
/*     */       try
/*     */       {
/* 166 */         finish("release", proxy, false);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 170 */         log.warn("Error in release ", t);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void before(Object proxy, MessagingContainer container, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 184 */     if (this.oldClassLoader != null) {
/* 185 */       throw new IllegalStateException("Missing afterDelivery from the previous beforeDelivery for message endpoint " + getProxyString(proxy));
/*     */     }
/* 187 */     if (this.trace) {
/* 188 */       log.trace("MessageEndpoint " + getProxyString(proxy) + " before");
/*     */     }
/*     */ 
/* 191 */     this.oldClassLoader = GetTCLAction.getContextClassLoader(this.inUseThread);
/* 192 */     SetTCLAction.setContextClassLoader(this.inUseThread, container.getClassloader());
/* 193 */     if (this.trace) {
/* 194 */       log.trace("MessageEndpoint " + getProxyString(proxy) + " set context classloader to " + container.getClassloader());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 200 */       MethodInfo methodInfo = container.getMethodInfo((Method)args[0]);
/* 201 */       boolean isTransacted = this.messageEndpointFactory.isDeliveryTransacted(methodInfo.getAdvisedMethod());
/*     */ 
/* 203 */       startTransaction("beforeDelivery", proxy, container, method, args, isTransacted);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 207 */       resetContextClassLoader(proxy);
/* 208 */       throw new ResourceException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void after(Object proxy)
/*     */     throws Throwable
/*     */   {
/* 221 */     if (this.oldClassLoader == null) {
/* 222 */       throw new IllegalStateException("afterDelivery without a previous beforeDelivery for message endpoint " + getProxyString(proxy));
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 227 */       finish("afterDelivery", proxy, true);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 231 */       throw new ResourceException(t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Object delivery(Object proxy, MessagingContainer container, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 245 */     if (this.delivered) {
/* 246 */       throw new IllegalStateException("Multiple message delivery between before and after delivery is not allowed for message endpoint " + getProxyString(proxy));
/*     */     }
/* 248 */     if (this.trace) {
/* 249 */       log.trace("MessageEndpoint " + getProxyString(proxy) + " delivering");
/*     */     }
/*     */ 
/* 252 */     if (this.oldClassLoader != null) {
/* 253 */       this.delivered = true;
/*     */     }
/* 255 */     boolean commit = true;
/*     */ 
/* 257 */     MethodInfo methodInfo = container.getMethodInfo(method);
/*     */     try
/*     */     {
/* 262 */       if (this.oldClassLoader == null)
/*     */       {
/* 264 */         isTransacted = this.messageEndpointFactory.isDeliveryTransacted(methodInfo.getAdvisedMethod());
/* 265 */         startTransaction("delivery", proxy, container, method, args, isTransacted);
/*     */       }
/* 267 */       isTransacted = container.localInvoke(methodInfo, args);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/*     */       boolean isTransacted;
/* 271 */       if (this.trace)
/* 272 */         log.trace("MessageEndpoint " + getProxyString(proxy) + " delivery error", t);
/* 273 */       if (((t instanceof Error)) || ((t instanceof RuntimeException)))
/*     */       {
/* 275 */         if (this.transaction != null)
/* 276 */           this.transaction.setRollbackOnly();
/* 277 */         commit = false;
/*     */       }
/* 279 */       throw t;
/*     */     }
/*     */     finally
/*     */     {
/* 284 */       if (this.oldClassLoader != null);
/*     */     }
/*     */ 
/* 293 */     ret;
/*     */   }
/*     */ 
/*     */   protected void finish(String context, Object proxy, boolean commit)
/*     */     throws Throwable
/*     */   {
/*     */     try
/*     */     {
/* 311 */       endTransaction(proxy, commit);
/*     */     }
/*     */     finally
/*     */     {
/* 316 */       this.delivered = false;
/*     */ 
/* 318 */       resetContextClassLoader(proxy);
/*     */ 
/* 320 */       releaseThreadLock(proxy);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void startTransaction(String context, Object proxy, MessagingContainer container, Method m, Object[] args, boolean isTransacted)
/*     */     throws Throwable
/*     */   {
/*     */     Method method;
/*     */     Method method;
/* 337 */     if ("delivery".equals(context)) {
/* 338 */       method = m;
/*     */     }
/*     */     else {
/* 341 */       method = (Method)args[0];
/*     */     }
/* 343 */     if (this.trace) {
/* 344 */       log.trace("MessageEndpoint " + getProxyString(proxy) + " " + context + " method=" + method + " xaResource=" + this.resource + " transacted=" + isTransacted);
/*     */     }
/*     */ 
/* 347 */     TransactionManager tm = TxUtil.getTransactionManager();
/* 348 */     this.suspended = tm.suspend();
/*     */ 
/* 350 */     if (this.trace) {
/* 351 */       log.trace("MessageEndpoint " + getProxyString(proxy) + " " + context + " currentTx=" + this.suspended);
/*     */     }
/*     */ 
/* 354 */     if (isTransacted)
/*     */     {
/* 357 */       if (this.suspended == null)
/*     */       {
/* 359 */         tm.begin();
/* 360 */         this.transaction = tm.getTransaction();
/* 361 */         if (this.trace) {
/* 362 */           log.trace("MessageEndpoint " + getProxyString(proxy) + " started transaction=" + this.transaction);
/*     */         }
/*     */ 
/* 365 */         if (this.resource != null)
/*     */         {
/* 367 */           this.transaction.enlistResource(this.resource);
/* 368 */           if (this.trace) {
/* 369 */             log.trace("MessageEndpoint " + getProxyString(proxy) + " enlisted=" + this.resource);
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/* 377 */           tm.resume(this.suspended);
/*     */         }
/*     */         finally
/*     */         {
/* 381 */           this.suspended = null;
/* 382 */           if (this.trace)
/* 383 */             log.trace("MessageEndpoint " + getProxyString(proxy) + " transaction=" + this.suspended + " already active, IGNORED=" + this.resource);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void endTransaction(Object proxy, boolean commit)
/*     */     throws Throwable
/*     */   {
/* 398 */     TransactionManager tm = null;
/* 399 */     Transaction currentTx = null;
/*     */     try
/*     */     {
/* 403 */       if (this.transaction != null)
/*     */       {
/* 405 */         tm = TxUtil.getTransactionManager();
/* 406 */         currentTx = tm.getTransaction();
/*     */ 
/* 409 */         if ((currentTx != null) && (!currentTx.equals(this.transaction)))
/*     */         {
/* 411 */           log.warn("Current transaction " + currentTx + " is not the expected transaction.");
/* 412 */           tm.suspend();
/* 413 */           tm.resume(this.transaction);
/*     */         }
/*     */         else
/*     */         {
/* 418 */           currentTx = null;
/*     */         }
/*     */ 
/* 422 */         if ((!commit) || (this.transaction.getStatus() == 1))
/*     */         {
/* 424 */           if (this.trace)
/* 425 */             log.trace("MessageEndpoint " + getProxyString(proxy) + " rollback");
/* 426 */           tm.rollback();
/*     */         }
/*     */         else
/*     */         {
/* 430 */           if (this.trace)
/* 431 */             log.trace("MessageEndpoint " + getProxyString(proxy) + " commit");
/* 432 */           tm.commit();
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 437 */       if (this.suspended != null)
/*     */       {
/*     */         try
/*     */         {
/* 441 */           tm = TxUtil.getTransactionManager();
/* 442 */           tm.resume(this.suspended);
/*     */         }
/*     */         finally
/*     */         {
/* 446 */           this.suspended = null;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/* 453 */       this.transaction = null;
/*     */ 
/* 456 */       if (currentTx != null)
/*     */       {
/*     */         try
/*     */         {
/* 460 */           tm.resume(currentTx);
/*     */         }
/*     */         catch (Throwable t)
/*     */         {
/* 464 */           log.warn("MessageEndpoint " + getProxyString(proxy) + " failed to resume old transaction " + currentTx);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void resetContextClassLoader(Object proxy)
/*     */   {
/* 478 */     if (this.trace)
/* 479 */       log.trace("MessageEndpoint " + getProxyString(proxy) + " reset classloader " + this.oldClassLoader);
/* 480 */     SetTCLAction.setContextClassLoader(this.inUseThread, this.oldClassLoader);
/* 481 */     this.oldClassLoader = null;
/*     */   }
/*     */ 
/*     */   protected void releaseThreadLock(Object proxy)
/*     */   {
/* 491 */     if (this.trace)
/* 492 */       log.trace("MessageEndpoint " + getProxyString(proxy) + " no longer in use by " + this.inUseThread);
/* 493 */     this.inUseThread = null;
/*     */   }
/*     */ 
/*     */   protected String getProxyString(Object proxy)
/*     */   {
/* 504 */     if (this.cachedProxyString == null)
/* 505 */       this.cachedProxyString = this.container.getEjbName();
/* 506 */     return this.cachedProxyString;
/*     */   }
/*     */ 
/*     */   protected JBossMessageEndpointFactory getMessageEndpointFactory(Invocation invocation)
/*     */   {
/* 516 */     if (this.endpointFactory == null)
/*     */     {
/* 518 */       MethodInvocation mi = (MethodInvocation)invocation;
/* 519 */       this.endpointFactory = ((JBossMessageEndpointFactory)mi.getResponseAttachment("MessageEndpoint.Factory"));
/*     */     }
/* 521 */     return this.endpointFactory;
/*     */   }
/*     */ 
/*     */   protected MessagingContainer getContainer(Invocation mi)
/*     */   {
/* 531 */     return getMessageEndpointFactory(mi).getContainer();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ejb3.mdb.inflow.MessageInflowLocalProxy
 * JD-Core Version:    0.6.0
 */